/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.util.Map;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.protege.editor.owl.ui.renderer.OWLEntityAnnotationValueRenderer;
import org.protege.editor.owl.ui.renderer.prefix.PrefixBasedRenderer;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.PrefixManager;

public class PrefixedOWLEntityAnnotationValueRenderer
extends OWLEntityAnnotationValueRenderer
implements PrefixBasedRenderer {
    private PrefixManager prefixManager;

    @Override
    public void initialise() {
        this.prefixManager = PrefixUtilities.getPrefixOWLOntologyFormat(this.getOWLModelManager());
        super.initialise();
    }

    @Override
    public void ontologiesChanged() {
        this.prefixManager = PrefixUtilities.getPrefixOWLOntologyFormat(this.getOWLModelManager());
    }

    @Override
    public String render(OWLEntity entity) {
        String shortForm = this.getProvider().getShortForm(entity);
        String uriStr = entity.getIRI().toString();
        for (Map.Entry prefixName2PrefixEntry : this.prefixManager.getPrefixName2PrefixMap().entrySet()) {
            String prefixName = (String)prefixName2PrefixEntry.getKey();
            if (!shortForm.startsWith(prefixName)) {
                String prefix = (String)prefixName2PrefixEntry.getValue();
                if (!uriStr.startsWith(prefix)) continue;
                if (!prefixName.equals(":")) {
                    return this.escape(prefixName + shortForm);
                }
                return this.escape(shortForm);
            }
            return this.escape(shortForm);
        }
        return entity.getIRI().toQuotedString();
    }
}

