/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import com.google.common.base.Optional;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.profiles.OWL2Profile;
import org.semanticweb.owlapi.profiles.OWLOntologyProfileWalker;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.CycleInDatatypeDefinition;
import org.semanticweb.owlapi.profiles.violations.DatatypeIRIAlsoUsedAsClassIRI;
import org.semanticweb.owlapi.profiles.violations.EmptyOneOfAxiom;
import org.semanticweb.owlapi.profiles.violations.IllegalPunning;
import org.semanticweb.owlapi.profiles.violations.InsufficientIndividuals;
import org.semanticweb.owlapi.profiles.violations.InsufficientOperands;
import org.semanticweb.owlapi.profiles.violations.InsufficientPropertyExpressions;
import org.semanticweb.owlapi.profiles.violations.UseOfBuiltInDatatypeInDatatypeDefinition;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInCardinalityRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInDisjointPropertiesAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInFunctionalPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInIrreflexivePropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInObjectHasSelf;
import org.semanticweb.owlapi.profiles.violations.UseOfPropertyInChainCausesCycle;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForAnnotationPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForClassIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForDataPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForIndividualIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForObjectPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForOntologyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForVersionIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredAnnotationProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredClass;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredDataProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredDatatype;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredObjectProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUnknownDatatype;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2DLProfile
implements OWLProfile {
    @Override
    public String getName() {
        return "OWL 2 DL";
    }

    @Override
    @Nonnull
    public IRI getIRI() {
        return Profiles.OWL2_DL.getIRI();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2Profile owl2Profile = new OWL2Profile();
        OWLProfileReport report = owl2Profile.checkOntology(ontology);
        LinkedHashSet<OWLProfileViolation> violations = new LinkedHashSet<OWLProfileViolation>();
        if (!report.isInProfile()) {
            violations.addAll(report.getViolations());
        }
        OWLOntologyProfileWalker walker = new OWLOntologyProfileWalker(ontology.getImportsClosure());
        OWL2DLProfileObjectVisitor visitor = new OWL2DLProfileObjectVisitor(walker, ontology.getOWLOntologyManager());
        walker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    private static class OWL2DLProfileObjectVisitor
    extends OWLOntologyWalkerVisitor {
        private OWLObjectPropertyManager objectPropertyManager = null;
        @Nonnull
        private final OWLOntologyManager manager;
        @Nonnull
        private final Set<OWLProfileViolation> profileViolations = new HashSet<OWLProfileViolation>();

        OWL2DLProfileObjectVisitor(@Nonnull OWLOntologyWalker walker, @Nonnull OWLOntologyManager manager) {
            super(walker);
            this.manager = manager;
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        private OWLObjectPropertyManager getPropertyManager() {
            if (this.objectPropertyManager == null) {
                this.objectPropertyManager = new OWLObjectPropertyManager(this.manager, this.getCurrentOntology());
            }
            return this.objectPropertyManager;
        }

        @Override
        public void visit(OWLDataOneOf node) {
            if (node.getValues().isEmpty()) {
                this.profileViolations.add(new EmptyOneOfAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
            }
        }

        @Override
        public void visit(OWLDataUnionOf node) {
            if (node.getOperands().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLDataIntersectionOf node) {
            if (node.getOperands().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf ce) {
            if (ce.getOperands().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectOneOf ce) {
            if (ce.getIndividuals().isEmpty()) {
                this.profileViolations.add(new EmptyOneOfAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
            }
        }

        @Override
        public void visit(OWLObjectUnionOf ce) {
            if (ce.getOperands().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            if (axiom.getClassExpressions().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)axiom, axiom));
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            if (axiom.getClassExpressions().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)axiom, axiom));
            }
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            if (axiom.getClassExpressions().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)axiom, axiom));
            }
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            if (axiom.getProperties().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            if (axiom.getProperties().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            if (axiom.getProperties().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (axiom.getPropertyExpressions().size() < 1) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            if (axiom.getIndividuals().size() < 2) {
                this.profileViolations.add(new InsufficientIndividuals(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            if (axiom.getIndividuals().size() < 2) {
                this.profileViolations.add(new InsufficientIndividuals(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLOntology ontology) {
            OWLOntologyID ontologyID = ontology.getOntologyID();
            if (!ontologyID.isAnonymous()) {
                Optional<IRI> versionIRI;
                if (((IRI)ontologyID.getOntologyIRI().get()).isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfReservedVocabularyForOntologyIRI(this.getCurrentOntology()));
                }
                if ((versionIRI = ontologyID.getVersionIRI()).isPresent() && ((IRI)versionIRI.get()).isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfReservedVocabularyForVersionIRI(this.getCurrentOntology()));
                }
            }
            this.objectPropertyManager = null;
        }

        @Override
        public void visit(OWLClass ce) {
            if (!ce.isBuiltIn() && ce.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
            if (!ce.isBuiltIn() && !this.getCurrentOntology().isDeclared(ce, Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredClass(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
            if (this.getCurrentOntology().containsDatatypeInSignature(ce.getIRI(), Imports.EXCLUDED)) {
                this.profileViolations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), ce.getIRI()));
            }
        }

        @Override
        public void visit(OWLDatatype node) {
            if (!OWL2Datatype.isBuiltIn(node.getIRI())) {
                if (!node.getIRI().getNamespace().equals(Namespaces.XSD.toString()) && !node.isTopDatatype() && node.getIRI().isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfUnknownDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), node));
                }
                if (!(node.isTopDatatype() || node.isBuiltIn() || this.getCurrentOntology().isDeclared(node, Imports.INCLUDED))) {
                    this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), node));
                }
            }
            if (this.getCurrentOntology().containsClassInSignature(node.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), node.getIRI()));
            }
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            if (axiom.getDatatype().getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfBuiltInDatatypeInDatatypeDefinition(this.getCurrentOntology(), axiom));
            }
            HashSet<OWLDatatype> datatypes = new HashSet<OWLDatatype>();
            LinkedHashSet<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();
            axioms.add(axiom);
            this.getDatatypesInSignature(datatypes, axiom.getDataRange(), axioms);
            if (datatypes.contains(axiom.getDatatype())) {
                this.profileViolations.add(new CycleInDatatypeDefinition(this.getCurrentOntology(), axiom));
            }
        }

        private void getDatatypesInSignature(Set<OWLDatatype> datatypes, OWLObject obj, Set<OWLAxiom> axioms) {
            for (OWLDatatype dt : obj.getDatatypesInSignature()) {
                assert (dt != null);
                if (!datatypes.add(dt)) continue;
                for (OWLOntology ont : this.getCurrentOntology().getImportsClosure()) {
                    for (OWLDatatypeDefinitionAxiom ax : ont.getDatatypeDefinitions(dt)) {
                        axioms.add(ax);
                        this.getDatatypesInSignature(datatypes, ax.getDataRange(), axioms);
                    }
                }
            }
        }

        @Override
        public void visit(OWLObjectProperty property) {
            if (!property.isOWLTopObjectProperty() && !property.isOWLBottomObjectProperty() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForObjectPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredObjectProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
        }

        @Override
        public void visit(OWLDataProperty property) {
            if (!property.isOWLTopDataProperty() && !property.isOWLBottomDataProperty() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForDataPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredDataProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
        }

        @Override
        public void visit(OWLAnnotationProperty property) {
            if (!property.isBuiltIn() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForAnnotationPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredAnnotationProperty(this.getCurrentOntology(), this.getCurrentAxiom(), this.getCurrentAnnotation(), property));
            }
            if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
        }

        @Override
        public void visit(OWLNamedIndividual individual) {
            if (!individual.isAnonymous() && individual.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForIndividualIRI(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
            }
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            if (((OWLDataPropertyExpression)axiom.getSubProperty()).isOWLTopDataProperty()) {
                this.profileViolations.add(new UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLObjectMinCardinality ce) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectMaxCardinality ce) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectExactCardinality ce) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLObjectHasSelf ce) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInObjectHasSelf(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
            }
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInFunctionalPropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInIrreflexivePropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom(this.getCurrentOntology(), axiom));
            }
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            if (axiom.getProperties().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                assert (prop != null);
                if (!this.getPropertyManager().isNonSimple(prop)) continue;
                this.profileViolations.add(new UseOfNonSimplePropertyInDisjointPropertiesAxiom(this.getCurrentOntology(), axiom, prop));
            }
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            OWLObjectPropertyExpression superProp;
            if (axiom.getPropertyChain().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
            }
            if ((superProp = axiom.getSuperProperty()).isOWLTopObjectProperty() || axiom.isEncodingOfTransitiveProperty()) {
                return;
            }
            List<OWLObjectPropertyExpression> chain = axiom.getPropertyChain();
            OWLObjectPropertyExpression first = chain.get(0);
            OWLObjectPropertyExpression last = chain.get(chain.size() - 1);
            assert (last != null);
            for (int i = 1; i < chain.size() - 1; ++i) {
                OWLObjectPropertyExpression propB = chain.get(i);
                assert (propB != null);
                if (!this.getPropertyManager().isLessThan(superProp, propB)) continue;
                this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, propB));
            }
            if (first.equals(superProp)) {
                if (this.getPropertyManager().isLessThan(superProp, last)) {
                    this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, last));
                }
            } else if (this.getPropertyManager().isLessThan(superProp, first)) {
                this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, first));
            }
            if (last.equals(superProp)) {
                if (this.getPropertyManager().isLessThan(superProp, first)) {
                    this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, first));
                }
            } else if (this.getPropertyManager().isLessThan(superProp, last)) {
                this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, last));
            }
        }
    }
}

