/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ObservableListWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class VetoableObservableList<T>
extends ObservableListWrapper<T>
implements ObservableList<T> {
    private int modCount;

    protected abstract void onProposedChange(List<T> var1, int ... var2);

    protected void onChanged(ListChangeListener.Change<T> change) {
    }

    public VetoableObservableList(List<T> list) {
        super(list);
    }

    public VetoableObservableList() {
        super(new ArrayList());
    }

    @Override
    protected void callObservers(ListChangeListener.Change<T> change) {
        this.onChanged(change);
        change.reset();
        super.callObservers(change);
    }

    @Override
    public boolean setAll(Collection<? extends T> collection) {
        this.onProposedChange(new ArrayList<T>(collection), 0, this.backingList.size());
        ++this.modCount;
        super.setAll(collection);
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new VetoableObservableListIterator(this.backingList.iterator(), 0, 0);
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.onProposedChange(new ArrayList<T>(collection), n, n);
        ++this.modCount;
        return super.addAll(n, collection);
    }

    @Override
    protected boolean removeFromList(List<T> list, int n, Collection<?> collection, boolean bl) {
        int[] nArray = new int[2];
        int n2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            T t = list.get(i);
            if (!(collection.contains(t) ^ bl)) continue;
            if (n2 == -1) {
                nArray[n2 + 1] = n + i;
                nArray[n2 + 2] = n + i + 1;
                n2 += 2;
                continue;
            }
            if (nArray[n2 - 1] == n + i) {
                nArray[n2 - 1] = n + i + 1;
                continue;
            }
            int[] nArray2 = new int[nArray.length + 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
            nArray[n2 + 1] = n + i;
            nArray[n2 + 2] = n + i + 1;
            n2 += 2;
        }
        if (n2 == -1) {
            return false;
        }
        this.onProposedChange(Collections.emptyList(), nArray);
        return super.removeFromList(list, n, collection, bl);
    }

    @Override
    public void clear() {
        this.onProposedChange(Collections.emptyList(), 0, this.size());
        ++this.modCount;
        super.clear();
    }

    @Override
    public T set(int n, T t) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.onProposedChange(Collections.singletonList(t), n, n + 1);
        return super.set(n, t);
    }

    @Override
    public void add(int n, T t) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.onProposedChange(Collections.singletonList(t), n, n);
        ++this.modCount;
        super.add(n, t);
    }

    @Override
    public T remove(int n) {
        this.onProposedChange(Collections.emptyList(), n, n + 1);
        ++this.modCount;
        return (T)super.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        return super.remove(object);
    }

    @Override
    protected boolean hasObserver() {
        return true;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new VetoableObservableListIterator(this.backingList.listIterator(), 0, 0);
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new VetoableObservableListIterator(this.backingList.listIterator(n), 0, n);
    }

    @Override
    public List<T> subList(int n, int n2) {
        return new ObservableListWrapper.ObservableSubList(n, n2){
            private int expectedModCount;
            {
                this.expectedModCount = VetoableObservableList.this.modCount;
            }

            @Override
            public void add(int n, T t) {
                this.checkForComodification();
                VetoableObservableList.this.onProposedChange(Collections.singletonList(t), this.offset + n, this.offset + n);
                this.expectedModCount = ++VetoableObservableList.this.modCount;
                super.add(n, t);
            }

            @Override
            public boolean addAll(int n, Collection<? extends T> collection) {
                this.checkForComodification();
                VetoableObservableList.this.onProposedChange(new ArrayList(collection), this.offset + n, this.offset + n);
                this.expectedModCount = ++VetoableObservableList.this.modCount;
                return super.addAll(n, collection);
            }

            @Override
            public T set(int n, T t) {
                this.checkForComodification();
                VetoableObservableList.this.onProposedChange(Collections.singletonList(t), this.offset + n, this.offset + n + 1);
                return super.set(n, t);
            }

            @Override
            public void clear() {
                this.checkForComodification();
                VetoableObservableList.this.onProposedChange(Collections.emptyList(), this.offset, this.offset + this.sz);
                this.expectedModCount = ++VetoableObservableList.this.modCount;
                super.clear();
            }

            @Override
            public T remove(int n) {
                this.checkForComodification();
                VetoableObservableList.this.onProposedChange(Collections.emptyList(), n, n + 1);
                this.expectedModCount = ++VetoableObservableList.this.modCount;
                return super.remove(n);
            }

            @Override
            public Iterator<T> iterator() {
                return new VetoableObservableListIterator(this.backingSubList.iterator(), this.offset, 0);
            }

            @Override
            public ListIterator<T> listIterator() {
                return new VetoableObservableListIterator(this.backingSubList.listIterator(), this.offset, 0);
            }

            @Override
            public ListIterator<T> listIterator(int n) {
                if (n < 0 || n > this.size()) {
                    throw new IndexOutOfBoundsException();
                }
                return new VetoableObservableListIterator(this.backingSubList.listIterator(n), this.offset, n);
            }

            private void checkForComodification() {
                if (VetoableObservableList.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    private class VetoableObservableListIterator
    extends ObservableListWrapper.ObservableListIterator {
        boolean requireNextPrev;
        private int expectedModCount;

        public VetoableObservableListIterator(Iterator<T> iterator, int n, int n2) {
            super(iterator, n, n2);
            this.requireNextPrev = true;
            this.expectedModCount = VetoableObservableList.this.modCount;
        }

        public VetoableObservableListIterator(ListIterator<T> listIterator, int n, int n2) {
            super(listIterator, n, n2);
            this.requireNextPrev = true;
            this.expectedModCount = VetoableObservableList.this.modCount;
        }

        @Override
        public void add(T t) {
            this.checkForComodification();
            VetoableObservableList.this.onProposedChange(Collections.singletonList(t), this.cursor, this.cursor);
            this.requireNextPrev = true;
            super.add(t);
        }

        @Override
        public void set(T t) {
            if (this.requireNextPrev) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            if (this.forward) {
                VetoableObservableList.this.onProposedChange(Collections.singletonList(t), this.cursor - 1, this.cursor);
            } else {
                VetoableObservableList.this.onProposedChange(Collections.singletonList(t), this.cursor, this.cursor + 1);
            }
            this.expectedModCount = ++VetoableObservableList.this.modCount;
            super.set(t);
        }

        @Override
        public void remove() {
            if (this.requireNextPrev) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            if (this.forward) {
                VetoableObservableList.this.onProposedChange(Collections.emptyList(), this.cursor - 1, this.cursor);
            } else {
                VetoableObservableList.this.onProposedChange(Collections.emptyList(), this.cursor, this.cursor + 1);
            }
            this.expectedModCount = ++VetoableObservableList.this.modCount;
            this.requireNextPrev = true;
            super.remove();
        }

        @Override
        public T next() {
            this.requireNextPrev = false;
            return super.next();
        }

        @Override
        public T previous() {
            this.requireNextPrev = false;
            return super.previous();
        }

        private void checkForComodification() {
            if (VetoableObservableList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

