/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.StackPane;

public class TooltipSkin
implements Skin<Tooltip> {
    private StackPane root;
    private Label tipLabel;
    private StackPane pageCorner;
    private Tooltip tooltip;

    public TooltipSkin(Tooltip tooltip) {
        this.tooltip = tooltip;
        this.tipLabel = new Label();
        this.tipLabel.contentDisplayProperty().bind(tooltip.contentDisplayProperty());
        this.tipLabel.fontProperty().bind(tooltip.fontProperty());
        this.tipLabel.graphicProperty().bind(tooltip.graphicProperty());
        this.tipLabel.textAlignmentProperty().bind(tooltip.textAlignmentProperty());
        this.tipLabel.textOverrunProperty().bind(tooltip.textOverrunProperty());
        this.tipLabel.textProperty().bind(tooltip.textProperty());
        this.tipLabel.wrapTextProperty().bind(tooltip.wrapTextProperty());
        this.pageCorner = new StackPane();
        this.pageCorner.getStyleClass().setAll((String[])new String[]{"page-corner"});
        this.root = new StackPane(){

            @Override
            protected void layoutChildren() {
                TooltipSkin.this.tipLabel.resizeRelocate(this.getInsets().getLeft(), this.getInsets().getTop(), this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight(), this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom());
                double d = TooltipSkin.this.pageCorner.prefWidth(-1.0);
                double d2 = TooltipSkin.this.pageCorner.prefHeight(-1.0);
                TooltipSkin.this.pageCorner.resizeRelocate(this.getWidth() - d, this.getHeight() - d2, d, d2);
            }

            @Override
            protected double computeMinWidth(double d) {
                return TooltipSkin.this.tooltip.getMinWidth() != -1.0 ? TooltipSkin.this.tooltip.getMinWidth() : this.computePrefWidth(d);
            }

            @Override
            protected double computeMinHeight(double d) {
                return TooltipSkin.this.tooltip.getMinHeight() != -1.0 ? TooltipSkin.this.tooltip.getMinHeight() : this.computePrefHeight(d);
            }

            @Override
            protected double computePrefWidth(double d) {
                if (TooltipSkin.this.tooltip.getPrefWidth() != -1.0) {
                    return TooltipSkin.this.tooltip.getPrefWidth();
                }
                return TooltipSkin.this.tooltip.isWrapText() ? TooltipSkin.this.tipLabel.prefWidth(d) : this.getInsets().getLeft() + TooltipSkin.this.tipLabel.prefWidth(-1.0) + this.getInsets().getRight();
            }

            @Override
            protected double computePrefHeight(double d) {
                if (TooltipSkin.this.tooltip.getPrefWidth() != -1.0) {
                    return this.getInsets().getTop() + TooltipSkin.this.tipLabel.prefHeight(TooltipSkin.this.tooltip.getPrefWidth() - this.getInsets().getLeft() - this.getInsets().getRight()) + this.getInsets().getBottom();
                }
                return this.getInsets().getTop() + TooltipSkin.this.tipLabel.prefHeight(-1.0) + this.getInsets().getBottom();
            }

            @Override
            protected double computeMaxWidth(double d) {
                return TooltipSkin.this.tooltip.getMaxWidth() != -1.0 ? TooltipSkin.this.tooltip.getMaxWidth() : this.computePrefWidth(d);
            }

            @Override
            protected double computeMaxHeight(double d) {
                return TooltipSkin.this.tooltip.getMaxHeight() != -1.0 ? TooltipSkin.this.tooltip.getMaxHeight() : this.computePrefHeight(d);
            }
        };
        this.root.getChildren().addAll((Node[])new Node[]{this.tipLabel, this.pageCorner});
        this.root.getStyleClass().setAll((Collection<String>)tooltip.getStyleClass());
        this.root.setStyle(tooltip.getStyle());
        this.root.setId(tooltip.getId());
    }

    @Override
    public Tooltip getSkinnable() {
        return this.tooltip;
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    @Override
    public void dispose() {
        this.tooltip = null;
    }
}

