/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.t2k.CMap;
import com.sun.t2k.CharToGlyphMapper;
import com.sun.t2k.T2KFontFile;

public class OpenTypeGlyphMapper
extends CharToGlyphMapper {
    T2KFontFile font;
    CMap cmap;
    int numGlyphs;

    public OpenTypeGlyphMapper(T2KFontFile t2KFontFile) {
        this.font = t2KFontFile;
        try {
            this.cmap = CMap.initialize(t2KFontFile);
        }
        catch (Exception exception) {
            this.cmap = null;
        }
        if (this.cmap == null) {
            this.handleBadCMAP();
        }
        this.missingGlyph = 0;
        this.numGlyphs = t2KFontFile.getNumGlyphs();
    }

    @Override
    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    @Override
    public int getGlyphCode(int n) {
        try {
            return this.cmap.getGlyph(n);
        }
        catch (Exception exception) {
            this.handleBadCMAP();
            return this.missingGlyph;
        }
    }

    private void handleBadCMAP() {
        this.cmap = CMap.theNullCmap;
    }

    boolean hasSupplementaryChars() {
        return this.cmap instanceof CMap.CMapFormat8 || this.cmap instanceof CMap.CMapFormat10 || this.cmap instanceof CMap.CMapFormat12;
    }
}

