/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.StyleableStringProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.OverrunStyle;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="text")
public abstract class Labeled
extends Control {
    private static final String DEFAULT_ELLIPSIS_STRING = "...";
    private StringProperty text;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<TextAlignment> textAlignment;
    private ObjectProperty<OverrunStyle> textOverrun;
    private StringProperty ellipsisString;
    private BooleanProperty wrapText;
    private ObjectProperty<Font> font;
    private ObjectProperty<Node> graphic;
    private StringProperty imageUrl = null;
    private BooleanProperty underline;
    private ObjectProperty<ContentDisplay> contentDisplay;
    private ObjectProperty<Insets> labelPadding;
    private DoubleProperty graphicTextGap;
    private ObjectProperty<Paint> textFill;
    private BooleanProperty mnemonicParsing;

    public Labeled() {
    }

    public Labeled(String string) {
        this.setText(string);
    }

    public Labeled(String string, Node node) {
        this.setText(string);
        this.setGraphic(node);
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty(this, "text", "");
        }
        return this.text;
    }

    public final void setText(String string) {
        this.textProperty().setValue(string);
    }

    public final String getText() {
        return this.text == null ? "" : this.text.getValue();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.CENTER_LEFT){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.CENTER_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new StyleableObjectProperty<TextAlignment>(TextAlignment.LEFT){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TEXT_ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textAlignment";
                }
            };
        }
        return this.textAlignment;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().setValue(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)this.textAlignment.getValue());
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        if (this.textOverrun == null) {
            this.textOverrun = new StyleableObjectProperty<OverrunStyle>(OverrunStyle.ELLIPSIS){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TEXT_OVERRUN;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textOverrun";
                }
            };
        }
        return this.textOverrun;
    }

    public final void setTextOverrun(OverrunStyle overrunStyle) {
        this.textOverrunProperty().setValue(overrunStyle);
    }

    public final OverrunStyle getTextOverrun() {
        return this.textOverrun == null ? OverrunStyle.ELLIPSIS : (OverrunStyle)((Object)this.textOverrun.getValue());
    }

    public final StringProperty ellipsisStringProperty() {
        if (this.ellipsisString == null) {
            this.ellipsisString = new StyleableStringProperty(DEFAULT_ELLIPSIS_STRING){

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "ellipsisString";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ELLIPSIS_STRING;
                }
            };
        }
        return this.ellipsisString;
    }

    public final void setEllipsisString(String string) {
        this.ellipsisStringProperty().set(string == null ? "" : string);
    }

    public final String getEllipsisString() {
        return this.ellipsisString == null ? DEFAULT_ELLIPSIS_STRING : (String)this.ellipsisString.get();
    }

    public final BooleanProperty wrapTextProperty() {
        if (this.wrapText == null) {
            this.wrapText = new StyleableBooleanProperty(){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.WRAP_TEXT;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "wrapText";
                }
            };
        }
        return this.wrapText;
    }

    public final void setWrapText(boolean bl) {
        this.wrapTextProperty().setValue(bl);
    }

    public final boolean isWrapText() {
        return this.wrapText == null ? false : this.wrapText.getValue();
    }

    @Override
    public Orientation getContentBias() {
        return this.isWrapText() ? Orientation.HORIZONTAL : null;
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new StyleableObjectProperty<Font>(Font.getDefault()){

                @Override
                protected void invalidated() {
                    Stylesheet.Origin origin = StyleableProperty.getOrigin(Labeled.this.font);
                    if (origin == null || origin == Stylesheet.Origin.USER) {
                        Labeled.this.impl_reapplyCSS();
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.FONT;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue(font);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new ObjectPropertyBase<Node>(){

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().setValue(node);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.getValue();
    }

    private StringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new StyleableStringProperty(){

                @Override
                protected void invalidated() {
                    Object var1_1 = null;
                    if (this.get() != null) {
                        URL uRL = null;
                        try {
                            uRL = new URL(this.get());
                        }
                        catch (MalformedURLException malformedURLException) {
                            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                            uRL = classLoader.getResource(this.get());
                        }
                        if (uRL != null) {
                            Labeled.this.setGraphic(new ImageView(new Image(uRL.toExternalForm())));
                        }
                    } else {
                        Labeled.this.setGraphic(null);
                    }
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "imageUrl";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.GRAPHIC;
                }
            };
        }
        return this.imageUrl;
    }

    public final BooleanProperty underlineProperty() {
        if (this.underline == null) {
            this.underline = new StyleableBooleanProperty(false){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.UNDERLINE;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "underline";
                }
            };
        }
        return this.underline;
    }

    public final void setUnderline(boolean bl) {
        this.underlineProperty().setValue(bl);
    }

    public final boolean isUnderline() {
        return this.underline == null ? false : this.underline.getValue();
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        if (this.contentDisplay == null) {
            this.contentDisplay = new StyleableObjectProperty<ContentDisplay>(ContentDisplay.LEFT){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.CONTENT_DISPLAY;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "contentDisplay";
                }
            };
        }
        return this.contentDisplay;
    }

    public final void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplayProperty().setValue(contentDisplay);
    }

    public final ContentDisplay getContentDisplay() {
        return this.contentDisplay == null ? ContentDisplay.LEFT : (ContentDisplay)((Object)this.contentDisplay.getValue());
    }

    public final ReadOnlyObjectProperty<Insets> labelPaddingProperty() {
        return this.labelPaddingPropertyImpl();
    }

    private ObjectProperty<Insets> labelPaddingPropertyImpl() {
        if (this.labelPadding == null) {
            this.labelPadding = new StyleableObjectProperty<Insets>(Insets.EMPTY){
                private Insets lastValidValue;
                {
                    this.lastValidValue = Insets.EMPTY;
                }

                @Override
                public void invalidated() {
                    Insets insets = (Insets)this.get();
                    if (insets == null) {
                        this.set(this.lastValidValue);
                        throw new NullPointerException("cannot set labelPadding to null");
                    }
                    this.lastValidValue = insets;
                    Labeled.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.LABEL_PADDING;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "labelPadding";
                }
            };
        }
        return this.labelPadding;
    }

    private void setLabelPadding(Insets insets) {
        this.labelPaddingPropertyImpl().set(insets);
    }

    public final Insets getLabelPadding() {
        return this.labelPadding == null ? Insets.EMPTY : (Insets)this.labelPadding.get();
    }

    public final DoubleProperty graphicTextGapProperty() {
        if (this.graphicTextGap == null) {
            this.graphicTextGap = new StyleableDoubleProperty(4.0){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.GRAPHIC_TEXT_GAP;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "graphicTextGap";
                }
            };
        }
        return this.graphicTextGap;
    }

    public final void setGraphicTextGap(double d) {
        this.graphicTextGapProperty().setValue(d);
    }

    public final double getGraphicTextGap() {
        return this.graphicTextGap == null ? 4.0 : this.graphicTextGap.getValue();
    }

    public final void setTextFill(Paint paint) {
        this.textFillProperty().set(paint);
    }

    public final Paint getTextFill() {
        return this.textFill == null ? Color.BLACK : (Paint)this.textFill.get();
    }

    public final ObjectProperty<Paint> textFillProperty() {
        if (this.textFill == null) {
            this.textFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TEXT_FILL;
                }

                @Override
                public Object getBean() {
                    return Labeled.this;
                }

                @Override
                public String getName() {
                    return "textFill";
                }
            };
        }
        return this.textFill;
    }

    public final void setMnemonicParsing(boolean bl) {
        this.mnemonicParsingProperty().set(bl);
    }

    public final boolean isMnemonicParsing() {
        return this.mnemonicParsing == null ? false : this.mnemonicParsing.get();
    }

    public final BooleanProperty mnemonicParsingProperty() {
        if (this.mnemonicParsing == null) {
            this.mnemonicParsing = new SimpleBooleanProperty(this, "mnemonicParsing");
        }
        return this.mnemonicParsing;
    }

    @Deprecated
    protected Pos impl_cssGetAlignmentInitialValue() {
        return Pos.CENTER_LEFT;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Labeled.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty.FONT<Labeled> FONT = new StyleableProperty.FONT<Labeled>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.font == null || !labeled.font.isBound();
            }

            @Override
            public WritableValue<Font> getWritableValue(Labeled labeled) {
                return labeled.fontProperty();
            }
        };
        private static final StyleableProperty<Labeled, Pos> ALIGNMENT = new StyleableProperty<Labeled, Pos>("-fx-alignment", new EnumConverter(Pos.class), Pos.CENTER_LEFT){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.alignment == null || !labeled.alignment.isBound();
            }

            @Override
            public WritableValue<Pos> getWritableValue(Labeled labeled) {
                return labeled.alignmentProperty();
            }

            @Override
            public Pos getInitialValue(Labeled labeled) {
                return labeled.impl_cssGetAlignmentInitialValue();
            }
        };
        private static final StyleableProperty<Labeled, TextAlignment> TEXT_ALIGNMENT = new StyleableProperty<Labeled, TextAlignment>("-fx-text-alignment", new EnumConverter(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.textAlignment == null || !labeled.textAlignment.isBound();
            }

            @Override
            public WritableValue<TextAlignment> getWritableValue(Labeled labeled) {
                return labeled.textAlignmentProperty();
            }
        };
        private static final StyleableProperty<Labeled, Paint> TEXT_FILL = new StyleableProperty<Labeled, Paint>("-fx-text-fill", (StyleConverter)PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.textFill == null || !labeled.textFill.isBound();
            }

            @Override
            public WritableValue<Paint> getWritableValue(Labeled labeled) {
                return labeled.textFillProperty();
            }
        };
        private static final StyleableProperty<Labeled, OverrunStyle> TEXT_OVERRUN = new StyleableProperty<Labeled, OverrunStyle>("-fx-text-overrun", new EnumConverter(OverrunStyle.class), OverrunStyle.ELLIPSIS){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.textOverrun == null || !labeled.textOverrun.isBound();
            }

            @Override
            public WritableValue<OverrunStyle> getWritableValue(Labeled labeled) {
                return labeled.textOverrunProperty();
            }
        };
        private static final StyleableProperty<Labeled, String> ELLIPSIS_STRING = new StyleableProperty<Labeled, String>("-fx-ellipsis-string", (StyleConverter)StringConverter.getInstance(), "..."){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.ellipsisString == null || !labeled.ellipsisString.isBound();
            }

            @Override
            public WritableValue<String> getWritableValue(Labeled labeled) {
                return labeled.ellipsisStringProperty();
            }
        };
        private static final StyleableProperty<Labeled, Boolean> WRAP_TEXT = new StyleableProperty<Labeled, Boolean>("-fx-wrap-text", (StyleConverter)BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.wrapText == null || !labeled.wrapText.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Labeled labeled) {
                return labeled.wrapTextProperty();
            }
        };
        private static final StyleableProperty<Labeled, String> GRAPHIC = new StyleableProperty<Labeled, String>("-fx-graphic", (StyleConverter)StringConverter.getInstance()){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.graphic == null || !labeled.graphic.isBound();
            }

            @Override
            public WritableValue<String> getWritableValue(Labeled labeled) {
                return labeled.imageUrlProperty();
            }
        };
        private static final StyleableProperty<Labeled, Boolean> UNDERLINE = new StyleableProperty<Labeled, Boolean>("-fx-underline", (StyleConverter)BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.underline == null || !labeled.underline.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Labeled labeled) {
                return labeled.underlineProperty();
            }
        };
        private static final StyleableProperty<Labeled, ContentDisplay> CONTENT_DISPLAY = new StyleableProperty<Labeled, ContentDisplay>("-fx-content-display", new EnumConverter(ContentDisplay.class), ContentDisplay.LEFT){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.contentDisplay == null || !labeled.contentDisplay.isBound();
            }

            @Override
            public WritableValue<ContentDisplay> getWritableValue(Labeled labeled) {
                return labeled.contentDisplayProperty();
            }
        };
        private static final StyleableProperty<Labeled, Insets> LABEL_PADDING = new StyleableProperty<Labeled, Insets>("-fx-label-padding", (StyleConverter)InsetsConverter.getInstance(), Insets.EMPTY){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.labelPadding == null || !labeled.labelPadding.isBound();
            }

            @Override
            public WritableValue<Insets> getWritableValue(Labeled labeled) {
                return labeled.labelPaddingPropertyImpl();
            }
        };
        private static final StyleableProperty<Labeled, Number> GRAPHIC_TEXT_GAP = new StyleableProperty<Labeled, Number>("-fx-graphic-text-gap", (StyleConverter)SizeConverter.getInstance(), (Number)4.0){

            @Override
            public boolean isSettable(Labeled labeled) {
                return labeled.graphicTextGap == null || !labeled.graphicTextGap.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(Labeled labeled) {
                return labeled.graphicTextGapProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FONT, ALIGNMENT, TEXT_ALIGNMENT, TEXT_FILL, TEXT_OVERRUN, ELLIPSIS_STRING, WRAP_TEXT, GRAPHIC, UNDERLINE, CONTENT_DISPLAY, LABEL_PADDING, GRAPHIC_TEXT_GAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

