/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.transformation.SortableList;
import com.sun.javafx.collections.transformation.TransformationList;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.TableColumnComparator;
import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.util.Callback;

@DefaultProperty(value="items")
public class TableView<S>
extends Control {
    private static final String SET_CONTENT_WIDTH = "TableView.contentWidth";
    private static final String REFRESH = "TableView.refresh";
    public static final Callback<ResizeFeatures, Boolean> UNCONSTRAINED_RESIZE_POLICY = new Callback<ResizeFeatures, Boolean>(){

        public String toString() {
            return "unconstrained-resize";
        }

        @Override
        public Boolean call(ResizeFeatures resizeFeatures) {
            double d = TableView.resize(resizeFeatures.getColumn(), resizeFeatures.getDelta());
            return Double.compare(d, 0.0) == 0;
        }
    };
    public static final Callback<ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY = new Callback<ResizeFeatures, Boolean>(){
        private boolean isFirstRun = true;

        public String toString() {
            return "constrained-resize";
        }

        @Override
        public Boolean call(ResizeFeatures resizeFeatures) {
            double d;
            boolean bl;
            TableView tableView = resizeFeatures.getTable();
            TableColumn tableColumn = resizeFeatures.getColumn();
            double d2 = resizeFeatures.getDelta();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = tableView.contentWidth;
            if (d5 == 0.0) {
                return false;
            }
            double d6 = 0.0;
            for (TableColumn tableColumn2 : tableView.getVisibleLeafColumns()) {
                d6 += tableColumn2.getWidth();
            }
            if (Math.abs(d6 - d5) > 1.0) {
                bl = d6 > d5;
                double d7 = d5;
                if (this.isFirstRun) {
                    for (TableColumn tableColumn2 : tableView.getVisibleLeafColumns()) {
                        d3 += tableColumn2.getMinWidth();
                        d4 += tableColumn2.getMaxWidth();
                    }
                    d4 = d4 == Double.POSITIVE_INFINITY ? Double.MAX_VALUE : (d4 == Double.NEGATIVE_INFINITY ? Double.MIN_VALUE : d4);
                    for (TableColumn tableColumn3 : tableView.getVisibleLeafColumns()) {
                        double d8;
                        double d9 = tableColumn3.getMinWidth();
                        double d10 = tableColumn3.getMaxWidth();
                        if (d3 == d4) {
                            d8 = d9;
                        } else {
                            d = (d7 - d3) / (d4 - d3);
                            d8 = Math.round(d9 + d * (d10 - d9));
                        }
                        d = TableView.resize(tableColumn3, d8 - tableColumn3.getWidth());
                        d7 -= d8 + d;
                        d3 -= d9;
                        d4 -= d10;
                    }
                    this.isFirstRun = false;
                } else {
                    double d11 = d5 - d6;
                    ObservableList observableList = tableView.getVisibleLeafColumns();
                    TableView.resizeColumns(observableList, d11);
                }
            }
            if (tableColumn == null) {
                return false;
            }
            bl = d2 < 0.0;
            TableColumn tableColumn3 = tableColumn;
            while (tableColumn3.getColumns().size() > 0) {
                tableColumn3 = (TableColumn)tableColumn3.getColumns().get(0);
            }
            int n = tableView.getVisibleLeafColumns().indexOf(tableColumn3);
            int n2 = tableView.getVisibleLeafColumns().size() - 1;
            double d11 = d2;
            while (n2 > n && d11 != 0.0) {
                TableColumn tableColumn4;
                TableColumn tableColumn5 = (TableColumn)tableView.getVisibleLeafColumns().get(n2);
                --n2;
                if (!tableColumn5.isResizable()) continue;
                TableColumn tableColumn6 = bl ? tableColumn3 : tableColumn5;
                TableColumn tableColumn7 = tableColumn4 = !bl ? tableColumn3 : tableColumn5;
                if (tableColumn4.getWidth() > tableColumn4.getPrefWidth()) {
                    List list = tableView.getVisibleLeafColumns().subList(n + 1, n2 + 1);
                    for (int i = list.size() - 1; i >= 0; --i) {
                        TableColumn tableColumn8 = (TableColumn)list.get(i);
                        if (!(tableColumn8.getWidth() < tableColumn8.getPrefWidth())) continue;
                        tableColumn4 = tableColumn8;
                        break;
                    }
                }
                d = Math.min(Math.abs(d11), tableColumn6.getWidth() - tableColumn6.getMinWidth());
                double d12 = TableView.resize(tableColumn6, -d);
                double d13 = TableView.resize(tableColumn4, d);
                d11 += bl ? d : -d;
            }
            return d11 == 0.0;
        }
    };
    private final ObservableList<TableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private final ObservableList<TableColumn<S, ?>> visibleLeafColumns = FXCollections.observableArrayList();
    private final ObservableList<TableColumn<S, ?>> unmodifiableVisibleLeafColumns = FXCollections.unmodifiableObservableList(this.visibleLeafColumns);
    private ObservableList<TableColumn<S, ?>> sortOrder = FXCollections.observableArrayList();
    private double contentWidth;
    private boolean isInited = false;
    private final ListChangeListener columnsObserver = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            TableView.this.updateVisibleLeafColumns();
            ArrayList arrayList = new ArrayList();
            while (change.next()) {
                TableView.this.removeColumnsListener(change.getRemoved(), TableView.this.weakColumnsObserver);
                TableView.this.addColumnsListener(change.getAddedSubList(), TableView.this.weakColumnsObserver);
                if (change.wasRemoved()) {
                    arrayList.addAll(change.getRemoved());
                }
                if (!change.wasAdded()) continue;
                arrayList.removeAll(change.getAddedSubList());
            }
            TableView.this.sortOrder.removeAll(arrayList);
        }
    };
    private final InvalidationListener columnVisibleObserver = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableView.this.updateVisibleLeafColumns();
        }
    };
    private final InvalidationListener columnSortableObserver = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableColumn tableColumn = (TableColumn)((BooleanProperty)observable).getBean();
            if (!TableView.this.getSortOrder().contains(tableColumn)) {
                return;
            }
            TableView.this.sort();
        }
    };
    private final InvalidationListener columnSortTypeObserver = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableColumn tableColumn = (TableColumn)((ObjectProperty)observable).getBean();
            if (!TableView.this.getSortOrder().contains(tableColumn)) {
                return;
            }
            TableView.this.sort();
        }
    };
    private final WeakInvalidationListener weakColumnVisibleObserver = new WeakInvalidationListener(this.columnVisibleObserver);
    private final WeakInvalidationListener weakColumnSortableObserver = new WeakInvalidationListener(this.columnSortableObserver);
    private final WeakInvalidationListener weakColumnSortTypeObserver = new WeakInvalidationListener(this.columnSortTypeObserver);
    private final WeakListChangeListener weakColumnsObserver = new WeakListChangeListener(this.columnsObserver);
    private ObjectProperty<ObservableList<S>> items = new SimpleObjectProperty<ObservableList<S>>(this, "items"){
        WeakReference<ObservableList<S>> oldItemsRef;

        @Override
        protected void invalidated() {
            ObservableList observableList;
            ObservableList observableList2 = observableList = this.oldItemsRef == null ? null : (ObservableList)this.oldItemsRef.get();
            if (TableView.this.getSelectionModel() instanceof TableViewArrayListSelectionModel) {
                ((TableViewArrayListSelectionModel)TableView.this.getSelectionModel()).updateItemsObserver(observableList, TableView.this.getItems());
            }
            if (TableView.this.getFocusModel() instanceof TableViewFocusModel) {
                TableView.this.getFocusModel().updateItemsObserver(observableList, TableView.this.getItems());
            }
            if (TableView.this.getSkin() instanceof TableViewSkin) {
                TableViewSkin tableViewSkin = (TableViewSkin)TableView.this.getSkin();
                tableViewSkin.updateTableItems(observableList, TableView.this.getItems());
            }
            this.oldItemsRef = new WeakReference(TableView.this.getItems());
        }
    };
    private BooleanProperty tableMenuButtonVisible;
    private ObjectProperty<Callback<ResizeFeatures, Boolean>> columnResizePolicy;
    private ObjectProperty<Callback<TableView<S>, TableRow<S>>> rowFactory;
    private ObjectProperty<Node> placeholder;
    private ObjectProperty<TableViewSelectionModel<S>> selectionModel = new SimpleObjectProperty<TableViewSelectionModel<S>>(this, "selectionModel");
    private ObjectProperty<TableViewFocusModel<S>> focusModel;
    private BooleanProperty editable;
    private ReadOnlyObjectWrapper<TablePosition<S, ?>> editingCell;
    private static final String DEFAULT_STYLE_CLASS = "table-view";
    private static final String PSEUDO_CLASS_CELL_SELECTION = "cell-selection";
    private static final String PSEUDO_CLASS_ROW_SELECTION = "row-selection";
    private static final long CELL_SELECTION_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("cell-selection");
    private static final long ROW_SELECTION_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("row-selection");

    private static double resize(TableColumn<?, ?> tableColumn, double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (!tableColumn.isResizable()) {
            return d;
        }
        boolean bl = d < 0.0;
        List<TableColumn<?, ?>> list = TableView.getResizableChildren(tableColumn, bl);
        if (list.size() > 0) {
            return TableView.resizeColumns(list, d);
        }
        double d2 = tableColumn.getWidth() + d;
        if (d2 > tableColumn.getMaxWidth()) {
            tableColumn.impl_setWidth(tableColumn.getMaxWidth());
            return d2 - tableColumn.getMaxWidth();
        }
        if (d2 < tableColumn.getMinWidth()) {
            tableColumn.impl_setWidth(tableColumn.getMinWidth());
            return d2 - tableColumn.getMinWidth();
        }
        tableColumn.impl_setWidth(d2);
        return 0.0;
    }

    private static List<TableColumn<?, ?>> getResizableChildren(TableColumn<?, ?> tableColumn, boolean bl) {
        if (tableColumn == null || tableColumn.getColumns().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        for (TableColumn tableColumn2 : tableColumn.getColumns()) {
            if (!tableColumn2.isVisible() || !tableColumn2.isResizable()) continue;
            if (bl && tableColumn2.getWidth() > tableColumn2.getMinWidth()) {
                arrayList.add(tableColumn2);
                continue;
            }
            if (bl || !(tableColumn2.getWidth() < tableColumn2.getMaxWidth())) continue;
            arrayList.add(tableColumn2);
        }
        return arrayList;
    }

    private static double resizeColumns(List<TableColumn<?, ?>> list, double d) {
        int n = list.size();
        double d2 = d / (double)n;
        double d3 = d;
        int n2 = 0;
        boolean bl = true;
        for (TableColumn<?, ?> tableColumn : list) {
            ++n2;
            double d4 = TableView.resize(tableColumn, d2);
            d3 = d3 - d2 + d4;
            if (d4 == 0.0) continue;
            bl = false;
            d2 = d3 / (double)(n - n2);
        }
        return bl ? 0.0 : d3;
    }

    public TableView() {
        this(FXCollections.observableArrayList());
    }

    public TableView(ObservableList<S> observableList) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setItems(observableList);
        this.setSelectionModel(new TableViewArrayListSelectionModel(this));
        this.setFocusModel(new TableViewFocusModel(this));
        this.getColumns().addListener(this.weakColumnsObserver);
        this.getColumns().addListener(new ListChangeListener<TableColumn<S, ?>>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends TableColumn<S, ?>> change) {
                while (change.next()) {
                    for (TableColumn tableColumn : change.getRemoved()) {
                        tableColumn.setTableView(null);
                    }
                    for (TableColumn tableColumn : change.getAddedSubList()) {
                        tableColumn.setTableView(TableView.this);
                    }
                    TableView.this.removeTableColumnListener(change.getRemoved());
                    TableView.this.addTableColumnListener(change.getAddedSubList());
                }
                TableView.this.updateVisibleLeafColumns();
            }
        });
        this.getSortOrder().addListener(new ListChangeListener<TableColumn<S, ?>>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends TableColumn<S, ?>> change) {
                TableView.this.sort();
            }
        });
        this.getProperties().addListener(new MapChangeListener<Object, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                if (change.wasAdded() && TableView.SET_CONTENT_WIDTH.equals(change.getKey())) {
                    if (change.getValueAdded() instanceof Number) {
                        TableView.this.setContentWidth((Double)change.getValueAdded());
                    }
                    TableView.this.getProperties().remove(TableView.SET_CONTENT_WIDTH);
                }
            }
        });
        this.isInited = true;
    }

    public final ObjectProperty<ObservableList<S>> itemsProperty() {
        return this.items;
    }

    public final void setItems(ObservableList<S> observableList) {
        this.itemsProperty().set(observableList);
    }

    public final ObservableList<S> getItems() {
        return (ObservableList)this.items.get();
    }

    public final BooleanProperty tableMenuButtonVisibleProperty() {
        if (this.tableMenuButtonVisible == null) {
            this.tableMenuButtonVisible = new SimpleBooleanProperty(this, "tableMenuButtonVisible");
        }
        return this.tableMenuButtonVisible;
    }

    public final void setTableMenuButtonVisible(boolean bl) {
        this.tableMenuButtonVisibleProperty().set(bl);
    }

    public final boolean isTableMenuButtonVisible() {
        return this.tableMenuButtonVisible == null ? false : this.tableMenuButtonVisible.get();
    }

    public final void setColumnResizePolicy(Callback<ResizeFeatures, Boolean> callback) {
        this.columnResizePolicyProperty().set(callback);
    }

    public final Callback<ResizeFeatures, Boolean> getColumnResizePolicy() {
        return this.columnResizePolicy == null ? UNCONSTRAINED_RESIZE_POLICY : (Callback)this.columnResizePolicy.get();
    }

    public final ObjectProperty<Callback<ResizeFeatures, Boolean>> columnResizePolicyProperty() {
        if (this.columnResizePolicy == null) {
            this.columnResizePolicy = new ObjectPropertyBase<Callback<ResizeFeatures, Boolean>>(UNCONSTRAINED_RESIZE_POLICY){
                private Callback<ResizeFeatures, Boolean> oldPolicy;

                @Override
                protected void invalidated() {
                    if (TableView.this.isInited) {
                        ((Callback)this.get()).call(new ResizeFeatures(TableView.this, null, 0.0));
                        TableView.this.refresh();
                        if (this.oldPolicy != null) {
                            TableView.this.impl_pseudoClassStateChanged(this.oldPolicy.toString());
                        }
                        if (this.get() != null) {
                            TableView.this.impl_pseudoClassStateChanged(((Callback)this.get()).toString());
                        }
                        this.oldPolicy = (Callback)this.get();
                    }
                }

                @Override
                public Object getBean() {
                    return TableView.this;
                }

                @Override
                public String getName() {
                    return "columnResizePolicy";
                }
            };
        }
        return this.columnResizePolicy;
    }

    public final ObjectProperty<Callback<TableView<S>, TableRow<S>>> rowFactoryProperty() {
        if (this.rowFactory == null) {
            this.rowFactory = new SimpleObjectProperty<Callback<TableView<S>, TableRow<S>>>(this, "rowFactory");
        }
        return this.rowFactory;
    }

    public final void setRowFactory(Callback<TableView<S>, TableRow<S>> callback) {
        this.rowFactoryProperty().set(callback);
    }

    public final Callback<TableView<S>, TableRow<S>> getRowFactory() {
        return this.rowFactory == null ? null : (Callback)this.rowFactory.get();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node node) {
        this.placeholderProperty().set(node);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    public final ObjectProperty<TableViewSelectionModel<S>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setSelectionModel(TableViewSelectionModel<S> tableViewSelectionModel) {
        this.selectionModelProperty().set(tableViewSelectionModel);
    }

    public final TableViewSelectionModel<S> getSelectionModel() {
        return (TableViewSelectionModel)this.selectionModel.get();
    }

    public final void setFocusModel(TableViewFocusModel<S> tableViewFocusModel) {
        this.focusModelProperty().set(tableViewFocusModel);
    }

    public final TableViewFocusModel<S> getFocusModel() {
        return this.focusModel == null ? null : (TableViewFocusModel)this.focusModel.get();
    }

    public final ObjectProperty<TableViewFocusModel<S>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<TableViewFocusModel<S>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final void setEditable(boolean bl) {
        this.editableProperty().set(bl);
    }

    public final boolean isEditable() {
        return this.editable == null ? false : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingCell(TablePosition<S, ?> tablePosition) {
        this.editingCellPropertyImpl().set(tablePosition);
    }

    public final TablePosition<S, ?> getEditingCell() {
        return this.editingCell == null ? null : (TablePosition)this.editingCell.get();
    }

    public final ReadOnlyObjectProperty<TablePosition<S, ?>> editingCellProperty() {
        return this.editingCellPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TablePosition<S, ?>> editingCellPropertyImpl() {
        if (this.editingCell == null) {
            this.editingCell = new ReadOnlyObjectWrapper(this, "editingCell");
        }
        return this.editingCell;
    }

    public final ObservableList<TableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    public final ObservableList<TableColumn<S, ?>> getSortOrder() {
        return this.sortOrder;
    }

    public void scrollTo(int n) {
        this.getProperties().put("VirtualContainerBase.scrollToIndexCentered", n);
    }

    public boolean resizeColumn(TableColumn<S, ?> tableColumn, double d) {
        if (tableColumn == null || Double.compare(d, 0.0) == 0) {
            return false;
        }
        boolean bl = this.getColumnResizePolicy().call(new ResizeFeatures<S>(this, tableColumn, d));
        if (!bl) {
            return false;
        }
        this.refresh();
        return true;
    }

    public void edit(int n, TableColumn<S, ?> tableColumn) {
        if (!this.isEditable() || tableColumn != null && !tableColumn.isEditable()) {
            return;
        }
        this.setEditingCell(new TablePosition(this, n, tableColumn));
    }

    public ObservableList<TableColumn<S, ?>> getVisibleLeafColumns() {
        return this.unmodifiableVisibleLeafColumns;
    }

    public int getVisibleLeafIndex(TableColumn<S, ?> tableColumn) {
        return this.getVisibleLeafColumns().indexOf(tableColumn);
    }

    public TableColumn<S, ?> getVisibleLeafColumn(int n) {
        if (n < 0 || n >= this.visibleLeafColumns.size()) {
            return null;
        }
        return (TableColumn)this.visibleLeafColumns.get(n);
    }

    private void refresh() {
        this.getProperties().put(REFRESH, Boolean.TRUE);
    }

    private void sort() {
        TableColumnComparator tableColumnComparator = new TableColumnComparator();
        for (TableColumn object : this.getSortOrder()) {
            tableColumnComparator.getColumns().add(object);
        }
        if (this.getItems() instanceof TransformationList) {
            List list = this.getItems();
            while (list != null && !(list instanceof SortableList) && list instanceof TransformationList) {
                list = ((TransformationList)list).getDirectSource();
            }
            if (list instanceof SortableList) {
                SortableList sortableList = (SortableList)list;
                sortableList.setComparator(tableColumnComparator);
                if (sortableList.getMode() == SortableList.SortMode.BATCH) {
                    sortableList.sort();
                }
                return;
            }
        }
        FXCollections.sort(this.getItems(), tableColumnComparator);
    }

    private void setContentWidth(double d) {
        this.contentWidth = d;
        if (this.isInited) {
            this.getColumnResizePolicy().call(new ResizeFeatures(this, null, 0.0));
            this.refresh();
        }
    }

    private void updateVisibleLeafColumns() {
        ArrayList arrayList = new ArrayList();
        this.buildVisibleLeafColumns(this.getColumns(), arrayList);
        this.visibleLeafColumns.setAll(arrayList);
        this.getColumnResizePolicy().call(new ResizeFeatures(this, null, 0.0));
        this.refresh();
    }

    private void buildVisibleLeafColumns(List<TableColumn<S, ?>> list, List<TableColumn<S, ?>> list2) {
        for (TableColumn<S, ?> tableColumn : list) {
            boolean bl;
            if (tableColumn == null) continue;
            boolean bl2 = bl = !tableColumn.getColumns().isEmpty();
            if (bl) {
                this.buildVisibleLeafColumns(tableColumn.getColumns(), list2);
                continue;
            }
            if (!tableColumn.isVisible()) continue;
            list2.add(tableColumn);
        }
    }

    private void removeTableColumnListener(List<? extends TableColumn<S, ?>> list) {
        if (list == null) {
            return;
        }
        for (TableColumn<S, ?> tableColumn : list) {
            tableColumn.visibleProperty().removeListener(this.weakColumnVisibleObserver);
            tableColumn.sortableProperty().removeListener(this.weakColumnSortableObserver);
            tableColumn.sortTypeProperty().removeListener(this.weakColumnSortTypeObserver);
            this.removeTableColumnListener(tableColumn.getColumns());
        }
    }

    private void addTableColumnListener(List<? extends TableColumn<S, ?>> list) {
        if (list == null) {
            return;
        }
        for (TableColumn<S, ?> tableColumn : list) {
            tableColumn.visibleProperty().addListener(this.weakColumnVisibleObserver);
            tableColumn.sortableProperty().addListener(this.weakColumnSortableObserver);
            tableColumn.sortTypeProperty().addListener(this.weakColumnSortTypeObserver);
            this.addTableColumnListener(tableColumn.getColumns());
        }
    }

    private void removeColumnsListener(List<? extends TableColumn<S, ?>> list, ListChangeListener listChangeListener) {
        if (list == null) {
            return;
        }
        for (TableColumn<S, ?> tableColumn : list) {
            tableColumn.getColumns().removeListener(listChangeListener);
            this.removeColumnsListener(tableColumn.getColumns(), listChangeListener);
        }
    }

    private void addColumnsListener(List<? extends TableColumn<S, ?>> list, ListChangeListener listChangeListener) {
        if (list == null) {
            return;
        }
        for (TableColumn<S, ?> tableColumn : list) {
            tableColumn.getColumns().addListener(listChangeListener);
            this.addColumnsListener(tableColumn.getColumns(), listChangeListener);
        }
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.getSelectionModel() != null) {
            l |= this.getSelectionModel().isCellSelectionEnabled() ? CELL_SELECTION_PSEUDOCLASS_STATE : ROW_SELECTION_PSEUDOCLASS_STATE;
        }
        return l;
    }

    public static class ResizeFeatures<S> {
        private TableView<S> table;
        private TableColumn<S, ?> column;
        private Double delta;

        public ResizeFeatures(TableView<S> tableView, TableColumn<S, ?> tableColumn, Double d) {
            this.table = tableView;
            this.column = tableColumn;
            this.delta = d;
        }

        public TableColumn<S, ?> getColumn() {
            return this.column;
        }

        public Double getDelta() {
            return this.delta;
        }

        public TableView<S> getTable() {
            return this.table;
        }
    }

    static class TableViewArrayListSelectionModel<S>
    extends TableViewSelectionModel<S> {
        private final TableView<S> tableView;
        private ChangeListener<ObservableList<S>> itemsPropertyListener = new ChangeListener<ObservableList<S>>(){

            @Override
            public void changed(ObservableValue<? extends ObservableList<S>> observableValue, ObservableList<S> observableList, ObservableList<S> observableList2) {
                TableViewArrayListSelectionModel.this.updateItemsObserver(observableList, observableList2);
            }
        };
        private WeakChangeListener<ObservableList<S>> weakItemsPropertyListener = new WeakChangeListener<ObservableList<S>>(this.itemsPropertyListener);
        final ListChangeListener<S> itemsContentListener = new ListChangeListener<S>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends S> change) {
                int n;
                if (TableViewArrayListSelectionModel.this.tableView.getItems() == null || TableViewArrayListSelectionModel.this.tableView.getItems().isEmpty()) {
                    TableViewArrayListSelectionModel.this.setSelectedIndex(-1);
                } else if (TableViewArrayListSelectionModel.this.getSelectedIndex() == -1 && TableViewArrayListSelectionModel.this.getSelectedItem() != null && (n = TableViewArrayListSelectionModel.this.tableView.getItems().indexOf(TableViewArrayListSelectionModel.this.getSelectedItem())) != -1) {
                    TableViewArrayListSelectionModel.this.setSelectedIndex(n);
                }
                TableViewArrayListSelectionModel.this.updateSelection(change);
            }
        };
        final WeakListChangeListener weakItemsContentListener = new WeakListChangeListener<S>(this.itemsContentListener);
        private final ObservableList<TablePosition> selectedCells;
        private final ReadOnlyUnbackedObservableList<Integer> selectedIndices;
        private final ReadOnlyUnbackedObservableList<S> selectedItems;
        private final ReadOnlyUnbackedObservableList<TablePosition> selectedCellsSeq;
        private int previousModelSize = 0;

        public TableViewArrayListSelectionModel(TableView<S> tableView) {
            super(tableView);
            this.tableView = tableView;
            final MappingChange.Map map = new MappingChange.Map<TablePosition, S>(){

                @Override
                public S map(TablePosition tablePosition) {
                    return TableViewArrayListSelectionModel.this.getModelItem(tablePosition.getRow());
                }
            };
            final MappingChange.Map<TablePosition, Integer> map2 = new MappingChange.Map<TablePosition, Integer>(){

                @Override
                public Integer map(TablePosition tablePosition) {
                    return tablePosition.getRow();
                }
            };
            this.selectedCells = FXCollections.observableArrayList();
            this.selectedCells.addListener(new ListChangeListener<TablePosition>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends TablePosition> change) {
                    TableViewArrayListSelectionModel.this.selectedItems.callObservers(new MappingChange(change, map, TableViewArrayListSelectionModel.this.selectedItems));
                    change.reset();
                    TableViewArrayListSelectionModel.this.selectedIndices.callObservers(new MappingChange(change, map2, TableViewArrayListSelectionModel.this.selectedIndices));
                    change.reset();
                    TableViewArrayListSelectionModel.this.selectedCellsSeq.callObservers(new MappingChange(change, MappingChange.NOOP_MAP, TableViewArrayListSelectionModel.this.selectedCellsSeq));
                    change.reset();
                }
            });
            this.selectedIndices = new ReadOnlyUnbackedObservableList<Integer>(){

                @Override
                public Integer get(int n) {
                    return ((TablePosition)TableViewArrayListSelectionModel.this.selectedCells.get(n)).getRow();
                }

                @Override
                public int size() {
                    return TableViewArrayListSelectionModel.this.selectedCells.size();
                }
            };
            this.selectedItems = new ReadOnlyUnbackedObservableList<S>(){

                @Override
                public S get(int n) {
                    return TableViewArrayListSelectionModel.this.getModelItem((Integer)TableViewArrayListSelectionModel.this.selectedIndices.get(n));
                }

                @Override
                public int size() {
                    return TableViewArrayListSelectionModel.this.selectedIndices.size();
                }
            };
            this.selectedCellsSeq = new ReadOnlyUnbackedObservableList<TablePosition>(){

                @Override
                public TablePosition get(int n) {
                    return (TablePosition)TableViewArrayListSelectionModel.this.selectedCells.get(n);
                }

                @Override
                public int size() {
                    return TableViewArrayListSelectionModel.this.selectedCells.size();
                }
            };
            tableView.itemsProperty().addListener(this.weakItemsPropertyListener);
            if (tableView.getItems() != null) {
                tableView.getItems().addListener(this.weakItemsContentListener);
            }
        }

        private void updateItemsObserver(ObservableList<S> observableList, ObservableList<S> observableList2) {
            if (observableList != null) {
                observableList.removeListener(this.weakItemsContentListener);
            }
            if (observableList2 != null) {
                observableList2.addListener(this.weakItemsContentListener);
            }
            this.setSelectedIndex(-1);
        }

        @Override
        public ObservableList<Integer> getSelectedIndices() {
            return this.selectedIndices;
        }

        @Override
        public ObservableList<S> getSelectedItems() {
            return this.selectedItems;
        }

        @Override
        public ObservableList<TablePosition> getSelectedCells() {
            return this.selectedCellsSeq;
        }

        private void updateSelection(ListChangeListener.Change<? extends S> change) {
            while (change.next()) {
                ArrayList<Object> arrayList;
                int n;
                if (change.wasReplaced()) {
                    if (change.getList().isEmpty()) {
                        this.clearSelection();
                        continue;
                    }
                    n = this.getSelectedIndex();
                    if (this.previousModelSize == change.getRemovedSize()) {
                        this.clearSelection();
                        continue;
                    }
                    if (n < this.getRowCount() && n >= 0) {
                        this.clearSelection(n);
                        this.select(n);
                        continue;
                    }
                    this.clearSelection();
                    continue;
                }
                if (change.wasAdded() || change.wasRemoved()) {
                    TablePosition tablePosition;
                    int n2;
                    int n3;
                    n = change.getFrom();
                    int n4 = n3 = change.wasAdded() ? change.getAddedSize() : -change.getRemovedSize();
                    if (n < 0) {
                        return;
                    }
                    arrayList = new ArrayList(this.selectedCells.size());
                    for (n2 = 0; n2 < this.selectedCells.size(); ++n2) {
                        int n5;
                        tablePosition = (TablePosition)this.selectedCells.get(n2);
                        int n6 = n5 = tablePosition.getRow() < n ? tablePosition.getRow() : tablePosition.getRow() + n3;
                        if (n5 < 0) continue;
                        arrayList.add(new TablePosition(this.getTableView(), n5, tablePosition.getTableColumn()));
                    }
                    this.quietClearSelection();
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        tablePosition = (TablePosition)arrayList.get(n2);
                        this.select(tablePosition.getRow(), tablePosition.getTableColumn());
                    }
                    continue;
                }
                if (!change.wasPermutated()) continue;
                n = change.getTo() - change.getFrom();
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n);
                for (int i = change.getFrom(); i < change.getTo(); ++i) {
                    hashMap.put(i, change.getPermutation(i));
                }
                arrayList = new ArrayList<TablePosition>(this.getSelectedCells());
                this.clearSelection();
                ArrayList arrayList2 = new ArrayList(this.getSelectedIndices().size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    TablePosition tablePosition = (TablePosition)arrayList.get(i);
                    if (!hashMap.containsKey(tablePosition.getRow())) continue;
                    Integer n7 = (Integer)hashMap.get(tablePosition.getRow());
                    arrayList2.add(new TablePosition(tablePosition.getTableView(), n7, tablePosition.getTableColumn()));
                }
                this.quietClearSelection();
                this.selectedCells.setAll(arrayList2);
                this.selectedCellsSeq.callObservers(new NonIterableChange.SimpleAddChange<TablePosition>(0, arrayList2.size(), this.selectedCellsSeq));
            }
            this.previousModelSize = this.getRowCount();
        }

        @Override
        public void clearAndSelect(int n) {
            this.clearAndSelect(n, null);
        }

        @Override
        public void clearAndSelect(int n, TableColumn<S, ?> tableColumn) {
            this.quietClearSelection();
            this.select(n, tableColumn);
        }

        @Override
        public void select(int n) {
            this.select(n, null);
        }

        @Override
        public void select(int n, TableColumn<S, ?> tableColumn) {
            if (n < 0 || n >= this.getRowCount()) {
                return;
            }
            if (this.isCellSelectionEnabled() && tableColumn == null) {
                return;
            }
            TablePosition tablePosition = new TablePosition(this.getTableView(), n, tableColumn);
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            if (!this.selectedCells.contains(tablePosition)) {
                this.selectedCells.add(tablePosition);
            }
            this.updateSelectedIndex(n);
            this.focus(n, tableColumn);
        }

        @Override
        public void select(S s) {
            if (this.getTableModel() == null) {
                return;
            }
            Object object = null;
            for (int i = 0; i < this.getRowCount(); ++i) {
                object = this.getTableModel().get(i);
                if (object == null || !object.equals(s)) continue;
                if (this.isSelected(i)) {
                    return;
                }
                if (this.getSelectionMode() == SelectionMode.SINGLE) {
                    this.quietClearSelection();
                }
                this.select(i);
                return;
            }
            this.setSelectedItem(s);
        }

        @Override
        public void selectIndices(int n, int ... nArray) {
            if (nArray == null) {
                this.select(n);
                return;
            }
            int n2 = this.getRowCount();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n3 = nArray[i];
                    if (n3 < 0 || n3 >= n2) continue;
                    this.select(n3);
                    break;
                }
                if (this.selectedCells.isEmpty() && n > 0 && n < n2) {
                    this.select(n);
                }
            } else {
                int n4 = -1;
                ArrayList arrayList = new ArrayList();
                if (n >= 0 && n < n2) {
                    arrayList.add(new TablePosition(this.getTableView(), n, null));
                    n4 = n;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    int n5 = nArray[i];
                    if (n5 < 0 || n5 >= n2) continue;
                    n4 = n5;
                    TablePosition tablePosition = new TablePosition(this.getTableView(), n5, null);
                    if (this.selectedCells.contains(tablePosition)) continue;
                    arrayList.add(tablePosition);
                }
                this.selectedCells.addAll(arrayList);
                if (n4 != -1) {
                    this.select(n4);
                }
            }
        }

        @Override
        public void selectAll() {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                return;
            }
            this.quietClearSelection();
            if (this.getTableModel() == null) {
                return;
            }
            if (this.isCellSelectionEnabled()) {
                ArrayList arrayList = new ArrayList();
                TablePosition tablePosition = null;
                for (int i = 0; i < this.getTableView().getVisibleLeafColumns().size(); ++i) {
                    TableColumn tableColumn = (TableColumn)this.getTableView().getVisibleLeafColumns().get(i);
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        tablePosition = new TablePosition(this.getTableView(), j, tableColumn);
                        arrayList.add(tablePosition);
                    }
                }
                this.selectedCells.setAll(arrayList);
                if (tablePosition != null) {
                    this.select(tablePosition.getRow(), tablePosition.getTableColumn());
                    this.focus(tablePosition.getRow(), tablePosition.getTableColumn());
                }
            } else {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    arrayList.add(new TablePosition(this.getTableView(), i, null));
                }
                this.selectedCells.setAll(arrayList);
                this.select(this.getRowCount() - 1);
                this.focus((TablePosition)arrayList.get(arrayList.size() - 1));
            }
        }

        @Override
        public void clearSelection(int n) {
            this.clearSelection(n, null);
        }

        @Override
        public void clearSelection(int n, TableColumn<S, ?> tableColumn) {
            TablePosition tablePosition = new TablePosition(this.getTableView(), n, tableColumn);
            boolean bl = this.isCellSelectionEnabled();
            for (TablePosition tablePosition2 : this.getSelectedCells()) {
                if ((bl || tablePosition2.getRow() != n) && (!bl || !tablePosition2.equals(tablePosition))) continue;
                this.selectedCells.remove(tablePosition2);
                this.focus(n);
                return;
            }
        }

        @Override
        public void clearSelection() {
            this.updateSelectedIndex(-1);
            this.focus(-1);
            this.quietClearSelection();
        }

        private void quietClearSelection() {
            this.selectedCells.clear();
        }

        @Override
        public boolean isSelected(int n) {
            return this.isSelected(n, null);
        }

        @Override
        public boolean isSelected(int n, TableColumn<S, ?> tableColumn) {
            if (this.isCellSelectionEnabled() && tableColumn == null) {
                return false;
            }
            for (TablePosition tablePosition : this.getSelectedCells()) {
                boolean bl;
                boolean bl2 = bl = !this.isCellSelectionEnabled() || tableColumn == null && tablePosition.getTableColumn() == null || tableColumn != null && tableColumn.equals(tablePosition.getTableColumn());
                if (tablePosition.getRow() != n || !bl) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.selectedCells.isEmpty();
        }

        @Override
        public void selectPrevious() {
            if (this.isCellSelectionEnabled()) {
                TablePosition tablePosition = this.getFocusedCell();
                if (tablePosition.getColumn() - 1 >= 0) {
                    this.select(tablePosition.getRow(), this.getTableColumn(tablePosition.getTableColumn(), -1));
                } else if (tablePosition.getRow() < this.getRowCount() - 1) {
                    this.select(tablePosition.getRow() - 1, this.getTableColumn(this.getTableView().getVisibleLeafColumns().size() - 1));
                }
            } else {
                int n = this.getFocusedIndex();
                if (n == -1) {
                    this.select(this.getRowCount() - 1);
                } else if (n > 0) {
                    this.select(n - 1);
                }
            }
        }

        @Override
        public void selectNext() {
            if (this.isCellSelectionEnabled()) {
                TablePosition tablePosition = this.getFocusedCell();
                if (tablePosition.getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
                    this.select(tablePosition.getRow(), this.getTableColumn(tablePosition.getTableColumn(), 1));
                } else if (tablePosition.getRow() < this.getRowCount() - 1) {
                    this.select(tablePosition.getRow() + 1, this.getTableColumn(0));
                }
            } else {
                int n = this.getFocusedIndex();
                if (n == -1) {
                    this.select(0);
                } else if (n < this.getRowCount() - 1) {
                    this.select(n + 1);
                }
            }
        }

        @Override
        public void selectAboveCell() {
            TablePosition tablePosition = this.getFocusedCell();
            if (tablePosition.getRow() == -1) {
                this.select(this.getRowCount() - 1);
            } else if (tablePosition.getRow() > 0) {
                this.select(tablePosition.getRow() - 1, tablePosition.getTableColumn());
            }
        }

        @Override
        public void selectBelowCell() {
            TablePosition tablePosition = this.getFocusedCell();
            if (tablePosition.getRow() == -1) {
                this.select(0);
            } else if (tablePosition.getRow() < this.getRowCount() - 1) {
                this.select(tablePosition.getRow() + 1, tablePosition.getTableColumn());
            }
        }

        @Override
        public void selectFirst() {
            TablePosition tablePosition = this.getFocusedCell();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            if (this.getRowCount() > 0) {
                if (this.isCellSelectionEnabled()) {
                    this.select(0, tablePosition.getTableColumn());
                } else {
                    this.select(0);
                }
            }
        }

        @Override
        public void selectLast() {
            int n;
            TablePosition tablePosition = this.getFocusedCell();
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            if ((n = this.getRowCount()) > 0 && this.getSelectedIndex() < n - 1) {
                if (this.isCellSelectionEnabled()) {
                    this.select(n - 1, tablePosition.getTableColumn());
                } else {
                    this.select(n - 1);
                }
            }
        }

        @Override
        public void selectLeftCell() {
            if (!this.isCellSelectionEnabled()) {
                return;
            }
            TablePosition tablePosition = this.getFocusedCell();
            if (tablePosition.getColumn() - 1 >= 0) {
                this.select(tablePosition.getRow(), this.getTableColumn(tablePosition.getTableColumn(), -1));
            }
        }

        @Override
        public void selectRightCell() {
            if (!this.isCellSelectionEnabled()) {
                return;
            }
            TablePosition tablePosition = this.getFocusedCell();
            if (tablePosition.getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
                this.select(tablePosition.getRow(), this.getTableColumn(tablePosition.getTableColumn(), 1));
            }
        }

        private TableColumn<S, ?> getTableColumn(int n) {
            return this.getTableView().getVisibleLeafColumn(n);
        }

        private TableColumn<S, ?> getTableColumn(TableColumn<S, ?> tableColumn, int n) {
            int n2 = this.getTableView().getVisibleLeafIndex(tableColumn);
            int n3 = n2 + n;
            return this.getTableView().getVisibleLeafColumn(n3);
        }

        private void updateSelectedIndex(int n) {
            this.setSelectedIndex(n);
            this.setSelectedItem(this.getModelItem(n));
        }

        private void focus(int n) {
            this.focus(n, null);
        }

        private void focus(int n, TableColumn<S, ?> tableColumn) {
            this.focus(new TablePosition(this.getTableView(), n, tableColumn));
        }

        private void focus(TablePosition tablePosition) {
            if (this.getTableView().getFocusModel() == null) {
                return;
            }
            this.getTableView().getFocusModel().focus(tablePosition.getRow(), tablePosition.getTableColumn());
        }

        private int getFocusedIndex() {
            return this.getFocusedCell().getRow();
        }

        private TablePosition getFocusedCell() {
            if (this.getTableView().getFocusModel() == null) {
                return new TablePosition(this.getTableView(), -1, null);
            }
            return this.getTableView().getFocusModel().getFocusedCell();
        }

        private int getRowCount() {
            return this.getTableModel() == null ? -1 : this.getTableModel().size();
        }

        private S getModelItem(int n) {
            if (this.getTableModel() == null) {
                return null;
            }
            if (n < 0 || n >= this.getRowCount()) {
                return null;
            }
            return this.getTableModel().get(n);
        }
    }

    public static class TableViewFocusModel<S>
    extends FocusModel<S> {
        private final TableView<S> tableView;
        private final TablePosition EMPTY_CELL;
        private ChangeListener<ObservableList<S>> itemsPropertyListener = new ChangeListener<ObservableList<S>>(){

            @Override
            public void changed(ObservableValue<? extends ObservableList<S>> observableValue, ObservableList<S> observableList, ObservableList<S> observableList2) {
                TableViewFocusModel.this.updateItemsObserver(observableList, observableList2);
            }
        };
        private WeakChangeListener<ObservableList<S>> weakItemsPropertyListener = new WeakChangeListener<ObservableList<S>>(this.itemsPropertyListener);
        private final ListChangeListener<S> itemsContentListener = new ListChangeListener<S>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends S> change) {
                change.next();
                if (change.getFrom() > TableViewFocusModel.this.getFocusedIndex()) {
                    return;
                }
                change.reset();
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                int n2 = 0;
                while (change.next()) {
                    bl |= change.wasAdded();
                    bl2 |= change.wasRemoved();
                    n += change.getAddedSize();
                    n2 += change.getRemovedSize();
                }
                if (bl && !bl2) {
                    TableViewFocusModel.this.focus(TableViewFocusModel.this.getFocusedIndex() + n);
                } else if (!bl && bl2) {
                    TableViewFocusModel.this.focus(TableViewFocusModel.this.getFocusedIndex() - n2);
                }
            }
        };
        private WeakListChangeListener<S> weakItemsContentListener = new WeakListChangeListener<S>(this.itemsContentListener);
        private ReadOnlyObjectWrapper<TablePosition> focusedCell;

        public TableViewFocusModel(TableView<S> tableView) {
            if (tableView == null) {
                throw new NullPointerException("TableView can not be null");
            }
            this.tableView = tableView;
            this.tableView.itemsProperty().addListener(this.weakItemsPropertyListener);
            if (tableView.getItems() != null) {
                this.tableView.getItems().addListener(this.weakItemsContentListener);
            }
            TablePosition tablePosition = new TablePosition(tableView, -1, null);
            this.setFocusedCell(tablePosition);
            this.EMPTY_CELL = tablePosition;
        }

        private void updateItemsObserver(ObservableList<S> observableList, ObservableList<S> observableList2) {
            if (observableList != null) {
                observableList.removeListener(this.weakItemsContentListener);
            }
            if (observableList2 != null) {
                observableList2.addListener(this.weakItemsContentListener);
            }
        }

        @Override
        protected int getItemCount() {
            if (this.tableView.getItems() == null) {
                return -1;
            }
            return this.tableView.getItems().size();
        }

        @Override
        protected S getModelItem(int n) {
            if (this.tableView.getItems() == null) {
                return null;
            }
            if (n < 0 || n >= this.getItemCount()) {
                return null;
            }
            return (S)this.tableView.getItems().get(n);
        }

        public final ReadOnlyObjectProperty<TablePosition> focusedCellProperty() {
            return this.focusedCellPropertyImpl().getReadOnlyProperty();
        }

        private void setFocusedCell(TablePosition tablePosition) {
            this.focusedCellPropertyImpl().set(tablePosition);
        }

        public final TablePosition getFocusedCell() {
            return this.focusedCell == null ? this.EMPTY_CELL : (TablePosition)this.focusedCell.get();
        }

        private ReadOnlyObjectWrapper<TablePosition> focusedCellPropertyImpl() {
            if (this.focusedCell == null) {
                this.focusedCell = new ReadOnlyObjectWrapper<TablePosition>(this.EMPTY_CELL){
                    private TablePosition old;

                    @Override
                    protected void invalidated() {
                        if (this.get() == null) {
                            return;
                        }
                        if (this.old == null || this.old != null && !this.old.equals(this.get())) {
                            TableViewFocusModel.this.setFocusedIndex(((TablePosition)this.get()).getRow());
                            TableViewFocusModel.this.setFocusedItem(TableViewFocusModel.this.getModelItem(((TablePosition)this.getValue()).getRow()));
                            this.old = (TablePosition)this.get();
                        }
                    }

                    @Override
                    public Object getBean() {
                        return TableViewFocusModel.this;
                    }

                    @Override
                    public String getName() {
                        return "focusedCell";
                    }
                };
            }
            return this.focusedCell;
        }

        public void focus(int n, TableColumn<S, ?> tableColumn) {
            if (n < 0 || n >= this.getItemCount()) {
                this.setFocusedCell(this.EMPTY_CELL);
            } else {
                this.setFocusedCell(new TablePosition(this.tableView, n, tableColumn));
            }
        }

        public void focus(TablePosition tablePosition) {
            if (tablePosition == null) {
                return;
            }
            this.focus(tablePosition.getRow(), tablePosition.getTableColumn());
        }

        public boolean isFocused(int n, TableColumn<S, ?> tableColumn) {
            if (n < 0 || n >= this.getItemCount()) {
                return false;
            }
            TablePosition tablePosition = this.getFocusedCell();
            boolean bl = tableColumn == null || tableColumn != null && tableColumn.equals(tablePosition.getTableColumn());
            return tablePosition.getRow() == n && bl;
        }

        @Override
        public void focus(int n) {
            if (n < 0 || n >= this.getItemCount()) {
                this.setFocusedCell(this.EMPTY_CELL);
            } else {
                this.setFocusedCell(new TablePosition(this.tableView, n, null));
            }
        }

        public void focusAboveCell() {
            TablePosition tablePosition = this.getFocusedCell();
            if (this.getFocusedIndex() == -1) {
                this.focus(this.getItemCount() - 1, tablePosition.getTableColumn());
            } else if (this.getFocusedIndex() > 0) {
                this.focus(this.getFocusedIndex() - 1, tablePosition.getTableColumn());
            }
        }

        public void focusBelowCell() {
            TablePosition tablePosition = this.getFocusedCell();
            if (this.getFocusedIndex() == -1) {
                this.focus(0, tablePosition.getTableColumn());
            } else if (this.getFocusedIndex() != this.getItemCount() - 1) {
                this.focus(this.getFocusedIndex() + 1, tablePosition.getTableColumn());
            }
        }

        public void focusLeftCell() {
            TablePosition tablePosition = this.getFocusedCell();
            if (tablePosition.getColumn() <= 0) {
                return;
            }
            this.focus(tablePosition.getRow(), this.getTableColumn(tablePosition.getTableColumn(), -1));
        }

        public void focusRightCell() {
            TablePosition tablePosition = this.getFocusedCell();
            if (tablePosition.getColumn() == this.getColumnCount() - 1) {
                return;
            }
            this.focus(tablePosition.getRow(), this.getTableColumn(tablePosition.getTableColumn(), 1));
        }

        private int getColumnCount() {
            return this.tableView.getVisibleLeafColumns().size();
        }

        private TableColumn<S, ?> getTableColumn(TableColumn<S, ?> tableColumn, int n) {
            int n2 = this.tableView.getVisibleLeafIndex(tableColumn);
            int n3 = n2 + n;
            return this.tableView.getVisibleLeafColumn(n3);
        }
    }

    public static abstract class TableViewSelectionModel<S>
    extends MultipleSelectionModel<S> {
        private final TableView<S> tableView;
        private BooleanProperty cellSelectionEnabled;

        public TableViewSelectionModel(TableView<S> tableView) {
            if (tableView == null) {
                throw new NullPointerException("TableView can not be null");
            }
            this.tableView = tableView;
            this.selectedIndexProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    if (TableViewSelectionModel.this.getTableModel() == null) {
                        return;
                    }
                    int n = TableViewSelectionModel.this.getSelectedIndex();
                    if (n < 0 || n >= TableViewSelectionModel.this.getTableModel().size()) {
                        TableViewSelectionModel.this.setSelectedItem(null);
                    } else {
                        TableViewSelectionModel.this.setSelectedItem(TableViewSelectionModel.this.getTableModel().get(n));
                    }
                }
            });
        }

        public abstract ObservableList<TablePosition> getSelectedCells();

        public abstract boolean isSelected(int var1, TableColumn<S, ?> var2);

        public abstract void select(int var1, TableColumn<S, ?> var2);

        public abstract void clearAndSelect(int var1, TableColumn<S, ?> var2);

        public abstract void clearSelection(int var1, TableColumn<S, ?> var2);

        public abstract void selectLeftCell();

        public abstract void selectRightCell();

        public abstract void selectAboveCell();

        public abstract void selectBelowCell();

        public final BooleanProperty cellSelectionEnabledProperty() {
            if (this.cellSelectionEnabled == null) {
                this.cellSelectionEnabled = new BooleanPropertyBase(){

                    @Override
                    protected void invalidated() {
                        this.get();
                        TableViewSelectionModel.this.clearSelection();
                        TableViewSelectionModel.this.tableView.impl_pseudoClassStateChanged(TableView.PSEUDO_CLASS_CELL_SELECTION);
                        TableViewSelectionModel.this.tableView.impl_pseudoClassStateChanged(TableView.PSEUDO_CLASS_ROW_SELECTION);
                    }

                    @Override
                    public Object getBean() {
                        return TableViewSelectionModel.this;
                    }

                    @Override
                    public String getName() {
                        return "cellSelectionEnabled";
                    }
                };
            }
            return this.cellSelectionEnabled;
        }

        public final void setCellSelectionEnabled(boolean bl) {
            this.cellSelectionEnabledProperty().set(bl);
        }

        public final boolean isCellSelectionEnabled() {
            return this.cellSelectionEnabled == null ? false : this.cellSelectionEnabled.get();
        }

        public TableView<S> getTableView() {
            return this.tableView;
        }

        protected List<S> getTableModel() {
            return this.tableView.getItems();
        }
    }
}

