/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Utils;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.css.StyleManager;
import java.text.BreakIterator;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

@DefaultProperty(value="text")
public abstract class TextInputControl
extends Control {
    private StringProperty promptText = new SimpleStringProperty(this, "promptText", ""){

        @Override
        protected void invalidated() {
            String string = this.get();
            if (string != null && string.contains("\n")) {
                string = string.replace("\n", "");
                this.set(string);
            }
        }
    };
    private final Content content;
    private TextProperty text = new TextProperty();
    private ReadOnlyIntegerWrapper length = new ReadOnlyIntegerWrapper(this, "length");
    private BooleanProperty editable = new SimpleBooleanProperty(this, "editable", true){

        @Override
        protected void invalidated() {
            TextInputControl.this.impl_pseudoClassStateChanged(TextInputControl.PSEUDO_CLASS_READONLY);
        }
    };
    private ReadOnlyObjectWrapper<IndexRange> selection = new ReadOnlyObjectWrapper<IndexRange>(this, "selection", new IndexRange(0, 0));
    private ReadOnlyStringWrapper selectedText = new ReadOnlyStringWrapper(this, "selectedText");
    private ReadOnlyIntegerWrapper anchor = new ReadOnlyIntegerWrapper(this, "anchor", 0);
    private ReadOnlyIntegerWrapper caretPosition = new ReadOnlyIntegerWrapper(this, "caretPosition", 0);
    private boolean doNotAdjustCaret = false;
    private BreakIterator breakIterator;
    private static final String PSEUDO_CLASS_READONLY = "readonly";
    private static final long PSEUDO_CLASS_READONLY_MASK = StyleManager.getInstance().getPseudoclassMask("readonly");

    protected TextInputControl(final Content content) {
        this.content = content;
        content.addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (content.length() > 0) {
                    TextInputControl.this.text.textIsNull = false;
                }
                TextInputControl.this.text.invalidate();
            }
        });
        this.length.bind(new IntegerBinding(){
            {
                this.bind(TextInputControl.this.text);
            }

            @Override
            protected int computeValue() {
                String string = TextInputControl.this.text.get();
                return string == null ? 0 : string.length();
            }
        });
        this.selectedText.bind(new StringBinding(){
            {
                this.bind(TextInputControl.this.selection, TextInputControl.this.text);
            }

            @Override
            protected String computeValue() {
                int n;
                String string = TextInputControl.this.text.get();
                IndexRange indexRange = (IndexRange)TextInputControl.this.selection.get();
                if (string == null || indexRange == null) {
                    return "";
                }
                int n2 = indexRange.getStart();
                int n3 = indexRange.getEnd();
                if (n3 > n2 + (n = string.length())) {
                    n3 = n;
                }
                if (n2 > n - 1) {
                    n3 = 0;
                    n2 = 0;
                }
                return string.substring(n2, n3);
            }
        });
        this.getStyleClass().add("text-input");
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final void setPromptText(String string) {
        this.promptText.set(string);
    }

    protected final Content getContent() {
        return this.content;
    }

    public final String getText() {
        return this.text.get();
    }

    public final void setText(String string) {
        this.text.set(string);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final int getLength() {
        return this.length.get();
    }

    public final ReadOnlyIntegerProperty lengthProperty() {
        return this.length.getReadOnlyProperty();
    }

    public final boolean isEditable() {
        return this.editable.getValue();
    }

    public final void setEditable(boolean bl) {
        this.editable.setValue(bl);
    }

    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    public final IndexRange getSelection() {
        return (IndexRange)this.selection.getValue();
    }

    public final ReadOnlyObjectProperty<IndexRange> selectionProperty() {
        return this.selection.getReadOnlyProperty();
    }

    public final String getSelectedText() {
        return this.selectedText.get();
    }

    public final ReadOnlyStringProperty selectedTextProperty() {
        return this.selectedText.getReadOnlyProperty();
    }

    public final int getAnchor() {
        return this.anchor.get();
    }

    public final ReadOnlyIntegerProperty anchorProperty() {
        return this.anchor.getReadOnlyProperty();
    }

    public final int getCaretPosition() {
        return this.caretPosition.get();
    }

    public final ReadOnlyIntegerProperty caretPositionProperty() {
        return this.caretPosition.getReadOnlyProperty();
    }

    public String getText(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The start must be <= the end");
        }
        if (n < 0 || n2 > this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.getContent().get(n, n2);
    }

    public void appendText(String string) {
        this.insertText(this.getLength(), string);
    }

    public void insertText(int n, String string) {
        this.replaceText(n, n, string);
    }

    public void deleteText(IndexRange indexRange) {
        this.replaceText(indexRange, "");
    }

    public void deleteText(int n, int n2) {
        this.replaceText(n, n2, "");
    }

    public void replaceText(IndexRange indexRange, String string) {
        if (indexRange == null) {
            throw new NullPointerException();
        }
        int n = indexRange.getStart();
        int n2 = n + indexRange.getLength();
        this.replaceText(n, n2, string);
    }

    public void replaceText(int n, int n2, String string) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 > this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.text.isBound()) {
            this.getContent().delete(n, n2, string.isEmpty());
            this.getContent().insert(n, string, true);
            this.selectRange(n += string.length(), n);
        }
    }

    public void cut() {
        this.copy();
        IndexRange indexRange = this.getSelection();
        this.deleteText(indexRange.getStart(), indexRange.getEnd());
    }

    public void copy() {
        String string = this.getSelectedText();
        if (string.length() > 0) {
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(string);
            Clipboard.getSystemClipboard().setContent(clipboardContent);
        }
    }

    public void paste() {
        String string;
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasString() && (string = clipboard.getString()) != null) {
            this.replaceSelection(string);
        }
    }

    public void selectBackward() {
        if (this.getCaretPosition() > 0 && this.getLength() > 0) {
            this.selectRange(this.getAnchor(), this.getCaretPosition() - 1);
        }
    }

    public void selectForward() {
        int n = this.getLength();
        if (n > 0 && this.getCaretPosition() < n) {
            this.selectRange(this.getAnchor(), this.getCaretPosition() + 1);
        }
    }

    public void previousWord() {
        this.previousWord(false);
    }

    public void nextWord() {
        this.nextWord(false);
    }

    public void endOfNextWord() {
        this.endOfNextWord(false);
    }

    public void selectPreviousWord() {
        this.previousWord(true);
    }

    public void selectNextWord() {
        this.nextWord(true);
    }

    public void selectEndOfNextWord() {
        this.endOfNextWord(true);
    }

    private void previousWord(boolean bl) {
        int n = this.getLength();
        String string = this.getText();
        if (n <= 0) {
            return;
        }
        if (this.breakIterator == null) {
            this.breakIterator = BreakIterator.getWordInstance();
        }
        this.breakIterator.setText(string);
        int n2 = this.breakIterator.preceding(Utils.clamp(0, this.getCaretPosition(), n - 1));
        while (n2 != -1 && !Character.isLetter(string.charAt(Utils.clamp(0, n2, n - 1)))) {
            n2 = this.breakIterator.preceding(Utils.clamp(0, n2, n - 1));
        }
        this.selectRange(bl ? this.getAnchor() : n2, n2);
    }

    private void nextWord(boolean bl) {
        int n = this.getLength();
        String string = this.getText();
        if (n <= 0) {
            return;
        }
        if (this.breakIterator == null) {
            this.breakIterator = BreakIterator.getWordInstance();
        }
        this.breakIterator.setText(string);
        int n2 = this.breakIterator.following(Utils.clamp(0, this.getCaretPosition(), n - 1));
        int n3 = this.breakIterator.next();
        while (n3 != -1) {
            for (int i = n2; i <= n3; ++i) {
                if (!Character.isLetter(string.charAt(Utils.clamp(0, i, n - 1)))) continue;
                if (bl) {
                    this.selectRange(this.getAnchor(), i);
                } else {
                    this.selectRange(i, i);
                }
                return;
            }
            n2 = n3;
            n3 = this.breakIterator.next();
        }
        if (bl) {
            this.selectRange(this.getAnchor(), n);
        } else {
            this.end();
        }
    }

    private void endOfNextWord(boolean bl) {
        int n = this.getLength();
        String string = this.getText();
        if (n <= 0) {
            return;
        }
        if (this.breakIterator == null) {
            this.breakIterator = BreakIterator.getWordInstance();
        }
        this.breakIterator.setText(string);
        int n2 = this.breakIterator.following(Utils.clamp(0, this.getCaretPosition(), n - 1));
        int n3 = this.breakIterator.next();
        while (n3 != -1) {
            for (int i = n2; i <= n3; ++i) {
                if (Character.isLetter(string.charAt(Utils.clamp(0, i, n - 1)))) continue;
                if (bl) {
                    this.selectRange(this.getAnchor(), i);
                } else {
                    this.selectRange(i, i);
                }
                return;
            }
            n2 = n3;
            n3 = this.breakIterator.next();
        }
        if (bl) {
            this.selectRange(this.getAnchor(), n);
        } else {
            this.end();
        }
    }

    public void selectAll() {
        this.selectRange(0, this.getLength());
    }

    public void home() {
        this.selectRange(0, 0);
    }

    public void end() {
        int n = this.getLength();
        if (n > 0) {
            this.selectRange(n, n);
        }
    }

    public void selectHome() {
        this.selectRange(this.getAnchor(), 0);
    }

    public void selectEnd() {
        int n = this.getLength();
        if (n > 0) {
            this.selectRange(this.getAnchor(), n);
        }
    }

    public boolean deletePreviousChar() {
        boolean bl = true;
        if (this.isEditable() && !this.isDisabled()) {
            int n;
            String string = this.getText();
            int n2 = this.getCaretPosition();
            if (n2 != (n = this.getAnchor())) {
                this.replaceSelection("");
                bl = false;
            } else if (n2 > 0) {
                int n3;
                int n4;
                int n5 = 1;
                if (n2 > 1) {
                    n4 = string.codePointAt(n2 - 2);
                    n3 = string.codePointAt(n2 - 1);
                    if (n4 >= 55296 && n4 <= 56319 && n3 >= 56320 && n3 <= 57343) {
                        n5 = 2;
                    }
                }
                this.doNotAdjustCaret = true;
                n4 = n2;
                this.deleteText(n2 - n5, n2);
                n3 = n4 - n5;
                this.selectRange(n3, n3);
                bl = false;
                this.doNotAdjustCaret = false;
            }
        }
        return !bl;
    }

    public boolean deleteNextChar() {
        boolean bl = true;
        if (this.isEditable() && !this.isDisabled()) {
            int n;
            String string = this.getText();
            int n2 = this.getCaretPosition();
            if (n2 != (n = this.getAnchor())) {
                this.replaceSelection("");
                int n3 = Math.min(n2, n);
                this.selectRange(n3, n3);
                bl = false;
            } else if (string.length() > 0 && n2 < string.length()) {
                int n4 = 1;
                if (n2 < string.length() - 2) {
                    int n5 = string.codePointAt(n2 + 2);
                    int n6 = string.codePointAt(n2 + 1);
                    if (n5 >= 55296 && n5 <= 56319 && n6 >= 56320 && n6 <= 57343) {
                        n4 = 2;
                    }
                }
                this.doNotAdjustCaret = true;
                this.deleteText(n2, n2 + n4);
                bl = false;
                this.doNotAdjustCaret = false;
            }
        }
        return !bl;
    }

    public void forward() {
        int n;
        int n2 = this.getLength();
        int n3 = this.getCaretPosition();
        if (n3 != (n = this.getAnchor())) {
            int n4 = Math.max(n3, n);
            this.selectRange(n4, n4);
        } else if (n3 < n2 && n2 > 0) {
            int n5 = n3 + 1;
            this.selectRange(n5, n5);
        }
        this.deselect();
    }

    public void backward() {
        int n;
        int n2 = this.getLength();
        int n3 = this.getCaretPosition();
        if (n3 != (n = this.getAnchor())) {
            int n4 = Math.min(n3, n);
            this.selectRange(n4, n4);
        } else if (n3 > 0 && n2 > 0) {
            int n5 = n3 - 1;
            this.selectRange(n5, n5);
        }
        this.deselect();
    }

    public void positionCaret(int n) {
        int n2 = Utils.clamp(0, n, this.getLength());
        this.selectRange(n2, n2);
    }

    public void selectPositionCaret(int n) {
        this.selectRange(this.getAnchor(), Utils.clamp(0, n, this.getLength()));
    }

    public void selectRange(int n, int n2) {
        this.caretPosition.set(Utils.clamp(0, n2, this.getLength()));
        this.anchor.set(Utils.clamp(0, n, this.getLength()));
        this.selection.set(IndexRange.normalize(this.getAnchor(), this.getCaretPosition()));
    }

    public void extendSelection(int n) {
        int n2 = Utils.clamp(0, n, this.getLength());
        int n3 = this.getCaretPosition();
        int n4 = this.getAnchor();
        int n5 = Math.min(n3, n4);
        int n6 = Math.max(n3, n4);
        if (n2 < n5) {
            this.selectRange(n6, n2);
        } else {
            this.selectRange(n5, n2);
        }
    }

    public void clear() {
        this.deselect();
        if (!this.text.isBound()) {
            this.setText("");
        }
    }

    public void deselect() {
        this.selectRange(this.getCaretPosition(), this.getCaretPosition());
    }

    public void replaceSelection(String string) {
        if (this.text.isBound()) {
            return;
        }
        if (string == null) {
            throw new NullPointerException();
        }
        int n = this.getCaretPosition();
        int n2 = this.getAnchor();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = n;
        if (this.getLength() == 0) {
            this.doNotAdjustCaret = true;
            this.setText(string);
            this.selectRange(this.getLength(), this.getLength());
            this.doNotAdjustCaret = false;
        } else {
            this.deselect();
            this.doNotAdjustCaret = true;
            int n6 = this.getLength();
            n4 = Math.min(n4, n6);
            if (n4 > n3) {
                this.getContent().delete(n3, n4, string.isEmpty());
                n6 -= n4 - n3;
            }
            this.getContent().insert(n3, string, true);
            int n7 = n3 + this.getLength() - n6;
            this.selectRange(n7, n7);
            this.doNotAdjustCaret = false;
        }
    }

    void textUpdated() {
    }

    static String filterInput(String string, boolean bl, boolean bl2) {
        if (TextInputControl.containsInvalidCharacters(string, bl, bl2)) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (TextInputControl.isInvalidCharacter(c, bl, bl2)) continue;
                stringBuilder.append(c);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    static boolean containsInvalidCharacters(String string, boolean bl, boolean bl2) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!TextInputControl.isInvalidCharacter(c, bl, bl2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInvalidCharacter(char c, boolean bl, boolean bl2) {
        if (c == '\u007f') {
            return true;
        }
        if (c == '\n') {
            return bl;
        }
        if (c == '\t') {
            return bl2;
        }
        return c < ' ';
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (!this.isEditable()) {
            l |= PSEUDO_CLASS_READONLY_MASK;
        }
        return l;
    }

    protected static interface Content
    extends ObservableStringValue {
        public String get(int var1, int var2);

        public void insert(int var1, String var2, boolean var3);

        public void delete(int var1, int var2, boolean var3);

        public int length();
    }

    private class TextProperty
    extends StringProperty {
        private ObservableValue<? extends String> observable = null;
        private InvalidationListener listener = null;
        private ExpressionHelper<String> helper = null;
        private boolean textIsNull = false;

        private TextProperty() {
        }

        @Override
        public String get() {
            return this.textIsNull ? null : (String)TextInputControl.this.content.get();
        }

        @Override
        public void set(String string) {
            if (this.isBound()) {
                throw new RuntimeException("A bound value cannot be set.");
            }
            this.doSet(string);
            this.markInvalid();
        }

        private void invalidate() {
            this.markInvalid();
        }

        @Override
        public void bind(ObservableValue<? extends String> observableValue) {
            if (observableValue == null) {
                throw new NullPointerException("Cannot bind to null");
            }
            if (!observableValue.equals(this.observable)) {
                this.unbind();
                this.observable = observableValue;
                if (this.listener == null) {
                    this.listener = new Listener();
                }
                this.observable.addListener(this.listener);
                this.markInvalid();
                this.doSet(observableValue.getValue());
            }
        }

        @Override
        public void unbind() {
            if (this.observable != null) {
                this.doSet(this.observable.getValue());
                this.observable.removeListener(this.listener);
                this.observable = null;
            }
        }

        @Override
        public boolean isBound() {
            return this.observable != null;
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
        }

        @Override
        public void addListener(ChangeListener<? super String> changeListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super String> changeListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
        }

        @Override
        public Object getBean() {
            return TextInputControl.this;
        }

        @Override
        public String getName() {
            return "text";
        }

        private void fireValueChangedEvent() {
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }

        private void markInvalid() {
            this.fireValueChangedEvent();
        }

        private void doSet(String string) {
            boolean bl = this.textIsNull = string == null;
            if (string == null) {
                string = "";
            }
            TextInputControl.this.content.delete(0, TextInputControl.this.content.length(), string.isEmpty());
            TextInputControl.this.content.insert(0, string, true);
            if (!TextInputControl.this.doNotAdjustCaret) {
                TextInputControl.this.selectRange(0, 0);
                TextInputControl.this.textUpdated();
            }
        }

        private class Listener
        implements InvalidationListener {
            private Listener() {
            }

            @Override
            public void invalidated(Observable observable) {
                TextProperty.this.doSet((String)TextProperty.this.observable.getValue());
            }
        }
    }
}

