/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public class HBox
extends Pane {
    private static final String MARGIN_CONSTRAINT = "hbox-margin";
    private static final String HGROW_CONSTRAINT = "hbox-hgrow";
    private DoubleProperty spacing;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty fillHeight;
    private double[] actualAreaWidths;

    public static void setHgrow(Node node, Priority priority) {
        HBox.setConstraint(node, HGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getHgrow(Node node) {
        return (Priority)((Object)HBox.getConstraint(node, HGROW_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        HBox.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)HBox.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        HBox.setHgrow(node, null);
        HBox.setMargin(node, null);
    }

    public HBox() {
    }

    public HBox(double d) {
        this();
        this.setSpacing(d);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SPACING;
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "spacing";
                }
            };
        }
        return this.spacing;
    }

    public final void setSpacing(double d) {
        this.spacingProperty().set(d);
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final BooleanProperty fillHeightProperty() {
        if (this.fillHeight == null) {
            this.fillHeight = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.FILL_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "fillHeight";
                }
            };
        }
        return this.fillHeight;
    }

    public final void setFillHeight(boolean bl) {
        this.fillHeightProperty().set(bl);
    }

    public final boolean isFillHeight() {
        return this.fillHeight == null ? true : this.fillHeight.get();
    }

    private boolean shouldFillHeight() {
        return this.isFillHeight() && this.getAlignment().getVpos() != VPos.BASELINE;
    }

    @Override
    public Orientation getContentBias() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged() || node.getContentBias() == null) continue;
            return node.getContentBias();
        }
        return null;
    }

    @Override
    protected double computeMinWidth(double d) {
        Insets insets = this.getInsets();
        return this.snapSpace(insets.getLeft()) + this.computeContentWidth(this.getAreaWidths(this.getManagedChildren(), d, true)) + this.snapSpace(insets.getRight());
    }

    @Override
    protected double computeMinHeight(double d) {
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        double d2 = 0.0;
        if (this.getContentBias() == Orientation.HORIZONTAL) {
            double[] dArray = this.getAreaWidths(list, -1.0, true);
            this.adjustAreaWidths(list, dArray, d, -1.0);
            d2 = this.computeMaxMinAreaHeight(list, this.getMargins(list), dArray, this.getAlignment().getVpos());
        } else {
            d2 = this.computeMaxMinAreaHeight(list, this.getMargins(list), this.getAlignment().getVpos());
        }
        return this.snapSpace(insets.getTop()) + d2 + this.snapSpace(insets.getBottom());
    }

    @Override
    protected double computePrefWidth(double d) {
        Insets insets = this.getInsets();
        return this.snapSpace(insets.getLeft()) + this.computeContentWidth(this.getAreaWidths(this.getManagedChildren(), d, false)) + this.snapSpace(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        double d2 = 0.0;
        if (this.getContentBias() == Orientation.HORIZONTAL) {
            double[] dArray = this.getAreaWidths(list, -1.0, false);
            this.adjustAreaWidths(list, dArray, d, -1.0);
            d2 = this.computeMaxPrefAreaHeight(list, this.getMargins(list), dArray, this.getAlignment().getVpos());
        } else {
            d2 = this.computeMaxPrefAreaHeight(list, this.getMargins(list), this.getAlignment().getVpos());
        }
        return this.snapSpace(insets.getTop()) + d2 + this.snapSpace(insets.getBottom());
    }

    private Insets[] getMargins(List<Node> list) {
        Insets[] insetsArray = new Insets[list.size()];
        for (int i = 0; i < insetsArray.length; ++i) {
            insetsArray[i] = HBox.getMargin(list.get(i));
        }
        return insetsArray;
    }

    private double[] getAreaWidths(List<Node> list, double d, boolean bl) {
        double[] dArray = new double[list.size()];
        double d2 = d == -1.0 ? -1.0 : d - this.snapSpace(this.getInsets().getTop()) - this.snapSpace(this.getInsets().getBottom());
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            Insets insets = HBox.getMargin(node);
            dArray[i] = bl ? this.computeChildMinAreaWidth(node, insets, this.shouldFillHeight() ? d2 : node.minHeight(-1.0)) : this.computeChildPrefAreaWidth(node, insets, this.shouldFillHeight() ? d2 : node.prefHeight(-1.0));
        }
        return dArray;
    }

    private double adjustAreaWidths(List<Node> list, double[] dArray, double d, double d2) {
        Insets insets = this.getInsets();
        double d3 = this.snapSpace(insets.getTop());
        double d4 = this.snapSpace(insets.getBottom());
        double d5 = this.snapSpace(this.getSpacing());
        double d6 = this.computeContentWidth(dArray);
        double d7 = (d == -1.0 ? this.prefWidth(-1.0) : d) - this.snapSpace(insets.getLeft()) - this.snapSpace(insets.getRight()) - d6;
        if (d7 != 0.0) {
            double d8 = this.growOrShrinkAreaWidths(list, dArray, Priority.ALWAYS, d7, this.shouldFillHeight() && d2 != -1.0 ? d2 - d3 - d4 : -1.0);
            d8 = this.growOrShrinkAreaWidths(list, dArray, Priority.SOMETIMES, d8, this.shouldFillHeight() && d2 != -1.0 ? d2 - d3 - d4 : -1.0);
            d6 += d7 - d8;
        }
        return d6;
    }

    private double growOrShrinkAreaWidths(List<Node> list, double[] dArray, Priority priority, double d, double d2) {
        Node[] nodeArray;
        boolean bl = d < 0.0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            if (!bl && HBox.getHgrow(node) != priority) continue;
            arrayList.add(node);
            arrayList2.add(node);
        }
        double[] dArray2 = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node = (Node)arrayList.get(i);
            nodeArray = HBox.getMargin(node);
            dArray2[i] = bl ? this.computeChildMinAreaWidth(node, (Insets)nodeArray, d2) : this.computeChildMaxAreaWidth(node, (Insets)nodeArray, d2);
        }
        double d3 = d;
        while (Math.abs(d3) > 1.0 && arrayList2.size() > 0) {
            nodeArray = new Node[arrayList.size()];
            double d4 = d3 / (double)arrayList2.size();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Node node = (Node)arrayList2.get(i);
                int n = list.indexOf(node);
                double d5 = dArray2[arrayList.indexOf(node)] - dArray[n];
                double d6 = Math.abs(d5) <= Math.abs(d4) ? d5 : d4;
                int n2 = n;
                dArray[n2] = dArray[n2] + d6;
                d3 -= d6;
                if (!(Math.abs(d6) < Math.abs(d4))) continue;
                nodeArray[i] = node;
            }
            for (Node node : nodeArray) {
                if (node == null) continue;
                arrayList2.remove(node);
            }
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.snapSpace(dArray[i]);
        }
        return d3;
    }

    private double computeContentWidth(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d + (double)(dArray.length - 1) * this.snapSpace(this.getSpacing());
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        Insets insets = this.getInsets();
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.snapSpace(insets.getTop());
        double d4 = this.snapSpace(insets.getLeft());
        double d5 = this.snapSpace(insets.getBottom());
        double d6 = this.snapSpace(insets.getRight());
        double d7 = this.snapSpace(this.getSpacing());
        this.actualAreaWidths = this.getAreaWidths(list, d2, false);
        double d8 = this.adjustAreaWidths(list, this.actualAreaWidths, d, d2);
        double d9 = d2 - d3 - d5;
        double d10 = this.snapSpace(insets.getLeft()) + HBox.computeXOffset(d - d4 - d6, d8, this.getAlignment().getHpos());
        double d11 = this.snapSpace(insets.getTop());
        double d12 = this.getAlignment().getVpos() == VPos.BASELINE ? HBox.getMaxBaselineOffset(list) : d2 / 2.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            Insets insets2 = HBox.getMargin(node);
            this.layoutInArea(node, d10, d11, this.actualAreaWidths[i], d9, d12, insets2, true, this.shouldFillHeight(), this.getAlignment().getHpos(), this.getAlignment().getVpos());
            d10 += this.actualAreaWidths[i] + d7;
        }
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return HBox.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<HBox, Pos> ALIGNMENT = new StyleableProperty<HBox, Pos>("-fx-alignment", new EnumConverter(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(HBox hBox) {
                return hBox.alignment == null || !hBox.alignment.isBound();
            }

            @Override
            public WritableValue<Pos> getWritableValue(HBox hBox) {
                return hBox.alignmentProperty();
            }
        };
        private static final StyleableProperty<HBox, Boolean> FILL_HEIGHT = new StyleableProperty<HBox, Boolean>("-fx-fill-height", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(HBox hBox) {
                return hBox.fillHeight == null || !hBox.fillHeight.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(HBox hBox) {
                return hBox.fillHeightProperty();
            }
        };
        private static final StyleableProperty<HBox, Number> SPACING = new StyleableProperty<HBox, Number>("-fx-spacing", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(HBox hBox) {
                return hBox.spacing == null || !hBox.spacing.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(HBox hBox) {
                return hBox.spacingProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Pane.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FILL_HEIGHT, ALIGNMENT, SPACING);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

