/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.autoupdate.Downloader;

public class DownloadManager
extends Thread {
    private static final Logger logger = Logger.getLogger(DownloadManager.class);
    private List<Downloader> currentDownloads = new ArrayList<Downloader>();
    private List<Downloader> completedDownloads = new ArrayList<Downloader>();
    private boolean shutdown = false;
    private boolean cancelDownloads = false;
    private ConnectionParam connectionParam;

    public DownloadManager(ConnectionParam connectionParam) {
        super("ZAP-DownloadManager");
        this.connectionParam = connectionParam;
        this.setDaemon(true);
        Authenticator.setDefault(new ZapProxyAuthenticator());
    }

    public Downloader downloadFile(URL url, File targetFile, long size, String hash) {
        Proxy proxy;
        logger.debug((Object)("Download file " + url + " to " + targetFile.getAbsolutePath()));
        if (this.connectionParam.isUseProxy(url.getHost())) {
            InetSocketAddress scoketAddress = new InetSocketAddress(this.connectionParam.getProxyChainName(), this.connectionParam.getProxyChainPort());
            proxy = new Proxy(Proxy.Type.HTTP, scoketAddress);
        } else {
            proxy = Proxy.NO_PROXY;
        }
        Downloader dl = new Downloader(url, proxy, targetFile, size, hash);
        dl.start();
        this.currentDownloads.add(dl);
        return dl;
    }

    @Override
    public void run() {
        while (this.getCurrentDownloadCount() > 0 || !this.shutdown) {
            ArrayList<Downloader> finishedDownloads = new ArrayList<Downloader>();
            for (Downloader dl : this.currentDownloads) {
                if (!dl.isAlive()) {
                    if (dl.getException() != null) {
                        logger.debug((Object)("Download failed " + dl.getTargetFile().getAbsolutePath()));
                    } else if (dl.isValidated()) {
                        logger.debug((Object)("Download finished " + dl.getTargetFile().getAbsolutePath()));
                    } else {
                        logger.error((Object)("Validation failed " + dl.getTargetFile().getAbsolutePath()));
                        dl.cancelDownload();
                        if (View.isInitialised()) {
                            View.getSingleton().showWarningDialog(Constant.messages.getString("cfu.warn.badhash", dl.getTargetFile().getName()));
                        }
                    }
                    finishedDownloads.add(dl);
                    continue;
                }
                if (this.cancelDownloads) {
                    logger.debug((Object)("Cancelling download " + dl.getTargetFile().getAbsolutePath()));
                    dl.cancelDownload();
                    continue;
                }
                logger.debug((Object)("Still downloading " + dl.getTargetFile().getAbsolutePath() + " progress % " + dl.getProgressPercent()));
            }
            for (Downloader dl : finishedDownloads) {
                this.completedDownloads.add(dl);
                this.currentDownloads.remove(dl);
            }
            try {
                if (this.getCurrentDownloadCount() > 0) {
                    DownloadManager.sleep(200L);
                    continue;
                }
                DownloadManager.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.debug((Object)"Shutdown");
    }

    public int getCurrentDownloadCount() {
        return this.currentDownloads.size();
    }

    public void shutdown(boolean cancelDownloads) {
        this.shutdown = true;
        this.cancelDownloads = cancelDownloads;
    }

    public int getProgressPercent(URL url) throws Exception {
        for (Downloader dl : this.currentDownloads) {
            if (!dl.getUrl().equals(url)) continue;
            if (dl.getException() != null) {
                throw dl.getException();
            }
            return dl.getProgressPercent();
        }
        for (Downloader dl : this.completedDownloads) {
            if (!dl.getUrl().equals(url)) continue;
            if (dl.getException() != null) {
                throw dl.getException();
            }
            return 100;
        }
        return -1;
    }

    public List<Downloader> getProgress() {
        ArrayList<Downloader> allDownloads = new ArrayList<Downloader>();
        for (Downloader d : this.currentDownloads) {
            allDownloads.add(d);
        }
        for (Downloader d : this.completedDownloads) {
            allDownloads.add(d);
        }
        return allDownloads;
    }

    private final class ZapProxyAuthenticator
    extends Authenticator {
        private ZapProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
                return null;
            }
            if (this.getRequestingURL() == null) {
                return null;
            }
            if (!DownloadManager.this.connectionParam.isUseProxy(this.getRequestingURL().getHost())) {
                return null;
            }
            if (DownloadManager.this.connectionParam.getProxyChainPort() != this.getRequestingPort()) {
                return null;
            }
            if (!DownloadManager.this.connectionParam.getProxyChainName().equals(this.getRequestingHost())) {
                return null;
            }
            return new PasswordAuthentication(DownloadManager.this.connectionParam.getProxyChainUserName(), DownloadManager.this.connectionParam.getProxyChainPassword().toCharArray());
        }
    }
}

