/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.response;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;

public class ResponseByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    private static final Logger logger = Logger.getLogger(ResponseByteHttpPanelViewModel.class);

    @Override
    public byte[] getData() {
        if (this.httpMessage == null || this.httpMessage.getResponseHeader().isEmpty()) {
            return new byte[0];
        }
        byte[] headerBytes = this.httpMessage.getResponseHeader().toString().getBytes();
        byte[] bodyBytes = this.httpMessage.getResponseBody().getBytes();
        byte[] bytes = new byte[headerBytes.length + bodyBytes.length];
        System.arraycopy(headerBytes, 0, bytes, 0, headerBytes.length);
        System.arraycopy(bodyBytes, 0, bytes, headerBytes.length, bodyBytes.length);
        return bytes;
    }

    @Override
    public void setData(byte[] data) {
        int pos = this.findHeaderLimit(data);
        if (pos == -1) {
            logger.warn((Object)("Could not Save Header, limit not found. Header: " + new String(data)));
            return;
        }
        try {
            this.httpMessage.setResponseHeader(new String(data, 0, pos));
        }
        catch (HttpMalformedHeaderException e) {
            logger.warn((Object)("Could not Save Header: " + Arrays.toString(data)), (Throwable)e);
        }
        this.httpMessage.getResponseBody().setBody(ArrayUtils.subarray((byte[])data, (int)pos, (int)data.length));
        HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
    }

    private int findHeaderLimit(byte[] data) {
        boolean lastIsCRLF = false;
        boolean lastIsCR = false;
        boolean lastIsLF = false;
        int pos = -1;
        for (int i = 0; i < data.length; ++i) {
            if (!lastIsCR && data[i] == 13) {
                lastIsCR = true;
                continue;
            }
            if (!lastIsLF && data[i] == 10) {
                if (lastIsCRLF) {
                    pos = i;
                    break;
                }
                lastIsCRLF = true;
                lastIsCR = false;
                lastIsLF = false;
                continue;
            }
            lastIsCR = false;
            lastIsLF = false;
            lastIsCRLF = false;
        }
        return pos;
    }
}

