/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderGitParser
extends SpiderParser {
    private SpiderParam params;
    private static final Pattern gitIndexFilenamePattern = Pattern.compile("/.git/index$");
    private static final Pattern gitIndexContentPattern = Pattern.compile("^DIRC");
    private Pattern GIT_FILE_PATTERN = Pattern.compile("/\\.git/index$");

    public SpiderGitParser(SpiderParam params) {
        this.params = params;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        if (message == null || !this.params.isParseGit()) {
            return false;
        }
        log.debug((Object)"Parsing a Git resource...");
        byte[] data = message.getResponseBody().getBytes();
        String baseURL = message.getRequestHeader().getURI().toString();
        try {
            Matcher gitIndexFilenameMatcher;
            String fullpath = message.getRequestHeader().getURI().getPath();
            if (fullpath == null) {
                fullpath = "";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The full path is [" + fullpath + "]"));
            }
            if (!(gitIndexFilenameMatcher = gitIndexFilenamePattern.matcher(fullpath)).find()) {
                log.warn((Object)("This path cannot be handled by the Git parser: " + fullpath));
                return false;
            }
            Matcher gitIndexContentMatcher = gitIndexContentPattern.matcher(new String(data));
            if (!gitIndexContentMatcher.find()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The file '" + fullpath + "' could not be parsed as a Git Index file due to unexpected content"));
                }
                return false;
            }
            ByteBuffer dataBuffer = ByteBuffer.wrap(data);
            byte[] dircArray = new byte[4];
            dataBuffer.get(dircArray, 0, 4);
            int indexFileVersion = dataBuffer.getInt();
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Git index file version is " + indexFileVersion));
            }
            int indexEntryCount = dataBuffer.getInt();
            if (log.isDebugEnabled()) {
                log.debug((Object)(indexEntryCount + " entries were found in the Git index file "));
            }
            if (indexFileVersion != 2 && indexFileVersion != 3 && indexFileVersion != 4) {
                throw new Exception("Only Git Index File versions 2, 3, and 4 are currently supported. Git Index File Version " + indexFileVersion + " was found.");
            }
            String previousIndexEntryName = "";
            for (int entryIndex = 0; entryIndex < indexEntryCount; ++entryIndex) {
                int entryBytesRead = 0;
                int indexEntryCtime1 = dataBuffer.getInt();
                entryBytesRead += 4;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entry " + entryIndex + " has indexEntryCtime1 " + indexEntryCtime1));
                }
                int indexEntryCtime2 = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryMtime1 = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryMtime2 = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryDev = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryInode = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryMode = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryUid = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntryGid = dataBuffer.getInt();
                entryBytesRead += 4;
                int indexEntrySize = dataBuffer.getInt();
                entryBytesRead += 4;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entry " + entryIndex + " has size " + indexEntrySize));
                }
                byte[] indexEntryIdBuffer = new byte[20];
                dataBuffer.get(indexEntryIdBuffer, 0, 20);
                entryBytesRead += 20;
                String indexEntryId = new String(indexEntryIdBuffer);
                short indexEntryFlags = dataBuffer.getShort();
                entryBytesRead += 2;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entry " + entryIndex + " has flags " + indexEntryFlags));
                }
                int indexEntryNameByteLength = indexEntryFlags & 0xFFF;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entry " + entryIndex + " has a name of length " + indexEntryNameByteLength));
                }
                int indexEntryExtendedFlag = (indexEntryFlags & 0x4000) >> 14;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entry " + entryIndex + " has an extended flag of " + indexEntryExtendedFlag));
                }
                if (indexEntryExtendedFlag != 0 && indexEntryExtendedFlag != 1) {
                    throw new Exception("Error parsing out the extended flag for index entry " + entryIndex + ". We got " + indexEntryExtendedFlag);
                }
                if (indexFileVersion == 2 && indexEntryExtendedFlag != 0) {
                    throw new Exception("Index File Version 2 is supposed to have the extended flag set to 0. For index entry " + entryIndex + ", it is set to " + indexEntryExtendedFlag);
                }
                if (indexFileVersion > 2 && indexEntryExtendedFlag == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("For Index file version " + indexFileVersion + ", reading an extra 16 bits for Entry " + entryIndex));
                    }
                    short indexEntryExtendedFlags = dataBuffer.getShort();
                    entryBytesRead += 2;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Entry " + entryIndex + " has (optional) extended flags " + indexEntryExtendedFlags));
                    }
                }
                String indexEntryName = null;
                if (indexFileVersion > 3) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Inflating the (deflated) entry name for index entry " + entryIndex + " based on the previous entry name, since Index file version " + indexFileVersion + " requires this"));
                    }
                    int n = 0;
                    int removeNfromPreviousName = 0;
                    int msbsetmask = -128;
                    byte msbunsetmask = (byte)(~msbsetmask & 0xFF);
                    while (++n > 0) {
                        byte byteRead = dataBuffer.get();
                        ++entryBytesRead;
                        removeNfromPreviousName = n == 1 ? removeNfromPreviousName << 8 | 0xFF & (byteRead & msbunsetmask) : removeNfromPreviousName << 8 | 0xFF & (byteRead | msbsetmask);
                        if ((byteRead & msbsetmask) != 0) continue;
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("We read " + n + " bytes of variable length data from before the start of the entry name"));
                    }
                    if (n > 4) {
                        throw new Exception("An entry name is never expected to be > 2^^32 bytes long. Some file corruption may have occurred, or a parsing error has occurred");
                    }
                    int bytesToReadCurrentNameEntry = indexEntryNameByteLength - (previousIndexEntryName.length() - removeNfromPreviousName);
                    byte[] indexEntryNameBuffer = new byte[bytesToReadCurrentNameEntry];
                    dataBuffer.get(indexEntryNameBuffer, 0, bytesToReadCurrentNameEntry);
                    entryBytesRead += bytesToReadCurrentNameEntry;
                    indexEntryName = previousIndexEntryName.substring(0, previousIndexEntryName.length() - removeNfromPreviousName) + new String(indexEntryNameBuffer);
                } else {
                    byte[] indexEntryNameBuffer = new byte[indexEntryNameByteLength];
                    dataBuffer.get(indexEntryNameBuffer, 0, indexEntryNameByteLength);
                    entryBytesRead += indexEntryNameByteLength;
                    indexEntryName = new String(indexEntryNameBuffer);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entry " + entryIndex + " has name " + indexEntryName));
                }
                previousIndexEntryName = indexEntryName;
                byte indexEntryNul = dataBuffer.get();
                ++entryBytesRead;
                if (indexFileVersion < 4) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Aligning to an 8 byte boundary after Entry " + entryIndex + ", since Index file version " + indexFileVersion + " mandates 64 bit alignment for index entries"));
                    }
                    int entryBytesToRead = (8 - entryBytesRead % 8) % 8;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The number of bytes read for index entry " + entryIndex + " thus far is: " + entryBytesRead));
                        log.debug((Object)("So we must read " + entryBytesToRead + " bytes to stay on a 64 bit boundary"));
                    }
                    byte[] indexEntryPadBuffer = new byte[entryBytesToRead];
                    dataBuffer.get(indexEntryPadBuffer, 0, entryBytesToRead);
                    entryBytesRead += entryBytesToRead;
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Not aligning to an 8 byte boundary after Entry " + entryIndex + ", since Index file version " + indexFileVersion + " does not mandate 64 bit alignment for index entries"));
                }
                if (indexEntryName == null || indexEntryName.length() <= 0) continue;
                log.info((Object)("Found file/symbolic link/gitlink " + indexEntryName + " in the Git entries file"));
                this.processURL(message, depth, "../" + indexEntryName, baseURL);
            }
            return true;
        }
        catch (Exception e) {
            log.warn((Object)("An error occurred trying to parse Git url '" + baseURL + "': " + e));
            return true;
        }
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        Matcher matcher = this.GIT_FILE_PATTERN.matcher(path);
        return matcher.find();
    }
}

