'use strict';

// autogenerated

/*
 *
 * http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSS2Properties
 */

var external_dependency_parsers_0 = require("./parsers.js");

var alignContent_export_definition;
alignContent_export_definition = {
  set: function (v) {
    this._setProperty('align-content', v);
  },
  get: function () {
    return this.getPropertyValue('align-content');
  },
  enumerable: true,
  configurable: true
};
var alignItems_export_definition;
alignItems_export_definition = {
  set: function (v) {
    this._setProperty('align-items', v);
  },
  get: function () {
    return this.getPropertyValue('align-items');
  },
  enumerable: true,
  configurable: true
};
var alignmentBaseline_export_definition;
alignmentBaseline_export_definition = {
  set: function (v) {
    this._setProperty('alignment-baseline', v);
  },
  get: function () {
    return this.getPropertyValue('alignment-baseline');
  },
  enumerable: true,
  configurable: true
};
var azimuth_export_definition;
azimuth_export_definition = {
  set: function (v) {
    var valueType = external_dependency_parsers_0.valueType(v);

    if (valueType === external_dependency_parsers_0.TYPES.ANGLE) {
      return this._setProperty('azimuth', external_dependency_parsers_0.parseAngle(v));
    }

    if (valueType === external_dependency_parsers_0.TYPES.KEYWORD) {
      var keywords = v.toLowerCase().trim().split(/\s+/);
      var hasBehind = false;

      if (keywords.length > 2) {
        return;
      }

      var behindIndex = keywords.indexOf('behind');
      hasBehind = behindIndex !== -1;

      if (keywords.length === 2) {
        if (!hasBehind) {
          return;
        }

        keywords.splice(behindIndex, 1);
      }

      if (keywords[0] === 'leftwards' || keywords[0] === 'rightwards') {
        if (hasBehind) {
          return;
        }

        return this._setProperty('azimuth', keywords[0]);
      }

      if (keywords[0] === 'behind') {
        return this._setProperty('azimuth', '180deg');
      }

      var deg;

      switch (keywords[0]) {
        case 'left-side':
          return this._setProperty('azimuth', '270deg');

        case 'far-left':
          return this._setProperty('azimuth', (hasBehind ? 240 : 300) + 'deg');

        case 'left':
          return this._setProperty('azimuth', (hasBehind ? 220 : 320) + 'deg');

        case 'center-left':
          return this._setProperty('azimuth', (hasBehind ? 200 : 340) + 'deg');

        case 'center':
          return this._setProperty('azimuth', (hasBehind ? 180 : 0) + 'deg');

        case 'center-right':
          return this._setProperty('azimuth', (hasBehind ? 160 : 20) + 'deg');

        case 'right':
          return this._setProperty('azimuth', (hasBehind ? 140 : 40) + 'deg');

        case 'far-right':
          return this._setProperty('azimuth', (hasBehind ? 120 : 60) + 'deg');

        case 'right-side':
          return this._setProperty('azimuth', '90deg');

        default:
          return;
      }
    }
  },
  get: function () {
    return this.getPropertyValue('azimuth');
  },
  enumerable: true,
  configurable: true
};
var backgroundColor_export_isValid, backgroundColor_export_definition;

var backgroundColor_local_var_parse = function parse(v) {
  var parsed = external_dependency_parsers_0.parseColor(v);

  if (parsed !== undefined) {
    return parsed;
  }

  if (external_dependency_parsers_0.valueType(v) === external_dependency_parsers_0.TYPES.KEYWORD && (v.toLowerCase() === 'transparent' || v.toLowerCase() === 'inherit')) {
    return v;
  }

  return undefined;
};

backgroundColor_export_isValid = function isValid(v) {
  return backgroundColor_local_var_parse(v) !== undefined;
};

backgroundColor_export_definition = {
  set: function (v) {
    var parsed = backgroundColor_local_var_parse(v);

    if (parsed === undefined) {
      return;
    }

    this._setProperty('background-color', parsed);
  },
  get: function () {
    return this.getPropertyValue('background-color');
  },
  enumerable: true,
  configurable: true
};
var backgroundImage_export_isValid, backgroundImage_export_definition;

var backgroundImage_local_var_parse = function parse(v) {
  var parsed = external_dependency_parsers_0.parseUrl(v);

  if (parsed !== undefined) {
    return parsed;
  }

  if (external_dependency_parsers_0.valueType(v) === external_dependency_parsers_0.TYPES.KEYWORD && (v.toLowerCase() === 'none' || v.toLowerCase() === 'inherit')) {
    return v;
  }

  return undefined;
};

backgroundImage_export_isValid = function isValid(v) {
  return backgroundImage_local_var_parse(v) !== undefined;
};

backgroundImage_export_definition = {
  set: function (v) {
    this._setProperty('background-image', backgroundImage_local_var_parse(v));
  },
  get: function () {
    return this.getPropertyValue('background-image');
  },
  enumerable: true,
  configurable: true
};
var backgroundRepeat_export_isValid, backgroundRepeat_export_definition;

var backgroundRepeat_local_var_parse = function parse(v) {
  if (external_dependency_parsers_0.valueType(v) === external_dependency_parsers_0.TYPES.KEYWORD && (v.toLowerCase() === 'repeat' || v.toLowerCase() === 'repeat-x' || v.toLowerCase() === 'repeat-y' || v.toLowerCase() === 'no-repeat' || v.toLowerCase() === 'inherit')) {
    return v;
  }

  return undefined;
};

backgroundRepeat_export_isValid = function isValid(v) {
  return backgroundRepeat_local_var_parse(v) !== undefined;
};

backgroundRepeat_export_definition = {
  set: function (v) {
    this._setProperty('background-repeat', backgroundRepeat_local_var_parse(v));
  },
  get: function () {
    return this.getPropertyValue('background-repeat');
  },
  enumerable: true,
  configurable: true
};
var backgroundAttachment_export_isValid, backgroundAttachment_export_definition;

var backgroundAttachment_local_var_isValid = backgroundAttachment_export_isValid = function isValid(v) {
  return external_dependency_parsers_0.valueType(v) === external_dependency_parsers_0.TYPES.KEYWORD && (v.toLowerCase() === 'scroll' || v.toLowerCase() === 'fixed' || v.toLowerCase() === 'inherit');
};

backgroundAttachment_export_definition = {
  set: function (v) {
    if (!backgroundAttachment_local_var_isValid(v)) {
      return;
    }

    this._setProperty('background-attachment', v);
  },
  get: function () {
    return this.getPropertyValue('background-attachment');
  },
  enumerable: true,
  configurable: true
};
var backgroundPosition_export_isValid, backgroundPosition_export_definition;
var backgroundPosition_local_var_valid_keywords = ['top', 'center', 'bottom', 'left', 'right'];

var backgroundPosition_local_var_parse = function parse(v) {
  if (v === '' || v === null) {
    return undefined;
  }

  var parts = v.split(/\s+/);

  if (parts.length > 2 || parts.length < 1) {
    return undefined;
  }

  var types = [];
  parts.forEach(function (part, index) {
    types[index] = external_dependency_parsers_0.valueType(part);
  });

  if (parts.length === 1) {
    if (types[0] === external_dependency_parsers_0.TYPES.LENGTH || types[0] === external_dependency_parsers_0.TYPES.PERCENT) {
      return v;
    }

    if (types[0] === external_dependency_parsers_0.TYPES.KEYWORD) {
      if (backgroundPosition_local_var_valid_keywords.indexOf(v.toLowerCase()) !== -1 || v.toLowerCase() === 'inherit') {
        return v;
      }
    }

    return undefined;
  }

  if ((types[0] === external_dependency_parsers_0.TYPES.LENGTH || types[0] === external_dependency_parsers_0.TYPES.PERCENT) && (types[1] === external_dependency_parsers_0.TYPES.LENGTH || types[1] === external_dependency_parsers_0.TYPES.PERCENT)) {
    return v;
  }

  if (types[0] !== external_dependency_parsers_0.TYPES.KEYWORD || types[1] !== external_dependency_parsers_0.TYPES.KEYWORD) {
    return undefined;
  }

  if (backgroundPosition_local_var_valid_keywords.indexOf(parts[0]) !== -1 && backgroundPosition_local_var_valid_keywords.indexOf(parts[1]) !== -1) {
    return v;
  }

  return undefined;
};

backgroundPosition_export_isValid = function isValid(v) {
  return backgroundPosition_local_var_parse(v) !== undefined;
};

backgroundPosition_export_definition = {
  set: function (v) {
    this._setProperty('background-position', backgroundPosition_local_var_parse(v));
  },
  get: function () {
    return this.getPropertyValue('background-position');
  },
  enumerable: true,
  configurable: true
};
var background_export_isValid, background_export_definition;
var background_local_var_shorthand_for = {
  'background-color': {
    isValid: backgroundColor_export_isValid,
    definition: backgroundColor_export_definition
  },
  'background-image': {
    isValid: backgroundImage_export_isValid,
    definition: backgroundImage_export_definition
  },
  'background-repeat': {
    isValid: backgroundRepeat_export_isValid,
    definition: backgroundRepeat_export_definition
  },
  'background-attachment': {
    isValid: backgroundAttachment_export_isValid,
    definition: backgroundAttachment_export_definition
  },
  'background-position': {
    isValid: backgroundPosition_export_isValid,
    definition: backgroundPosition_export_definition
  }
};

background_export_isValid = function isValid(v) {
  return external_dependency_parsers_0.shorthandParser(v, background_local_var_shorthand_for) !== undefined;
};

background_export_definition = {
  set: external_dependency_parsers_0.shorthandSetter('background', background_local_var_shorthand_for),
  get: external_dependency_parsers_0.shorthandGetter('background', background_local_var_shorthand_for),
  enumerable: true,
  configurable: true
};
var backgroundClip_export_definition;
backgroundClip_export_definition = {
  set: function (v) {
    this._setProperty('background-clip', v);
  },
  get: function () {
    return this.getPropertyValue('background-clip');
  },
  enumerable: true,
  configurable: true
};
var backgroundOrigin_export_definition;
backgroundOrigin_export_definition = {
  set: function (v) {
    this._setProperty('background-origin', v);
  },
  get: function () {
    return this.getPropertyValue('background-origin');
  },
  enumerable: true,
  configurable: true
};
var backgroundPositionX_export_definition;
backgroundPositionX_export_definition = {
  set: function (v) {
    this._setProperty('background-position-x', v);
  },
  get: function () {
    return this.getPropertyValue('background-position-x');
  },
  enumerable: true,
  configurable: true
};
var backgroundPositionY_export_definition;
backgroundPositionY_export_definition = {
  set: function (v) {
    this._setProperty('background-position-y', v);
  },
  get: function () {
    return this.getPropertyValue('background-position-y');
  },
  enumerable: true,
  configurable: true
};
var backgroundRepeatX_export_definition;
backgroundRepeatX_export_definition = {
  set: function (v) {
    this._setProperty('background-repeat-x', v);
  },
  get: function () {
    return this.getPropertyValue('background-repeat-x');
  },
  enumerable: true,
  configurable: true
};
var backgroundRepeatY_export_definition;
backgroundRepeatY_export_definition = {
  set: function (v) {
    this._setProperty('background-repeat-y', v);
  },
  get: function () {
    return this.getPropertyValue('background-repeat-y');
  },
  enumerable: true,
  configurable: true
};
var backgroundSize_export_definition;
backgroundSize_export_definition = {
  set: function (v) {
    this._setProperty('background-size', v);
  },
  get: function () {
    return this.getPropertyValue('background-size');
  },
  enumerable: true,
  configurable: true
};
var baselineShift_export_definition;
baselineShift_export_definition = {
  set: function (v) {
    this._setProperty('baseline-shift', v);
  },
  get: function () {
    return this.getPropertyValue('baseline-shift');
  },
  enumerable: true,
  configurable: true
};
var borderWidth_export_isValid, borderWidth_export_definition;
// the valid border-widths:
var borderWidth_local_var_widths = ['thin', 'medium', 'thick'];

borderWidth_export_isValid = function parse(v) {
  var length = external_dependency_parsers_0.parseLength(v);

  if (length !== undefined) {
    return true;
  }

  if (typeof v !== 'string') {
    return false;
  }

  if (v === '') {
    return true;
  }

  v = v.toLowerCase();

  if (borderWidth_local_var_widths.indexOf(v) === -1) {
    return false;
  }

  return true;
};

var borderWidth_local_var_isValid = borderWidth_export_isValid;

var borderWidth_local_var_parser = function (v) {
  var length = external_dependency_parsers_0.parseLength(v);

  if (length !== undefined) {
    return length;
  }

  if (borderWidth_local_var_isValid(v)) {
    return v.toLowerCase();
  }

  return undefined;
};

borderWidth_export_definition = {
  set: external_dependency_parsers_0.implicitSetter('border', 'width', borderWidth_local_var_isValid, borderWidth_local_var_parser),
  get: function () {
    return this.getPropertyValue('border-width');
  },
  enumerable: true,
  configurable: true
};
var borderStyle_export_isValid, borderStyle_export_definition;
// the valid border-styles:
var borderStyle_local_var_styles = ['none', 'hidden', 'dotted', 'dashed', 'solid', 'double', 'groove', 'ridge', 'inset', 'outset'];

borderStyle_export_isValid = function parse(v) {
  return typeof v === 'string' && (v === '' || borderStyle_local_var_styles.indexOf(v) !== -1);
};

var borderStyle_local_var_isValid = borderStyle_export_isValid;

var borderStyle_local_var_parser = function (v) {
  if (borderStyle_local_var_isValid(v)) {
    return v.toLowerCase();
  }

  return undefined;
};

borderStyle_export_definition = {
  set: external_dependency_parsers_0.implicitSetter('border', 'style', borderStyle_local_var_isValid, borderStyle_local_var_parser),
  get: function () {
    return this.getPropertyValue('border-style');
  },
  enumerable: true,
  configurable: true
};
var borderColor_export_isValid, borderColor_export_definition;

borderColor_export_isValid = function parse(v) {
  if (typeof v !== 'string') {
    return false;
  }

  return v === '' || v.toLowerCase() === 'transparent' || external_dependency_parsers_0.valueType(v) === external_dependency_parsers_0.TYPES.COLOR;
};

var borderColor_local_var_isValid = borderColor_export_isValid;

var borderColor_local_var_parser = function (v) {
  if (borderColor_local_var_isValid(v)) {
    return v.toLowerCase();
  }

  return undefined;
};

borderColor_export_definition = {
  set: external_dependency_parsers_0.implicitSetter('border', 'color', borderColor_local_var_isValid, borderColor_local_var_parser),
  get: function () {
    return this.getPropertyValue('border-color');
  },
  enumerable: true,
  configurable: true
};
var border_export_isValid, border_export_definition;
var border_local_var_shorthand_for = {
  'border-width': {
    isValid: borderWidth_export_isValid,
    definition: borderWidth_export_definition
  },
  'border-style': {
    isValid: borderStyle_export_isValid,
    definition: borderStyle_export_definition
  },
  'border-color': {
    isValid: borderColor_export_isValid,
    definition: borderColor_export_definition
  }
};

var border_local_var_isValid = function isValid(v) {
  return external_dependency_parsers_0.shorthandParser(v, border_local_var_shorthand_for) !== undefined;
};

border_export_isValid = border_local_var_isValid;

var border_local_var_parser = function (v) {
  if (v.toString().toLowerCase() === 'none') {
    v = '';
  }

  if (border_local_var_isValid(v)) {
    return v;
  }

  return undefined;
};

var border_local_var_myShorthandSetter = external_dependency_parsers_0.shorthandSetter('border', border_local_var_shorthand_for);
var border_local_var_myShorthandGetter = external_dependency_parsers_0.shorthandGetter('border', border_local_var_shorthand_for);
border_export_definition = {
  set: function (v) {
    if (v.toString().toLowerCase() === 'none') {
      v = '';
    }

    border_local_var_myShorthandSetter.call(this, v);
    this.removeProperty('border-top');
    this.removeProperty('border-left');
    this.removeProperty('border-right');
    this.removeProperty('border-bottom');
    this._values['border-top'] = this._values.border;
    this._values['border-left'] = this._values.border;
    this._values['border-right'] = this._values.border;
    this._values['border-bottom'] = this._values.border;
  },
  get: border_local_var_myShorthandGetter,
  enumerable: true,
  configurable: true
};
var borderBottomWidth_export_isValid, borderBottomWidth_export_definition;
var borderBottomWidth_local_var_isValid = borderBottomWidth_export_isValid = borderWidth_export_isValid;
borderBottomWidth_export_definition = {
  set: function (v) {
    if (borderBottomWidth_local_var_isValid(v)) {
      this._setProperty('border-bottom-width', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-bottom-width');
  },
  enumerable: true,
  configurable: true
};
var borderBottomStyle_export_isValid, borderBottomStyle_export_definition;
borderBottomStyle_export_isValid = borderStyle_export_isValid;
borderBottomStyle_export_definition = {
  set: function (v) {
    if (borderStyle_export_isValid(v)) {
      if (v.toLowerCase() === 'none') {
        v = '';
        this.removeProperty('border-bottom-width');
      }

      this._setProperty('border-bottom-style', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-bottom-style');
  },
  enumerable: true,
  configurable: true
};
var borderBottomColor_export_isValid, borderBottomColor_export_definition;
var borderBottomColor_local_var_isValid = borderBottomColor_export_isValid = borderColor_export_isValid;
borderBottomColor_export_definition = {
  set: function (v) {
    if (borderBottomColor_local_var_isValid(v)) {
      this._setProperty('border-bottom-color', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-bottom-color');
  },
  enumerable: true,
  configurable: true
};
var borderBottom_export_isValid, borderBottom_export_definition;
var borderBottom_local_var_shorthand_for = {
  'border-bottom-width': {
    isValid: borderBottomWidth_export_isValid,
    definition: borderBottomWidth_export_definition
  },
  'border-bottom-style': {
    isValid: borderBottomStyle_export_isValid,
    definition: borderBottomStyle_export_definition
  },
  'border-bottom-color': {
    isValid: borderBottomColor_export_isValid,
    definition: borderBottomColor_export_definition
  }
};

var borderBottom_local_var_isValid = function isValid(v) {
  return external_dependency_parsers_0.shorthandParser(v, borderBottom_local_var_shorthand_for) !== undefined;
};

borderBottom_export_isValid = borderBottom_local_var_isValid;
borderBottom_export_definition = {
  set: external_dependency_parsers_0.shorthandSetter('border-bottom', borderBottom_local_var_shorthand_for),
  get: external_dependency_parsers_0.shorthandGetter('border-bottom', borderBottom_local_var_shorthand_for),
  enumerable: true,
  configurable: true
};
var borderBottomLeftRadius_export_definition;
borderBottomLeftRadius_export_definition = {
  set: function (v) {
    this._setProperty('border-bottom-left-radius', v);
  },
  get: function () {
    return this.getPropertyValue('border-bottom-left-radius');
  },
  enumerable: true,
  configurable: true
};
var borderBottomRightRadius_export_definition;
borderBottomRightRadius_export_definition = {
  set: function (v) {
    this._setProperty('border-bottom-right-radius', v);
  },
  get: function () {
    return this.getPropertyValue('border-bottom-right-radius');
  },
  enumerable: true,
  configurable: true
};
var borderCollapse_export_isValid, borderCollapse_export_definition;

var borderCollapse_local_var_parse = function parse(v) {
  if (external_dependency_parsers_0.valueType(v) === external_dependency_parsers_0.TYPES.KEYWORD && (v.toLowerCase() === 'collapse' || v.toLowerCase() === 'separate' || v.toLowerCase() === 'inherit')) {
    return v;
  }

  return undefined;
};

borderCollapse_export_isValid = function isValid(v) {
  return borderCollapse_local_var_parse(v) !== undefined;
};

borderCollapse_export_definition = {
  set: function (v) {
    this._setProperty('border-collapse', borderCollapse_local_var_parse(v));
  },
  get: function () {
    return this.getPropertyValue('border-collapse');
  },
  enumerable: true,
  configurable: true
};
var borderImage_export_definition;
borderImage_export_definition = {
  set: function (v) {
    this._setProperty('border-image', v);
  },
  get: function () {
    return this.getPropertyValue('border-image');
  },
  enumerable: true,
  configurable: true
};
var borderImageOutset_export_definition;
borderImageOutset_export_definition = {
  set: function (v) {
    this._setProperty('border-image-outset', v);
  },
  get: function () {
    return this.getPropertyValue('border-image-outset');
  },
  enumerable: true,
  configurable: true
};
var borderImageRepeat_export_definition;
borderImageRepeat_export_definition = {
  set: function (v) {
    this._setProperty('border-image-repeat', v);
  },
  get: function () {
    return this.getPropertyValue('border-image-repeat');
  },
  enumerable: true,
  configurable: true
};
var borderImageSlice_export_definition;
borderImageSlice_export_definition = {
  set: function (v) {
    this._setProperty('border-image-slice', v);
  },
  get: function () {
    return this.getPropertyValue('border-image-slice');
  },
  enumerable: true,
  configurable: true
};
var borderImageSource_export_definition;
borderImageSource_export_definition = {
  set: function (v) {
    this._setProperty('border-image-source', v);
  },
  get: function () {
    return this.getPropertyValue('border-image-source');
  },
  enumerable: true,
  configurable: true
};
var borderImageWidth_export_definition;
borderImageWidth_export_definition = {
  set: function (v) {
    this._setProperty('border-image-width', v);
  },
  get: function () {
    return this.getPropertyValue('border-image-width');
  },
  enumerable: true,
  configurable: true
};
var borderLeftWidth_export_isValid, borderLeftWidth_export_definition;
var borderLeftWidth_local_var_isValid = borderLeftWidth_export_isValid = borderWidth_export_isValid;
borderLeftWidth_export_definition = {
  set: function (v) {
    if (borderLeftWidth_local_var_isValid(v)) {
      this._setProperty('border-left-width', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-left-width');
  },
  enumerable: true,
  configurable: true
};
var borderLeftStyle_export_isValid, borderLeftStyle_export_definition;
borderLeftStyle_export_isValid = borderStyle_export_isValid;
borderLeftStyle_export_definition = {
  set: function (v) {
    if (borderStyle_export_isValid(v)) {
      if (v.toLowerCase() === 'none') {
        v = '';
        this.removeProperty('border-left-width');
      }

      this._setProperty('border-left-style', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-left-style');
  },
  enumerable: true,
  configurable: true
};
var borderLeftColor_export_isValid, borderLeftColor_export_definition;
var borderLeftColor_local_var_isValid = borderLeftColor_export_isValid = borderColor_export_isValid;
borderLeftColor_export_definition = {
  set: function (v) {
    if (borderLeftColor_local_var_isValid(v)) {
      this._setProperty('border-left-color', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-left-color');
  },
  enumerable: true,
  configurable: true
};
var borderLeft_export_isValid, borderLeft_export_definition;
var borderLeft_local_var_shorthand_for = {
  'border-left-width': {
    isValid: borderLeftWidth_export_isValid,
    definition: borderLeftWidth_export_definition
  },
  'border-left-style': {
    isValid: borderLeftStyle_export_isValid,
    definition: borderLeftStyle_export_definition
  },
  'border-left-color': {
    isValid: borderLeftColor_export_isValid,
    definition: borderLeftColor_export_definition
  }
};

var borderLeft_local_var_isValid = function isValid(v) {
  return external_dependency_parsers_0.shorthandParser(v, borderLeft_local_var_shorthand_for) !== undefined;
};

borderLeft_export_isValid = borderLeft_local_var_isValid;
borderLeft_export_definition = {
  set: external_dependency_parsers_0.shorthandSetter('border-left', borderLeft_local_var_shorthand_for),
  get: external_dependency_parsers_0.shorthandGetter('border-left', borderLeft_local_var_shorthand_for),
  enumerable: true,
  configurable: true
};
var borderRadius_export_definition;
borderRadius_export_definition = {
  set: function (v) {
    this._setProperty('border-radius', v);
  },
  get: function () {
    return this.getPropertyValue('border-radius');
  },
  enumerable: true,
  configurable: true
};
var borderRightWidth_export_isValid, borderRightWidth_export_definition;
var borderRightWidth_local_var_isValid = borderRightWidth_export_isValid = borderWidth_export_isValid;
borderRightWidth_export_definition = {
  set: function (v) {
    if (borderRightWidth_local_var_isValid(v)) {
      this._setProperty('border-right-width', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-right-width');
  },
  enumerable: true,
  configurable: true
};
var borderRightStyle_export_isValid, borderRightStyle_export_definition;
borderRightStyle_export_isValid = borderStyle_export_isValid;
borderRightStyle_export_definition = {
  set: function (v) {
    if (borderStyle_export_isValid(v)) {
      if (v.toLowerCase() === 'none') {
        v = '';
        this.removeProperty('border-right-width');
      }

      this._setProperty('border-right-style', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-right-style');
  },
  enumerable: true,
  configurable: true
};
var borderRightColor_export_isValid, borderRightColor_export_definition;
var borderRightColor_local_var_isValid = borderRightColor_export_isValid = borderColor_export_isValid;
borderRightColor_export_definition = {
  set: function (v) {
    if (borderRightColor_local_var_isValid(v)) {
      this._setProperty('border-right-color', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-right-color');
  },
  enumerable: true,
  configurable: true
};
var borderRight_export_isValid, borderRight_export_definition;
var borderRight_local_var_shorthand_for = {
  'border-right-width': {
    isValid: borderRightWidth_export_isValid,
    definition: borderRightWidth_export_definition
  },
  'border-right-style': {
    isValid: borderRightStyle_export_isValid,
    definition: borderRightStyle_export_definition
  },
  'border-right-color': {
    isValid: borderRightColor_export_isValid,
    definition: borderRightColor_export_definition
  }
};

var borderRight_local_var_isValid = function isValid(v) {
  return external_dependency_parsers_0.shorthandParser(v, borderRight_local_var_shorthand_for) !== undefined;
};

borderRight_export_isValid = borderRight_local_var_isValid;
borderRight_export_definition = {
  set: external_dependency_parsers_0.shorthandSetter('border-right', borderRight_local_var_shorthand_for),
  get: external_dependency_parsers_0.shorthandGetter('border-right', borderRight_local_var_shorthand_for),
  enumerable: true,
  configurable: true
};
var borderSpacing_export_isValid, borderSpacing_export_definition;

// <length> <length>? | inherit
// if one, it applies to both horizontal and verical spacing
// if two, the first applies to the horizontal and the second applies to vertical spacing
var borderSpacing_local_var_parse = function parse(v) {
  if (v === '' || v === null) {
    return undefined;
  }

  if (v === 0) {
    return "0px";
  }

  if (v.toLowerCase() === 'inherit') {
    return v;
  }

  var parts = v.split(/\s+/);

  if (parts.length !== 1 && parts.length !== 2) {
    return undefined;
  }

  parts.forEach(function (part) {
    if (external_dependency_parsers_0.valueType(part) !== external_dependency_parsers_0.TYPES.LENGTH) {
      return undefined;
    }
  });
  return v;
};

borderSpacing_export_isValid = function isValid(v) {
  return borderSpacing_local_var_parse(v) !== undefined;
};

borderSpacing_export_definition = {
  set: function (v) {
    this._setProperty('border-spacing', borderSpacing_local_var_parse(v));
  },
  get: function () {
    return this.getPropertyValue('border-spacing');
  },
  enumerable: true,
  configurable: true
};
var borderTopWidth_export_isValid, borderTopWidth_export_definition;
borderTopWidth_export_isValid = borderWidth_export_isValid;
borderTopWidth_export_definition = {
  set: function (v) {
    if (borderWidth_export_isValid(v)) {
      this._setProperty('border-top-width', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-top-width');
  },
  enumerable: true,
  configurable: true
};
var borderTopStyle_export_isValid, borderTopStyle_export_definition;
borderTopStyle_export_isValid = borderStyle_export_isValid;
borderTopStyle_export_definition = {
  set: function (v) {
    if (borderStyle_export_isValid(v)) {
      if (v.toLowerCase() === 'none') {
        v = '';
        this.removeProperty('border-top-width');
      }

      this._setProperty('border-top-style', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-top-style');
  },
  enumerable: true,
  configurable: true
};
var borderTopColor_export_isValid, borderTopColor_export_definition;
var borderTopColor_local_var_isValid = borderTopColor_export_isValid = borderColor_export_isValid;
borderTopColor_export_definition = {
  set: function (v) {
    if (borderTopColor_local_var_isValid(v)) {
      this._setProperty('border-top-color', v);
    }
  },
  get: function () {
    return this.getPropertyValue('border-top-color');
  },
  enumerable: true,
  configurable: true
};
var borderTop_export_isValid, borderTop_export_definition;
var borderTop_local_var_shorthand_for = {
  'border-top-width': {
    isValid: borderTopWidth_export_isValid,
    definition: borderTopWidth_export_definition
  },
  'border-top-style': {
    isValid: borderTopStyle_export_isValid,
    definition: borderTopStyle_export_definition
  },
  'border-top-color': {
    isValid: borderTopColor_export_isValid,
    definition: borderTopColor_export_definition
  }
};

borderTop_export_isValid = function (v) {
  return external_dependency_parsers_0.shorthandParser(v, borderTop_local_var_shorthand_for) !== undefined;
};

borderTop_export_definition = {
  set: external_dependency_parsers_0.shorthandSetter('border-top', borderTop_local_var_shorthand_for),
  get: external_dependency_parsers_0.shorthandGetter('border-top', borderTop_local_var_shorthand_for),
  enumerable: true,
  configurable: true
};
var borderTopLeftRadius_export_definition;
borderTopLeftRadius_export_definition = {
  set: function (v) {
    this._setProperty('border-top-left-radius', v);
  },
  get: function () {
    return this.getPropertyValue('border-top-left-radius');
  },
  enumerable: true,
  configurable: true
};
var borderTopRightRadius_export_definition;
borderTopRightRadius_export_definition = {
  set: function (v) {
    this._setProperty('border-top-right-radius', v);
  },
  get: function () {
    return this.getPropertyValue('border-top-right-radius');
  },
  enumerable: true,
  configurable: true
};
var bottom_export_definition;
bottom_export_definition = {
  set: function (v) {
    this._setProperty('bottom', external_dependency_parsers_0.parseMeasurement(v));
  },
  get: function () {
    return this.getPropertyValue('bottom');
  },
  enumerable: true,
  configurable: true
};
var boxShadow_export_definition;
boxShadow_export_definition = {
  set: function (v) {
    this._setProperty('box-shadow', v);
  },
  get: function () {
    return this.getPropertyValue('box-shadow');
  },
  enumerable: true,
  configurable: true
};
var boxSizing_export_definition;
boxSizing_export_definition = {
  set: function (v) {
    this._setProperty('box-sizing', v);
  },
  get: function () {
    return this.getPropertyValue('box-sizing');
  },
  enumerable: true,
  configurable: true
};
var captionSide_export_definition;
captionSide_export_definition = {
  set: function (v) {
    this._setProperty('caption-side', v);
  },
  get: function () {
    return this.getPropertyValue('caption-side');
  },
  enumerable: true,
  configurable: true
};
var clear_export_definition;
var clear_local_var_clear_keywords = ['none', 'left', 'right', 'both', 'inherit'];
clear_export_definition = {
  set: function (v) {
    this._setProperty('clear', external_dependency_parsers_0.parseKeyword(v, clear_local_var_clear_keywords));
  },
  get: function () {
    return this.getPropertyValue('clear');
  },
  enumerable: true,
  configurable: true
};
var clip_export_definition;
/*jslint regexp: true*/var clip_local_var_shape_regex = /^rect\((.*)\)$/i; /*jslint regexp: false*/

var clip_local_var_parse = function (val) {
  if (val === '' || val === null) {
    return val;
  }

  if (typeof val !== 'string') {
    return undefined;
  }

  val = val.toLowerCase();

  if (val === 'auto' || val === 'inherit') {
    return val;
  }

  var matches = val.match(clip_local_var_shape_regex);

  if (!matches) {
    return undefined;
  }

  var parts = matches[1].split(/\s*,\s*/);

  if (parts.length !== 4) {
    return undefined;
  }

  var valid = parts.every(function (part, index) {
    var measurement = external_dependency_parsers_0.parseMeasurement(part);
    parts[index] = measurement;
    return measurement !== undefined;
  });

  if (!valid) {
    return undefined;
  }

  parts = parts.join(', ');
  return val.replace(matches[1], parts);
};

clip_export_definition = {
  set: function (v) {
    this._setProperty('clip', clip_local_var_parse(v));
  },
  get: function () {
    return this.getPropertyValue('clip');
  },
  enumerable: true,
  configurable: true
};
var color_export_definition;
color_export_definition = {
  set: function (v) {
    this._setProperty('color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('color');
  },
  enumerable: true,
  configurable: true
};
var colorInterpolation_export_definition;
colorInterpolation_export_definition = {
  set: function (v) {
    this._setProperty('color-interpolation', v);
  },
  get: function () {
    return this.getPropertyValue('color-interpolation');
  },
  enumerable: true,
  configurable: true
};
var colorInterpolationFilters_export_definition;
colorInterpolationFilters_export_definition = {
  set: function (v) {
    this._setProperty('color-interpolation-filters', v);
  },
  get: function () {
    return this.getPropertyValue('color-interpolation-filters');
  },
  enumerable: true,
  configurable: true
};
var colorProfile_export_definition;
colorProfile_export_definition = {
  set: function (v) {
    this._setProperty('color-profile', v);
  },
  get: function () {
    return this.getPropertyValue('color-profile');
  },
  enumerable: true,
  configurable: true
};
var colorRendering_export_definition;
colorRendering_export_definition = {
  set: function (v) {
    this._setProperty('color-rendering', v);
  },
  get: function () {
    return this.getPropertyValue('color-rendering');
  },
  enumerable: true,
  configurable: true
};
var content_export_definition;
content_export_definition = {
  set: function (v) {
    this._setProperty('content', v);
  },
  get: function () {
    return this.getPropertyValue('content');
  },
  enumerable: true,
  configurable: true
};
var counterIncrement_export_definition;
counterIncrement_export_definition = {
  set: function (v) {
    this._setProperty('counter-increment', v);
  },
  get: function () {
    return this.getPropertyValue('counter-increment');
  },
  enumerable: true,
  configurable: true
};
var counterReset_export_definition;
counterReset_export_definition = {
  set: function (v) {
    this._setProperty('counter-reset', v);
  },
  get: function () {
    return this.getPropertyValue('counter-reset');
  },
  enumerable: true,
  configurable: true
};
var cssFloat_export_definition;
cssFloat_export_definition = {
  set: function (v) {
    this._setProperty('float', v);
  },
  get: function () {
    return this.getPropertyValue('float');
  },
  enumerable: true,
  configurable: true
};
var cue_export_definition;
cue_export_definition = {
  set: function (v) {
    this._setProperty('cue', v);
  },
  get: function () {
    return this.getPropertyValue('cue');
  },
  enumerable: true,
  configurable: true
};
var cueAfter_export_definition;
cueAfter_export_definition = {
  set: function (v) {
    this._setProperty('cue-after', v);
  },
  get: function () {
    return this.getPropertyValue('cue-after');
  },
  enumerable: true,
  configurable: true
};
var cueBefore_export_definition;
cueBefore_export_definition = {
  set: function (v) {
    this._setProperty('cue-before', v);
  },
  get: function () {
    return this.getPropertyValue('cue-before');
  },
  enumerable: true,
  configurable: true
};
var cursor_export_definition;
cursor_export_definition = {
  set: function (v) {
    this._setProperty('cursor', v);
  },
  get: function () {
    return this.getPropertyValue('cursor');
  },
  enumerable: true,
  configurable: true
};
var direction_export_definition;
direction_export_definition = {
  set: function (v) {
    this._setProperty('direction', v);
  },
  get: function () {
    return this.getPropertyValue('direction');
  },
  enumerable: true,
  configurable: true
};
var display_export_definition;
display_export_definition = {
  set: function (v) {
    this._setProperty('display', v);
  },
  get: function () {
    return this.getPropertyValue('display');
  },
  enumerable: true,
  configurable: true
};
var dominantBaseline_export_definition;
dominantBaseline_export_definition = {
  set: function (v) {
    this._setProperty('dominant-baseline', v);
  },
  get: function () {
    return this.getPropertyValue('dominant-baseline');
  },
  enumerable: true,
  configurable: true
};
var elevation_export_definition;
elevation_export_definition = {
  set: function (v) {
    this._setProperty('elevation', v);
  },
  get: function () {
    return this.getPropertyValue('elevation');
  },
  enumerable: true,
  configurable: true
};
var emptyCells_export_definition;
emptyCells_export_definition = {
  set: function (v) {
    this._setProperty('empty-cells', v);
  },
  get: function () {
    return this.getPropertyValue('empty-cells');
  },
  enumerable: true,
  configurable: true
};
var enableBackground_export_definition;
enableBackground_export_definition = {
  set: function (v) {
    this._setProperty('enable-background', v);
  },
  get: function () {
    return this.getPropertyValue('enable-background');
  },
  enumerable: true,
  configurable: true
};
var fill_export_definition;
fill_export_definition = {
  set: function (v) {
    this._setProperty('fill', v);
  },
  get: function () {
    return this.getPropertyValue('fill');
  },
  enumerable: true,
  configurable: true
};
var fillOpacity_export_definition;
fillOpacity_export_definition = {
  set: function (v) {
    this._setProperty('fill-opacity', v);
  },
  get: function () {
    return this.getPropertyValue('fill-opacity');
  },
  enumerable: true,
  configurable: true
};
var fillRule_export_definition;
fillRule_export_definition = {
  set: function (v) {
    this._setProperty('fill-rule', v);
  },
  get: function () {
    return this.getPropertyValue('fill-rule');
  },
  enumerable: true,
  configurable: true
};
var filter_export_definition;
filter_export_definition = {
  set: function (v) {
    this._setProperty('filter', v);
  },
  get: function () {
    return this.getPropertyValue('filter');
  },
  enumerable: true,
  configurable: true
};
var flexDirection_export_definition;
flexDirection_export_definition = {
  set: function (v) {
    this._setProperty('flex-direction', v);
  },
  get: function () {
    return this.getPropertyValue('flex-direction');
  },
  enumerable: true,
  configurable: true
};
var flexFlow_export_definition;
flexFlow_export_definition = {
  set: function (v) {
    this._setProperty('flex-flow', v);
  },
  get: function () {
    return this.getPropertyValue('flex-flow');
  },
  enumerable: true,
  configurable: true
};
var flexWrap_export_definition;
flexWrap_export_definition = {
  set: function (v) {
    this._setProperty('flex-wrap', v);
  },
  get: function () {
    return this.getPropertyValue('flex-wrap');
  },
  enumerable: true,
  configurable: true
};
var floodColor_export_definition;
floodColor_export_definition = {
  set: function (v) {
    this._setProperty('flood-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('flood-color');
  },
  enumerable: true,
  configurable: true
};
var floodOpacity_export_definition;
floodOpacity_export_definition = {
  set: function (v) {
    this._setProperty('flood-opacity', v);
  },
  get: function () {
    return this.getPropertyValue('flood-opacity');
  },
  enumerable: true,
  configurable: true
};
var fontFamily_export_isValid, fontFamily_export_definition;
var fontFamily_local_var_partsRegEx = /\s*,\s*/;

fontFamily_export_isValid = function isValid(v) {
  if (v === '' || v === null) {
    return true;
  }

  var parts = v.split(fontFamily_local_var_partsRegEx);
  var len = parts.length;
  var i;
  var type;

  for (i = 0; i < len; i++) {
    type = external_dependency_parsers_0.valueType(parts[i]);

    if (type === external_dependency_parsers_0.TYPES.STRING || type === external_dependency_parsers_0.TYPES.KEYWORD) {
      return true;
    }
  }

  return false;
};

fontFamily_export_definition = {
  set: function (v) {
    this._setProperty('font-family', v);
  },
  get: function () {
    return this.getPropertyValue('font-family');
  },
  enumerable: true,
  configurable: true
};
var fontSize_export_isValid, fontSize_export_definition;
var fontSize_local_var_absoluteSizes = ['xx-small', 'x-small', 'small', 'medium', 'large', 'x-large', 'xx-large'];
var fontSize_local_var_relativeSizes = ['larger', 'smaller'];

fontSize_export_isValid = function (v) {
  var type = external_dependency_parsers_0.valueType(v.toLowerCase());
  return type === external_dependency_parsers_0.TYPES.LENGTH || type === external_dependency_parsers_0.TYPES.PERCENT || type === external_dependency_parsers_0.TYPES.KEYWORD && fontSize_local_var_absoluteSizes.indexOf(v.toLowerCase()) !== -1 || type === external_dependency_parsers_0.TYPES.KEYWORD && fontSize_local_var_relativeSizes.indexOf(v.toLowerCase()) !== -1;
};

fontSize_export_definition = {
  set: function (v) {
    this._setProperty('font-size', v);
  },
  get: function () {
    return this.getPropertyValue('font-size');
  },
  enumerable: true,
  configurable: true
};
var fontStyle_export_isValid, fontStyle_export_definition;
var fontStyle_local_var_valid_styles = ['normal', 'italic', 'oblique', 'inherit'];

fontStyle_export_isValid = function (v) {
  return fontStyle_local_var_valid_styles.indexOf(v.toLowerCase()) !== -1;
};

fontStyle_export_definition = {
  set: function (v) {
    this._setProperty('font-style', v);
  },
  get: function () {
    return this.getPropertyValue('font-style');
  },
  enumerable: true,
  configurable: true
};
var fontVariant_export_isValid, fontVariant_export_definition;
var fontVariant_local_var_valid_variants = ['normal', 'small-caps', 'inherit'];

fontVariant_export_isValid = function isValid(v) {
  return fontVariant_local_var_valid_variants.indexOf(v.toLowerCase()) !== -1;
};

fontVariant_export_definition = {
  set: function (v) {
    this._setProperty('font-variant', v);
  },
  get: function () {
    return this.getPropertyValue('font-variant');
  },
  enumerable: true,
  configurable: true
};
var fontWeight_export_isValid, fontWeight_export_definition;
var fontWeight_local_var_valid_weights = ['normal', 'bold', 'bolder', 'lighter', '100', '200', '300', '400', '500', '600', '700', '800', '900', 'inherit'];

fontWeight_export_isValid = function isValid(v) {
  return fontWeight_local_var_valid_weights.indexOf(v.toLowerCase()) !== -1;
};

fontWeight_export_definition = {
  set: function (v) {
    this._setProperty('font-weight', v);
  },
  get: function () {
    return this.getPropertyValue('font-weight');
  },
  enumerable: true,
  configurable: true
};
var lineHeight_export_isValid, lineHeight_export_definition;

lineHeight_export_isValid = function isValid(v) {
  var type = external_dependency_parsers_0.valueType(v);
  return type === external_dependency_parsers_0.TYPES.KEYWORD && v.toLowerCase() === 'normal' || v.toLowerCase() === 'inherit' || type === external_dependency_parsers_0.TYPES.NUMBER || type === external_dependency_parsers_0.TYPES.LENGTH || type === external_dependency_parsers_0.TYPES.PERCENT;
};

lineHeight_export_definition = {
  set: function (v) {
    this._setProperty('line-height', v);
  },
  get: function () {
    return this.getPropertyValue('line-height');
  },
  enumerable: true,
  configurable: true
};
var font_export_isValid, font_export_definition;
var font_local_var_shorthand_for = {
  'font-family': {
    isValid: fontFamily_export_isValid,
    definition: fontFamily_export_definition
  },
  'font-size': {
    isValid: fontSize_export_isValid,
    definition: fontSize_export_definition
  },
  'font-style': {
    isValid: fontStyle_export_isValid,
    definition: fontStyle_export_definition
  },
  'font-variant': {
    isValid: fontVariant_export_isValid,
    definition: fontVariant_export_definition
  },
  'font-weight': {
    isValid: fontWeight_export_isValid,
    definition: fontWeight_export_definition
  },
  'line-height': {
    isValid: lineHeight_export_isValid,
    definition: lineHeight_export_definition
  }
};
var font_local_var_static_fonts = ['caption', 'icon', 'menu', 'message-box', 'small-caption', 'status-bar', 'inherit'];

font_export_isValid = function isValid(v) {
  return external_dependency_parsers_0.shorthandParser(v, font_local_var_shorthand_for) !== undefined || external_dependency_parsers_0.valueType(v) === external_dependency_parsers_0.TYPES.KEYWORD && font_local_var_static_fonts.indexOf(v.toLowerCase()) !== -1;
};

var font_local_var_setter = external_dependency_parsers_0.shorthandSetter('font', font_local_var_shorthand_for);
font_export_definition = {
  set: function (v) {
    var short = external_dependency_parsers_0.shorthandParser(v, font_local_var_shorthand_for);

    if (short !== undefined) {
      return font_local_var_setter.call(this, v);
    }

    if (external_dependency_parsers_0.valueType(v) === external_dependency_parsers_0.TYPES.KEYWORD && font_local_var_static_fonts.indexOf(v.toLowerCase()) !== -1) {
      this._setProperty('font', v);
    }
  },
  get: external_dependency_parsers_0.shorthandGetter('font', font_local_var_shorthand_for),
  enumerable: true,
  configurable: true
};
var fontSizeAdjust_export_definition;
fontSizeAdjust_export_definition = {
  set: function (v) {
    this._setProperty('font-size-adjust', v);
  },
  get: function () {
    return this.getPropertyValue('font-size-adjust');
  },
  enumerable: true,
  configurable: true
};
var fontStretch_export_definition;
fontStretch_export_definition = {
  set: function (v) {
    this._setProperty('font-stretch', v);
  },
  get: function () {
    return this.getPropertyValue('font-stretch');
  },
  enumerable: true,
  configurable: true
};
var glyphOrientationHorizontal_export_definition;
glyphOrientationHorizontal_export_definition = {
  set: function (v) {
    this._setProperty('glyph-orientation-horizontal', v);
  },
  get: function () {
    return this.getPropertyValue('glyph-orientation-horizontal');
  },
  enumerable: true,
  configurable: true
};
var glyphOrientationVertical_export_definition;
glyphOrientationVertical_export_definition = {
  set: function (v) {
    this._setProperty('glyph-orientation-vertical', v);
  },
  get: function () {
    return this.getPropertyValue('glyph-orientation-vertical');
  },
  enumerable: true,
  configurable: true
};
var height_export_definition;

function parse(v) {
  if (String(v).toLowerCase() === 'auto') {
    return 'auto';
  }

  if (String(v).toLowerCase() === 'inherit') {
    return 'inherit';
  }

  return external_dependency_parsers_0.parseMeasurement(v);
}

height_export_definition = {
  set: function (v) {
    this._setProperty('height', parse(v));
  },
  get: function () {
    return this.getPropertyValue('height');
  },
  enumerable: true,
  configurable: true
};
var imageRendering_export_definition;
imageRendering_export_definition = {
  set: function (v) {
    this._setProperty('image-rendering', v);
  },
  get: function () {
    return this.getPropertyValue('image-rendering');
  },
  enumerable: true,
  configurable: true
};
var justifyContent_export_definition;
justifyContent_export_definition = {
  set: function (v) {
    this._setProperty('justify-content', v);
  },
  get: function () {
    return this.getPropertyValue('justify-content');
  },
  enumerable: true,
  configurable: true
};
var kerning_export_definition;
kerning_export_definition = {
  set: function (v) {
    this._setProperty('kerning', v);
  },
  get: function () {
    return this.getPropertyValue('kerning');
  },
  enumerable: true,
  configurable: true
};
var left_export_definition;
left_export_definition = {
  set: function (v) {
    this._setProperty('left', external_dependency_parsers_0.parseMeasurement(v));
  },
  get: function () {
    return this.getPropertyValue('left');
  },
  enumerable: true,
  configurable: true
};
var letterSpacing_export_definition;
letterSpacing_export_definition = {
  set: function (v) {
    this._setProperty('letter-spacing', v);
  },
  get: function () {
    return this.getPropertyValue('letter-spacing');
  },
  enumerable: true,
  configurable: true
};
var lightingColor_export_definition;
lightingColor_export_definition = {
  set: function (v) {
    this._setProperty('lighting-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('lighting-color');
  },
  enumerable: true,
  configurable: true
};
var listStyle_export_definition;
listStyle_export_definition = {
  set: function (v) {
    this._setProperty('list-style', v);
  },
  get: function () {
    return this.getPropertyValue('list-style');
  },
  enumerable: true,
  configurable: true
};
var listStyleImage_export_definition;
listStyleImage_export_definition = {
  set: function (v) {
    this._setProperty('list-style-image', v);
  },
  get: function () {
    return this.getPropertyValue('list-style-image');
  },
  enumerable: true,
  configurable: true
};
var listStylePosition_export_definition;
listStylePosition_export_definition = {
  set: function (v) {
    this._setProperty('list-style-position', v);
  },
  get: function () {
    return this.getPropertyValue('list-style-position');
  },
  enumerable: true,
  configurable: true
};
var listStyleType_export_definition;
listStyleType_export_definition = {
  set: function (v) {
    this._setProperty('list-style-type', v);
  },
  get: function () {
    return this.getPropertyValue('list-style-type');
  },
  enumerable: true,
  configurable: true
};
var margin_export_definition, margin_export_isValid, margin_export_parser;
var margin_local_var_TYPES = external_dependency_parsers_0.TYPES;

var margin_local_var_isValid = function (v) {
  if (v.toLowerCase() === "auto") {
    return true;
  }

  var type = external_dependency_parsers_0.valueType(v);
  return type === margin_local_var_TYPES.LENGTH || type === margin_local_var_TYPES.PERCENT || type === margin_local_var_TYPES.INTEGER && (v === '0' || v === 0);
};

var margin_local_var_parser = function (v) {
  var V = v.toLowerCase();

  if (V === "auto") {
    return V;
  }

  return external_dependency_parsers_0.parseMeasurement(v);
};

var margin_local_var_mySetter = external_dependency_parsers_0.implicitSetter('margin', '', margin_local_var_isValid, margin_local_var_parser);
var margin_local_var_myGlobal = external_dependency_parsers_0.implicitSetter('margin', '', function () {
  return true;
}, function (v) {
  return v;
});
margin_export_definition = {
  set: function (v) {
    if (typeof v === "number") {
      v = String(v);
    }

    if (typeof v !== "string") {
      return;
    }

    var V = v.toLowerCase();

    switch (V) {
      case 'inherit':
      case 'initial':
      case 'unset':
      case '':
        margin_local_var_myGlobal.call(this, V);
        break;

      default:
        margin_local_var_mySetter.call(this, v);
        break;
    }
  },
  get: function () {
    return this.getPropertyValue('margin');
  },
  enumerable: true,
  configurable: true
};
margin_export_isValid = margin_local_var_isValid;
margin_export_parser = margin_local_var_parser;
var marginBottom_export_definition;
marginBottom_export_definition = {
  set: external_dependency_parsers_0.subImplicitSetter('margin', 'bottom', {
    definition: margin_export_definition,
    isValid: margin_export_isValid,
    parser: margin_export_parser
  }.isValid, {
    definition: margin_export_definition,
    isValid: margin_export_isValid,
    parser: margin_export_parser
  }.parser),
  get: function () {
    return this.getPropertyValue('margin-bottom');
  },
  enumerable: true,
  configurable: true
};
var marginLeft_export_definition;
marginLeft_export_definition = {
  set: external_dependency_parsers_0.subImplicitSetter('margin', 'left', {
    definition: margin_export_definition,
    isValid: margin_export_isValid,
    parser: margin_export_parser
  }.isValid, {
    definition: margin_export_definition,
    isValid: margin_export_isValid,
    parser: margin_export_parser
  }.parser),
  get: function () {
    return this.getPropertyValue('margin-left');
  },
  enumerable: true,
  configurable: true
};
var marginRight_export_definition;
marginRight_export_definition = {
  set: external_dependency_parsers_0.subImplicitSetter('margin', 'right', {
    definition: margin_export_definition,
    isValid: margin_export_isValid,
    parser: margin_export_parser
  }.isValid, {
    definition: margin_export_definition,
    isValid: margin_export_isValid,
    parser: margin_export_parser
  }.parser),
  get: function () {
    return this.getPropertyValue('margin-right');
  },
  enumerable: true,
  configurable: true
};
var marginTop_export_definition;
marginTop_export_definition = {
  set: external_dependency_parsers_0.subImplicitSetter('margin', 'top', {
    definition: margin_export_definition,
    isValid: margin_export_isValid,
    parser: margin_export_parser
  }.isValid, {
    definition: margin_export_definition,
    isValid: margin_export_isValid,
    parser: margin_export_parser
  }.parser),
  get: function () {
    return this.getPropertyValue('margin-top');
  },
  enumerable: true,
  configurable: true
};
var marker_export_definition;
marker_export_definition = {
  set: function (v) {
    this._setProperty('marker', v);
  },
  get: function () {
    return this.getPropertyValue('marker');
  },
  enumerable: true,
  configurable: true
};
var markerEnd_export_definition;
markerEnd_export_definition = {
  set: function (v) {
    this._setProperty('marker-end', v);
  },
  get: function () {
    return this.getPropertyValue('marker-end');
  },
  enumerable: true,
  configurable: true
};
var markerMid_export_definition;
markerMid_export_definition = {
  set: function (v) {
    this._setProperty('marker-mid', v);
  },
  get: function () {
    return this.getPropertyValue('marker-mid');
  },
  enumerable: true,
  configurable: true
};
var markerOffset_export_definition;
markerOffset_export_definition = {
  set: function (v) {
    this._setProperty('marker-offset', v);
  },
  get: function () {
    return this.getPropertyValue('marker-offset');
  },
  enumerable: true,
  configurable: true
};
var markerStart_export_definition;
markerStart_export_definition = {
  set: function (v) {
    this._setProperty('marker-start', v);
  },
  get: function () {
    return this.getPropertyValue('marker-start');
  },
  enumerable: true,
  configurable: true
};
var marks_export_definition;
marks_export_definition = {
  set: function (v) {
    this._setProperty('marks', v);
  },
  get: function () {
    return this.getPropertyValue('marks');
  },
  enumerable: true,
  configurable: true
};
var mask_export_definition;
mask_export_definition = {
  set: function (v) {
    this._setProperty('mask', v);
  },
  get: function () {
    return this.getPropertyValue('mask');
  },
  enumerable: true,
  configurable: true
};
var maxHeight_export_definition;
maxHeight_export_definition = {
  set: function (v) {
    this._setProperty('max-height', v);
  },
  get: function () {
    return this.getPropertyValue('max-height');
  },
  enumerable: true,
  configurable: true
};
var maxWidth_export_definition;
maxWidth_export_definition = {
  set: function (v) {
    this._setProperty('max-width', v);
  },
  get: function () {
    return this.getPropertyValue('max-width');
  },
  enumerable: true,
  configurable: true
};
var minHeight_export_definition;
minHeight_export_definition = {
  set: function (v) {
    this._setProperty('min-height', v);
  },
  get: function () {
    return this.getPropertyValue('min-height');
  },
  enumerable: true,
  configurable: true
};
var minWidth_export_definition;
minWidth_export_definition = {
  set: function (v) {
    this._setProperty('min-width', v);
  },
  get: function () {
    return this.getPropertyValue('min-width');
  },
  enumerable: true,
  configurable: true
};
var opacity_export_definition;
opacity_export_definition = {
  set: function (v) {
    this._setProperty('opacity', external_dependency_parsers_0.parseNumber(v));
  },
  get: function () {
    return this.getPropertyValue('opacity');
  },
  enumerable: true,
  configurable: true
};
var orphans_export_definition;
orphans_export_definition = {
  set: function (v) {
    this._setProperty('orphans', v);
  },
  get: function () {
    return this.getPropertyValue('orphans');
  },
  enumerable: true,
  configurable: true
};
var outline_export_definition;
outline_export_definition = {
  set: function (v) {
    this._setProperty('outline', v);
  },
  get: function () {
    return this.getPropertyValue('outline');
  },
  enumerable: true,
  configurable: true
};
var outlineColor_export_definition;
outlineColor_export_definition = {
  set: function (v) {
    this._setProperty('outline-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('outline-color');
  },
  enumerable: true,
  configurable: true
};
var outlineOffset_export_definition;
outlineOffset_export_definition = {
  set: function (v) {
    this._setProperty('outline-offset', v);
  },
  get: function () {
    return this.getPropertyValue('outline-offset');
  },
  enumerable: true,
  configurable: true
};
var outlineStyle_export_definition;
outlineStyle_export_definition = {
  set: function (v) {
    this._setProperty('outline-style', v);
  },
  get: function () {
    return this.getPropertyValue('outline-style');
  },
  enumerable: true,
  configurable: true
};
var outlineWidth_export_definition;
outlineWidth_export_definition = {
  set: function (v) {
    this._setProperty('outline-width', v);
  },
  get: function () {
    return this.getPropertyValue('outline-width');
  },
  enumerable: true,
  configurable: true
};
var overflow_export_definition;
overflow_export_definition = {
  set: function (v) {
    this._setProperty('overflow', v);
  },
  get: function () {
    return this.getPropertyValue('overflow');
  },
  enumerable: true,
  configurable: true
};
var overflowX_export_definition;
overflowX_export_definition = {
  set: function (v) {
    this._setProperty('overflow-x', v);
  },
  get: function () {
    return this.getPropertyValue('overflow-x');
  },
  enumerable: true,
  configurable: true
};
var overflowY_export_definition;
overflowY_export_definition = {
  set: function (v) {
    this._setProperty('overflow-y', v);
  },
  get: function () {
    return this.getPropertyValue('overflow-y');
  },
  enumerable: true,
  configurable: true
};
var padding_export_definition, padding_export_isValid, padding_export_parser;
var padding_local_var_TYPES = external_dependency_parsers_0.TYPES;

var padding_local_var_isValid = function (v) {
  var type = external_dependency_parsers_0.valueType(v);
  return type === padding_local_var_TYPES.LENGTH || type === padding_local_var_TYPES.PERCENT || type === padding_local_var_TYPES.INTEGER && (v === '0' || v === 0);
};

var padding_local_var_parser = function (v) {
  return external_dependency_parsers_0.parseMeasurement(v);
};

var padding_local_var_mySetter = external_dependency_parsers_0.implicitSetter('padding', '', padding_local_var_isValid, padding_local_var_parser);
var padding_local_var_myGlobal = external_dependency_parsers_0.implicitSetter('padding', '', function () {
  return true;
}, function (v) {
  return v;
});
padding_export_definition = {
  set: function (v) {
    if (typeof v === "number") {
      v = String(v);
    }

    if (typeof v !== "string") {
      return;
    }

    var V = v.toLowerCase();

    switch (V) {
      case 'inherit':
      case 'initial':
      case 'unset':
      case '':
        padding_local_var_myGlobal.call(this, V);
        break;

      default:
        padding_local_var_mySetter.call(this, v);
        break;
    }
  },
  get: function () {
    return this.getPropertyValue('padding');
  },
  enumerable: true,
  configurable: true
};
padding_export_isValid = padding_local_var_isValid;
padding_export_parser = padding_local_var_parser;
var paddingBottom_export_definition;
paddingBottom_export_definition = {
  set: external_dependency_parsers_0.subImplicitSetter('padding', 'bottom', {
    definition: padding_export_definition,
    isValid: padding_export_isValid,
    parser: padding_export_parser
  }.isValid, {
    definition: padding_export_definition,
    isValid: padding_export_isValid,
    parser: padding_export_parser
  }.parser),
  get: function () {
    return this.getPropertyValue('padding-bottom');
  },
  enumerable: true,
  configurable: true
};
var paddingLeft_export_definition;
paddingLeft_export_definition = {
  set: external_dependency_parsers_0.subImplicitSetter('padding', 'left', {
    definition: padding_export_definition,
    isValid: padding_export_isValid,
    parser: padding_export_parser
  }.isValid, {
    definition: padding_export_definition,
    isValid: padding_export_isValid,
    parser: padding_export_parser
  }.parser),
  get: function () {
    return this.getPropertyValue('padding-left');
  },
  enumerable: true,
  configurable: true
};
var paddingRight_export_definition;
paddingRight_export_definition = {
  set: external_dependency_parsers_0.subImplicitSetter('padding', 'right', {
    definition: padding_export_definition,
    isValid: padding_export_isValid,
    parser: padding_export_parser
  }.isValid, {
    definition: padding_export_definition,
    isValid: padding_export_isValid,
    parser: padding_export_parser
  }.parser),
  get: function () {
    return this.getPropertyValue('padding-right');
  },
  enumerable: true,
  configurable: true
};
var paddingTop_export_definition;
paddingTop_export_definition = {
  set: external_dependency_parsers_0.subImplicitSetter('padding', 'top', {
    definition: padding_export_definition,
    isValid: padding_export_isValid,
    parser: padding_export_parser
  }.isValid, {
    definition: padding_export_definition,
    isValid: padding_export_isValid,
    parser: padding_export_parser
  }.parser),
  get: function () {
    return this.getPropertyValue('padding-top');
  },
  enumerable: true,
  configurable: true
};
var page_export_definition;
page_export_definition = {
  set: function (v) {
    this._setProperty('page', v);
  },
  get: function () {
    return this.getPropertyValue('page');
  },
  enumerable: true,
  configurable: true
};
var pageBreakAfter_export_definition;
pageBreakAfter_export_definition = {
  set: function (v) {
    this._setProperty('page-break-after', v);
  },
  get: function () {
    return this.getPropertyValue('page-break-after');
  },
  enumerable: true,
  configurable: true
};
var pageBreakBefore_export_definition;
pageBreakBefore_export_definition = {
  set: function (v) {
    this._setProperty('page-break-before', v);
  },
  get: function () {
    return this.getPropertyValue('page-break-before');
  },
  enumerable: true,
  configurable: true
};
var pageBreakInside_export_definition;
pageBreakInside_export_definition = {
  set: function (v) {
    this._setProperty('page-break-inside', v);
  },
  get: function () {
    return this.getPropertyValue('page-break-inside');
  },
  enumerable: true,
  configurable: true
};
var pause_export_definition;
pause_export_definition = {
  set: function (v) {
    this._setProperty('pause', v);
  },
  get: function () {
    return this.getPropertyValue('pause');
  },
  enumerable: true,
  configurable: true
};
var pauseAfter_export_definition;
pauseAfter_export_definition = {
  set: function (v) {
    this._setProperty('pause-after', v);
  },
  get: function () {
    return this.getPropertyValue('pause-after');
  },
  enumerable: true,
  configurable: true
};
var pauseBefore_export_definition;
pauseBefore_export_definition = {
  set: function (v) {
    this._setProperty('pause-before', v);
  },
  get: function () {
    return this.getPropertyValue('pause-before');
  },
  enumerable: true,
  configurable: true
};
var pitch_export_definition;
pitch_export_definition = {
  set: function (v) {
    this._setProperty('pitch', v);
  },
  get: function () {
    return this.getPropertyValue('pitch');
  },
  enumerable: true,
  configurable: true
};
var pitchRange_export_definition;
pitchRange_export_definition = {
  set: function (v) {
    this._setProperty('pitch-range', v);
  },
  get: function () {
    return this.getPropertyValue('pitch-range');
  },
  enumerable: true,
  configurable: true
};
var playDuring_export_definition;
playDuring_export_definition = {
  set: function (v) {
    this._setProperty('play-during', v);
  },
  get: function () {
    return this.getPropertyValue('play-during');
  },
  enumerable: true,
  configurable: true
};
var pointerEvents_export_definition;
pointerEvents_export_definition = {
  set: function (v) {
    this._setProperty('pointer-events', v);
  },
  get: function () {
    return this.getPropertyValue('pointer-events');
  },
  enumerable: true,
  configurable: true
};
var position_export_definition;
position_export_definition = {
  set: function (v) {
    this._setProperty('position', v);
  },
  get: function () {
    return this.getPropertyValue('position');
  },
  enumerable: true,
  configurable: true
};
var quotes_export_definition;
quotes_export_definition = {
  set: function (v) {
    this._setProperty('quotes', v);
  },
  get: function () {
    return this.getPropertyValue('quotes');
  },
  enumerable: true,
  configurable: true
};
var resize_export_definition;
resize_export_definition = {
  set: function (v) {
    this._setProperty('resize', v);
  },
  get: function () {
    return this.getPropertyValue('resize');
  },
  enumerable: true,
  configurable: true
};
var richness_export_definition;
richness_export_definition = {
  set: function (v) {
    this._setProperty('richness', v);
  },
  get: function () {
    return this.getPropertyValue('richness');
  },
  enumerable: true,
  configurable: true
};
var right_export_definition;
right_export_definition = {
  set: function (v) {
    this._setProperty('right', external_dependency_parsers_0.parseMeasurement(v));
  },
  get: function () {
    return this.getPropertyValue('right');
  },
  enumerable: true,
  configurable: true
};
var shapeRendering_export_definition;
shapeRendering_export_definition = {
  set: function (v) {
    this._setProperty('shape-rendering', v);
  },
  get: function () {
    return this.getPropertyValue('shape-rendering');
  },
  enumerable: true,
  configurable: true
};
var size_export_definition;
size_export_definition = {
  set: function (v) {
    this._setProperty('size', v);
  },
  get: function () {
    return this.getPropertyValue('size');
  },
  enumerable: true,
  configurable: true
};
var speak_export_definition;
speak_export_definition = {
  set: function (v) {
    this._setProperty('speak', v);
  },
  get: function () {
    return this.getPropertyValue('speak');
  },
  enumerable: true,
  configurable: true
};
var speakHeader_export_definition;
speakHeader_export_definition = {
  set: function (v) {
    this._setProperty('speak-header', v);
  },
  get: function () {
    return this.getPropertyValue('speak-header');
  },
  enumerable: true,
  configurable: true
};
var speakNumeral_export_definition;
speakNumeral_export_definition = {
  set: function (v) {
    this._setProperty('speak-numeral', v);
  },
  get: function () {
    return this.getPropertyValue('speak-numeral');
  },
  enumerable: true,
  configurable: true
};
var speakPunctuation_export_definition;
speakPunctuation_export_definition = {
  set: function (v) {
    this._setProperty('speak-punctuation', v);
  },
  get: function () {
    return this.getPropertyValue('speak-punctuation');
  },
  enumerable: true,
  configurable: true
};
var speechRate_export_definition;
speechRate_export_definition = {
  set: function (v) {
    this._setProperty('speech-rate', v);
  },
  get: function () {
    return this.getPropertyValue('speech-rate');
  },
  enumerable: true,
  configurable: true
};
var src_export_definition;
src_export_definition = {
  set: function (v) {
    this._setProperty('src', v);
  },
  get: function () {
    return this.getPropertyValue('src');
  },
  enumerable: true,
  configurable: true
};
var stopColor_export_definition;
stopColor_export_definition = {
  set: function (v) {
    this._setProperty('stop-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('stop-color');
  },
  enumerable: true,
  configurable: true
};
var stopOpacity_export_definition;
stopOpacity_export_definition = {
  set: function (v) {
    this._setProperty('stop-opacity', v);
  },
  get: function () {
    return this.getPropertyValue('stop-opacity');
  },
  enumerable: true,
  configurable: true
};
var stress_export_definition;
stress_export_definition = {
  set: function (v) {
    this._setProperty('stress', v);
  },
  get: function () {
    return this.getPropertyValue('stress');
  },
  enumerable: true,
  configurable: true
};
var stroke_export_definition;
stroke_export_definition = {
  set: function (v) {
    this._setProperty('stroke', v);
  },
  get: function () {
    return this.getPropertyValue('stroke');
  },
  enumerable: true,
  configurable: true
};
var strokeDasharray_export_definition;
strokeDasharray_export_definition = {
  set: function (v) {
    this._setProperty('stroke-dasharray', v);
  },
  get: function () {
    return this.getPropertyValue('stroke-dasharray');
  },
  enumerable: true,
  configurable: true
};
var strokeDashoffset_export_definition;
strokeDashoffset_export_definition = {
  set: function (v) {
    this._setProperty('stroke-dashoffset', v);
  },
  get: function () {
    return this.getPropertyValue('stroke-dashoffset');
  },
  enumerable: true,
  configurable: true
};
var strokeLinecap_export_definition;
strokeLinecap_export_definition = {
  set: function (v) {
    this._setProperty('stroke-linecap', v);
  },
  get: function () {
    return this.getPropertyValue('stroke-linecap');
  },
  enumerable: true,
  configurable: true
};
var strokeLinejoin_export_definition;
strokeLinejoin_export_definition = {
  set: function (v) {
    this._setProperty('stroke-linejoin', v);
  },
  get: function () {
    return this.getPropertyValue('stroke-linejoin');
  },
  enumerable: true,
  configurable: true
};
var strokeMiterlimit_export_definition;
strokeMiterlimit_export_definition = {
  set: function (v) {
    this._setProperty('stroke-miterlimit', v);
  },
  get: function () {
    return this.getPropertyValue('stroke-miterlimit');
  },
  enumerable: true,
  configurable: true
};
var strokeOpacity_export_definition;
strokeOpacity_export_definition = {
  set: function (v) {
    this._setProperty('stroke-opacity', v);
  },
  get: function () {
    return this.getPropertyValue('stroke-opacity');
  },
  enumerable: true,
  configurable: true
};
var strokeWidth_export_definition;
strokeWidth_export_definition = {
  set: function (v) {
    this._setProperty('stroke-width', v);
  },
  get: function () {
    return this.getPropertyValue('stroke-width');
  },
  enumerable: true,
  configurable: true
};
var tableLayout_export_definition;
tableLayout_export_definition = {
  set: function (v) {
    this._setProperty('table-layout', v);
  },
  get: function () {
    return this.getPropertyValue('table-layout');
  },
  enumerable: true,
  configurable: true
};
var textAlign_export_definition;
textAlign_export_definition = {
  set: function (v) {
    this._setProperty('text-align', v);
  },
  get: function () {
    return this.getPropertyValue('text-align');
  },
  enumerable: true,
  configurable: true
};
var textAnchor_export_definition;
textAnchor_export_definition = {
  set: function (v) {
    this._setProperty('text-anchor', v);
  },
  get: function () {
    return this.getPropertyValue('text-anchor');
  },
  enumerable: true,
  configurable: true
};
var textDecoration_export_definition;
textDecoration_export_definition = {
  set: function (v) {
    this._setProperty('text-decoration', v);
  },
  get: function () {
    return this.getPropertyValue('text-decoration');
  },
  enumerable: true,
  configurable: true
};
var textIndent_export_definition;
textIndent_export_definition = {
  set: function (v) {
    this._setProperty('text-indent', v);
  },
  get: function () {
    return this.getPropertyValue('text-indent');
  },
  enumerable: true,
  configurable: true
};
var textLineThrough_export_definition;
textLineThrough_export_definition = {
  set: function (v) {
    this._setProperty('text-line-through', v);
  },
  get: function () {
    return this.getPropertyValue('text-line-through');
  },
  enumerable: true,
  configurable: true
};
var textLineThroughColor_export_definition;
textLineThroughColor_export_definition = {
  set: function (v) {
    this._setProperty('text-line-through-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('text-line-through-color');
  },
  enumerable: true,
  configurable: true
};
var textLineThroughMode_export_definition;
textLineThroughMode_export_definition = {
  set: function (v) {
    this._setProperty('text-line-through-mode', v);
  },
  get: function () {
    return this.getPropertyValue('text-line-through-mode');
  },
  enumerable: true,
  configurable: true
};
var textLineThroughStyle_export_definition;
textLineThroughStyle_export_definition = {
  set: function (v) {
    this._setProperty('text-line-through-style', v);
  },
  get: function () {
    return this.getPropertyValue('text-line-through-style');
  },
  enumerable: true,
  configurable: true
};
var textLineThroughWidth_export_definition;
textLineThroughWidth_export_definition = {
  set: function (v) {
    this._setProperty('text-line-through-width', v);
  },
  get: function () {
    return this.getPropertyValue('text-line-through-width');
  },
  enumerable: true,
  configurable: true
};
var textOverflow_export_definition;
textOverflow_export_definition = {
  set: function (v) {
    this._setProperty('text-overflow', v);
  },
  get: function () {
    return this.getPropertyValue('text-overflow');
  },
  enumerable: true,
  configurable: true
};
var textOverline_export_definition;
textOverline_export_definition = {
  set: function (v) {
    this._setProperty('text-overline', v);
  },
  get: function () {
    return this.getPropertyValue('text-overline');
  },
  enumerable: true,
  configurable: true
};
var textOverlineColor_export_definition;
textOverlineColor_export_definition = {
  set: function (v) {
    this._setProperty('text-overline-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('text-overline-color');
  },
  enumerable: true,
  configurable: true
};
var textOverlineMode_export_definition;
textOverlineMode_export_definition = {
  set: function (v) {
    this._setProperty('text-overline-mode', v);
  },
  get: function () {
    return this.getPropertyValue('text-overline-mode');
  },
  enumerable: true,
  configurable: true
};
var textOverlineStyle_export_definition;
textOverlineStyle_export_definition = {
  set: function (v) {
    this._setProperty('text-overline-style', v);
  },
  get: function () {
    return this.getPropertyValue('text-overline-style');
  },
  enumerable: true,
  configurable: true
};
var textOverlineWidth_export_definition;
textOverlineWidth_export_definition = {
  set: function (v) {
    this._setProperty('text-overline-width', v);
  },
  get: function () {
    return this.getPropertyValue('text-overline-width');
  },
  enumerable: true,
  configurable: true
};
var textRendering_export_definition;
textRendering_export_definition = {
  set: function (v) {
    this._setProperty('text-rendering', v);
  },
  get: function () {
    return this.getPropertyValue('text-rendering');
  },
  enumerable: true,
  configurable: true
};
var textShadow_export_definition;
textShadow_export_definition = {
  set: function (v) {
    this._setProperty('text-shadow', v);
  },
  get: function () {
    return this.getPropertyValue('text-shadow');
  },
  enumerable: true,
  configurable: true
};
var textTransform_export_definition;
textTransform_export_definition = {
  set: function (v) {
    this._setProperty('text-transform', v);
  },
  get: function () {
    return this.getPropertyValue('text-transform');
  },
  enumerable: true,
  configurable: true
};
var textUnderline_export_definition;
textUnderline_export_definition = {
  set: function (v) {
    this._setProperty('text-underline', v);
  },
  get: function () {
    return this.getPropertyValue('text-underline');
  },
  enumerable: true,
  configurable: true
};
var textUnderlineColor_export_definition;
textUnderlineColor_export_definition = {
  set: function (v) {
    this._setProperty('text-underline-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('text-underline-color');
  },
  enumerable: true,
  configurable: true
};
var textUnderlineMode_export_definition;
textUnderlineMode_export_definition = {
  set: function (v) {
    this._setProperty('text-underline-mode', v);
  },
  get: function () {
    return this.getPropertyValue('text-underline-mode');
  },
  enumerable: true,
  configurable: true
};
var textUnderlineStyle_export_definition;
textUnderlineStyle_export_definition = {
  set: function (v) {
    this._setProperty('text-underline-style', v);
  },
  get: function () {
    return this.getPropertyValue('text-underline-style');
  },
  enumerable: true,
  configurable: true
};
var textUnderlineWidth_export_definition;
textUnderlineWidth_export_definition = {
  set: function (v) {
    this._setProperty('text-underline-width', v);
  },
  get: function () {
    return this.getPropertyValue('text-underline-width');
  },
  enumerable: true,
  configurable: true
};
var top_export_definition;
top_export_definition = {
  set: function (v) {
    this._setProperty('top', external_dependency_parsers_0.parseMeasurement(v));
  },
  get: function () {
    return this.getPropertyValue('top');
  },
  enumerable: true,
  configurable: true
};
var transform_export_definition;
transform_export_definition = {
  set: function (v) {
    this._setProperty('transform', v);
  },
  get: function () {
    return this.getPropertyValue('transform');
  },
  enumerable: true,
  configurable: true
};
var unicodeBidi_export_definition;
unicodeBidi_export_definition = {
  set: function (v) {
    this._setProperty('unicode-bidi', v);
  },
  get: function () {
    return this.getPropertyValue('unicode-bidi');
  },
  enumerable: true,
  configurable: true
};
var unicodeRange_export_definition;
unicodeRange_export_definition = {
  set: function (v) {
    this._setProperty('unicode-range', v);
  },
  get: function () {
    return this.getPropertyValue('unicode-range');
  },
  enumerable: true,
  configurable: true
};
var vectorEffect_export_definition;
vectorEffect_export_definition = {
  set: function (v) {
    this._setProperty('vector-effect', v);
  },
  get: function () {
    return this.getPropertyValue('vector-effect');
  },
  enumerable: true,
  configurable: true
};
var verticalAlign_export_definition;
verticalAlign_export_definition = {
  set: function (v) {
    this._setProperty('vertical-align', v);
  },
  get: function () {
    return this.getPropertyValue('vertical-align');
  },
  enumerable: true,
  configurable: true
};
var visibility_export_definition;
visibility_export_definition = {
  set: function (v) {
    this._setProperty('visibility', v);
  },
  get: function () {
    return this.getPropertyValue('visibility');
  },
  enumerable: true,
  configurable: true
};
var voiceFamily_export_definition;
voiceFamily_export_definition = {
  set: function (v) {
    this._setProperty('voic-family', v);
  },
  get: function () {
    return this.getPropertyValue('voice-family');
  },
  enumerable: true,
  configurable: true
};
var volume_export_definition;
volume_export_definition = {
  set: function (v) {
    this._setProperty('volume', v);
  },
  get: function () {
    return this.getPropertyValue('volume');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimation_export_definition;
webkitAnimation_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimationDelay_export_definition;
webkitAnimationDelay_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation-delay', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation-delay');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimationDirection_export_definition;
webkitAnimationDirection_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation-direction', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation-direction');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimationDuration_export_definition;
webkitAnimationDuration_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation-duration', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation-duration');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimationFillMode_export_definition;
webkitAnimationFillMode_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation-fill-mode', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation-fill-mode');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimationIterationCount_export_definition;
webkitAnimationIterationCount_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation-iteration-count', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation-iteration-count');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimationName_export_definition;
webkitAnimationName_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation-name', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation-name');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimationPlayState_export_definition;
webkitAnimationPlayState_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation-play-state', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation-play-state');
  },
  enumerable: true,
  configurable: true
};
var webkitAnimationTimingFunction_export_definition;
webkitAnimationTimingFunction_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-animation-timing-function', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-animation-timing-function');
  },
  enumerable: true,
  configurable: true
};
var webkitAppearance_export_definition;
webkitAppearance_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-appearance', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-appearance');
  },
  enumerable: true,
  configurable: true
};
var webkitAspectRatio_export_definition;
webkitAspectRatio_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-aspect-ratio', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-aspect-ratio');
  },
  enumerable: true,
  configurable: true
};
var webkitBackfaceVisibility_export_definition;
webkitBackfaceVisibility_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-backface-visibility', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-backface-visibility');
  },
  enumerable: true,
  configurable: true
};
var webkitBackgroundClip_export_definition;
webkitBackgroundClip_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-background-clip', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-background-clip');
  },
  enumerable: true,
  configurable: true
};
var webkitBackgroundComposite_export_definition;
webkitBackgroundComposite_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-background-composite', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-background-composite');
  },
  enumerable: true,
  configurable: true
};
var webkitBackgroundOrigin_export_definition;
webkitBackgroundOrigin_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-background-origin', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-background-origin');
  },
  enumerable: true,
  configurable: true
};
var webkitBackgroundSize_export_definition;
webkitBackgroundSize_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-background-size', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-background-size');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderAfter_export_definition;
webkitBorderAfter_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-after', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-after');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderAfterColor_export_definition;
webkitBorderAfterColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-after-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-after-color');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderAfterStyle_export_definition;
webkitBorderAfterStyle_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-after-style', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-after-style');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderAfterWidth_export_definition;
webkitBorderAfterWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-after-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-after-width');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderBefore_export_definition;
webkitBorderBefore_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-before', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-before');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderBeforeColor_export_definition;
webkitBorderBeforeColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-before-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-before-color');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderBeforeStyle_export_definition;
webkitBorderBeforeStyle_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-before-style', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-before-style');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderBeforeWidth_export_definition;
webkitBorderBeforeWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-before-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-before-width');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderEnd_export_definition;
webkitBorderEnd_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-end', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-end');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderEndColor_export_definition;
webkitBorderEndColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-end-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-end-color');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderEndStyle_export_definition;
webkitBorderEndStyle_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-end-style', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-end-style');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderEndWidth_export_definition;
webkitBorderEndWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-end-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-end-width');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderFit_export_definition;
webkitBorderFit_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-fit', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-fit');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderHorizontalSpacing_export_definition;
webkitBorderHorizontalSpacing_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-horizontal-spacing', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-horizontal-spacing');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderImage_export_definition;
webkitBorderImage_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-image', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-image');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderRadius_export_definition;
webkitBorderRadius_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-radius', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-radius');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderStart_export_definition;
webkitBorderStart_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-start', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-start');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderStartColor_export_definition;
webkitBorderStartColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-start-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-start-color');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderStartStyle_export_definition;
webkitBorderStartStyle_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-start-style', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-start-style');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderStartWidth_export_definition;
webkitBorderStartWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-start-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-start-width');
  },
  enumerable: true,
  configurable: true
};
var webkitBorderVerticalSpacing_export_definition;
webkitBorderVerticalSpacing_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-border-vertical-spacing', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-border-vertical-spacing');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxAlign_export_definition;
webkitBoxAlign_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-align', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-align');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxDirection_export_definition;
webkitBoxDirection_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-direction', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-direction');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxFlex_export_definition;
webkitBoxFlex_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-flex', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-flex');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxFlexGroup_export_definition;
webkitBoxFlexGroup_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-flex-group', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-flex-group');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxLines_export_definition;
webkitBoxLines_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-lines', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-lines');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxOrdinalGroup_export_definition;
webkitBoxOrdinalGroup_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-ordinal-group', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-ordinal-group');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxOrient_export_definition;
webkitBoxOrient_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-orient', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-orient');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxPack_export_definition;
webkitBoxPack_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-pack', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-pack');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxReflect_export_definition;
webkitBoxReflect_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-reflect', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-reflect');
  },
  enumerable: true,
  configurable: true
};
var webkitBoxShadow_export_definition;
webkitBoxShadow_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-box-shadow', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-box-shadow');
  },
  enumerable: true,
  configurable: true
};
var webkitColorCorrection_export_definition;
webkitColorCorrection_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-color-correction', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-color-correction');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnAxis_export_definition;
webkitColumnAxis_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-axis', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-axis');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnBreakAfter_export_definition;
webkitColumnBreakAfter_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-break-after', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-break-after');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnBreakBefore_export_definition;
webkitColumnBreakBefore_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-break-before', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-break-before');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnBreakInside_export_definition;
webkitColumnBreakInside_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-break-inside', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-break-inside');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnCount_export_definition;
webkitColumnCount_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-count', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-count');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnGap_export_definition;
webkitColumnGap_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-gap', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-gap');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnRule_export_definition;
webkitColumnRule_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-rule', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-rule');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnRuleColor_export_definition;
webkitColumnRuleColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-rule-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-rule-color');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnRuleStyle_export_definition;
webkitColumnRuleStyle_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-rule-style', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-rule-style');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnRuleWidth_export_definition;
webkitColumnRuleWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-rule-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-rule-width');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnSpan_export_definition;
webkitColumnSpan_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-span', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-span');
  },
  enumerable: true,
  configurable: true
};
var webkitColumnWidth_export_definition;
webkitColumnWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-column-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-column-width');
  },
  enumerable: true,
  configurable: true
};
var webkitColumns_export_definition;
webkitColumns_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-columns', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-columns');
  },
  enumerable: true,
  configurable: true
};
var webkitFilter_export_definition;
webkitFilter_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-filter', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-filter');
  },
  enumerable: true,
  configurable: true
};
var webkitFlexAlign_export_definition;
webkitFlexAlign_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flex-align', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flex-align');
  },
  enumerable: true,
  configurable: true
};
var webkitFlexDirection_export_definition;
webkitFlexDirection_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flex-direction', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flex-direction');
  },
  enumerable: true,
  configurable: true
};
var webkitFlexFlow_export_definition;
webkitFlexFlow_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flex-flow', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flex-flow');
  },
  enumerable: true,
  configurable: true
};
var webkitFlexItemAlign_export_definition;
webkitFlexItemAlign_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flex-item-align', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flex-item-align');
  },
  enumerable: true,
  configurable: true
};
var webkitFlexLinePack_export_definition;
webkitFlexLinePack_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flex-line-pack', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flex-line-pack');
  },
  enumerable: true,
  configurable: true
};
var webkitFlexOrder_export_definition;
webkitFlexOrder_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flex-order', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flex-order');
  },
  enumerable: true,
  configurable: true
};
var webkitFlexPack_export_definition;
webkitFlexPack_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flex-pack', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flex-pack');
  },
  enumerable: true,
  configurable: true
};
var webkitFlexWrap_export_definition;
webkitFlexWrap_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flex-wrap', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flex-wrap');
  },
  enumerable: true,
  configurable: true
};
var webkitFlowFrom_export_definition;
webkitFlowFrom_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flow-from', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flow-from');
  },
  enumerable: true,
  configurable: true
};
var webkitFlowInto_export_definition;
webkitFlowInto_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-flow-into', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-flow-into');
  },
  enumerable: true,
  configurable: true
};
var webkitFontFeatureSettings_export_definition;
webkitFontFeatureSettings_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-font-feature-settings', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-font-feature-settings');
  },
  enumerable: true,
  configurable: true
};
var webkitFontKerning_export_definition;
webkitFontKerning_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-font-kerning', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-font-kerning');
  },
  enumerable: true,
  configurable: true
};
var webkitFontSizeDelta_export_definition;
webkitFontSizeDelta_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-font-size-delta', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-font-size-delta');
  },
  enumerable: true,
  configurable: true
};
var webkitFontSmoothing_export_definition;
webkitFontSmoothing_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-font-smoothing', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-font-smoothing');
  },
  enumerable: true,
  configurable: true
};
var webkitFontVariantLigatures_export_definition;
webkitFontVariantLigatures_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-font-variant-ligatures', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-font-variant-ligatures');
  },
  enumerable: true,
  configurable: true
};
var webkitHighlight_export_definition;
webkitHighlight_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-highlight', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-highlight');
  },
  enumerable: true,
  configurable: true
};
var webkitHyphenateCharacter_export_definition;
webkitHyphenateCharacter_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-hyphenate-character', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-hyphenate-character');
  },
  enumerable: true,
  configurable: true
};
var webkitHyphenateLimitAfter_export_definition;
webkitHyphenateLimitAfter_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-hyphenate-limit-after', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-hyphenate-limit-after');
  },
  enumerable: true,
  configurable: true
};
var webkitHyphenateLimitBefore_export_definition;
webkitHyphenateLimitBefore_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-hyphenate-limit-before', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-hyphenate-limit-before');
  },
  enumerable: true,
  configurable: true
};
var webkitHyphenateLimitLines_export_definition;
webkitHyphenateLimitLines_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-hyphenate-limit-lines', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-hyphenate-limit-lines');
  },
  enumerable: true,
  configurable: true
};
var webkitHyphens_export_definition;
webkitHyphens_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-hyphens', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-hyphens');
  },
  enumerable: true,
  configurable: true
};
var webkitLineAlign_export_definition;
webkitLineAlign_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-line-align', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-line-align');
  },
  enumerable: true,
  configurable: true
};
var webkitLineBoxContain_export_definition;
webkitLineBoxContain_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-line-box-contain', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-line-box-contain');
  },
  enumerable: true,
  configurable: true
};
var webkitLineBreak_export_definition;
webkitLineBreak_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-line-break', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-line-break');
  },
  enumerable: true,
  configurable: true
};
var webkitLineClamp_export_definition;
webkitLineClamp_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-line-clamp', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-line-clamp');
  },
  enumerable: true,
  configurable: true
};
var webkitLineGrid_export_definition;
webkitLineGrid_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-line-grid', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-line-grid');
  },
  enumerable: true,
  configurable: true
};
var webkitLineSnap_export_definition;
webkitLineSnap_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-line-snap', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-line-snap');
  },
  enumerable: true,
  configurable: true
};
var webkitLocale_export_definition;
webkitLocale_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-locale', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-locale');
  },
  enumerable: true,
  configurable: true
};
var webkitLogicalHeight_export_definition;
webkitLogicalHeight_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-logical-height', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-logical-height');
  },
  enumerable: true,
  configurable: true
};
var webkitLogicalWidth_export_definition;
webkitLogicalWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-logical-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-logical-width');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginAfter_export_definition;
webkitMarginAfter_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-after', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-after');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginAfterCollapse_export_definition;
webkitMarginAfterCollapse_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-after-collapse', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-after-collapse');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginBefore_export_definition;
webkitMarginBefore_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-before', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-before');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginBeforeCollapse_export_definition;
webkitMarginBeforeCollapse_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-before-collapse', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-before-collapse');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginBottomCollapse_export_definition;
webkitMarginBottomCollapse_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-bottom-collapse', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-bottom-collapse');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginCollapse_export_definition;
webkitMarginCollapse_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-collapse', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-collapse');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginEnd_export_definition;
webkitMarginEnd_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-end', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-end');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginStart_export_definition;
webkitMarginStart_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-start', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-start');
  },
  enumerable: true,
  configurable: true
};
var webkitMarginTopCollapse_export_definition;
webkitMarginTopCollapse_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-margin-top-collapse', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-margin-top-collapse');
  },
  enumerable: true,
  configurable: true
};
var webkitMarquee_export_definition;
webkitMarquee_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-marquee', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-marquee');
  },
  enumerable: true,
  configurable: true
};
var webkitMarqueeDirection_export_definition;
webkitMarqueeDirection_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-marquee-direction', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-marquee-direction');
  },
  enumerable: true,
  configurable: true
};
var webkitMarqueeIncrement_export_definition;
webkitMarqueeIncrement_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-marquee-increment', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-marquee-increment');
  },
  enumerable: true,
  configurable: true
};
var webkitMarqueeRepetition_export_definition;
webkitMarqueeRepetition_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-marquee-repetition', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-marquee-repetition');
  },
  enumerable: true,
  configurable: true
};
var webkitMarqueeSpeed_export_definition;
webkitMarqueeSpeed_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-marquee-speed', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-marquee-speed');
  },
  enumerable: true,
  configurable: true
};
var webkitMarqueeStyle_export_definition;
webkitMarqueeStyle_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-marquee-style', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-marquee-style');
  },
  enumerable: true,
  configurable: true
};
var webkitMask_export_definition;
webkitMask_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskAttachment_export_definition;
webkitMaskAttachment_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-attachment', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-attachment');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskBoxImage_export_definition;
webkitMaskBoxImage_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-box-image', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-box-image');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskBoxImageOutset_export_definition;
webkitMaskBoxImageOutset_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-box-image-outset', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-box-image-outset');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskBoxImageRepeat_export_definition;
webkitMaskBoxImageRepeat_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-box-image-repeat', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-box-image-repeat');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskBoxImageSlice_export_definition;
webkitMaskBoxImageSlice_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-box-image-slice', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-box-image-slice');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskBoxImageSource_export_definition;
webkitMaskBoxImageSource_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-box-image-source', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-box-image-source');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskBoxImageWidth_export_definition;
webkitMaskBoxImageWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-box-image-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-box-image-width');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskClip_export_definition;
webkitMaskClip_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-clip', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-clip');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskComposite_export_definition;
webkitMaskComposite_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-composite', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-composite');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskImage_export_definition;
webkitMaskImage_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-image', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-image');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskOrigin_export_definition;
webkitMaskOrigin_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-origin', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-origin');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskPosition_export_definition;
webkitMaskPosition_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-position', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-position');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskPositionX_export_definition;
webkitMaskPositionX_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-position-x', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-position-x');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskPositionY_export_definition;
webkitMaskPositionY_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-position-y', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-position-y');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskRepeat_export_definition;
webkitMaskRepeat_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-repeat', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-repeat');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskRepeatX_export_definition;
webkitMaskRepeatX_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-repeat-x', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-repeat-x');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskRepeatY_export_definition;
webkitMaskRepeatY_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-repeat-y', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-repeat-y');
  },
  enumerable: true,
  configurable: true
};
var webkitMaskSize_export_definition;
webkitMaskSize_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-mask-size', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-mask-size');
  },
  enumerable: true,
  configurable: true
};
var webkitMatchNearestMailBlockquoteColor_export_definition;
webkitMatchNearestMailBlockquoteColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-match-nearest-mail-blockquote-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-match-nearest-mail-blockquote-color');
  },
  enumerable: true,
  configurable: true
};
var webkitMaxLogicalHeight_export_definition;
webkitMaxLogicalHeight_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-max-logical-height', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-max-logical-height');
  },
  enumerable: true,
  configurable: true
};
var webkitMaxLogicalWidth_export_definition;
webkitMaxLogicalWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-max-logical-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-max-logical-width');
  },
  enumerable: true,
  configurable: true
};
var webkitMinLogicalHeight_export_definition;
webkitMinLogicalHeight_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-min-logical-height', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-min-logical-height');
  },
  enumerable: true,
  configurable: true
};
var webkitMinLogicalWidth_export_definition;
webkitMinLogicalWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-min-logical-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-min-logical-width');
  },
  enumerable: true,
  configurable: true
};
var webkitNbspMode_export_definition;
webkitNbspMode_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-nbsp-mode', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-nbsp-mode');
  },
  enumerable: true,
  configurable: true
};
var webkitOverflowScrolling_export_definition;
webkitOverflowScrolling_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-overflow-scrolling', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-overflow-scrolling');
  },
  enumerable: true,
  configurable: true
};
var webkitPaddingAfter_export_definition;
webkitPaddingAfter_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-padding-after', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-padding-after');
  },
  enumerable: true,
  configurable: true
};
var webkitPaddingBefore_export_definition;
webkitPaddingBefore_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-padding-before', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-padding-before');
  },
  enumerable: true,
  configurable: true
};
var webkitPaddingEnd_export_definition;
webkitPaddingEnd_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-padding-end', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-padding-end');
  },
  enumerable: true,
  configurable: true
};
var webkitPaddingStart_export_definition;
webkitPaddingStart_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-padding-start', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-padding-start');
  },
  enumerable: true,
  configurable: true
};
var webkitPerspective_export_definition;
webkitPerspective_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-perspective', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-perspective');
  },
  enumerable: true,
  configurable: true
};
var webkitPerspectiveOrigin_export_definition;
webkitPerspectiveOrigin_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-perspective-origin', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-perspective-origin');
  },
  enumerable: true,
  configurable: true
};
var webkitPerspectiveOriginX_export_definition;
webkitPerspectiveOriginX_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-perspective-origin-x', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-perspective-origin-x');
  },
  enumerable: true,
  configurable: true
};
var webkitPerspectiveOriginY_export_definition;
webkitPerspectiveOriginY_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-perspective-origin-y', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-perspective-origin-y');
  },
  enumerable: true,
  configurable: true
};
var webkitPrintColorAdjust_export_definition;
webkitPrintColorAdjust_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-print-color-adjust', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-print-color-adjust');
  },
  enumerable: true,
  configurable: true
};
var webkitRegionBreakAfter_export_definition;
webkitRegionBreakAfter_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-region-break-after', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-region-break-after');
  },
  enumerable: true,
  configurable: true
};
var webkitRegionBreakBefore_export_definition;
webkitRegionBreakBefore_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-region-break-before', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-region-break-before');
  },
  enumerable: true,
  configurable: true
};
var webkitRegionBreakInside_export_definition;
webkitRegionBreakInside_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-region-break-inside', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-region-break-inside');
  },
  enumerable: true,
  configurable: true
};
var webkitRegionOverflow_export_definition;
webkitRegionOverflow_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-region-overflow', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-region-overflow');
  },
  enumerable: true,
  configurable: true
};
var webkitRtlOrdering_export_definition;
webkitRtlOrdering_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-rtl-ordering', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-rtl-ordering');
  },
  enumerable: true,
  configurable: true
};
var webkitSvgShadow_export_definition;
webkitSvgShadow_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-svg-shadow', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-svg-shadow');
  },
  enumerable: true,
  configurable: true
};
var webkitTapHighlightColor_export_definition;
webkitTapHighlightColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-tap-highlight-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-tap-highlight-color');
  },
  enumerable: true,
  configurable: true
};
var webkitTextCombine_export_definition;
webkitTextCombine_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-combine', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-combine');
  },
  enumerable: true,
  configurable: true
};
var webkitTextDecorationsInEffect_export_definition;
webkitTextDecorationsInEffect_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-decorations-in-effect', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-decorations-in-effect');
  },
  enumerable: true,
  configurable: true
};
var webkitTextEmphasis_export_definition;
webkitTextEmphasis_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-emphasis', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-emphasis');
  },
  enumerable: true,
  configurable: true
};
var webkitTextEmphasisColor_export_definition;
webkitTextEmphasisColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-emphasis-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-emphasis-color');
  },
  enumerable: true,
  configurable: true
};
var webkitTextEmphasisPosition_export_definition;
webkitTextEmphasisPosition_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-emphasis-position', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-emphasis-position');
  },
  enumerable: true,
  configurable: true
};
var webkitTextEmphasisStyle_export_definition;
webkitTextEmphasisStyle_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-emphasis-style', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-emphasis-style');
  },
  enumerable: true,
  configurable: true
};
var webkitTextFillColor_export_definition;
webkitTextFillColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-fill-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-fill-color');
  },
  enumerable: true,
  configurable: true
};
var webkitTextOrientation_export_definition;
webkitTextOrientation_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-orientation', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-orientation');
  },
  enumerable: true,
  configurable: true
};
var webkitTextSecurity_export_definition;
webkitTextSecurity_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-security', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-security');
  },
  enumerable: true,
  configurable: true
};
var webkitTextSizeAdjust_export_definition;
webkitTextSizeAdjust_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-size-adjust', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-size-adjust');
  },
  enumerable: true,
  configurable: true
};
var webkitTextStroke_export_definition;
webkitTextStroke_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-stroke', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-stroke');
  },
  enumerable: true,
  configurable: true
};
var webkitTextStrokeColor_export_definition;
webkitTextStrokeColor_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-stroke-color', external_dependency_parsers_0.parseColor(v));
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-stroke-color');
  },
  enumerable: true,
  configurable: true
};
var webkitTextStrokeWidth_export_definition;
webkitTextStrokeWidth_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-text-stroke-width', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-text-stroke-width');
  },
  enumerable: true,
  configurable: true
};
var webkitTransform_export_definition;
webkitTransform_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transform', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transform');
  },
  enumerable: true,
  configurable: true
};
var webkitTransformOrigin_export_definition;
webkitTransformOrigin_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transform-origin', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transform-origin');
  },
  enumerable: true,
  configurable: true
};
var webkitTransformOriginX_export_definition;
webkitTransformOriginX_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transform-origin-x', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transform-origin-x');
  },
  enumerable: true,
  configurable: true
};
var webkitTransformOriginY_export_definition;
webkitTransformOriginY_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transform-origin-y', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transform-origin-y');
  },
  enumerable: true,
  configurable: true
};
var webkitTransformOriginZ_export_definition;
webkitTransformOriginZ_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transform-origin-z', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transform-origin-z');
  },
  enumerable: true,
  configurable: true
};
var webkitTransformStyle_export_definition;
webkitTransformStyle_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transform-style', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transform-style');
  },
  enumerable: true,
  configurable: true
};
var webkitTransition_export_definition;
webkitTransition_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transition', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transition');
  },
  enumerable: true,
  configurable: true
};
var webkitTransitionDelay_export_definition;
webkitTransitionDelay_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transition-delay', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transition-delay');
  },
  enumerable: true,
  configurable: true
};
var webkitTransitionDuration_export_definition;
webkitTransitionDuration_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transition-duration', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transition-duration');
  },
  enumerable: true,
  configurable: true
};
var webkitTransitionProperty_export_definition;
webkitTransitionProperty_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transition-property', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transition-property');
  },
  enumerable: true,
  configurable: true
};
var webkitTransitionTimingFunction_export_definition;
webkitTransitionTimingFunction_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-transition-timing-function', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-transition-timing-function');
  },
  enumerable: true,
  configurable: true
};
var webkitUserDrag_export_definition;
webkitUserDrag_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-user-drag', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-user-drag');
  },
  enumerable: true,
  configurable: true
};
var webkitUserModify_export_definition;
webkitUserModify_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-user-modify', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-user-modify');
  },
  enumerable: true,
  configurable: true
};
var webkitUserSelect_export_definition;
webkitUserSelect_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-user-select', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-user-select');
  },
  enumerable: true,
  configurable: true
};
var webkitWrap_export_definition;
webkitWrap_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-wrap', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-wrap');
  },
  enumerable: true,
  configurable: true
};
var webkitWrapFlow_export_definition;
webkitWrapFlow_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-wrap-flow', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-wrap-flow');
  },
  enumerable: true,
  configurable: true
};
var webkitWrapMargin_export_definition;
webkitWrapMargin_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-wrap-margin', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-wrap-margin');
  },
  enumerable: true,
  configurable: true
};
var webkitWrapPadding_export_definition;
webkitWrapPadding_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-wrap-padding', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-wrap-padding');
  },
  enumerable: true,
  configurable: true
};
var webkitWrapShapeInside_export_definition;
webkitWrapShapeInside_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-wrap-shape-inside', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-wrap-shape-inside');
  },
  enumerable: true,
  configurable: true
};
var webkitWrapShapeOutside_export_definition;
webkitWrapShapeOutside_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-wrap-shape-outside', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-wrap-shape-outside');
  },
  enumerable: true,
  configurable: true
};
var webkitWrapThrough_export_definition;
webkitWrapThrough_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-wrap-through', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-wrap-through');
  },
  enumerable: true,
  configurable: true
};
var webkitWritingMode_export_definition;
webkitWritingMode_export_definition = {
  set: function (v) {
    this._setProperty('-webkit-writing-mode', v);
  },
  get: function () {
    return this.getPropertyValue('-webkit-writing-mode');
  },
  enumerable: true,
  configurable: true
};
var whiteSpace_export_definition;
whiteSpace_export_definition = {
  set: function (v) {
    this._setProperty('white-space', v);
  },
  get: function () {
    return this.getPropertyValue('white-space');
  },
  enumerable: true,
  configurable: true
};
var widows_export_definition;
widows_export_definition = {
  set: function (v) {
    this._setProperty('widows', v);
  },
  get: function () {
    return this.getPropertyValue('widows');
  },
  enumerable: true,
  configurable: true
};
var width_export_definition;

function parse(v) {
  if (String(v).toLowerCase() === 'auto') {
    return 'auto';
  }

  if (String(v).toLowerCase() === 'inherit') {
    return 'inherit';
  }

  return external_dependency_parsers_0.parseMeasurement(v);
}

width_export_definition = {
  set: function (v) {
    this._setProperty('width', parse(v));
  },
  get: function () {
    return this.getPropertyValue('width');
  },
  enumerable: true,
  configurable: true
};
var wordBreak_export_definition;
wordBreak_export_definition = {
  set: function (v) {
    this._setProperty('word-break', v);
  },
  get: function () {
    return this.getPropertyValue('word-break');
  },
  enumerable: true,
  configurable: true
};
var wordSpacing_export_definition;
wordSpacing_export_definition = {
  set: function (v) {
    this._setProperty('word-spacing', v);
  },
  get: function () {
    return this.getPropertyValue('word-spacing');
  },
  enumerable: true,
  configurable: true
};
var wordWrap_export_definition;
wordWrap_export_definition = {
  set: function (v) {
    this._setProperty('word-wrap', v);
  },
  get: function () {
    return this.getPropertyValue('word-wrap');
  },
  enumerable: true,
  configurable: true
};
var writingMode_export_definition;
writingMode_export_definition = {
  set: function (v) {
    this._setProperty('writing-mode', v);
  },
  get: function () {
    return this.getPropertyValue('writing-mode');
  },
  enumerable: true,
  configurable: true
};
var zIndex_export_definition;
zIndex_export_definition = {
  set: function (v) {
    this._setProperty('z-index', v);
  },
  get: function () {
    return this.getPropertyValue('z-index');
  },
  enumerable: true,
  configurable: true
};
var zoom_export_definition;
zoom_export_definition = {
  set: function (v) {
    this._setProperty('zoom', v);
  },
  get: function () {
    return this.getPropertyValue('zoom');
  },
  enumerable: true,
  configurable: true
};

module.exports = function (prototype) {
  Object.defineProperties(prototype, {
    alignContent: alignContent_export_definition,
    "align-content": alignContent_export_definition,
    alignItems: alignItems_export_definition,
    "align-items": alignItems_export_definition,
    alignmentBaseline: alignmentBaseline_export_definition,
    "alignment-baseline": alignmentBaseline_export_definition,
    azimuth: azimuth_export_definition,
    backgroundColor: backgroundColor_export_definition,
    "background-color": backgroundColor_export_definition,
    backgroundImage: backgroundImage_export_definition,
    "background-image": backgroundImage_export_definition,
    backgroundRepeat: backgroundRepeat_export_definition,
    "background-repeat": backgroundRepeat_export_definition,
    backgroundAttachment: backgroundAttachment_export_definition,
    "background-attachment": backgroundAttachment_export_definition,
    backgroundPosition: backgroundPosition_export_definition,
    "background-position": backgroundPosition_export_definition,
    background: background_export_definition,
    backgroundClip: backgroundClip_export_definition,
    "background-clip": backgroundClip_export_definition,
    backgroundOrigin: backgroundOrigin_export_definition,
    "background-origin": backgroundOrigin_export_definition,
    backgroundPositionX: backgroundPositionX_export_definition,
    "background-position-x": backgroundPositionX_export_definition,
    backgroundPositionY: backgroundPositionY_export_definition,
    "background-position-y": backgroundPositionY_export_definition,
    backgroundRepeatX: backgroundRepeatX_export_definition,
    "background-repeat-x": backgroundRepeatX_export_definition,
    backgroundRepeatY: backgroundRepeatY_export_definition,
    "background-repeat-y": backgroundRepeatY_export_definition,
    backgroundSize: backgroundSize_export_definition,
    "background-size": backgroundSize_export_definition,
    baselineShift: baselineShift_export_definition,
    "baseline-shift": baselineShift_export_definition,
    borderWidth: borderWidth_export_definition,
    "border-width": borderWidth_export_definition,
    borderStyle: borderStyle_export_definition,
    "border-style": borderStyle_export_definition,
    borderColor: borderColor_export_definition,
    "border-color": borderColor_export_definition,
    border: border_export_definition,
    borderBottomWidth: borderBottomWidth_export_definition,
    "border-bottom-width": borderBottomWidth_export_definition,
    borderBottomStyle: borderBottomStyle_export_definition,
    "border-bottom-style": borderBottomStyle_export_definition,
    borderBottomColor: borderBottomColor_export_definition,
    "border-bottom-color": borderBottomColor_export_definition,
    borderBottom: borderBottom_export_definition,
    "border-bottom": borderBottom_export_definition,
    borderBottomLeftRadius: borderBottomLeftRadius_export_definition,
    "border-bottom-left-radius": borderBottomLeftRadius_export_definition,
    borderBottomRightRadius: borderBottomRightRadius_export_definition,
    "border-bottom-right-radius": borderBottomRightRadius_export_definition,
    borderCollapse: borderCollapse_export_definition,
    "border-collapse": borderCollapse_export_definition,
    borderImage: borderImage_export_definition,
    "border-image": borderImage_export_definition,
    borderImageOutset: borderImageOutset_export_definition,
    "border-image-outset": borderImageOutset_export_definition,
    borderImageRepeat: borderImageRepeat_export_definition,
    "border-image-repeat": borderImageRepeat_export_definition,
    borderImageSlice: borderImageSlice_export_definition,
    "border-image-slice": borderImageSlice_export_definition,
    borderImageSource: borderImageSource_export_definition,
    "border-image-source": borderImageSource_export_definition,
    borderImageWidth: borderImageWidth_export_definition,
    "border-image-width": borderImageWidth_export_definition,
    borderLeftWidth: borderLeftWidth_export_definition,
    "border-left-width": borderLeftWidth_export_definition,
    borderLeftStyle: borderLeftStyle_export_definition,
    "border-left-style": borderLeftStyle_export_definition,
    borderLeftColor: borderLeftColor_export_definition,
    "border-left-color": borderLeftColor_export_definition,
    borderLeft: borderLeft_export_definition,
    "border-left": borderLeft_export_definition,
    borderRadius: borderRadius_export_definition,
    "border-radius": borderRadius_export_definition,
    borderRightWidth: borderRightWidth_export_definition,
    "border-right-width": borderRightWidth_export_definition,
    borderRightStyle: borderRightStyle_export_definition,
    "border-right-style": borderRightStyle_export_definition,
    borderRightColor: borderRightColor_export_definition,
    "border-right-color": borderRightColor_export_definition,
    borderRight: borderRight_export_definition,
    "border-right": borderRight_export_definition,
    borderSpacing: borderSpacing_export_definition,
    "border-spacing": borderSpacing_export_definition,
    borderTopWidth: borderTopWidth_export_definition,
    "border-top-width": borderTopWidth_export_definition,
    borderTopStyle: borderTopStyle_export_definition,
    "border-top-style": borderTopStyle_export_definition,
    borderTopColor: borderTopColor_export_definition,
    "border-top-color": borderTopColor_export_definition,
    borderTop: borderTop_export_definition,
    "border-top": borderTop_export_definition,
    borderTopLeftRadius: borderTopLeftRadius_export_definition,
    "border-top-left-radius": borderTopLeftRadius_export_definition,
    borderTopRightRadius: borderTopRightRadius_export_definition,
    "border-top-right-radius": borderTopRightRadius_export_definition,
    bottom: bottom_export_definition,
    boxShadow: boxShadow_export_definition,
    "box-shadow": boxShadow_export_definition,
    boxSizing: boxSizing_export_definition,
    "box-sizing": boxSizing_export_definition,
    captionSide: captionSide_export_definition,
    "caption-side": captionSide_export_definition,
    clear: clear_export_definition,
    clip: clip_export_definition,
    color: color_export_definition,
    colorInterpolation: colorInterpolation_export_definition,
    "color-interpolation": colorInterpolation_export_definition,
    colorInterpolationFilters: colorInterpolationFilters_export_definition,
    "color-interpolation-filters": colorInterpolationFilters_export_definition,
    colorProfile: colorProfile_export_definition,
    "color-profile": colorProfile_export_definition,
    colorRendering: colorRendering_export_definition,
    "color-rendering": colorRendering_export_definition,
    content: content_export_definition,
    counterIncrement: counterIncrement_export_definition,
    "counter-increment": counterIncrement_export_definition,
    counterReset: counterReset_export_definition,
    "counter-reset": counterReset_export_definition,
    cssFloat: cssFloat_export_definition,
    "css-float": cssFloat_export_definition,
    cue: cue_export_definition,
    cueAfter: cueAfter_export_definition,
    "cue-after": cueAfter_export_definition,
    cueBefore: cueBefore_export_definition,
    "cue-before": cueBefore_export_definition,
    cursor: cursor_export_definition,
    direction: direction_export_definition,
    display: display_export_definition,
    dominantBaseline: dominantBaseline_export_definition,
    "dominant-baseline": dominantBaseline_export_definition,
    elevation: elevation_export_definition,
    emptyCells: emptyCells_export_definition,
    "empty-cells": emptyCells_export_definition,
    enableBackground: enableBackground_export_definition,
    "enable-background": enableBackground_export_definition,
    fill: fill_export_definition,
    fillOpacity: fillOpacity_export_definition,
    "fill-opacity": fillOpacity_export_definition,
    fillRule: fillRule_export_definition,
    "fill-rule": fillRule_export_definition,
    filter: filter_export_definition,
    flexDirection: flexDirection_export_definition,
    "flex-direction": flexDirection_export_definition,
    flexFlow: flexFlow_export_definition,
    "flex-flow": flexFlow_export_definition,
    flexWrap: flexWrap_export_definition,
    "flex-wrap": flexWrap_export_definition,
    floodColor: floodColor_export_definition,
    "flood-color": floodColor_export_definition,
    floodOpacity: floodOpacity_export_definition,
    "flood-opacity": floodOpacity_export_definition,
    fontFamily: fontFamily_export_definition,
    "font-family": fontFamily_export_definition,
    fontSize: fontSize_export_definition,
    "font-size": fontSize_export_definition,
    fontStyle: fontStyle_export_definition,
    "font-style": fontStyle_export_definition,
    fontVariant: fontVariant_export_definition,
    "font-variant": fontVariant_export_definition,
    fontWeight: fontWeight_export_definition,
    "font-weight": fontWeight_export_definition,
    lineHeight: lineHeight_export_definition,
    "line-height": lineHeight_export_definition,
    font: font_export_definition,
    fontSizeAdjust: fontSizeAdjust_export_definition,
    "font-size-adjust": fontSizeAdjust_export_definition,
    fontStretch: fontStretch_export_definition,
    "font-stretch": fontStretch_export_definition,
    glyphOrientationHorizontal: glyphOrientationHorizontal_export_definition,
    "glyph-orientation-horizontal": glyphOrientationHorizontal_export_definition,
    glyphOrientationVertical: glyphOrientationVertical_export_definition,
    "glyph-orientation-vertical": glyphOrientationVertical_export_definition,
    height: height_export_definition,
    imageRendering: imageRendering_export_definition,
    "image-rendering": imageRendering_export_definition,
    justifyContent: justifyContent_export_definition,
    "justify-content": justifyContent_export_definition,
    kerning: kerning_export_definition,
    left: left_export_definition,
    letterSpacing: letterSpacing_export_definition,
    "letter-spacing": letterSpacing_export_definition,
    lightingColor: lightingColor_export_definition,
    "lighting-color": lightingColor_export_definition,
    listStyle: listStyle_export_definition,
    "list-style": listStyle_export_definition,
    listStyleImage: listStyleImage_export_definition,
    "list-style-image": listStyleImage_export_definition,
    listStylePosition: listStylePosition_export_definition,
    "list-style-position": listStylePosition_export_definition,
    listStyleType: listStyleType_export_definition,
    "list-style-type": listStyleType_export_definition,
    margin: margin_export_definition,
    marginBottom: marginBottom_export_definition,
    "margin-bottom": marginBottom_export_definition,
    marginLeft: marginLeft_export_definition,
    "margin-left": marginLeft_export_definition,
    marginRight: marginRight_export_definition,
    "margin-right": marginRight_export_definition,
    marginTop: marginTop_export_definition,
    "margin-top": marginTop_export_definition,
    marker: marker_export_definition,
    markerEnd: markerEnd_export_definition,
    "marker-end": markerEnd_export_definition,
    markerMid: markerMid_export_definition,
    "marker-mid": markerMid_export_definition,
    markerOffset: markerOffset_export_definition,
    "marker-offset": markerOffset_export_definition,
    markerStart: markerStart_export_definition,
    "marker-start": markerStart_export_definition,
    marks: marks_export_definition,
    mask: mask_export_definition,
    maxHeight: maxHeight_export_definition,
    "max-height": maxHeight_export_definition,
    maxWidth: maxWidth_export_definition,
    "max-width": maxWidth_export_definition,
    minHeight: minHeight_export_definition,
    "min-height": minHeight_export_definition,
    minWidth: minWidth_export_definition,
    "min-width": minWidth_export_definition,
    opacity: opacity_export_definition,
    orphans: orphans_export_definition,
    outline: outline_export_definition,
    outlineColor: outlineColor_export_definition,
    "outline-color": outlineColor_export_definition,
    outlineOffset: outlineOffset_export_definition,
    "outline-offset": outlineOffset_export_definition,
    outlineStyle: outlineStyle_export_definition,
    "outline-style": outlineStyle_export_definition,
    outlineWidth: outlineWidth_export_definition,
    "outline-width": outlineWidth_export_definition,
    overflow: overflow_export_definition,
    overflowX: overflowX_export_definition,
    "overflow-x": overflowX_export_definition,
    overflowY: overflowY_export_definition,
    "overflow-y": overflowY_export_definition,
    padding: padding_export_definition,
    paddingBottom: paddingBottom_export_definition,
    "padding-bottom": paddingBottom_export_definition,
    paddingLeft: paddingLeft_export_definition,
    "padding-left": paddingLeft_export_definition,
    paddingRight: paddingRight_export_definition,
    "padding-right": paddingRight_export_definition,
    paddingTop: paddingTop_export_definition,
    "padding-top": paddingTop_export_definition,
    page: page_export_definition,
    pageBreakAfter: pageBreakAfter_export_definition,
    "page-break-after": pageBreakAfter_export_definition,
    pageBreakBefore: pageBreakBefore_export_definition,
    "page-break-before": pageBreakBefore_export_definition,
    pageBreakInside: pageBreakInside_export_definition,
    "page-break-inside": pageBreakInside_export_definition,
    pause: pause_export_definition,
    pauseAfter: pauseAfter_export_definition,
    "pause-after": pauseAfter_export_definition,
    pauseBefore: pauseBefore_export_definition,
    "pause-before": pauseBefore_export_definition,
    pitch: pitch_export_definition,
    pitchRange: pitchRange_export_definition,
    "pitch-range": pitchRange_export_definition,
    playDuring: playDuring_export_definition,
    "play-during": playDuring_export_definition,
    pointerEvents: pointerEvents_export_definition,
    "pointer-events": pointerEvents_export_definition,
    position: position_export_definition,
    quotes: quotes_export_definition,
    resize: resize_export_definition,
    richness: richness_export_definition,
    right: right_export_definition,
    shapeRendering: shapeRendering_export_definition,
    "shape-rendering": shapeRendering_export_definition,
    size: size_export_definition,
    speak: speak_export_definition,
    speakHeader: speakHeader_export_definition,
    "speak-header": speakHeader_export_definition,
    speakNumeral: speakNumeral_export_definition,
    "speak-numeral": speakNumeral_export_definition,
    speakPunctuation: speakPunctuation_export_definition,
    "speak-punctuation": speakPunctuation_export_definition,
    speechRate: speechRate_export_definition,
    "speech-rate": speechRate_export_definition,
    src: src_export_definition,
    stopColor: stopColor_export_definition,
    "stop-color": stopColor_export_definition,
    stopOpacity: stopOpacity_export_definition,
    "stop-opacity": stopOpacity_export_definition,
    stress: stress_export_definition,
    stroke: stroke_export_definition,
    strokeDasharray: strokeDasharray_export_definition,
    "stroke-dasharray": strokeDasharray_export_definition,
    strokeDashoffset: strokeDashoffset_export_definition,
    "stroke-dashoffset": strokeDashoffset_export_definition,
    strokeLinecap: strokeLinecap_export_definition,
    "stroke-linecap": strokeLinecap_export_definition,
    strokeLinejoin: strokeLinejoin_export_definition,
    "stroke-linejoin": strokeLinejoin_export_definition,
    strokeMiterlimit: strokeMiterlimit_export_definition,
    "stroke-miterlimit": strokeMiterlimit_export_definition,
    strokeOpacity: strokeOpacity_export_definition,
    "stroke-opacity": strokeOpacity_export_definition,
    strokeWidth: strokeWidth_export_definition,
    "stroke-width": strokeWidth_export_definition,
    tableLayout: tableLayout_export_definition,
    "table-layout": tableLayout_export_definition,
    textAlign: textAlign_export_definition,
    "text-align": textAlign_export_definition,
    textAnchor: textAnchor_export_definition,
    "text-anchor": textAnchor_export_definition,
    textDecoration: textDecoration_export_definition,
    "text-decoration": textDecoration_export_definition,
    textIndent: textIndent_export_definition,
    "text-indent": textIndent_export_definition,
    textLineThrough: textLineThrough_export_definition,
    "text-line-through": textLineThrough_export_definition,
    textLineThroughColor: textLineThroughColor_export_definition,
    "text-line-through-color": textLineThroughColor_export_definition,
    textLineThroughMode: textLineThroughMode_export_definition,
    "text-line-through-mode": textLineThroughMode_export_definition,
    textLineThroughStyle: textLineThroughStyle_export_definition,
    "text-line-through-style": textLineThroughStyle_export_definition,
    textLineThroughWidth: textLineThroughWidth_export_definition,
    "text-line-through-width": textLineThroughWidth_export_definition,
    textOverflow: textOverflow_export_definition,
    "text-overflow": textOverflow_export_definition,
    textOverline: textOverline_export_definition,
    "text-overline": textOverline_export_definition,
    textOverlineColor: textOverlineColor_export_definition,
    "text-overline-color": textOverlineColor_export_definition,
    textOverlineMode: textOverlineMode_export_definition,
    "text-overline-mode": textOverlineMode_export_definition,
    textOverlineStyle: textOverlineStyle_export_definition,
    "text-overline-style": textOverlineStyle_export_definition,
    textOverlineWidth: textOverlineWidth_export_definition,
    "text-overline-width": textOverlineWidth_export_definition,
    textRendering: textRendering_export_definition,
    "text-rendering": textRendering_export_definition,
    textShadow: textShadow_export_definition,
    "text-shadow": textShadow_export_definition,
    textTransform: textTransform_export_definition,
    "text-transform": textTransform_export_definition,
    textUnderline: textUnderline_export_definition,
    "text-underline": textUnderline_export_definition,
    textUnderlineColor: textUnderlineColor_export_definition,
    "text-underline-color": textUnderlineColor_export_definition,
    textUnderlineMode: textUnderlineMode_export_definition,
    "text-underline-mode": textUnderlineMode_export_definition,
    textUnderlineStyle: textUnderlineStyle_export_definition,
    "text-underline-style": textUnderlineStyle_export_definition,
    textUnderlineWidth: textUnderlineWidth_export_definition,
    "text-underline-width": textUnderlineWidth_export_definition,
    top: top_export_definition,
    transform: transform_export_definition,
    unicodeBidi: unicodeBidi_export_definition,
    "unicode-bidi": unicodeBidi_export_definition,
    unicodeRange: unicodeRange_export_definition,
    "unicode-range": unicodeRange_export_definition,
    vectorEffect: vectorEffect_export_definition,
    "vector-effect": vectorEffect_export_definition,
    verticalAlign: verticalAlign_export_definition,
    "vertical-align": verticalAlign_export_definition,
    visibility: visibility_export_definition,
    voiceFamily: voiceFamily_export_definition,
    "voice-family": voiceFamily_export_definition,
    volume: volume_export_definition,
    webkitAnimation: webkitAnimation_export_definition,
    "webkit-animation": webkitAnimation_export_definition,
    webkitAnimationDelay: webkitAnimationDelay_export_definition,
    "webkit-animation-delay": webkitAnimationDelay_export_definition,
    webkitAnimationDirection: webkitAnimationDirection_export_definition,
    "webkit-animation-direction": webkitAnimationDirection_export_definition,
    webkitAnimationDuration: webkitAnimationDuration_export_definition,
    "webkit-animation-duration": webkitAnimationDuration_export_definition,
    webkitAnimationFillMode: webkitAnimationFillMode_export_definition,
    "webkit-animation-fill-mode": webkitAnimationFillMode_export_definition,
    webkitAnimationIterationCount: webkitAnimationIterationCount_export_definition,
    "webkit-animation-iteration-count": webkitAnimationIterationCount_export_definition,
    webkitAnimationName: webkitAnimationName_export_definition,
    "webkit-animation-name": webkitAnimationName_export_definition,
    webkitAnimationPlayState: webkitAnimationPlayState_export_definition,
    "webkit-animation-play-state": webkitAnimationPlayState_export_definition,
    webkitAnimationTimingFunction: webkitAnimationTimingFunction_export_definition,
    "webkit-animation-timing-function": webkitAnimationTimingFunction_export_definition,
    webkitAppearance: webkitAppearance_export_definition,
    "webkit-appearance": webkitAppearance_export_definition,
    webkitAspectRatio: webkitAspectRatio_export_definition,
    "webkit-aspect-ratio": webkitAspectRatio_export_definition,
    webkitBackfaceVisibility: webkitBackfaceVisibility_export_definition,
    "webkit-backface-visibility": webkitBackfaceVisibility_export_definition,
    webkitBackgroundClip: webkitBackgroundClip_export_definition,
    "webkit-background-clip": webkitBackgroundClip_export_definition,
    webkitBackgroundComposite: webkitBackgroundComposite_export_definition,
    "webkit-background-composite": webkitBackgroundComposite_export_definition,
    webkitBackgroundOrigin: webkitBackgroundOrigin_export_definition,
    "webkit-background-origin": webkitBackgroundOrigin_export_definition,
    webkitBackgroundSize: webkitBackgroundSize_export_definition,
    "webkit-background-size": webkitBackgroundSize_export_definition,
    webkitBorderAfter: webkitBorderAfter_export_definition,
    "webkit-border-after": webkitBorderAfter_export_definition,
    webkitBorderAfterColor: webkitBorderAfterColor_export_definition,
    "webkit-border-after-color": webkitBorderAfterColor_export_definition,
    webkitBorderAfterStyle: webkitBorderAfterStyle_export_definition,
    "webkit-border-after-style": webkitBorderAfterStyle_export_definition,
    webkitBorderAfterWidth: webkitBorderAfterWidth_export_definition,
    "webkit-border-after-width": webkitBorderAfterWidth_export_definition,
    webkitBorderBefore: webkitBorderBefore_export_definition,
    "webkit-border-before": webkitBorderBefore_export_definition,
    webkitBorderBeforeColor: webkitBorderBeforeColor_export_definition,
    "webkit-border-before-color": webkitBorderBeforeColor_export_definition,
    webkitBorderBeforeStyle: webkitBorderBeforeStyle_export_definition,
    "webkit-border-before-style": webkitBorderBeforeStyle_export_definition,
    webkitBorderBeforeWidth: webkitBorderBeforeWidth_export_definition,
    "webkit-border-before-width": webkitBorderBeforeWidth_export_definition,
    webkitBorderEnd: webkitBorderEnd_export_definition,
    "webkit-border-end": webkitBorderEnd_export_definition,
    webkitBorderEndColor: webkitBorderEndColor_export_definition,
    "webkit-border-end-color": webkitBorderEndColor_export_definition,
    webkitBorderEndStyle: webkitBorderEndStyle_export_definition,
    "webkit-border-end-style": webkitBorderEndStyle_export_definition,
    webkitBorderEndWidth: webkitBorderEndWidth_export_definition,
    "webkit-border-end-width": webkitBorderEndWidth_export_definition,
    webkitBorderFit: webkitBorderFit_export_definition,
    "webkit-border-fit": webkitBorderFit_export_definition,
    webkitBorderHorizontalSpacing: webkitBorderHorizontalSpacing_export_definition,
    "webkit-border-horizontal-spacing": webkitBorderHorizontalSpacing_export_definition,
    webkitBorderImage: webkitBorderImage_export_definition,
    "webkit-border-image": webkitBorderImage_export_definition,
    webkitBorderRadius: webkitBorderRadius_export_definition,
    "webkit-border-radius": webkitBorderRadius_export_definition,
    webkitBorderStart: webkitBorderStart_export_definition,
    "webkit-border-start": webkitBorderStart_export_definition,
    webkitBorderStartColor: webkitBorderStartColor_export_definition,
    "webkit-border-start-color": webkitBorderStartColor_export_definition,
    webkitBorderStartStyle: webkitBorderStartStyle_export_definition,
    "webkit-border-start-style": webkitBorderStartStyle_export_definition,
    webkitBorderStartWidth: webkitBorderStartWidth_export_definition,
    "webkit-border-start-width": webkitBorderStartWidth_export_definition,
    webkitBorderVerticalSpacing: webkitBorderVerticalSpacing_export_definition,
    "webkit-border-vertical-spacing": webkitBorderVerticalSpacing_export_definition,
    webkitBoxAlign: webkitBoxAlign_export_definition,
    "webkit-box-align": webkitBoxAlign_export_definition,
    webkitBoxDirection: webkitBoxDirection_export_definition,
    "webkit-box-direction": webkitBoxDirection_export_definition,
    webkitBoxFlex: webkitBoxFlex_export_definition,
    "webkit-box-flex": webkitBoxFlex_export_definition,
    webkitBoxFlexGroup: webkitBoxFlexGroup_export_definition,
    "webkit-box-flex-group": webkitBoxFlexGroup_export_definition,
    webkitBoxLines: webkitBoxLines_export_definition,
    "webkit-box-lines": webkitBoxLines_export_definition,
    webkitBoxOrdinalGroup: webkitBoxOrdinalGroup_export_definition,
    "webkit-box-ordinal-group": webkitBoxOrdinalGroup_export_definition,
    webkitBoxOrient: webkitBoxOrient_export_definition,
    "webkit-box-orient": webkitBoxOrient_export_definition,
    webkitBoxPack: webkitBoxPack_export_definition,
    "webkit-box-pack": webkitBoxPack_export_definition,
    webkitBoxReflect: webkitBoxReflect_export_definition,
    "webkit-box-reflect": webkitBoxReflect_export_definition,
    webkitBoxShadow: webkitBoxShadow_export_definition,
    "webkit-box-shadow": webkitBoxShadow_export_definition,
    webkitColorCorrection: webkitColorCorrection_export_definition,
    "webkit-color-correction": webkitColorCorrection_export_definition,
    webkitColumnAxis: webkitColumnAxis_export_definition,
    "webkit-column-axis": webkitColumnAxis_export_definition,
    webkitColumnBreakAfter: webkitColumnBreakAfter_export_definition,
    "webkit-column-break-after": webkitColumnBreakAfter_export_definition,
    webkitColumnBreakBefore: webkitColumnBreakBefore_export_definition,
    "webkit-column-break-before": webkitColumnBreakBefore_export_definition,
    webkitColumnBreakInside: webkitColumnBreakInside_export_definition,
    "webkit-column-break-inside": webkitColumnBreakInside_export_definition,
    webkitColumnCount: webkitColumnCount_export_definition,
    "webkit-column-count": webkitColumnCount_export_definition,
    webkitColumnGap: webkitColumnGap_export_definition,
    "webkit-column-gap": webkitColumnGap_export_definition,
    webkitColumnRule: webkitColumnRule_export_definition,
    "webkit-column-rule": webkitColumnRule_export_definition,
    webkitColumnRuleColor: webkitColumnRuleColor_export_definition,
    "webkit-column-rule-color": webkitColumnRuleColor_export_definition,
    webkitColumnRuleStyle: webkitColumnRuleStyle_export_definition,
    "webkit-column-rule-style": webkitColumnRuleStyle_export_definition,
    webkitColumnRuleWidth: webkitColumnRuleWidth_export_definition,
    "webkit-column-rule-width": webkitColumnRuleWidth_export_definition,
    webkitColumnSpan: webkitColumnSpan_export_definition,
    "webkit-column-span": webkitColumnSpan_export_definition,
    webkitColumnWidth: webkitColumnWidth_export_definition,
    "webkit-column-width": webkitColumnWidth_export_definition,
    webkitColumns: webkitColumns_export_definition,
    "webkit-columns": webkitColumns_export_definition,
    webkitFilter: webkitFilter_export_definition,
    "webkit-filter": webkitFilter_export_definition,
    webkitFlexAlign: webkitFlexAlign_export_definition,
    "webkit-flex-align": webkitFlexAlign_export_definition,
    webkitFlexDirection: webkitFlexDirection_export_definition,
    "webkit-flex-direction": webkitFlexDirection_export_definition,
    webkitFlexFlow: webkitFlexFlow_export_definition,
    "webkit-flex-flow": webkitFlexFlow_export_definition,
    webkitFlexItemAlign: webkitFlexItemAlign_export_definition,
    "webkit-flex-item-align": webkitFlexItemAlign_export_definition,
    webkitFlexLinePack: webkitFlexLinePack_export_definition,
    "webkit-flex-line-pack": webkitFlexLinePack_export_definition,
    webkitFlexOrder: webkitFlexOrder_export_definition,
    "webkit-flex-order": webkitFlexOrder_export_definition,
    webkitFlexPack: webkitFlexPack_export_definition,
    "webkit-flex-pack": webkitFlexPack_export_definition,
    webkitFlexWrap: webkitFlexWrap_export_definition,
    "webkit-flex-wrap": webkitFlexWrap_export_definition,
    webkitFlowFrom: webkitFlowFrom_export_definition,
    "webkit-flow-from": webkitFlowFrom_export_definition,
    webkitFlowInto: webkitFlowInto_export_definition,
    "webkit-flow-into": webkitFlowInto_export_definition,
    webkitFontFeatureSettings: webkitFontFeatureSettings_export_definition,
    "webkit-font-feature-settings": webkitFontFeatureSettings_export_definition,
    webkitFontKerning: webkitFontKerning_export_definition,
    "webkit-font-kerning": webkitFontKerning_export_definition,
    webkitFontSizeDelta: webkitFontSizeDelta_export_definition,
    "webkit-font-size-delta": webkitFontSizeDelta_export_definition,
    webkitFontSmoothing: webkitFontSmoothing_export_definition,
    "webkit-font-smoothing": webkitFontSmoothing_export_definition,
    webkitFontVariantLigatures: webkitFontVariantLigatures_export_definition,
    "webkit-font-variant-ligatures": webkitFontVariantLigatures_export_definition,
    webkitHighlight: webkitHighlight_export_definition,
    "webkit-highlight": webkitHighlight_export_definition,
    webkitHyphenateCharacter: webkitHyphenateCharacter_export_definition,
    "webkit-hyphenate-character": webkitHyphenateCharacter_export_definition,
    webkitHyphenateLimitAfter: webkitHyphenateLimitAfter_export_definition,
    "webkit-hyphenate-limit-after": webkitHyphenateLimitAfter_export_definition,
    webkitHyphenateLimitBefore: webkitHyphenateLimitBefore_export_definition,
    "webkit-hyphenate-limit-before": webkitHyphenateLimitBefore_export_definition,
    webkitHyphenateLimitLines: webkitHyphenateLimitLines_export_definition,
    "webkit-hyphenate-limit-lines": webkitHyphenateLimitLines_export_definition,
    webkitHyphens: webkitHyphens_export_definition,
    "webkit-hyphens": webkitHyphens_export_definition,
    webkitLineAlign: webkitLineAlign_export_definition,
    "webkit-line-align": webkitLineAlign_export_definition,
    webkitLineBoxContain: webkitLineBoxContain_export_definition,
    "webkit-line-box-contain": webkitLineBoxContain_export_definition,
    webkitLineBreak: webkitLineBreak_export_definition,
    "webkit-line-break": webkitLineBreak_export_definition,
    webkitLineClamp: webkitLineClamp_export_definition,
    "webkit-line-clamp": webkitLineClamp_export_definition,
    webkitLineGrid: webkitLineGrid_export_definition,
    "webkit-line-grid": webkitLineGrid_export_definition,
    webkitLineSnap: webkitLineSnap_export_definition,
    "webkit-line-snap": webkitLineSnap_export_definition,
    webkitLocale: webkitLocale_export_definition,
    "webkit-locale": webkitLocale_export_definition,
    webkitLogicalHeight: webkitLogicalHeight_export_definition,
    "webkit-logical-height": webkitLogicalHeight_export_definition,
    webkitLogicalWidth: webkitLogicalWidth_export_definition,
    "webkit-logical-width": webkitLogicalWidth_export_definition,
    webkitMarginAfter: webkitMarginAfter_export_definition,
    "webkit-margin-after": webkitMarginAfter_export_definition,
    webkitMarginAfterCollapse: webkitMarginAfterCollapse_export_definition,
    "webkit-margin-after-collapse": webkitMarginAfterCollapse_export_definition,
    webkitMarginBefore: webkitMarginBefore_export_definition,
    "webkit-margin-before": webkitMarginBefore_export_definition,
    webkitMarginBeforeCollapse: webkitMarginBeforeCollapse_export_definition,
    "webkit-margin-before-collapse": webkitMarginBeforeCollapse_export_definition,
    webkitMarginBottomCollapse: webkitMarginBottomCollapse_export_definition,
    "webkit-margin-bottom-collapse": webkitMarginBottomCollapse_export_definition,
    webkitMarginCollapse: webkitMarginCollapse_export_definition,
    "webkit-margin-collapse": webkitMarginCollapse_export_definition,
    webkitMarginEnd: webkitMarginEnd_export_definition,
    "webkit-margin-end": webkitMarginEnd_export_definition,
    webkitMarginStart: webkitMarginStart_export_definition,
    "webkit-margin-start": webkitMarginStart_export_definition,
    webkitMarginTopCollapse: webkitMarginTopCollapse_export_definition,
    "webkit-margin-top-collapse": webkitMarginTopCollapse_export_definition,
    webkitMarquee: webkitMarquee_export_definition,
    "webkit-marquee": webkitMarquee_export_definition,
    webkitMarqueeDirection: webkitMarqueeDirection_export_definition,
    "webkit-marquee-direction": webkitMarqueeDirection_export_definition,
    webkitMarqueeIncrement: webkitMarqueeIncrement_export_definition,
    "webkit-marquee-increment": webkitMarqueeIncrement_export_definition,
    webkitMarqueeRepetition: webkitMarqueeRepetition_export_definition,
    "webkit-marquee-repetition": webkitMarqueeRepetition_export_definition,
    webkitMarqueeSpeed: webkitMarqueeSpeed_export_definition,
    "webkit-marquee-speed": webkitMarqueeSpeed_export_definition,
    webkitMarqueeStyle: webkitMarqueeStyle_export_definition,
    "webkit-marquee-style": webkitMarqueeStyle_export_definition,
    webkitMask: webkitMask_export_definition,
    "webkit-mask": webkitMask_export_definition,
    webkitMaskAttachment: webkitMaskAttachment_export_definition,
    "webkit-mask-attachment": webkitMaskAttachment_export_definition,
    webkitMaskBoxImage: webkitMaskBoxImage_export_definition,
    "webkit-mask-box-image": webkitMaskBoxImage_export_definition,
    webkitMaskBoxImageOutset: webkitMaskBoxImageOutset_export_definition,
    "webkit-mask-box-image-outset": webkitMaskBoxImageOutset_export_definition,
    webkitMaskBoxImageRepeat: webkitMaskBoxImageRepeat_export_definition,
    "webkit-mask-box-image-repeat": webkitMaskBoxImageRepeat_export_definition,
    webkitMaskBoxImageSlice: webkitMaskBoxImageSlice_export_definition,
    "webkit-mask-box-image-slice": webkitMaskBoxImageSlice_export_definition,
    webkitMaskBoxImageSource: webkitMaskBoxImageSource_export_definition,
    "webkit-mask-box-image-source": webkitMaskBoxImageSource_export_definition,
    webkitMaskBoxImageWidth: webkitMaskBoxImageWidth_export_definition,
    "webkit-mask-box-image-width": webkitMaskBoxImageWidth_export_definition,
    webkitMaskClip: webkitMaskClip_export_definition,
    "webkit-mask-clip": webkitMaskClip_export_definition,
    webkitMaskComposite: webkitMaskComposite_export_definition,
    "webkit-mask-composite": webkitMaskComposite_export_definition,
    webkitMaskImage: webkitMaskImage_export_definition,
    "webkit-mask-image": webkitMaskImage_export_definition,
    webkitMaskOrigin: webkitMaskOrigin_export_definition,
    "webkit-mask-origin": webkitMaskOrigin_export_definition,
    webkitMaskPosition: webkitMaskPosition_export_definition,
    "webkit-mask-position": webkitMaskPosition_export_definition,
    webkitMaskPositionX: webkitMaskPositionX_export_definition,
    "webkit-mask-position-x": webkitMaskPositionX_export_definition,
    webkitMaskPositionY: webkitMaskPositionY_export_definition,
    "webkit-mask-position-y": webkitMaskPositionY_export_definition,
    webkitMaskRepeat: webkitMaskRepeat_export_definition,
    "webkit-mask-repeat": webkitMaskRepeat_export_definition,
    webkitMaskRepeatX: webkitMaskRepeatX_export_definition,
    "webkit-mask-repeat-x": webkitMaskRepeatX_export_definition,
    webkitMaskRepeatY: webkitMaskRepeatY_export_definition,
    "webkit-mask-repeat-y": webkitMaskRepeatY_export_definition,
    webkitMaskSize: webkitMaskSize_export_definition,
    "webkit-mask-size": webkitMaskSize_export_definition,
    webkitMatchNearestMailBlockquoteColor: webkitMatchNearestMailBlockquoteColor_export_definition,
    "webkit-match-nearest-mail-blockquote-color": webkitMatchNearestMailBlockquoteColor_export_definition,
    webkitMaxLogicalHeight: webkitMaxLogicalHeight_export_definition,
    "webkit-max-logical-height": webkitMaxLogicalHeight_export_definition,
    webkitMaxLogicalWidth: webkitMaxLogicalWidth_export_definition,
    "webkit-max-logical-width": webkitMaxLogicalWidth_export_definition,
    webkitMinLogicalHeight: webkitMinLogicalHeight_export_definition,
    "webkit-min-logical-height": webkitMinLogicalHeight_export_definition,
    webkitMinLogicalWidth: webkitMinLogicalWidth_export_definition,
    "webkit-min-logical-width": webkitMinLogicalWidth_export_definition,
    webkitNbspMode: webkitNbspMode_export_definition,
    "webkit-nbsp-mode": webkitNbspMode_export_definition,
    webkitOverflowScrolling: webkitOverflowScrolling_export_definition,
    "webkit-overflow-scrolling": webkitOverflowScrolling_export_definition,
    webkitPaddingAfter: webkitPaddingAfter_export_definition,
    "webkit-padding-after": webkitPaddingAfter_export_definition,
    webkitPaddingBefore: webkitPaddingBefore_export_definition,
    "webkit-padding-before": webkitPaddingBefore_export_definition,
    webkitPaddingEnd: webkitPaddingEnd_export_definition,
    "webkit-padding-end": webkitPaddingEnd_export_definition,
    webkitPaddingStart: webkitPaddingStart_export_definition,
    "webkit-padding-start": webkitPaddingStart_export_definition,
    webkitPerspective: webkitPerspective_export_definition,
    "webkit-perspective": webkitPerspective_export_definition,
    webkitPerspectiveOrigin: webkitPerspectiveOrigin_export_definition,
    "webkit-perspective-origin": webkitPerspectiveOrigin_export_definition,
    webkitPerspectiveOriginX: webkitPerspectiveOriginX_export_definition,
    "webkit-perspective-origin-x": webkitPerspectiveOriginX_export_definition,
    webkitPerspectiveOriginY: webkitPerspectiveOriginY_export_definition,
    "webkit-perspective-origin-y": webkitPerspectiveOriginY_export_definition,
    webkitPrintColorAdjust: webkitPrintColorAdjust_export_definition,
    "webkit-print-color-adjust": webkitPrintColorAdjust_export_definition,
    webkitRegionBreakAfter: webkitRegionBreakAfter_export_definition,
    "webkit-region-break-after": webkitRegionBreakAfter_export_definition,
    webkitRegionBreakBefore: webkitRegionBreakBefore_export_definition,
    "webkit-region-break-before": webkitRegionBreakBefore_export_definition,
    webkitRegionBreakInside: webkitRegionBreakInside_export_definition,
    "webkit-region-break-inside": webkitRegionBreakInside_export_definition,
    webkitRegionOverflow: webkitRegionOverflow_export_definition,
    "webkit-region-overflow": webkitRegionOverflow_export_definition,
    webkitRtlOrdering: webkitRtlOrdering_export_definition,
    "webkit-rtl-ordering": webkitRtlOrdering_export_definition,
    webkitSvgShadow: webkitSvgShadow_export_definition,
    "webkit-svg-shadow": webkitSvgShadow_export_definition,
    webkitTapHighlightColor: webkitTapHighlightColor_export_definition,
    "webkit-tap-highlight-color": webkitTapHighlightColor_export_definition,
    webkitTextCombine: webkitTextCombine_export_definition,
    "webkit-text-combine": webkitTextCombine_export_definition,
    webkitTextDecorationsInEffect: webkitTextDecorationsInEffect_export_definition,
    "webkit-text-decorations-in-effect": webkitTextDecorationsInEffect_export_definition,
    webkitTextEmphasis: webkitTextEmphasis_export_definition,
    "webkit-text-emphasis": webkitTextEmphasis_export_definition,
    webkitTextEmphasisColor: webkitTextEmphasisColor_export_definition,
    "webkit-text-emphasis-color": webkitTextEmphasisColor_export_definition,
    webkitTextEmphasisPosition: webkitTextEmphasisPosition_export_definition,
    "webkit-text-emphasis-position": webkitTextEmphasisPosition_export_definition,
    webkitTextEmphasisStyle: webkitTextEmphasisStyle_export_definition,
    "webkit-text-emphasis-style": webkitTextEmphasisStyle_export_definition,
    webkitTextFillColor: webkitTextFillColor_export_definition,
    "webkit-text-fill-color": webkitTextFillColor_export_definition,
    webkitTextOrientation: webkitTextOrientation_export_definition,
    "webkit-text-orientation": webkitTextOrientation_export_definition,
    webkitTextSecurity: webkitTextSecurity_export_definition,
    "webkit-text-security": webkitTextSecurity_export_definition,
    webkitTextSizeAdjust: webkitTextSizeAdjust_export_definition,
    "webkit-text-size-adjust": webkitTextSizeAdjust_export_definition,
    webkitTextStroke: webkitTextStroke_export_definition,
    "webkit-text-stroke": webkitTextStroke_export_definition,
    webkitTextStrokeColor: webkitTextStrokeColor_export_definition,
    "webkit-text-stroke-color": webkitTextStrokeColor_export_definition,
    webkitTextStrokeWidth: webkitTextStrokeWidth_export_definition,
    "webkit-text-stroke-width": webkitTextStrokeWidth_export_definition,
    webkitTransform: webkitTransform_export_definition,
    "webkit-transform": webkitTransform_export_definition,
    webkitTransformOrigin: webkitTransformOrigin_export_definition,
    "webkit-transform-origin": webkitTransformOrigin_export_definition,
    webkitTransformOriginX: webkitTransformOriginX_export_definition,
    "webkit-transform-origin-x": webkitTransformOriginX_export_definition,
    webkitTransformOriginY: webkitTransformOriginY_export_definition,
    "webkit-transform-origin-y": webkitTransformOriginY_export_definition,
    webkitTransformOriginZ: webkitTransformOriginZ_export_definition,
    "webkit-transform-origin-z": webkitTransformOriginZ_export_definition,
    webkitTransformStyle: webkitTransformStyle_export_definition,
    "webkit-transform-style": webkitTransformStyle_export_definition,
    webkitTransition: webkitTransition_export_definition,
    "webkit-transition": webkitTransition_export_definition,
    webkitTransitionDelay: webkitTransitionDelay_export_definition,
    "webkit-transition-delay": webkitTransitionDelay_export_definition,
    webkitTransitionDuration: webkitTransitionDuration_export_definition,
    "webkit-transition-duration": webkitTransitionDuration_export_definition,
    webkitTransitionProperty: webkitTransitionProperty_export_definition,
    "webkit-transition-property": webkitTransitionProperty_export_definition,
    webkitTransitionTimingFunction: webkitTransitionTimingFunction_export_definition,
    "webkit-transition-timing-function": webkitTransitionTimingFunction_export_definition,
    webkitUserDrag: webkitUserDrag_export_definition,
    "webkit-user-drag": webkitUserDrag_export_definition,
    webkitUserModify: webkitUserModify_export_definition,
    "webkit-user-modify": webkitUserModify_export_definition,
    webkitUserSelect: webkitUserSelect_export_definition,
    "webkit-user-select": webkitUserSelect_export_definition,
    webkitWrap: webkitWrap_export_definition,
    "webkit-wrap": webkitWrap_export_definition,
    webkitWrapFlow: webkitWrapFlow_export_definition,
    "webkit-wrap-flow": webkitWrapFlow_export_definition,
    webkitWrapMargin: webkitWrapMargin_export_definition,
    "webkit-wrap-margin": webkitWrapMargin_export_definition,
    webkitWrapPadding: webkitWrapPadding_export_definition,
    "webkit-wrap-padding": webkitWrapPadding_export_definition,
    webkitWrapShapeInside: webkitWrapShapeInside_export_definition,
    "webkit-wrap-shape-inside": webkitWrapShapeInside_export_definition,
    webkitWrapShapeOutside: webkitWrapShapeOutside_export_definition,
    "webkit-wrap-shape-outside": webkitWrapShapeOutside_export_definition,
    webkitWrapThrough: webkitWrapThrough_export_definition,
    "webkit-wrap-through": webkitWrapThrough_export_definition,
    webkitWritingMode: webkitWritingMode_export_definition,
    "webkit-writing-mode": webkitWritingMode_export_definition,
    whiteSpace: whiteSpace_export_definition,
    "white-space": whiteSpace_export_definition,
    widows: widows_export_definition,
    width: width_export_definition,
    wordBreak: wordBreak_export_definition,
    "word-break": wordBreak_export_definition,
    wordSpacing: wordSpacing_export_definition,
    "word-spacing": wordSpacing_export_definition,
    wordWrap: wordWrap_export_definition,
    "word-wrap": wordWrap_export_definition,
    writingMode: writingMode_export_definition,
    "writing-mode": writingMode_export_definition,
    zIndex: zIndex_export_definition,
    "z-index": zIndex_export_definition,
    zoom: zoom_export_definition
  });
};
