/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.WorkLocation;

public class ProductionInfo {
    private List<AbstractGoods> maximumProduction = new ArrayList<AbstractGoods>();
    private List<AbstractGoods> production = new ArrayList<AbstractGoods>();
    private List<AbstractGoods> maximumConsumption = new ArrayList<AbstractGoods>();
    private List<AbstractGoods> consumption = new ArrayList<AbstractGoods>();

    public final List<AbstractGoods> getConsumption() {
        return this.consumption;
    }

    public final void setConsumption(List<AbstractGoods> newConsumption) {
        this.consumption = newConsumption;
    }

    public void addConsumption(AbstractGoods goods) {
        this.consumption.add(goods);
    }

    public final List<AbstractGoods> getProduction() {
        return this.production;
    }

    public final void setProduction(List<AbstractGoods> newProduction) {
        this.production = newProduction;
    }

    public void addProduction(AbstractGoods goods) {
        this.production.add(goods);
    }

    public void addProduction(List<AbstractGoods> goods) {
        this.production.addAll(goods);
    }

    public final List<AbstractGoods> getMaximumProduction() {
        return this.maximumProduction;
    }

    public final void setMaximumProduction(List<AbstractGoods> newMaximumProduction) {
        this.maximumProduction = newMaximumProduction;
    }

    public void addMaximumProduction(AbstractGoods goods) {
        this.maximumProduction.add(goods);
    }

    public List<AbstractGoods> getProductionDeficit() {
        if (this.maximumProduction.isEmpty()) {
            return WorkLocation.EMPTY_LIST;
        }
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        for (AbstractGoods ag : this.production) {
            int amount;
            AbstractGoods agMax = AbstractGoods.findByType(ag.getType(), this.maximumProduction);
            if (agMax == null || (amount = agMax.getAmount() - ag.getAmount()) == 0) continue;
            result.add(new AbstractGoods(ag.getType(), amount));
        }
        return result;
    }

    public List<AbstractGoods> getConsumptionDeficit() {
        if (this.maximumConsumption.isEmpty()) {
            return WorkLocation.EMPTY_LIST;
        }
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        for (AbstractGoods ag : this.consumption) {
            int amount;
            AbstractGoods agMax = AbstractGoods.findByType(ag.getType(), this.maximumConsumption);
            if (agMax == null || (amount = agMax.getAmount() - ag.getAmount()) == 0) continue;
            result.add(new AbstractGoods(ag.getType(), amount));
        }
        return result;
    }

    public boolean hasMaximumProduction() {
        if (this.maximumProduction.isEmpty()) {
            return true;
        }
        for (int index = 0; index < this.production.size(); ++index) {
            if (this.maximumProduction.size() < index) {
                return true;
            }
            if (this.maximumProduction.get(index).getAmount() <= this.production.get(index).getAmount()) continue;
            return false;
        }
        return true;
    }

    public final List<AbstractGoods> getMaximumConsumption() {
        return this.maximumConsumption;
    }

    public final void setMaximumConsumption(List<AbstractGoods> newMaximumConsumption) {
        this.maximumConsumption = newMaximumConsumption;
    }

    public void addMaximumConsumption(AbstractGoods goods) {
        this.maximumConsumption.add(goods);
    }

    private void append(StringBuilder result, String key, List<AbstractGoods> list) {
        if (list.isEmpty()) {
            return;
        }
        result.append(key).append(": ");
        for (AbstractGoods goods : list) {
            result.append(goods);
            if (goods.getType().getStoredAs() != goods.getType()) {
                result.append(" [").append(goods.getType().getStoredAs().getId()).append("]");
            }
            result.append(", ");
        }
        int length = result.length();
        result.replace(length - 2, length, "\n");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.append(result, "Production", this.production);
        this.append(result, "Consumption", this.consumption);
        this.append(result, "Maximum Production", this.maximumProduction);
        this.append(result, "Maximum Consumption", this.maximumConsumption);
        return result.toString();
    }
}

