/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.timeout;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.RegexpOptions;

public class Timeout
implements Library {
    private static ScheduledExecutorService timeoutExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new DaemonThreadFactory());

    @Override
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        RubyModule timeout2 = runtime2.defineModule("Timeout");
        RubyClass RuntimeError2 = runtime2.getRuntimeError();
        RubyClass TimeoutError = runtime2.defineClassUnder("Error", RuntimeError2, RuntimeError2.getAllocator(), timeout2);
        timeout2.defineConstant("ExitException", TimeoutError);
        RubyClass anonException = runtime2.defineClassUnder("AnonymousException", runtime2.getException(), runtime2.getException().getAllocator(), timeout2);
        anonException.setBaseName(null);
        timeout2.defineConstant("THIS_FILE", RubyRegexp.newRegexp(runtime2, "timeout\\.rb", new RegexpOptions()));
        timeout2.defineConstant("CALLER_OFFSET", RubyFixnum.newFixnum(runtime2, 0L));
        timeout2.defineAnnotatedMethods(Timeout.class);
        runtime2.getObject().defineConstant("TimeoutError", TimeoutError);
        runtime2.getObject().deprecateConstant(runtime2, "TimeoutError");
        runtime2.getObject().defineAnnotatedMethods(TimeoutToplevel.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, Block block) {
        return Timeout.timeout(context, recv2, seconds, context.nil, block);
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, IRubyObject exceptionType, Block block) {
        return Timeout.timeout(context, recv2, seconds, exceptionType, RubyString.newString(context.runtime, "execution expired"), block);
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, IRubyObject exceptionType, IRubyObject message2, Block block) {
        RubyModule timeout2 = context.runtime.getModule("Timeout");
        if (Timeout.nilOrZeroSeconds(context, seconds)) {
            return block.yieldSpecific(context);
        }
        Ruby runtime2 = context.runtime;
        if (runtime2.getThreadService().getCritical()) {
            return Timeout.raiseBecauseCritical(context);
        }
        RubyThread currentThread = context.getThread();
        AtomicBoolean latch = new AtomicBoolean(false);
        RubyObject id2 = new RubyObject(runtime2, runtime2.getObject());
        TimeoutTask timeoutRunnable = exceptionType.isNil() ? TimeoutTask.newAnonymousTask(currentThread, timeout2, latch, id2, message2.convertToString()) : TimeoutTask.newTaskWithException(currentThread, timeout2, latch, exceptionType, message2.convertToString());
        try {
            return Timeout.yieldWithTimeout(context, seconds, block, timeoutRunnable, latch);
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == Timeout.getAnonymousException(timeout2) && exceptionType.isNil()) {
                Timeout.raiseTimeoutErrorIfMatches(context, timeout2, re, id2);
            }
            throw re;
        }
    }

    private static boolean nilOrZeroSeconds(ThreadContext context, IRubyObject seconds) {
        return seconds.isNil() || Helpers.invoke(context, seconds, "zero?").isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject yieldWithTimeout(ThreadContext context, IRubyObject seconds, Block block, Runnable runnable, AtomicBoolean latch) throws RaiseException {
        long micros = (long)(RubyTime.convertTimeInterval(context, seconds) * 1000000.0);
        ScheduledFuture<?> timeoutFuture = null;
        try {
            timeoutFuture = timeoutExecutor.schedule(runnable, micros, TimeUnit.MICROSECONDS);
            IRubyObject iRubyObject = block.yield(context, seconds);
            return iRubyObject;
        }
        finally {
            if (timeoutFuture != null) {
                Timeout.killTimeoutThread(context, timeoutFuture, latch);
            }
        }
    }

    private static void killTimeoutThread(ThreadContext context, Future timeoutFuture, AtomicBoolean latch) {
        if (latch.compareAndSet(false, true) && timeoutFuture.cancel(false)) {
            if (timeoutExecutor instanceof ScheduledThreadPoolExecutor && timeoutFuture instanceof Runnable) {
                ((ScheduledThreadPoolExecutor)timeoutExecutor).remove((Runnable)((Object)timeoutFuture));
            }
        } else {
            try {
                timeoutFuture.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            context.pollThreadEvents();
        }
    }

    private static IRubyObject raiseBecauseCritical(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return RubyKernel.raise(context, runtime2.getKernel(), new IRubyObject[]{runtime2.getThreadError(), runtime2.newString("timeout within critical section")}, Block.NULL_BLOCK);
    }

    private static IRubyObject raiseTimeoutErrorIfMatches(ThreadContext context, IRubyObject timeout2, RaiseException ex, IRubyObject id2) {
        if (ex.getException().getInternalVariable("__identifier__") == id2) {
            RubyException rubyException = ex.getException();
            return RubyKernel.raise(context, context.runtime.getKernel(), new IRubyObject[]{Timeout.getClassFrom(timeout2, "Error"), rubyException.callMethod(context, "message"), rubyException.callMethod(context, "backtrace")}, Block.NULL_BLOCK);
        }
        return null;
    }

    private static RubyClass getAnonymousException(IRubyObject timeout2) {
        return Timeout.getClassFrom(timeout2, "AnonymousException");
    }

    private static RubyClass getClassFrom(IRubyObject timeout2, String name2) {
        return ((RubyModule)timeout2).getClass(name2);
    }

    private static JavaSites.TimeoutSites sites(ThreadContext context) {
        return context.sites.Timeout;
    }

    private static class TimeoutTask
    implements Runnable {
        final RubyThread currentThread;
        final AtomicBoolean latch;
        final IRubyObject timeout;
        final IRubyObject id;
        final IRubyObject exception;
        final RubyString message;

        private TimeoutTask(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject id2, IRubyObject exception2, RubyString message2) {
            this.currentThread = currentThread;
            this.timeout = timeout2;
            this.latch = latch;
            this.id = id2;
            this.exception = exception2;
            this.message = message2;
        }

        static TimeoutTask newAnonymousTask(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject id2, RubyString message2) {
            return new TimeoutTask(currentThread, timeout2, latch, id2, null, message2);
        }

        static TimeoutTask newTaskWithException(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject exception2, RubyString message2) {
            return new TimeoutTask(currentThread, timeout2, latch, null, exception2, message2);
        }

        @Override
        public void run() {
            if (this.latch.compareAndSet(false, true)) {
                if (this.exception == null) {
                    this.raiseAnonymous();
                } else {
                    this.raiseException();
                }
            }
        }

        private void raiseAnonymous() {
            Ruby runtime2 = this.timeout.getRuntime();
            IRubyObject anonException = Timeout.getAnonymousException(this.timeout).newInstance(runtime2.getCurrentContext(), this.message, Block.NULL_BLOCK);
            anonException.getInternalVariables().setInternalVariable("__identifier__", this.id);
            this.currentThread.raise(anonException);
        }

        private void raiseException() {
            Ruby runtime2 = this.timeout.getRuntime();
            this.currentThread.raise(this.exception, this.message);
        }
    }

    public static class TimeoutToplevel {
        @JRubyMethod(visibility=Visibility.PRIVATE)
        public static IRubyObject timeout(ThreadContext context, IRubyObject self2, IRubyObject seconds, Block block) {
            TimeoutToplevel.warnToplevel(context);
            return Timeout.sites((ThreadContext)context).timeout.call(context, self2, (IRubyObject)context.runtime.getModule("Timeout"), seconds, block);
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public static IRubyObject timeout(ThreadContext context, IRubyObject self2, IRubyObject seconds, IRubyObject exceptionType, Block block) {
            TimeoutToplevel.warnToplevel(context);
            return Timeout.sites((ThreadContext)context).timeout.call(context, self2, (IRubyObject)context.runtime.getModule("Timeout"), seconds, exceptionType, block);
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public static IRubyObject timeout(ThreadContext context, IRubyObject self2, IRubyObject seconds, IRubyObject exceptionType, IRubyObject message2, Block block) {
            TimeoutToplevel.warnToplevel(context);
            return Timeout.sites((ThreadContext)context).timeout.call(context, self2, (IRubyObject)context.runtime.getModule("Timeout"), seconds, exceptionType, message2, block);
        }

        private static void warnToplevel(ThreadContext context) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#timeout is deprecated, use Timeout.timeout instead");
        }
    }
}

