/*!
 * Copyright 2014 The Rust Project Developers. See the COPYRIGHT
 * file at the top-level directory of this distribution and at
 * http://rust-lang.org/COPYRIGHT.
 *
 * Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
 * http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
 * <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
 * option. This file may not be copied, modified, or distributed
 * except according to those terms.
 */(function(){"use strict";var itemTypes=["mod","externcrate","import","struct","enum","fn","type","static","trait","impl","tymethod","method","structfield","variant","macro","primitive","associatedtype","constant","associatedconstant","union","foreigntype","keyword"];var search_input=document.getElementsByClassName('search-input')[0];var currentTab=0;var themesWidth=null;if(!String.prototype.startsWith){String.prototype.startsWith=function(searchString,position){position=position||0;return this.indexOf(searchString,position)===position;};}if(!String.prototype.endsWith){String.prototype.endsWith=function(suffix,length){var l=length||this.length;return this.indexOf(suffix,l-suffix.length)!==-1;};}function getPageId(){var id=document.location.href.split('#')[1];if(id){return id.split('?')[0].split('&')[0];}return null;}function hasClass(elem,className){if(elem&&className&&elem.className){var elemClass=elem.className;var start=elemClass.indexOf(className);if(start===-1){return false;}else if(elemClass.length===className.length){return true;}else{if(start>0&&elemClass[start-1]!==' '){return false;}var end=start+className.length;return!(end<elemClass.length&&elemClass[end]!==' ');}if(start>0&&elemClass[start-1]!==' '){return false;}var end=start+className.length;return!(end<elemClass.length&&elemClass[end]!==' ');}return false;}function addClass(elem,className){if(elem&&className&&!hasClass(elem,className)){if(elem.className&&elem.className.length>0){elem.className+=' '+className;}else{elem.className=className;}}}function removeClass(elem,className){if(elem&&className&&elem.className){elem.className=(" "+elem.className+" ").replace(" "+className+" "," ").trim();}}function isHidden(elem){return(elem.offsetParent===null)}function showSidebar(){var elems=document.getElementsByClassName("sidebar-elems")[0];if(elems){addClass(elems,"show-it");}var sidebar=document.getElementsByClassName('sidebar')[0];if(sidebar){addClass(sidebar,'mobile');var filler=document.getElementById("sidebar-filler");if(!filler){var div=document.createElement("div");div.id="sidebar-filler";sidebar.appendChild(div);}}var themePicker=document.getElementsByClassName("theme-picker");if(themePicker&&themePicker.length>0){themePicker[0].style.display="none";}}function hideSidebar(){var elems=document.getElementsByClassName("sidebar-elems")[0];if(elems){removeClass(elems,"show-it");}var sidebar=document.getElementsByClassName('sidebar')[0];removeClass(sidebar,'mobile');var filler=document.getElementById("sidebar-filler");if(filler){filler.remove();}document.getElementsByTagName("body")[0].style.marginTop='';var themePicker=document.getElementsByClassName("theme-picker");if(themePicker&&themePicker.length>0){themePicker[0].style.display=null;}}var TY_PRIMITIVE=itemTypes.indexOf("primitive");var TY_KEYWORD=itemTypes.indexOf("keyword");onEach(document.getElementsByClassName('js-only'),function(e){removeClass(e,'js-only');});function getQueryStringParams(){var params={};window.location.search.substring(1).split("&").map(function(s){var pair=s.split("=");params[decodeURIComponent(pair[0])]=typeof pair[1]==="undefined"?null:decodeURIComponent(pair[1]);});return params;}function browserSupportsHistoryApi(){return document.location.protocol!="file:"&&window.history&&typeof window.history.pushState==="function";}function highlightSourceLines(ev){hideSidebar();var search=document.getElementById("search");var i,from,to,match=window.location.hash.match(/^#?(\d+)(?:-(\d+))?$/);if(match){from=parseInt(match[1],10);to=Math.min(50000,parseInt(match[2]||match[1],10));from=Math.min(from,to);var elem=document.getElementById(from);if(!elem){return;}if(ev===null){var x=document.getElementById(from);if(x){x.scrollIntoView();}}onEach(document.getElementsByClassName('line-numbers'),function(e){onEach(e.getElementsByTagName('span'),function(i_e){removeClass(i_e,'line-highlighted');});});for(i=from;i<=to;++i){addClass(document.getElementById(i),'line-highlighted');}}else if(ev!==null&&search&&!hasClass(search,"hidden")&&ev.newURL){addClass(search,"hidden");removeClass(document.getElementById("main"),"hidden");var hash=ev.newURL.slice(ev.newURL.indexOf('#')+1);if(browserSupportsHistoryApi()){history.replaceState(hash,"","?search=#"+hash);}var elem=document.getElementById(hash);if(elem){elem.scrollIntoView();}}}highlightSourceLines(null);window.onhashchange=highlightSourceLines;function getVirtualKey(ev){if("key"in ev&&typeof ev.key!="undefined")return ev.key;var c=ev.charCode||ev.keyCode;if(c==27)return"Escape";return String.fromCharCode(c);}function displayHelp(display,ev){if(display===true){if(hasClass(help,"hidden")){ev.preventDefault();removeClass(help,"hidden");addClass(document.body,"blur");}}else if(!hasClass(help,"hidden")){ev.preventDefault();addClass(help,"hidden");removeClass(document.body,"blur");}}function handleEscape(ev,help){hideModal();var search=document.getElementById("search");if(!hasClass(help,"hidden")){displayHelp(false,ev);}else if(!hasClass(search,"hidden")){ev.preventDefault();addClass(search,"hidden");removeClass(document.getElementById("main"),"hidden");}defocusSearchBar();}function handleShortcut(ev){if(ev.ctrlKey||ev.altKey||ev.metaKey){return;}var help=document.getElementById("help");if(document.activeElement.tagName==="INPUT"){switch(getVirtualKey(ev)){case"Escape":handleEscape(ev,help);break;}}else{switch(getVirtualKey(ev)){case"Escape":handleEscape(ev,help);break;case"s":case"S":displayHelp(false,ev);hideModal();ev.preventDefault();focusSearchBar();break;case"+":case"-":ev.preventDefault();toggleAllDocs();break;case"?":if(ev.shiftKey){hideModal();displayHelp(true,ev);}break;}}}document.onkeypress=handleShortcut;document.onkeydown=handleShortcut;document.onclick=function(ev){if(hasClass(ev.target,'collapse-toggle')){collapseDocs(ev.target,"toggle");}else if(hasClass(ev.target.parentNode,'collapse-toggle')){collapseDocs(ev.target.parentNode,"toggle");}else if(ev.target.tagName==='SPAN'&&hasClass(ev.target.parentNode,'line-numbers')){var prev_id=0;var set_fragment=function(name){if(browserSupportsHistoryApi()){history.replaceState(null,null,'#'+name);window.hashchange();}else{location.replace('#'+name);}};var cur_id=parseInt(ev.target.id,10);if(ev.shiftKey&&prev_id){if(prev_id>cur_id){var tmp=prev_id;prev_id=cur_id;cur_id=tmp;}set_fragment(prev_id+'-'+cur_id);}else{prev_id=cur_id;set_fragment(cur_id);}}else if(!hasClass(document.getElementById("help"),"hidden")){addClass(document.getElementById("help"),"hidden");removeClass(document.body,"blur");}};var x=document.getElementsByClassName('version-selector');if(x.length>0){x[0].onchange=function(){var i,match,url=document.location.href,stripped='',len=rootPath.match(/\.\.\//g).length+1;for(i=0;i<len;++i){match=url.match(/\/[^\/]*$/);if(i<len-1){stripped=match[0]+stripped;}url=url.substring(0,url.length-match[0].length);}url+='/'+document.getElementsByClassName('version-selector')[0].value+stripped;document.location.href=url;};}var levenshtein_row2=[];function levenshtein(s1,s2){if(s1===s2){return 0;}var s1_len=s1.length,s2_len=s2.length;if(s1_len&&s2_len){var i1=0,i2=0,a,b,c,c2,row=levenshtein_row2;while(i1<s1_len){row[i1]=++i1;}while(i2<s2_len){c2=s2.charCodeAt(i2);a=i2;++i2;b=i2;for(i1=0;i1<s1_len;++i1){c=a+(s1.charCodeAt(i1)!==c2?1:0);a=row[i1];b=b<a?(b<c?b+1:c):(a<c?a+1:c);row[i1]=b;}}return b;}return s1_len+s2_len;}function initSearch(rawSearchIndex){var currentResults,index,searchIndex;var MAX_LEV_DISTANCE=3;var MAX_RESULTS=200;var params=getQueryStringParams();if(search_input.value===""){search_input.value=params.search||'';}function execQuery(query,searchWords){function itemTypeFromName(typename){for(var i=0;i<itemTypes.length;++i){if(itemTypes[i]===typename){return i;}}return-1;}var valLower=query.query.toLowerCase(),val=valLower,typeFilter=itemTypeFromName(query.type),results={},results_in_args={},results_returned={},split=valLower.split("::");for(var z=0;z<split.length;++z){if(split[z]===""){split.splice(z,1);z-=1;}}function transformResults(results,isType){var out=[];for(i=0;i<results.length;++i){if(results[i].id>-1){var obj=searchIndex[results[i].id];obj.lev=results[i].lev;if(isType!==true||obj.type){var res=buildHrefAndPath(obj);obj.displayPath=pathSplitter(res[0]);obj.fullPath=obj.displayPath+obj.name;obj.fullPath+='|'+obj.ty;obj.href=res[1];out.push(obj);if(out.length>=MAX_RESULTS){break;}}}}return out;}function sortResults(results,isType){var ar=[];for(var entry in results){if(results.hasOwnProperty(entry)){ar.push(results[entry]);}}results=ar;var nresults=results.length;for(var i=0;i<nresults;++i){results[i].word=searchWords[results[i].id];results[i].item=searchIndex[results[i].id]||{};}if(results.length===0){return[];}results.sort(function(aaa,bbb){var a,b;a=(aaa.lev);b=(bbb.lev);if(a!==b){return a-b;}a=(aaa.item.crate!==window.currentCrate);b=(bbb.item.crate!==window.currentCrate);if(a!==b){return a-b;}a=(aaa.word!==valLower);b=(bbb.word!==valLower);if(a!==b){return a-b;}a=aaa.word.length;b=bbb.word.length;if(a!==b){return a-b;}a=aaa.word;b=bbb.word;if(a!==b){return(a>b?+1:-1);}a=(aaa.index<0);b=(bbb.index<0);if(a!==b){return a-b;}a=aaa.index;b=bbb.index;if(a!==b){return a-b;}if((aaa.item.ty===TY_PRIMITIVE&&bbb.item.ty!==TY_KEYWORD)||(aaa.item.ty===TY_KEYWORD&&bbb.item.ty!==TY_PRIMITIVE)){return-1;}if((bbb.item.ty===TY_PRIMITIVE&&aaa.item.ty!==TY_PRIMITIVE)||(bbb.item.ty===TY_KEYWORD&&aaa.item.ty!==TY_KEYWORD)){return 1;}a=(aaa.item.desc==='');b=(bbb.item.desc==='');if(a!==b){return a-b;}a=aaa.item.ty;b=bbb.item.ty;if(a!==b){return a-b;}a=aaa.item.path;b=bbb.item.path;if(a!==b){return(a>b?+1:-1);}return 0;});for(var i=0;i<results.length;++i){var result=results[i];if(result.dontValidate){continue;}var name=result.item.name.toLowerCase(),path=result.item.path.toLowerCase(),parent=result.item.parent;if(isType!==true&&validateResult(name,path,split,parent)===false){result.id=-1;}}return transformResults(results);}function extractGenerics(val){val=val.toLowerCase();if(val.indexOf('<')!==-1){var values=val.substring(val.indexOf('<')+1,val.lastIndexOf('>'));return{name:val.substring(0,val.indexOf('<')),generics:values.split(/\s*,\s*/),};}return{name:val,generics:[],};}function checkGenerics(obj,val){var lev_distance=MAX_LEV_DISTANCE+1;if(val.generics.length>0){if(obj.g&&obj.g.length>=val.generics.length){var elems=obj.g.slice(0);var total=0;var done=0;for(var y=0;y<val.generics.length;++y){var lev={pos:-1,lev:MAX_LEV_DISTANCE+1};for(var x=0;x<elems.length;++x){var tmp_lev=levenshtein(elems[x],val.generics[y]);if(tmp_lev<lev.lev){lev.lev=tmp_lev;lev.pos=x;}}if(lev.pos!==-1){elems.splice(lev.pos,1);lev_distance=Math.min(lev.lev,lev_distance);total+=lev.lev;done+=1;}else{return MAX_LEV_DISTANCE+1;}}return lev_distance;}}return MAX_LEV_DISTANCE+1;}function checkType(obj,val,literalSearch){var lev_distance=MAX_LEV_DISTANCE+1;if(obj.n===val.name){if(literalSearch===true){if(val.generics&&val.generics.length!==0){if(obj.g&&obj.length>=val.generics.length){var elems=obj.g.slice(0);var allFound=true;var x;for(var y=0;allFound===true&&y<val.generics.length;++y){allFound=false;for(x=0;allFound===false&&x<elems.length;++x){allFound=elems[x]===val.generics[y];}if(allFound===true){elems.splice(x-1,1);}}if(allFound===true){return true;}}else{return false;}}return true;}if(obj.g&&obj.g.length!==0){var tmp_lev=checkGenerics(obj,val);if(tmp_lev<=MAX_LEV_DISTANCE){return tmp_lev;}}else{return 0;}}if(literalSearch===true){if(obj.g&&obj.g.length>0){for(var x=0;x<obj.g.length;++x){if(obj.g[x]===val.name){return true;}}}return false;}var lev_distance=Math.min(levenshtein(obj.n,val.name),lev_distance);if(lev_distance<=MAX_LEV_DISTANCE){lev_distance=Math.min(checkGenerics(obj,val),lev_distance);}else if(obj.g&&obj.g.length>0){for(var x=0;x<obj.g.length;++x){lev_distance=Math.min(levenshtein(obj.g[x],val.name),lev_distance);}}return lev_distance+1;}function findArg(obj,val,literalSearch){var lev_distance=MAX_LEV_DISTANCE+1;if(obj&&obj.type&&obj.type.i&&obj.type.i.length>0){for(var i=0;i<obj.type.i.length;i++){var tmp=checkType(obj.type.i[i],val,literalSearch);if(literalSearch===true&&tmp===true){return true;}lev_distance=Math.min(tmp,lev_distance);if(lev_distance===0){return 0;}}}return literalSearch===true?false:lev_distance;}function checkReturned(obj,val,literalSearch){var lev_distance=MAX_LEV_DISTANCE+1;if(obj&&obj.type&&obj.type.o){var tmp=checkType(obj.type.o,val,literalSearch);if(literalSearch===true&&tmp===true){return true;}lev_distance=Math.min(tmp,lev_distance);if(lev_distance===0){return 0;}}return literalSearch===true?false:lev_distance;}function checkPath(startsWith,lastElem,ty){if(startsWith.length===0){return 0;}var ret_lev=MAX_LEV_DISTANCE+1;var path=ty.path.split("::");if(ty.parent&&ty.parent.name){path.push(ty.parent.name.toLowerCase());}if(startsWith.length>path.length){return MAX_LEV_DISTANCE+1;}for(var i=0;i<path.length;++i){if(i+startsWith.length>path.length){break;}var lev_total=0;var aborted=false;for(var x=0;x<startsWith.length;++x){var lev=levenshtein(path[i+x],startsWith[x]);if(lev>MAX_LEV_DISTANCE){aborted=true;break;}lev_total+=lev;}if(aborted===false){ret_lev=Math.min(ret_lev,Math.round(lev_total/startsWith.length));}}return ret_lev;}function typePassesFilter(filter,type){if(filter<0)return true;if(filter===type)return true;var name=itemTypes[type];switch(itemTypes[filter]){case"constant":return(name=="associatedconstant");case"fn":return(name=="method"||name=="tymethod");case"type":return(name=="primitive"||name=="keyword");}return false;}function generateId(ty){if(ty.parent&&ty.parent.name){return itemTypes[ty.ty]+ty.path+ty.parent.name+ty.name;}return itemTypes[ty.ty]+ty.path+ty.name;}var nSearchWords=searchWords.length;if((val.charAt(0)==="\""||val.charAt(0)==="'")&&val.charAt(val.length-1)===val.charAt(0)){val=extractGenerics(val.substr(1,val.length-2));for(var i=0;i<nSearchWords;++i){var in_args=findArg(searchIndex[i],val,true);var returned=checkReturned(searchIndex[i],val,true);var ty=searchIndex[i];var fullId=generateId(ty);if(searchWords[i]===val.name){if(typePassesFilter(typeFilter,searchIndex[i].ty)&&results[fullId]===undefined){results[fullId]={id:i,index:-1};}}else if((in_args===true||returned===true)&&typePassesFilter(typeFilter,searchIndex[i].ty)){if(in_args===true||returned===true){if(in_args===true){results_in_args[fullId]={id:i,index:-1,dontValidate:true,};}if(returned===true){results_returned[fullId]={id:i,index:-1,dontValidate:true,};}}else{results[fullId]={id:i,index:-1,dontValidate:true,};}}}query.inputs=[val];query.output=val;query.search=val;}else if(val.search("->")>-1){var trimmer=function(s){return s.trim();};var parts=val.split("->").map(trimmer);var input=parts[0];var inputs=input.split(",").map(trimmer).sort();for(var i=0;i<inputs.length;++i){inputs[i]=extractGenerics(inputs[i]);}var output=extractGenerics(parts[1]);for(var i=0;i<nSearchWords;++i){var type=searchIndex[i].type;var ty=searchIndex[i];if(!type){continue;}var fullId=generateId(ty);var typeOutput=type.o?type.o.name:"";var returned=checkReturned(ty,output,true);if(output.name==="*"||returned===true){var in_args=false;var module=false;if(input==="*"){module=true;}else{var allFound=true;for(var it=0;allFound===true&&it<inputs.length;it++){allFound=checkType(type,inputs[it],true);}in_args=allFound;}if(in_args===true){results_in_args[fullId]={id:i,index:-1,dontValidate:true,};}if(returned===true){results_returned[fullId]={id:i,index:-1,dontValidate:true,};}if(module===true){results[fullId]={id:i,index:-1,dontValidate:true,};}}}query.inputs=inputs.map(function(input){return input.name;});query.output=output.name;}else{query.inputs=[val];query.output=val;query.search=val;val=val.replace(/\_/g,"");var valGenerics=extractGenerics(val);var paths=valLower.split("::");var j;for(j=0;j<paths.length;++j){if(paths[j]===""){paths.splice(j,1);j-=1;}}val=paths[paths.length-1];var startsWith=paths.slice(0,paths.length>1?paths.length-1:1);for(j=0;j<nSearchWords;++j){var lev_distance;var ty=searchIndex[j];if(!ty){continue;}var lev_add=0;if(paths.length>1){var lev=checkPath(startsWith,paths[paths.length-1],ty);if(lev>MAX_LEV_DISTANCE){continue;}else if(lev>0){lev_add=1;}}var returned=MAX_LEV_DISTANCE+1;var in_args=MAX_LEV_DISTANCE+1;var index=-1;var lev=MAX_LEV_DISTANCE+1;var fullId=generateId(ty);if(searchWords[j].indexOf(split[i])>-1||searchWords[j].indexOf(val)>-1||searchWords[j].replace(/_/g,"").indexOf(val)>-1){if(typePassesFilter(typeFilter,ty.ty)&&results[fullId]===undefined){index=searchWords[j].replace(/_/g,"").indexOf(val);}}if((lev=levenshtein(searchWords[j],val))<=MAX_LEV_DISTANCE){if(typePassesFilter(typeFilter,ty.ty)===false){lev=MAX_LEV_DISTANCE+1;}else{lev+=1;}}if((in_args=findArg(ty,valGenerics))<=MAX_LEV_DISTANCE){if(typePassesFilter(typeFilter,ty.ty)===false){in_args=MAX_LEV_DISTANCE+1;}}if((returned=checkReturned(ty,valGenerics))<=MAX_LEV_DISTANCE){if(typePassesFilter(typeFilter,ty.ty)===false){returned=MAX_LEV_DISTANCE+1;}}lev+=lev_add;if(lev>0&&val.length>3&&searchWords[j].startsWith(val)){if(val.length<6){lev-=1;}else{lev=0;}}if(in_args<=MAX_LEV_DISTANCE){if(results_in_args[fullId]===undefined){results_in_args[fullId]={id:j,index:index,lev:in_args,};}results_in_args[fullId].lev=Math.min(results_in_args[fullId].lev,in_args);}if(returned<=MAX_LEV_DISTANCE){if(results_returned[fullId]===undefined){results_returned[fullId]={id:j,index:index,lev:returned,};}results_returned[fullId].lev=Math.min(results_returned[fullId].lev,returned);}if(index!==-1||lev<=MAX_LEV_DISTANCE){if(index!==-1&&paths.length<2){lev=0;}if(results[fullId]===undefined){results[fullId]={id:j,index:index,lev:lev,};}results[fullId].lev=Math.min(results[fullId].lev,lev);}}}var ret={'in_args':sortResults(results_in_args,true),'returned':sortResults(results_returned,true),'others':sortResults(results),};if(ALIASES&&ALIASES[window.currentCrate]&&ALIASES[window.currentCrate][query.raw]){var aliases=ALIASES[window.currentCrate][query.raw];for(var i=0;i<aliases.length;++i){aliases[i].is_alias=true;aliases[i].alias=query.raw;aliases[i].path=aliases[i].p;var res=buildHrefAndPath(aliases[i]);aliases[i].displayPath=pathSplitter(res[0]);aliases[i].fullPath=aliases[i].displayPath+aliases[i].name;aliases[i].href=res[1];ret['others'].unshift(aliases[i]);if(ret['others'].length>MAX_RESULTS){ret['others'].pop();}}}return ret;}function validateResult(name,path,keys,parent){for(var i=0;i<keys.length;++i){if(!(name.indexOf(keys[i])>-1||path.indexOf(keys[i])>-1||(parent!==undefined&&parent.name.toLowerCase().indexOf(keys[i])>-1)||levenshtein(name,keys[i])<=MAX_LEV_DISTANCE)){return false;}}return true;}function getQuery(raw){var matches,type,query;query=raw;matches=query.match(/^(fn|mod|struct|enum|trait|type|const|macro)\s*:\s*/i);if(matches){type=matches[1].replace(/^const$/,'constant');query=query.substring(matches[0].length);}return{raw:raw,query:query,type:type,id:query+type};}function initSearchNav(){var hoverTimeout;var click_func=function(e){var el=e.target;while(el.tagName!=='TR'){el=el.parentNode;}var dst=e.target.getElementsByTagName('a');if(dst.length<1){return;}dst=dst[0];if(window.location.pathname===dst.pathname){addClass(document.getElementById('search'),'hidden');removeClass(document.getElementById('main'),'hidden');document.location.href=dst.href;}};var mouseover_func=function(e){var el=e.target;while(el.tagName!=='TR'){el=el.parentNode;}clearTimeout(hoverTimeout);hoverTimeout=setTimeout(function(){onEach(document.getElementsByClassName('search-results'),function(e){onEach(e.getElementsByClassName('result'),function(i_e){removeClass(i_e,'highlighted');});});addClass(el,'highlighted');},20);};onEach(document.getElementsByClassName('search-results'),function(e){onEach(e.getElementsByClassName('result'),function(i_e){i_e.onclick=click_func;i_e.onmouseover=mouseover_func;});});search_input.onkeydown=function(e){var actives=[[],[],[]];var current=0;onEach(document.getElementsByClassName('search-results'),function(e){onEach(e.getElementsByClassName('highlighted'),function(e){actives[current].push(e);});current+=1;});if(e.which===38){if(!actives[currentTab].length||!actives[currentTab][0].previousElementSibling){return;}addClass(actives[currentTab][0].previousElementSibling,'highlighted');removeClass(actives[currentTab][0],'highlighted');}else if(e.which===40){if(!actives[currentTab].length){var results=document.getElementsByClassName('search-results');if(results.length>0){var res=results[currentTab].getElementsByClassName('result');if(res.length>0){addClass(res[0],'highlighted');}}}else if(actives[currentTab][0].nextElementSibling){addClass(actives[currentTab][0].nextElementSibling,'highlighted');removeClass(actives[currentTab][0],'highlighted');}}else if(e.which===13){if(actives[currentTab].length){document.location.href=actives[currentTab][0].getElementsByTagName('a')[0].href;}}else if(e.which===9){if(e.shiftKey){printTab(currentTab>0?currentTab-1:2);}else{printTab(currentTab>1?0:currentTab+1);}e.preventDefault();}else if(e.which===16){}else if(e.which===27){removeClass(actives[currentTab][0],'highlighted');search_input.value='';defocusSearchBar();}else if(actives[currentTab].length>0){removeClass(actives[currentTab][0],'highlighted');}};}function buildHrefAndPath(item){var displayPath;var href;var type=itemTypes[item.ty];var name=item.name;if(type==='mod'){displayPath=item.path+'::';href=rootPath+item.path.replace(/::/g,'/')+'/'+name+'/index.html';}else if(type==="primitive"||type==="keyword"){displayPath="";href=rootPath+item.path.replace(/::/g,'/')+'/'+type+'.'+name+'.html';}else if(type==="externcrate"){displayPath="";href=rootPath+name+'/index.html';}else if(item.parent!==undefined){var myparent=item.parent;var anchor='#'+type+'.'+name;var parentType=itemTypes[myparent.ty];if(parentType==="primitive"){displayPath=myparent.name+'::';}else{displayPath=item.path+'::'+myparent.name+'::';}href=rootPath+item.path.replace(/::/g,'/')+'/'+parentType+'.'+myparent.name+'.html'+anchor;}else{displayPath=item.path+'::';href=rootPath+item.path.replace(/::/g,'/')+'/'+type+'.'+name+'.html';}return[displayPath,href];}function escape(content){var h1=document.createElement('h1');h1.textContent=content;return h1.innerHTML;}function pathSplitter(path){var tmp='<span>'+path.replace(/::/g,'::</span><span>');if(tmp.endsWith("<span>")){return tmp.slice(0,tmp.length-6);}return tmp;}function addTab(array,query,display){var extraStyle='';if(display===false){extraStyle=' style="display: none;"';}var output='';var duplicates={};var length=0;if(array.length>0){output='<table class="search-results"'+extraStyle+'>';array.forEach(function(item){var name,type;name=item.name;type=itemTypes[item.ty];if(item.is_alias!==true){if(duplicates[item.fullPath]){return;}duplicates[item.fullPath]=true;}length+=1;output+='<tr class="'+type+' result"><td>'+'<a href="'+item.href+'">'+(item.is_alias===true?('<span class="alias"><b>'+item.alias+' </b></span><span '+'class="grey"><i>&nbsp;- see&nbsp;</i></span>'):'')+item.displayPath+'<span class="'+type+'">'+name+'</span></a></td><td>'+'<a href="'+item.href+'">'+'<span class="desc">'+escape(item.desc)+'&nbsp;</span></a></td></tr>';});output+='</table>';}else{output='<div class="search-failed"'+extraStyle+'>No results :(<br/>'+'Try on <a href="https://duckduckgo.com/?q='+encodeURIComponent('rust '+query.query)+'">DuckDuckGo</a>?</div>';}return[output,length];}function makeTabHeader(tabNb,text,nbElems){if(currentTab===tabNb){return'<div class="selected">'+text+' <div class="count">('+nbElems+')</div></div>';}return'<div>'+text+' <div class="count">('+nbElems+')</div></div>';}function showResults(results){if(results['others'].length===1&&getCurrentValue('rustdoc-go-to-only-result')==="true"){var elem=document.createElement('a');elem.href=results['others'][0].href;elem.style.display='none';document.body.appendChild(elem);elem.click();}var query=getQuery(search_input.value);currentResults=query.id;var ret_others=addTab(results['others'],query);var ret_in_args=addTab(results['in_args'],query,false);var ret_returned=addTab(results['returned'],query,false);var output='<h1>Results for '+escape(query.query)+(query.type?' (type: '+escape(query.type)+')':'')+'</h1>'+'<div id="titles">'+makeTabHeader(0,"In Names",ret_others[1])+makeTabHeader(1,"In Parameters",ret_in_args[1])+makeTabHeader(2,"In Return Types",ret_returned[1])+'</div><div id="results">'+ret_others[0]+ret_in_args[0]+ret_returned[0]+'</div>';addClass(document.getElementById('main'),'hidden');var search=document.getElementById('search');removeClass(search,'hidden');search.innerHTML=output;var tds=search.getElementsByTagName('td');var td_width=0;if(tds.length>0){td_width=tds[0].offsetWidth;}var width=search.offsetWidth-40-td_width;onEach(search.getElementsByClassName('desc'),function(e){e.style.width=width+'px';});initSearchNav();var elems=document.getElementById('titles').childNodes;elems[0].onclick=function(){printTab(0);};elems[1].onclick=function(){printTab(1);};elems[2].onclick=function(){printTab(2);};printTab(currentTab);}function execSearch(query,searchWords){var queries=query.raw.split(",");var results={'in_args':[],'returned':[],'others':[],};for(var i=0;i<queries.length;++i){var query=queries[i].trim();if(query.length!==0){var tmp=execQuery(getQuery(query),searchWords);results['in_args'].push(tmp['in_args']);results['returned'].push(tmp['returned']);results['others'].push(tmp['others']);}}if(queries.length>1){function getSmallest(arrays,positions,notDuplicates){var start=null;for(var it=0;it<positions.length;++it){if(arrays[it].length>positions[it]&&(start===null||start>arrays[it][positions[it]].lev)&&!notDuplicates[arrays[it][positions[it]].fullPath]){start=arrays[it][positions[it]].lev;}}return start;}function mergeArrays(arrays){var ret=[];var positions=[];var notDuplicates={};for(var x=0;x<arrays.length;++x){positions.push(0);}while(ret.length<MAX_RESULTS){var smallest=getSmallest(arrays,positions,notDuplicates);if(smallest===null){break;}for(x=0;x<arrays.length&&ret.length<MAX_RESULTS;++x){if(arrays[x].length>positions[x]&&arrays[x][positions[x]].lev===smallest&&!notDuplicates[arrays[x][positions[x]].fullPath]){ret.push(arrays[x][positions[x]]);notDuplicates[arrays[x][positions[x]].fullPath]=true;positions[x]+=1;}}}return ret;}return{'in_args':mergeArrays(results['in_args']),'returned':mergeArrays(results['returned']),'others':mergeArrays(results['others']),};}else{return{'in_args':results['in_args'][0],'returned':results['returned'][0],'others':results['others'][0],};}}function search(e){var params=getQueryStringParams();var query=getQuery(search_input.value.trim());if(e){e.preventDefault();}if(query.query.length===0||query.id===currentResults){if(query.query.length>0){putBackSearch(search_input);}return;}document.title="Results for "+query.query+" - Rust";if(browserSupportsHistoryApi()){if(!history.state&&!params.search){history.pushState(query,"","?search="+encodeURIComponent(query.raw));}else{history.replaceState(query,"","?search="+encodeURIComponent(query.raw));}}showResults(execSearch(query,index));}function buildIndex(rawSearchIndex){searchIndex=[];var searchWords=[];for(var crate in rawSearchIndex){if(!rawSearchIndex.hasOwnProperty(crate)){continue;}searchWords.push(crate);searchIndex.push({crate:crate,ty:1,name:crate,path:"",desc:rawSearchIndex[crate].doc,type:null,});var items=rawSearchIndex[crate].items;var paths=rawSearchIndex[crate].paths;var len=paths.length;for(var i=0;i<len;++i){paths[i]={ty:paths[i][0],name:paths[i][1]};}var len=items.length;var lastPath="";for(var i=0;i<len;++i){var rawRow=items[i];var row={crate:crate,ty:rawRow[0],name:rawRow[1],path:rawRow[2]||lastPath,desc:rawRow[3],parent:paths[rawRow[4]],type:rawRow[5]};searchIndex.push(row);if(typeof row.name==="string"){var word=row.name.toLowerCase();searchWords.push(word);}else{searchWords.push("");}lastPath=row.path;}}return searchWords;}function startSearch(){var searchTimeout;var callback=function(){clearTimeout(searchTimeout);if(search_input.value.length===0){if(browserSupportsHistoryApi()){history.replaceState("","std - Rust","?search=");}var main=document.getElementById('main');if(hasClass(main,'content')){removeClass(main,'hidden');}var search_c=document.getElementById('search');if(hasClass(search_c,'content')){addClass(search_c,'hidden');}}else{searchTimeout=setTimeout(search,500);}};search_input.onkeyup=callback;search_input.oninput=callback;document.getElementsByClassName("search-form")[0].onsubmit=function(e){e.preventDefault();clearTimeout(searchTimeout);search();};search_input.onchange=function(e){clearTimeout(searchTimeout);setTimeout(search,0);};search_input.onpaste=search_input.onchange;if(browserSupportsHistoryApi()){var previousTitle=document.title;window.onpopstate=function(e){var params=getQueryStringParams();if(!params.search){var main=document.getElementById('main');if(hasClass(main,'content')){removeClass(main,'hidden');}var search_c=document.getElementById('search');if(hasClass(search_c,'content')){addClass(search_c,'hidden');}}document.title=previousTitle;currentResults=null;if(params.search){search_input.value=params.search;}else{search_input.value='';}search();};}search();}index=buildIndex(rawSearchIndex);startSearch();if(rootPath==='../'||rootPath==="./"){var sidebar=document.getElementsByClassName('sidebar-elems')[0];if(sidebar){var div=document.createElement('div');div.className='block crate';div.innerHTML='<h3>Crates</h3>';var ul=document.createElement('ul');div.appendChild(ul);var crates=[];for(var crate in rawSearchIndex){if(!rawSearchIndex.hasOwnProperty(crate)){continue;}crates.push(crate);}crates.sort();for(var i=0;i<crates.length;++i){var klass='crate';if(rootPath!=="./"&&crates[i]===window.currentCrate){klass+=' current';}var link=document.createElement('a');link.href=rootPath+crates[i]+'/index.html';link.title=rawSearchIndex[crates[i]].doc;link.className=klass;link.textContent=crates[i];var li=document.createElement('li');li.appendChild(link);ul.appendChild(li);}sidebar.appendChild(div);}}}window.initSearch=initSearch;function initSidebarItems(items){var sidebar=document.getElementsByClassName('sidebar-elems')[0];var current=window.sidebarCurrent;function block(shortty,longty){var filtered=items[shortty];if(!filtered){return;}var div=document.createElement('div');div.className='block '+shortty;var h3=document.createElement('h3');h3.textContent=longty;div.appendChild(h3);var ul=document.createElement('ul');for(var i=0;i<filtered.length;++i){var item=filtered[i];var name=item[0];var desc=item[1];var klass=shortty;if(name===current.name&&shortty===current.ty){klass+=' current';}var path;if(shortty==='mod'){path=name+'/index.html';}else{path=shortty+'.'+name+'.html';}var link=document.createElement('a');link.href=current.relpath+path;link.title=desc;link.className=klass;link.textContent=name;var li=document.createElement('li');li.appendChild(link);ul.appendChild(li);}div.appendChild(ul);if(sidebar){sidebar.appendChild(div);}}block("primitive","Primitive Types");block("mod","Modules");block("macro","Macros");block("struct","Structs");block("enum","Enums");block("union","Unions");block("constant","Constants");block("static","Statics");block("trait","Traits");block("fn","Functions");block("type","Type Definitions");block("foreigntype","Foreign Types");block("keyword","Keywords");}window.initSidebarItems=initSidebarItems;window.register_implementors=function(imp){var implementors=document.getElementById('implementors-list');var synthetic_implementors=document.getElementById('synthetic-implementors-list');var libs=Object.getOwnPropertyNames(imp);for(var i=0;i<libs.length;++i){if(libs[i]===currentCrate){continue;}var structs=imp[libs[i]];struct_loop:for(var j=0;j<structs.length;++j){var struct=structs[j];var list=struct.synthetic?synthetic_implementors:implementors;if(struct.synthetic){for(var k=0;k<struct.types.length;k++){if(window.inlined_types.has(struct.types[k])){continue struct_loop;}window.inlined_types.add(struct.types[k]);}}var code=document.createElement('code');code.innerHTML=struct.text;var x=code.getElementsByTagName('a');for(var k=0;k<x.length;k++){var href=x[k].getAttribute('href');if(href&&href.indexOf('http')!==0){x[k].setAttribute('href',rootPath+href);}}var li=document.createElement('li');li.appendChild(code);list.appendChild(li);}}};if(window.pending_implementors){window.register_implementors(window.pending_implementors);}function labelForToggleButton(sectionIsCollapsed){if(sectionIsCollapsed){return"+";}return"\u2212";}function onEveryMatchingChild(elem,className,func){if(elem&&className&&func){for(var i=0;i<elem.childNodes.length;i++){if(hasClass(elem.childNodes[i],className)){func(elem.childNodes[i]);}else{onEveryMatchingChild(elem.childNodes[i],className,func);}}}}function toggleAllDocs(pageId,fromAutoCollapse){var toggle=document.getElementById("toggle-all-docs");if(!toggle){return;}if(hasClass(toggle,"will-expand")){updateLocalStorage("rustdoc-collapse","false");removeClass(toggle,"will-expand");onEveryMatchingChild(toggle,"inner",function(e){e.innerHTML=labelForToggleButton(false);});toggle.title="collapse all docs";if(fromAutoCollapse!==true){onEach(document.getElementsByClassName("collapse-toggle"),function(e){collapseDocs(e,"show");});}}else{updateLocalStorage("rustdoc-collapse","true");addClass(toggle,"will-expand");onEveryMatchingChild(toggle,"inner",function(e){e.innerHTML=labelForToggleButton(true);});toggle.title="expand all docs";if(fromAutoCollapse!==true){onEach(document.getElementsByClassName("collapse-toggle"),function(e){collapseDocs(e,"hide",pageId);});}}}function collapseDocs(toggle,mode,pageId){if(!toggle||!toggle.parentNode){return;}function adjustToggle(arg){return function(e){if(hasClass(e,'toggle-label')){if(arg){e.style.display='inline-block';}else{e.style.display='none';}}if(hasClass(e,'inner')){e.innerHTML=labelForToggleButton(arg);}};};if(!hasClass(toggle.parentNode,"impl")){var relatedDoc=toggle.parentNode.nextElementSibling;if(hasClass(relatedDoc,"stability")){relatedDoc=relatedDoc.nextElementSibling;}if(hasClass(relatedDoc,"docblock")){var action=mode;if(action==="toggle"){if(hasClass(relatedDoc,"hidden-by-usual-hider")){action="show";}else{action="hide";}}if(action==="hide"){addClass(relatedDoc,"hidden-by-usual-hider");onEach(toggle.childNodes,adjustToggle(true));addClass(toggle.parentNode,'collapsed');}else if(action==="show"){removeClass(relatedDoc,"hidden-by-usual-hider");removeClass(toggle.parentNode,'collapsed');onEach(toggle.childNodes,adjustToggle(false));}}}else{function implHider(addOrRemove){return function(n){var is_method=hasClass(n,"method");if(is_method||hasClass(n,"type")){if(is_method===true){if(addOrRemove){addClass(n,"hidden-by-impl-hider");}else{removeClass(n,"hidden-by-impl-hider");}}var ns=n.nextElementSibling;while(true){if(ns&&(hasClass(ns,"docblock")||hasClass(ns,"stability"))){if(addOrRemove){addClass(ns,"hidden-by-impl-hider");}else{removeClass(ns,"hidden-by-impl-hider");}ns=ns.nextElementSibling;continue;}break;}}}}var parentElem=toggle.parentNode;var relatedDoc=parentElem;var docblock=relatedDoc.nextElementSibling;while(!hasClass(relatedDoc,"impl-items")){relatedDoc=relatedDoc.nextElementSibling;}if((!relatedDoc&&!hasClass(docblock,"docblock"))||(pageId&&onEach(relatedDoc.childNodes,function(e){return e.id===pageId;})===true)){return;}var action=mode;if(action==="toggle"){if(hasClass(relatedDoc,"fns-now-collapsed")||hasClass(docblock,"hidden-by-impl-hider")){action="show";}else{action="hide";}}if(action==="show"){removeClass(relatedDoc,"fns-now-collapsed");removeClass(docblock,"hidden-by-usual-hider");onEach(toggle.childNodes,adjustToggle(false));onEach(relatedDoc.childNodes,implHider(false));}else if(action==="hide"){addClass(relatedDoc,"fns-now-collapsed");addClass(docblock,"hidden-by-usual-hider");onEach(toggle.childNodes,adjustToggle(true));onEach(relatedDoc.childNodes,implHider(true));}}}function autoCollapse(pageId,collapse){if(collapse){toggleAllDocs(pageId,true);}onEach(document.getElementsByClassName("collapse-toggle"),function(e){var n=e.parentNode;if(n.id.match(/^impl(?:-\d+)?$/)===null){if(collapse||hasClass(n,'impl')){collapseDocs(e,"hide",pageId);}}});}var x=document.getElementById('toggle-all-docs');if(x){x.onclick=toggleAllDocs;}function insertAfter(newNode,referenceNode){referenceNode.parentNode.insertBefore(newNode,referenceNode.nextSibling);}function checkIfThereAreMethods(elems){var areThereMethods=false;onEach(elems,function(e){if(hasClass(e,"method")){areThereMethods=true;return true;}});return areThereMethods;}var toggle=document.createElement('a');toggle.href='javascript:void(0)';toggle.className='collapse-toggle';toggle.innerHTML="[<span class='inner'>"+labelForToggleButton(false)+"</span>]";var func=function(e){var next=e.nextElementSibling;if(hasClass(e,'impl')&&next&&hasClass(next,'docblock')){next=next.nextElementSibling;}if(!next){return;}if((checkIfThereAreMethods(next.childNodes)||hasClass(e,'method'))&&(hasClass(next,'docblock')||hasClass(e,'impl')||(hasClass(next,'stability')&&hasClass(next.nextElementSibling,'docblock')))){insertAfter(toggle.cloneNode(true),e.childNodes[e.childNodes.length-1]);}};onEach(document.getElementsByClassName('method'),func);onEach(document.getElementsByClassName('impl'),func);onEach(document.getElementsByClassName('impl-items'),function(e){onEach(e.getElementsByClassName('associatedconstant'),func);});function createToggle(otherMessage,extraClass){var span=document.createElement('span');span.className='toggle-label';span.style.display='none';if(!otherMessage){span.innerHTML='&nbsp;Expand&nbsp;description';}else{span.innerHTML=otherMessage;span.style.fontSize='20px';}var mainToggle=toggle.cloneNode(true);mainToggle.appendChild(span);var wrapper=document.createElement('div');wrapper.className='toggle-wrapper';if(extraClass){wrapper.className+=' '+extraClass;}wrapper.appendChild(mainToggle);return wrapper;}onEach(document.getElementsByClassName('docblock'),function(e){if(hasClass(e,'autohide')){var wrap=e.previousElementSibling;if(wrap&&hasClass(wrap,'toggle-wrapper')){var toggle=wrap.childNodes[0];var extra=false;if(e.childNodes[0].tagName==='H3'){extra=true;}e.style.display='none';addClass(wrap,'collapsed');onEach(toggle.getElementsByClassName('inner'),function(e){e.innerHTML=labelForToggleButton(true);});onEach(toggle.getElementsByClassName('toggle-label'),function(e){e.style.display='inline-block';if(extra===true){i_e.innerHTML=" Show "+e.childNodes[0].innerHTML;}});}}if(e.parentNode.id==="main"){var otherMessage;var extraClass;if(hasClass(e,"type-decl")){otherMessage='&nbsp;Show&nbsp;declaration';}else if(hasClass(e.childNodes[0],"impl-items")){extraClass="marg-left";}e.parentNode.insertBefore(createToggle(otherMessage,extraClass),e);if(otherMessage&&getCurrentValue('rustdoc-item-declarations')!=="false"){collapseDocs(e.previousSibling.childNodes[0],"toggle");}}});function createToggleWrapper(tog){var span=document.createElement('span');span.className='toggle-label';span.style.display='none';span.innerHTML='&nbsp;Expand&nbsp;attributes';tog.appendChild(span);var wrapper=document.createElement('div');wrapper.className='toggle-wrapper toggle-attributes';wrapper.appendChild(tog);return wrapper;}function printTab(nb){if(nb===0||nb===1||nb===2){currentTab=nb;}var nb_copy=nb;onEach(document.getElementById('titles').childNodes,function(elem){if(nb_copy===0){addClass(elem,'selected');}else{removeClass(elem,'selected');}nb_copy-=1;});onEach(document.getElementById('results').childNodes,function(elem){if(nb===0){elem.style.display='';}else{elem.style.display='none';}nb-=1;});}onEach(document.getElementById('main').getElementsByClassName('attributes'),function(i_e){i_e.parentNode.insertBefore(createToggleWrapper(toggle.cloneNode(true)),i_e);if(getCurrentValue("rustdoc-item-attributes")!=="false"){collapseDocs(i_e.previousSibling.childNodes[0],"toggle");}});onEach(document.getElementsByClassName('rust-example-rendered'),function(e){if(hasClass(e,'compile_fail')){e.addEventListener("mouseover",function(event){e.previousElementSibling.childNodes[0].style.color='#f00';});e.addEventListener("mouseout",function(event){e.previousElementSibling.childNodes[0].style.color='';});}else if(hasClass(e,'ignore')){e.addEventListener("mouseover",function(event){e.previousElementSibling.childNodes[0].style.color='#ff9200';});e.addEventListener("mouseout",function(event){e.previousElementSibling.childNodes[0].style.color='';});}});function showModal(content){var modal=document.createElement('div');modal.id="important";addClass(modal,'modal');modal.innerHTML='<div class="modal-content"><div class="close" id="modal-close">✕</div>'+'<div class="whiter"></div><span class="docblock">'+content+'</span></div>';document.getElementsByTagName('body')[0].appendChild(modal);document.getElementById('modal-close').onclick=hideModal;modal.onclick=hideModal;}function hideModal(){var modal=document.getElementById("important");if(modal){modal.parentNode.removeChild(modal);}}onEach(document.getElementsByClassName('important-traits'),function(e){e.onclick=function(){showModal(e.lastElementChild.innerHTML);};});function putBackSearch(search_input){if(search_input.value!==""){addClass(document.getElementById("main"),"hidden");removeClass(document.getElementById("search"),"hidden");if(browserSupportsHistoryApi()){history.replaceState(search_input.value,"","?search="+encodeURIComponent(search_input.value));}}}if(search_input){search_input.onfocus=function(){putBackSearch(this);};}var params=getQueryStringParams();if(params&&params.search){addClass(document.getElementById("main"),"hidden");var search=document.getElementById("search");removeClass(search,"hidden");search.innerHTML='<h3 style="text-align: center;">Loading search results...</h3>';}var sidebar_menu=document.getElementsByClassName("sidebar-menu")[0];if(sidebar_menu){sidebar_menu.onclick=function(){var sidebar=document.getElementsByClassName('sidebar')[0];if(hasClass(sidebar,"mobile")===true){hideSidebar();}else{showSidebar();}};}window.onresize=function(){hideSidebar();};autoCollapse(getPageId(),getCurrentValue("rustdoc-collapse")==="true");}());function focusSearchBar(){document.getElementsByClassName('search-input')[0].focus();}function defocusSearchBar(){document.getElementsByClassName('search-input')[0].blur();}