/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.spi.JavaPlatformManagerProvider;
import org.netbeans.modules.profiler.spi.JavaPlatformProvider;
import org.openide.util.Lookup;

public final class JavaPlatform {
    private final JavaPlatformProvider provider;

    public static JavaPlatform getJavaPlatformById(String string) {
        if (string != null) {
            List<JavaPlatform> list = JavaPlatform.getPlatforms();
            for (JavaPlatform javaPlatform : list) {
                if (!string.equals(javaPlatform.getPlatformId())) continue;
                return javaPlatform;
            }
        }
        return null;
    }

    public static List<JavaPlatform> getPlatforms() {
        List<JavaPlatformProvider> list = JavaPlatform.provider().getPlatforms();
        ArrayList<JavaPlatform> arrayList = new ArrayList<JavaPlatform>(list.size());
        for (JavaPlatformProvider javaPlatformProvider : list) {
            if (javaPlatformProvider.getPlatformJavaFile() == null || !MiscUtils.isSupportedJVM(javaPlatformProvider.getSystemProperties())) continue;
            arrayList.add(new JavaPlatform(javaPlatformProvider));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static JavaPlatform getDefaultPlatform() {
        return new JavaPlatform(JavaPlatform.provider().getDefaultPlatform());
    }

    public static void showCustomizer() {
        JavaPlatform.provider().showCustomizer();
    }

    private static JavaPlatformManagerProvider provider() {
        return (JavaPlatformManagerProvider)Lookup.getDefault().lookup(JavaPlatformManagerProvider.class);
    }

    JavaPlatform(JavaPlatformProvider javaPlatformProvider) {
        this.provider = javaPlatformProvider;
    }

    public String getDisplayName() {
        return this.provider.getDisplayName();
    }

    public String getPlatformId() {
        return this.provider.getPlatformId();
    }

    public int getPlatformJDKMinor() {
        return Platform.getJDKMinorNumber((String)this.getVersion());
    }

    public String getPlatformJDKVersion() {
        String string = this.getVersion();
        if (string == null) {
            return null;
        }
        if (string.startsWith("1.5")) {
            return "jdk15";
        }
        if (string.startsWith("1.6")) {
            return "jdk16";
        }
        if (string.startsWith("1.7")) {
            return "jdk17";
        }
        if (string.startsWith("1.8")) {
            return "jdk18";
        }
        if (string.startsWith("1.9")) {
            return "jdk19";
        }
        if (string.startsWith("9")) {
            return "jdk19";
        }
        if (string.startsWith("10")) {
            return "jdk100";
        }
        return null;
    }

    public String getPlatformJavaFile() {
        return this.provider.getPlatformJavaFile();
    }

    public Map<String, String> getSystemProperties() {
        return this.provider.getSystemProperties();
    }

    public Map<String, String> getProperties() {
        return this.provider.getProperties();
    }

    public int getPlatformArchitecture() {
        String string = this.getSystemProperties().get("sun.arch.data.model");
        if (string == null) {
            return 32;
        }
        return Integer.parseInt(string);
    }

    public String getVersion() {
        return this.getSystemProperties().get("java.version");
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object object) {
        if (object instanceof JavaPlatform) {
            return this.getPlatformId().equals(((JavaPlatform)object).getPlatformId());
        }
        return false;
    }

    public int hashCode() {
        return this.getPlatformId().hashCode();
    }
}

