/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.admin.indices.analyze.DetailAnalyzeResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.CustomAnalyzerProvider;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ReferringFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportAnalyzeAction
extends TransportSingleShardAction<AnalyzeRequest, AnalyzeResponse> {
    private final IndicesService indicesService;
    private final Environment environment;

    @Inject
    public TransportAnalyzeAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Environment environment) {
        super(settings, "indices:admin/analyze", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, AnalyzeRequest::new, "analyze");
        this.indicesService = indicesService;
        this.environment = environment;
    }

    @Override
    protected AnalyzeResponse newResponse() {
        return new AnalyzeResponse();
    }

    @Override
    protected boolean resolveIndex(AnalyzeRequest request) {
        return request.index() != null;
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (request.concreteIndex() != null) {
            return super.checkRequestBlock(state, request);
        }
        return null;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (request.concreteIndex() == null) {
            return null;
        }
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected AnalyzeResponse shardOperation(AnalyzeRequest request, ShardId shardId) {
        try {
            IndexService indexService = shardId != null ? this.indicesService.indexServiceSafe(shardId.getIndex()) : null;
            String field = null;
            NamedAnalyzer analyzer = null;
            if (request.field() != null) {
                if (indexService == null) {
                    throw new IllegalArgumentException("No index provided, and trying to analyzer based on a specific field which requires the index parameter");
                }
                MappedFieldType fieldType = indexService.mapperService().fullName(request.field());
                if (fieldType != null) {
                    if (fieldType.tokenized()) {
                        analyzer = fieldType.indexAnalyzer();
                    } else if (fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
                        analyzer = ((KeywordFieldMapper.KeywordFieldType)fieldType).normalizer();
                        if (analyzer == null) {
                            analyzer = fieldType.indexAnalyzer();
                        }
                    } else {
                        throw new IllegalArgumentException("Can't process field [" + request.field() + "], Analysis requests are only supported on tokenized fields");
                    }
                    field = fieldType.name();
                }
            }
            if (field == null) {
                field = indexService != null ? indexService.getIndexSettings().getDefaultFields().get(0) : "_all";
            }
            AnalysisRegistry analysisRegistry = this.indicesService.getAnalysis();
            return TransportAnalyzeAction.analyze(request, field, (Analyzer)analyzer, indexService != null ? indexService.getIndexAnalyzers() : null, analysisRegistry, this.environment);
        }
        catch (IOException e) {
            throw new ElasticsearchException("analysis failed", (Throwable)e, new Object[0]);
        }
    }

    public static AnalyzeResponse analyze(AnalyzeRequest request, String field, Analyzer analyzer, IndexAnalyzers indexAnalyzers, AnalysisRegistry analysisRegistry, Environment environment) throws IOException {
        IndexSettings indexSettings;
        boolean closeAnalyzer = false;
        if (analyzer == null && request.analyzer() != null) {
            if (indexAnalyzers == null) {
                analyzer = analysisRegistry.getAnalyzer(request.analyzer());
                if (analyzer == null) {
                    throw new IllegalArgumentException("failed to find global analyzer [" + request.analyzer() + "]");
                }
            } else {
                analyzer = indexAnalyzers.get(request.analyzer());
                if (analyzer == null) {
                    throw new IllegalArgumentException("failed to find analyzer [" + request.analyzer() + "]");
                }
            }
        } else if (request.tokenizer() != null) {
            indexSettings = indexAnalyzers == null ? null : indexAnalyzers.getIndexSettings();
            Tuple<String, TokenizerFactory> tokenizerFactory = TransportAnalyzeAction.parseTokenizerFactory(request, indexAnalyzers, analysisRegistry, environment);
            List<CharFilterFactory> charFilterFactoryList = TransportAnalyzeAction.parseCharFilterFactories(request, indexSettings, analysisRegistry, environment, false);
            List<TokenFilterFactory> tokenFilterFactoryList = TransportAnalyzeAction.parseTokenFilterFactories(request, indexSettings, analysisRegistry, environment, tokenizerFactory, charFilterFactoryList, false);
            analyzer = new CustomAnalyzer((String)tokenizerFactory.v1(), (TokenizerFactory)tokenizerFactory.v2(), charFilterFactoryList.toArray(new CharFilterFactory[charFilterFactoryList.size()]), tokenFilterFactoryList.toArray(new TokenFilterFactory[tokenFilterFactoryList.size()]));
            closeAnalyzer = true;
        } else if (request.normalizer() != null) {
            analyzer = indexAnalyzers.getNormalizer(request.normalizer());
            if (analyzer == null) {
                throw new IllegalArgumentException("failed to find normalizer under [" + request.normalizer() + "]");
            }
        } else if (request.tokenFilters() != null && request.tokenFilters().size() > 0 || request.charFilters() != null && request.charFilters().size() > 0) {
            indexSettings = indexAnalyzers == null ? null : indexAnalyzers.getIndexSettings();
            List<CharFilterFactory> charFilterFactoryList = TransportAnalyzeAction.parseCharFilterFactories(request, indexSettings, analysisRegistry, environment, true);
            String keywordTokenizerName = "keyword";
            TokenizerFactory keywordTokenizerFactory = TransportAnalyzeAction.getTokenizerFactory(analysisRegistry, environment, "keyword");
            List<TokenFilterFactory> tokenFilterFactoryList = TransportAnalyzeAction.parseTokenFilterFactories(request, indexSettings, analysisRegistry, environment, (Tuple<String, TokenizerFactory>)new Tuple((Object)"keyword", (Object)keywordTokenizerFactory), charFilterFactoryList, true);
            analyzer = new CustomAnalyzer("keyword_for_normalizer", keywordTokenizerFactory, charFilterFactoryList.toArray(new CharFilterFactory[charFilterFactoryList.size()]), tokenFilterFactoryList.toArray(new TokenFilterFactory[tokenFilterFactoryList.size()]));
            closeAnalyzer = true;
        } else if (analyzer == null) {
            analyzer = indexAnalyzers == null ? analysisRegistry.getAnalyzer("standard") : indexAnalyzers.getDefaultIndexAnalyzer();
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("failed to find analyzer");
        }
        List<AnalyzeResponse.AnalyzeToken> tokens = null;
        DetailAnalyzeResponse detail = null;
        if (request.explain()) {
            detail = TransportAnalyzeAction.detailAnalyze(request, analyzer, field);
        } else {
            tokens = TransportAnalyzeAction.simpleAnalyze(request, analyzer, field);
        }
        if (closeAnalyzer) {
            analyzer.close();
        }
        return new AnalyzeResponse(tokens, detail);
    }

    private static List<AnalyzeResponse.AnalyzeToken> simpleAnalyze(AnalyzeRequest request, Analyzer analyzer, String field) {
        ArrayList<AnalyzeResponse.AnalyzeToken> tokens = new ArrayList<AnalyzeResponse.AnalyzeToken>();
        int lastPosition = -1;
        int lastOffset = 0;
        for (String text : request.text()) {
            try (TokenStream stream = analyzer.tokenStream(field, text);){
                stream.reset();
                CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                PositionIncrementAttribute posIncr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                OffsetAttribute offset = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
                TypeAttribute type = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
                PositionLengthAttribute posLen = (PositionLengthAttribute)stream.addAttribute(PositionLengthAttribute.class);
                while (stream.incrementToken()) {
                    int increment = posIncr.getPositionIncrement();
                    if (increment > 0) {
                        lastPosition += increment;
                    }
                    tokens.add(new AnalyzeResponse.AnalyzeToken(term.toString(), lastPosition, lastOffset + offset.startOffset(), lastOffset + offset.endOffset(), posLen.getPositionLength(), type.type(), null));
                }
                stream.end();
                lastOffset += offset.endOffset();
                lastPosition += posIncr.getPositionIncrement();
                lastPosition += analyzer.getPositionIncrementGap(field);
                lastOffset += analyzer.getOffsetGap(field);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to analyze", (Throwable)e, new Object[0]);
            }
        }
        return tokens;
    }

    private static DetailAnalyzeResponse detailAnalyze(AnalyzeRequest request, Analyzer analyzer, String field) {
        DetailAnalyzeResponse detailResponse;
        HashSet<String> includeAttributes = new HashSet<String>();
        if (request.attributes() != null) {
            for (String attribute : request.attributes()) {
                includeAttributes.add(attribute.toLowerCase(Locale.ROOT));
            }
        }
        CustomAnalyzer customAnalyzer = null;
        if (analyzer instanceof CustomAnalyzer) {
            customAnalyzer = (CustomAnalyzer)analyzer;
        } else if (analyzer instanceof NamedAnalyzer && ((NamedAnalyzer)analyzer).analyzer() instanceof CustomAnalyzer) {
            customAnalyzer = (CustomAnalyzer)((NamedAnalyzer)analyzer).analyzer();
        }
        if (customAnalyzer != null) {
            CharFilterFactory[] charFilterFactories = customAnalyzer.charFilters();
            TokenizerFactory tokenizerFactory = customAnalyzer.tokenizerFactory();
            TokenFilterFactory[] tokenFilterFactories = customAnalyzer.tokenFilters();
            String[][] charFiltersTexts = new String[charFilterFactories != null ? charFilterFactories.length : 0][request.text().length];
            TokenListCreator[] tokenFiltersTokenListCreator = new TokenListCreator[tokenFilterFactories != null ? tokenFilterFactories.length : 0];
            TokenListCreator tokenizerTokenListCreator = new TokenListCreator();
            for (int textIndex = 0; textIndex < request.text().length; ++textIndex) {
                String charFilteredSource = request.text()[textIndex];
                Reader reader = new StringReader(charFilteredSource);
                if (charFilterFactories != null) {
                    for (int charFilterIndex = 0; charFilterIndex < charFilterFactories.length; ++charFilterIndex) {
                        reader = charFilterFactories[charFilterIndex].create(reader);
                        Reader readerForWriteOut = new StringReader(charFilteredSource);
                        readerForWriteOut = charFilterFactories[charFilterIndex].create(readerForWriteOut);
                        charFiltersTexts[charFilterIndex][textIndex] = charFilteredSource = TransportAnalyzeAction.writeCharStream(readerForWriteOut);
                    }
                }
                Tokenizer tokenizer = tokenizerFactory.create();
                tokenizer.setReader(reader);
                tokenizerTokenListCreator.analyze((TokenStream)tokenizer, customAnalyzer, field, includeAttributes);
                if (tokenFilterFactories == null) continue;
                for (int tokenFilterIndex = 0; tokenFilterIndex < tokenFilterFactories.length; ++tokenFilterIndex) {
                    if (tokenFiltersTokenListCreator[tokenFilterIndex] == null) {
                        tokenFiltersTokenListCreator[tokenFilterIndex] = new TokenListCreator();
                    }
                    TokenStream stream = TransportAnalyzeAction.createStackedTokenStream(request.text()[textIndex], charFilterFactories, tokenizerFactory, tokenFilterFactories, tokenFilterIndex + 1);
                    tokenFiltersTokenListCreator[tokenFilterIndex].analyze(stream, customAnalyzer, field, includeAttributes);
                }
            }
            DetailAnalyzeResponse.CharFilteredText[] charFilteredLists = new DetailAnalyzeResponse.CharFilteredText[charFiltersTexts.length];
            if (charFilterFactories != null) {
                for (int charFilterIndex = 0; charFilterIndex < charFiltersTexts.length; ++charFilterIndex) {
                    charFilteredLists[charFilterIndex] = new DetailAnalyzeResponse.CharFilteredText(charFilterFactories[charFilterIndex].name(), charFiltersTexts[charFilterIndex]);
                }
            }
            DetailAnalyzeResponse.AnalyzeTokenList[] tokenFilterLists = new DetailAnalyzeResponse.AnalyzeTokenList[tokenFiltersTokenListCreator.length];
            if (tokenFilterFactories != null) {
                for (int tokenFilterIndex = 0; tokenFilterIndex < tokenFiltersTokenListCreator.length; ++tokenFilterIndex) {
                    tokenFilterLists[tokenFilterIndex] = new DetailAnalyzeResponse.AnalyzeTokenList(tokenFilterFactories[tokenFilterIndex].name(), tokenFiltersTokenListCreator[tokenFilterIndex].getArrayTokens());
                }
            }
            detailResponse = new DetailAnalyzeResponse(charFilteredLists, new DetailAnalyzeResponse.AnalyzeTokenList(customAnalyzer.getTokenizerName(), tokenizerTokenListCreator.getArrayTokens()), tokenFilterLists);
        } else {
            String name = analyzer instanceof NamedAnalyzer ? ((NamedAnalyzer)analyzer).name() : analyzer.getClass().getName();
            TokenListCreator tokenListCreator = new TokenListCreator();
            for (String text : request.text()) {
                tokenListCreator.analyze(analyzer.tokenStream(field, text), analyzer, field, includeAttributes);
            }
            detailResponse = new DetailAnalyzeResponse(new DetailAnalyzeResponse.AnalyzeTokenList(name, tokenListCreator.getArrayTokens()));
        }
        return detailResponse;
    }

    private static TokenStream createStackedTokenStream(String source, CharFilterFactory[] charFilterFactories, TokenizerFactory tokenizerFactory, TokenFilterFactory[] tokenFilterFactories, int current) {
        Reader reader = new StringReader(source);
        for (CharFilterFactory charFilterFactory : charFilterFactories) {
            reader = charFilterFactory.create(reader);
        }
        Tokenizer tokenizer = tokenizerFactory.create();
        tokenizer.setReader(reader);
        Tokenizer tokenStream = tokenizer;
        for (int i = 0; i < current; ++i) {
            tokenStream = tokenFilterFactories[i].create((TokenStream)tokenStream);
        }
        return tokenStream;
    }

    private static String writeCharStream(Reader input) {
        int len;
        int BUFFER_SIZE = 1024;
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        do {
            try {
                len = input.read(buf, 0, 1024);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to analyze (charFiltering)", (Throwable)e, new Object[0]);
            }
            if (len <= 0) continue;
            sb.append(buf, 0, len);
        } while (len == 1024);
        return sb.toString();
    }

    private static Map<String, Object> extractExtendedAttributes(TokenStream stream, Set<String> includeAttributes) {
        TreeMap<String, Object> extendedAttributes = new TreeMap<String, Object>();
        stream.reflectWith((attClass, key, value) -> {
            if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (PositionIncrementAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (OffsetAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (TypeAttribute.class.isAssignableFrom(attClass)) {
                return;
            }
            if (includeAttributes == null || includeAttributes.isEmpty() || includeAttributes.contains(key.toLowerCase(Locale.ROOT))) {
                if (value instanceof BytesRef) {
                    BytesRef p = (BytesRef)value;
                    value = p.toString();
                }
                extendedAttributes.put(key, value);
            }
        });
        return extendedAttributes;
    }

    private static List<CharFilterFactory> parseCharFilterFactories(AnalyzeRequest request, IndexSettings indexSettings, AnalysisRegistry analysisRegistry, Environment environment, boolean normalizer) throws IOException {
        ArrayList<CharFilterFactory> charFilterFactoryList = new ArrayList<CharFilterFactory>();
        if (request.charFilters() != null && request.charFilters().size() > 0) {
            List<AnalyzeRequest.NameOrDefinition> charFilters = request.charFilters();
            for (AnalyzeRequest.NameOrDefinition charFilter : charFilters) {
                AnalysisModule.AnalysisProvider<CharFilterFactory> charFilterFactoryFactory;
                CharFilterFactory charFilterFactory;
                if (charFilter.definition != null) {
                    Settings settings = TransportAnalyzeAction.getAnonymousSettings(charFilter.definition);
                    String charFilterTypeName = settings.get("type");
                    if (charFilterTypeName == null) {
                        throw new IllegalArgumentException("Missing [type] setting for anonymous char filter: " + charFilter.definition);
                    }
                    AnalysisModule.AnalysisProvider<CharFilterFactory> charFilterFactoryFactory2 = analysisRegistry.getCharFilterProvider(charFilterTypeName);
                    if (charFilterFactoryFactory2 == null) {
                        throw new IllegalArgumentException("failed to find global char filter under [" + charFilterTypeName + "]");
                    }
                    charFilterFactory = charFilterFactoryFactory2.get(TransportAnalyzeAction.getNaIndexSettings(settings), environment, "_anonymous_charfilter", settings);
                } else if (indexSettings == null) {
                    charFilterFactoryFactory = analysisRegistry.getCharFilterProvider(charFilter.name);
                    if (charFilterFactoryFactory == null) {
                        throw new IllegalArgumentException("failed to find global char filter under [" + charFilter.name + "]");
                    }
                    charFilterFactory = charFilterFactoryFactory.get(environment, charFilter.name);
                } else {
                    charFilterFactoryFactory = analysisRegistry.getCharFilterProvider(charFilter.name, indexSettings);
                    if (charFilterFactoryFactory == null) {
                        throw new IllegalArgumentException("failed to find char filter under [" + charFilter.name + "]");
                    }
                    charFilterFactory = charFilterFactoryFactory.get(indexSettings, environment, charFilter.name, AnalysisRegistry.getSettingsFromIndexSettings(indexSettings, "index.analysis.char_filter." + charFilter.name));
                }
                if (charFilterFactory == null) {
                    throw new IllegalArgumentException("failed to find char filter under [" + charFilter.name + "]");
                }
                if (normalizer) {
                    if (!(charFilterFactory instanceof MultiTermAwareComponent)) {
                        throw new IllegalArgumentException("Custom normalizer may not use char filter [" + charFilterFactory.name() + "]");
                    }
                    charFilterFactory = (CharFilterFactory)((MultiTermAwareComponent)((Object)charFilterFactory)).getMultiTermComponent();
                }
                charFilterFactoryList.add(charFilterFactory);
            }
        }
        return charFilterFactoryList;
    }

    private static List<TokenFilterFactory> parseTokenFilterFactories(AnalyzeRequest request, IndexSettings indexSettings, AnalysisRegistry analysisRegistry, Environment environment, Tuple<String, TokenizerFactory> tokenizerFactory, List<CharFilterFactory> charFilterFactoryList, boolean normalizer) throws IOException {
        ArrayList<TokenFilterFactory> tokenFilterFactoryList = new ArrayList<TokenFilterFactory>();
        ArrayList<ReferringFilterFactory> referringFilters = new ArrayList<ReferringFilterFactory>();
        if (request.tokenFilters() != null && request.tokenFilters().size() > 0) {
            List<AnalyzeRequest.NameOrDefinition> tokenFilters = request.tokenFilters();
            for (AnalyzeRequest.NameOrDefinition tokenFilter : tokenFilters) {
                AnalysisModule.AnalysisProvider<TokenFilterFactory> tokenFilterFactoryFactory;
                TokenFilterFactory tokenFilterFactory;
                if (tokenFilter.definition != null) {
                    Settings settings = TransportAnalyzeAction.getAnonymousSettings(tokenFilter.definition);
                    String filterTypeName = settings.get("type");
                    if (filterTypeName == null) {
                        throw new IllegalArgumentException("Missing [type] setting for anonymous token filter: " + tokenFilter.definition);
                    }
                    AnalysisModule.AnalysisProvider<TokenFilterFactory> tokenFilterFactoryFactory2 = analysisRegistry.getTokenFilterProvider(filterTypeName);
                    if (tokenFilterFactoryFactory2 == null) {
                        throw new IllegalArgumentException("failed to find global token filter under [" + filterTypeName + "]");
                    }
                    tokenFilterFactory = tokenFilterFactoryFactory2.get(TransportAnalyzeAction.getNaIndexSettings(settings), environment, "_anonymous_tokenfilter", settings);
                    if ((tokenFilterFactory = CustomAnalyzerProvider.checkAndApplySynonymFilter(tokenFilterFactory, (String)tokenizerFactory.v1(), (TokenizerFactory)tokenizerFactory.v2(), tokenFilterFactoryList, charFilterFactoryList, environment)) instanceof ReferringFilterFactory) {
                        referringFilters.add((ReferringFilterFactory)((Object)tokenFilterFactory));
                    }
                } else if (indexSettings == null) {
                    tokenFilterFactoryFactory = analysisRegistry.getTokenFilterProvider(tokenFilter.name);
                    if (tokenFilterFactoryFactory == null) {
                        throw new IllegalArgumentException("failed to find global token filter under [" + tokenFilter.name + "]");
                    }
                    tokenFilterFactory = tokenFilterFactoryFactory.get(environment, tokenFilter.name);
                } else {
                    tokenFilterFactoryFactory = analysisRegistry.getTokenFilterProvider(tokenFilter.name, indexSettings);
                    if (tokenFilterFactoryFactory == null) {
                        throw new IllegalArgumentException("failed to find token filter under [" + tokenFilter.name + "]");
                    }
                    Settings settings = AnalysisRegistry.getSettingsFromIndexSettings(indexSettings, "index.analysis.filter." + tokenFilter.name);
                    tokenFilterFactory = tokenFilterFactoryFactory.get(indexSettings, environment, tokenFilter.name, settings);
                    tokenFilterFactory = CustomAnalyzerProvider.checkAndApplySynonymFilter(tokenFilterFactory, (String)tokenizerFactory.v1(), (TokenizerFactory)tokenizerFactory.v2(), tokenFilterFactoryList, charFilterFactoryList, environment);
                }
                if (tokenFilterFactory == null) {
                    throw new IllegalArgumentException("failed to find or create token filter under [" + tokenFilter.name + "]");
                }
                if (normalizer) {
                    if (!(tokenFilterFactory instanceof MultiTermAwareComponent)) {
                        throw new IllegalArgumentException("Custom normalizer may not use filter [" + tokenFilterFactory.name() + "]");
                    }
                    tokenFilterFactory = (TokenFilterFactory)((MultiTermAwareComponent)((Object)tokenFilterFactory)).getMultiTermComponent();
                }
                tokenFilterFactoryList.add(tokenFilterFactory);
            }
        }
        if (!referringFilters.isEmpty()) {
            if (indexSettings == null) {
                Settings settings = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 0).put("index.number_of_shards", 1).put("index.uuid", UUIDs.randomBase64UUID()).build();
                IndexMetaData metaData = IndexMetaData.builder("_na_").settings(settings).build();
                indexSettings = new IndexSettings(metaData, Settings.EMPTY);
            }
            Map<String, TokenFilterFactory> prebuiltFilters = analysisRegistry.buildTokenFilterFactories(indexSettings);
            for (ReferringFilterFactory rff : referringFilters) {
                rff.setReferences(prebuiltFilters);
            }
        }
        return tokenFilterFactoryList;
    }

    private static Tuple<String, TokenizerFactory> parseTokenizerFactory(AnalyzeRequest request, IndexAnalyzers indexAnalzyers, AnalysisRegistry analysisRegistry, Environment environment) throws IOException {
        TokenizerFactory tokenizerFactory;
        String name;
        AnalyzeRequest.NameOrDefinition tokenizer = request.tokenizer();
        if (tokenizer.definition != null) {
            Settings settings = TransportAnalyzeAction.getAnonymousSettings(tokenizer.definition);
            String tokenizerTypeName = settings.get("type");
            if (tokenizerTypeName == null) {
                throw new IllegalArgumentException("Missing [type] setting for anonymous tokenizer: " + tokenizer.definition);
            }
            AnalysisModule.AnalysisProvider<TokenizerFactory> tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizerTypeName);
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("failed to find global tokenizer under [" + tokenizerTypeName + "]");
            }
            name = "_anonymous_tokenizer";
            tokenizerFactory = tokenizerFactoryFactory.get(TransportAnalyzeAction.getNaIndexSettings(settings), environment, "_anonymous_tokenizer", settings);
        } else if (indexAnalzyers == null) {
            tokenizerFactory = TransportAnalyzeAction.getTokenizerFactory(analysisRegistry, environment, tokenizer.name);
            name = tokenizer.name;
        } else {
            AnalysisModule.AnalysisProvider<TokenizerFactory> tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizer.name, indexAnalzyers.getIndexSettings());
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("failed to find tokenizer under [" + tokenizer.name + "]");
            }
            name = tokenizer.name;
            tokenizerFactory = tokenizerFactoryFactory.get(indexAnalzyers.getIndexSettings(), environment, tokenizer.name, AnalysisRegistry.getSettingsFromIndexSettings(indexAnalzyers.getIndexSettings(), "index.analysis.tokenizer." + tokenizer.name));
        }
        return new Tuple((Object)name, (Object)tokenizerFactory);
    }

    private static TokenizerFactory getTokenizerFactory(AnalysisRegistry analysisRegistry, Environment environment, String name) throws IOException {
        AnalysisModule.AnalysisProvider<TokenizerFactory> tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(name);
        if (tokenizerFactoryFactory == null) {
            throw new IllegalArgumentException("failed to find global tokenizer under [" + name + "]");
        }
        TokenizerFactory tokenizerFactory = tokenizerFactoryFactory.get(environment, name);
        return tokenizerFactory;
    }

    private static IndexSettings getNaIndexSettings(Settings settings) {
        IndexMetaData metaData = IndexMetaData.builder("_na_").settings(settings).build();
        return new IndexSettings(metaData, Settings.EMPTY);
    }

    private static Settings getAnonymousSettings(Settings providerSetting) {
        return Settings.builder().put(providerSetting).put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 0).put("index.number_of_shards", 1).put("index.uuid", UUIDs.randomBase64UUID()).build();
    }

    private static class TokenListCreator {
        int lastPosition = -1;
        int lastOffset = 0;
        List<AnalyzeResponse.AnalyzeToken> tokens = new ArrayList<AnalyzeResponse.AnalyzeToken>();

        TokenListCreator() {
        }

        private void analyze(TokenStream stream, Analyzer analyzer, String field, Set<String> includeAttributes) {
            try {
                stream.reset();
                CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                PositionIncrementAttribute posIncr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                OffsetAttribute offset = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
                TypeAttribute type = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
                PositionLengthAttribute posLen = (PositionLengthAttribute)stream.addAttribute(PositionLengthAttribute.class);
                while (stream.incrementToken()) {
                    int increment = posIncr.getPositionIncrement();
                    if (increment > 0) {
                        this.lastPosition += increment;
                    }
                    this.tokens.add(new AnalyzeResponse.AnalyzeToken(term.toString(), this.lastPosition, this.lastOffset + offset.startOffset(), this.lastOffset + offset.endOffset(), posLen.getPositionLength(), type.type(), TransportAnalyzeAction.extractExtendedAttributes(stream, includeAttributes)));
                }
                stream.end();
                this.lastOffset += offset.endOffset();
                this.lastPosition += posIncr.getPositionIncrement();
                this.lastPosition += analyzer.getPositionIncrementGap(field);
                this.lastOffset += analyzer.getOffsetGap(field);
            }
            catch (IOException e) {
                try {
                    throw new ElasticsearchException("failed to analyze", (Throwable)e, new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{stream});
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{stream});
        }

        private AnalyzeResponse.AnalyzeToken[] getArrayTokens() {
            return this.tokens.toArray(new AnalyzeResponse.AnalyzeToken[this.tokens.size()]);
        }
    }
}

