/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.CodePosition;
import jadx.api.JadxDecompiler;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.codegen.CodeWriter;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class JavaClass
implements JavaNode {
    private final JadxDecompiler decompiler;
    private final ClassNode cls;
    private final JavaClass parent;
    private List<JavaClass> innerClasses = Collections.emptyList();
    private List<JavaField> fields = Collections.emptyList();
    private List<JavaMethod> methods = Collections.emptyList();

    JavaClass(ClassNode classNode, JadxDecompiler decompiler) {
        this.decompiler = decompiler;
        this.cls = classNode;
        this.parent = null;
    }

    JavaClass(ClassNode classNode, JavaClass parent) {
        this.decompiler = null;
        this.cls = classNode;
        this.parent = parent;
    }

    public String getCode() {
        CodeWriter code = this.cls.getCode();
        if (code == null) {
            this.decompile();
            code = this.cls.getCode();
            if (code == null) {
                return "";
            }
        }
        return code.getCodeStr();
    }

    public synchronized void decompile() {
        if (this.decompiler == null) {
            return;
        }
        if (this.cls.getCode() == null) {
            this.decompiler.processClass(this.cls);
            this.load();
        }
    }

    ClassNode getClassNode() {
        return this.cls;
    }

    private void load() {
        int methodsCount;
        int fieldsCount;
        JadxDecompiler rootDecompiler = this.getRootDecompiler();
        int inClsCount = this.cls.getInnerClasses().size();
        if (inClsCount != 0) {
            ArrayList<JavaClass> list = new ArrayList<JavaClass>(inClsCount);
            for (ClassNode inner : this.cls.getInnerClasses()) {
                if (inner.contains(AFlag.DONT_GENERATE)) continue;
                JavaClass javaClass = new JavaClass(inner, this);
                javaClass.load();
                list.add(javaClass);
                rootDecompiler.getClassesMap().put(inner, javaClass);
            }
            this.innerClasses = Collections.unmodifiableList(list);
        }
        if ((fieldsCount = this.cls.getFields().size()) != 0) {
            ArrayList<JavaField> flds = new ArrayList<JavaField>(fieldsCount);
            for (FieldNode f : this.cls.getFields()) {
                if (f.contains(AFlag.DONT_GENERATE)) continue;
                JavaField javaField = new JavaField(f, this);
                flds.add(javaField);
                rootDecompiler.getFieldsMap().put(f, javaField);
            }
            this.fields = Collections.unmodifiableList(flds);
        }
        if ((methodsCount = this.cls.getMethods().size()) != 0) {
            ArrayList<JavaMethod> mths = new ArrayList<JavaMethod>(methodsCount);
            for (MethodNode m : this.cls.getMethods()) {
                if (m.contains(AFlag.DONT_GENERATE)) continue;
                JavaMethod javaMethod = new JavaMethod(this, m);
                mths.add(javaMethod);
                rootDecompiler.getMethodsMap().put(m, javaMethod);
            }
            Collections.sort(mths, new Comparator<JavaMethod>(){

                @Override
                public int compare(JavaMethod o1, JavaMethod o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.methods = Collections.unmodifiableList(mths);
        }
    }

    private JadxDecompiler getRootDecompiler() {
        if (this.parent != null) {
            return this.parent.getRootDecompiler();
        }
        return this.decompiler;
    }

    private Map<CodePosition, Object> getCodeAnnotations() {
        this.decompile();
        return this.cls.getCode().getAnnotations();
    }

    public Map<CodePosition, JavaNode> getUsageMap() {
        Map<CodePosition, Object> map = this.getCodeAnnotations();
        if (map.isEmpty() || this.decompiler == null) {
            return Collections.emptyMap();
        }
        HashMap<CodePosition, JavaNode> resultMap = new HashMap<CodePosition, JavaNode>(map.size());
        for (Map.Entry<CodePosition, Object> entry : map.entrySet()) {
            JavaNode node;
            CodePosition codePosition = entry.getKey();
            Object obj = entry.getValue();
            if (!(obj instanceof LineAttrNode) || (node = this.convertNode(obj)) == null) continue;
            resultMap.put(codePosition, node);
        }
        return resultMap;
    }

    @Nullable
    private JavaNode convertNode(Object obj) {
        if (!(obj instanceof LineAttrNode)) {
            return null;
        }
        if (obj instanceof ClassNode) {
            return this.getRootDecompiler().getClassesMap().get(obj);
        }
        if (obj instanceof MethodNode) {
            return this.getRootDecompiler().getMethodsMap().get(obj);
        }
        if (obj instanceof FieldNode) {
            return this.getRootDecompiler().getFieldsMap().get(obj);
        }
        return null;
    }

    @Nullable
    public JavaNode getJavaNodeAtPosition(int line, int offset) {
        Map<CodePosition, Object> map = this.getCodeAnnotations();
        if (map.isEmpty()) {
            return null;
        }
        Object obj = map.get(new CodePosition(line, offset));
        if (obj == null) {
            return null;
        }
        return this.convertNode(obj);
    }

    @Nullable
    public CodePosition getDefinitionPosition(int line, int offset) {
        JavaNode javaNode = this.getJavaNodeAtPosition(line, offset);
        if (javaNode == null) {
            return null;
        }
        return this.getDefinitionPosition(javaNode);
    }

    @Nullable
    public CodePosition getDefinitionPosition(JavaNode javaNode) {
        JavaClass jCls = javaNode.getTopParentClass();
        jCls.decompile();
        int defLine = javaNode.getDecompiledLine();
        if (defLine == 0) {
            return null;
        }
        return new CodePosition(jCls, defLine, 0);
    }

    public Integer getSourceLine(int decompiledLine) {
        this.decompile();
        return this.cls.getCode().getLineMapping().get(decompiledLine);
    }

    @Override
    public String getName() {
        return this.cls.getShortName();
    }

    @Override
    public String getFullName() {
        return this.cls.getFullName();
    }

    public String getPackage() {
        return this.cls.getPackage();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.parent;
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.parent == null ? this : this.parent.getTopParentClass();
    }

    public AccessInfo getAccessInfo() {
        return this.cls.getAccessFlags();
    }

    public List<JavaClass> getInnerClasses() {
        this.decompile();
        return this.innerClasses;
    }

    public List<JavaField> getFields() {
        this.decompile();
        return this.fields;
    }

    public List<JavaMethod> getMethods() {
        this.decompile();
        return this.methods;
    }

    @Override
    public int getDecompiledLine() {
        return this.cls.getDecompiledLine();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JavaClass && this.cls.equals(((JavaClass)o).cls);
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public String toString() {
        return this.cls.getFullName() + "[ " + this.getFullName() + " ]";
    }
}

