/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.PrimitiveTransferable;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class CopyAction
extends JosmAction {
    public CopyAction() {
        super(I18n.tr("Copy", new Object[0]), "copy", I18n.tr("Copy selected objects to paste buffer.", new Object[0]), Shortcut.registerShortcut("system:copy", I18n.tr("Edit: {0}", I18n.tr("Copy", new Object[0])), 67, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Copy"));
        MainApplication.registerActionShortcut(this, Shortcut.registerShortcut("system:copy:cua", I18n.tr("Edit: {0}", I18n.tr("Copy", new Object[0])), 155, 5006));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<Object> selection;
        DataSet set = this.getLayerManager().getActiveDataSet();
        Collection<Object> collection = selection = set == null ? Collections.emptySet() : set.getSelected();
        if (selection.isEmpty()) {
            this.showEmptySelectionWarning();
            return;
        }
        CopyAction.copy(this.getLayerManager().getActiveDataLayer(), selection);
    }

    public static void copy(OsmDataLayer source, Collection<OsmPrimitive> primitives) {
        ClipboardUtils.copy(new PrimitiveTransferable(PrimitiveTransferData.getDataWithReferences(primitives), source));
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection(true);
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    protected void showEmptySelectionWarning() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select something to copy.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
    }
}

