/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.Collections;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmIdTask
extends DownloadOsmTask {
    private static final String URL_ID_PATTERN = "https?://www\\.(osm|openstreetmap)\\.org/(node|way|relation)/(\\p{Digit}+).*";

    @Override
    public String[] getPatterns() {
        return new String[]{URL_ID_PATTERN};
    }

    @Override
    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        Matcher matcher = Pattern.compile(URL_ID_PATTERN).matcher(url);
        if (matcher.matches()) {
            OsmPrimitiveType type = OsmPrimitiveType.from(matcher.group(2));
            long id = Long.parseLong(matcher.group(3));
            SimplePrimitiveId primitiveId = new SimplePrimitiveId(id, type);
            DownloadPrimitivesWithReferrersTask downloadTask = new DownloadPrimitivesWithReferrersTask(settings.isNewLayer(), Collections.singletonList(primitiveId), true, true, null, null);
            return MainApplication.worker.submit(downloadTask);
        }
        throw new IllegalStateException("Failed to parse id from " + url);
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download OSM object by ID", new Object[0]);
    }
}

