#ifndef _EFL_UI_VIEW_LIST_EO_H_
#define _EFL_UI_VIEW_LIST_EO_H_

#ifndef _EFL_UI_VIEW_LIST_EO_CLASS_TYPE
#define _EFL_UI_VIEW_LIST_EO_CLASS_TYPE

typedef Eo Efl_Ui_View_List;

#endif

#ifndef _EFL_UI_VIEW_LIST_EO_TYPES
#define _EFL_UI_VIEW_LIST_EO_TYPES

typedef struct _Efl_Ui_View_List_Item_Event
{
  Efl_Ui_Layout_Object *layout;
  Efl_Model *child;
  int index;
} Efl_Ui_View_List_Item_Event;


#endif
#define EFL_UI_VIEW_LIST_CLASS efl_ui_view_list_class_get()

EWAPI const Efl_Class *efl_ui_view_list_class_get(void);

EOAPI void efl_ui_view_list_relayout_set(Eo *obj, Efl_Ui_View_List_Relayout *object);

EOAPI Efl_Ui_View_List_Relayout *efl_ui_view_list_relayout_get(const Eo *obj);

/**
 * @brief Enable/disable homogeneous mode.
 *
 * @param[in] obj The object.
 * @param[in] homogeneous Assume the items within the genlist are of the same
 * height and width. Default is @c false.
 *
 * @ingroup Efl_Ui_View_List
 */
EOAPI void efl_ui_view_list_homogeneous_set(Eo *obj, Eina_Bool homogeneous);

/**
 * @brief Get whether the homogeneous mode is enabled.
 *
 * @param[in] obj The object.
 *
 * @return Assume the items within the genlist are of the same height and
 * width. Default is @c false.
 *
 * @ingroup Efl_Ui_View_List
 */
EOAPI Eina_Bool efl_ui_view_list_homogeneous_get(const Eo *obj);

/**
 * @brief Listview select mode.
 *
 * @param[in] obj The object.
 * @param[in] mode The select mode.
 *
 * @ingroup Efl_Ui_View_List
 */
EOAPI void efl_ui_view_list_select_mode_set(Eo *obj, Elm_Object_Select_Mode mode);

/**
 * @brief Listview select mode.
 *
 * @param[in] obj The object.
 *
 * @return The select mode.
 *
 * @ingroup Efl_Ui_View_List
 */
EOAPI Elm_Object_Select_Mode efl_ui_view_list_select_mode_get(const Eo *obj);

EOAPI void efl_ui_view_list_default_style_set(Eo *obj, Eina_Stringshare *style);

EOAPI Eina_Stringshare *efl_ui_view_list_default_style_get(const Eo *obj);

/**
 * @brief Listview layout factory set.
 *
 * @param[in] obj The object.
 * @param[in] factory The factory.
 *
 * @ingroup Efl_Ui_View_List
 */
EOAPI void efl_ui_view_list_layout_factory_set(Eo *obj, Efl_Ui_Factory *factory);

EWAPI extern const Efl_Event_Description _EFL_UI_VIEW_LIST_EVENT_ITEM_REALIZED;

/**
 * No description
 * @return Efl_Ui_View_List_Item_Event
 */
#define EFL_UI_VIEW_LIST_EVENT_ITEM_REALIZED (&(_EFL_UI_VIEW_LIST_EVENT_ITEM_REALIZED))

EWAPI extern const Efl_Event_Description _EFL_UI_VIEW_LIST_EVENT_ITEM_UNREALIZED;

/**
 * No description
 * @return Efl_Ui_View_List_Item_Event
 */
#define EFL_UI_VIEW_LIST_EVENT_ITEM_UNREALIZED (&(_EFL_UI_VIEW_LIST_EVENT_ITEM_UNREALIZED))

EWAPI extern const Efl_Event_Description _EFL_UI_VIEW_LIST_EVENT_ITEM_FOCUSED;

/**
 * No description
 * @return Efl_Ui_View_List_Item_Event
 */
#define EFL_UI_VIEW_LIST_EVENT_ITEM_FOCUSED (&(_EFL_UI_VIEW_LIST_EVENT_ITEM_FOCUSED))

EWAPI extern const Efl_Event_Description _EFL_UI_VIEW_LIST_EVENT_ITEM_UNFOCUSED;

/**
 * No description
 * @return Efl_Ui_View_List_Item_Event
 */
#define EFL_UI_VIEW_LIST_EVENT_ITEM_UNFOCUSED (&(_EFL_UI_VIEW_LIST_EVENT_ITEM_UNFOCUSED))

EWAPI extern const Efl_Event_Description _EFL_UI_VIEW_LIST_EVENT_ITEM_HIGHLIGHTED;

/**
 * No description
 * @return Efl_Ui_View_List_Item_Event
 */
#define EFL_UI_VIEW_LIST_EVENT_ITEM_HIGHLIGHTED (&(_EFL_UI_VIEW_LIST_EVENT_ITEM_HIGHLIGHTED))

EWAPI extern const Efl_Event_Description _EFL_UI_VIEW_LIST_EVENT_ITEM_UNHIGHLIGHTED;

/**
 * No description
 * @return Efl_Ui_View_List_Item_Event
 */
#define EFL_UI_VIEW_LIST_EVENT_ITEM_UNHIGHLIGHTED (&(_EFL_UI_VIEW_LIST_EVENT_ITEM_UNHIGHLIGHTED))

EWAPI extern const Efl_Event_Description _EFL_UI_VIEW_LIST_EVENT_ITEM_SELECTED;

/**
 * No description
 * @return Efl_Ui_View_List_Item_Event
 */
#define EFL_UI_VIEW_LIST_EVENT_ITEM_SELECTED (&(_EFL_UI_VIEW_LIST_EVENT_ITEM_SELECTED))

EWAPI extern const Efl_Event_Description _EFL_UI_VIEW_LIST_EVENT_ITEM_UNSELECTED;

/**
 * No description
 * @return Efl_Ui_View_List_Item_Event
 */
#define EFL_UI_VIEW_LIST_EVENT_ITEM_UNSELECTED (&(_EFL_UI_VIEW_LIST_EVENT_ITEM_UNSELECTED))

#endif
