/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gennbo.NBODialog;
import org.gennbo.NBOFileAcceptor;
import org.gennbo.NBOFileData47;
import org.gennbo.NBOUtil;
import org.jmol.i18n.GT;

class NBOFileHandler
extends JPanel {
    protected static final String sep = System.getProperty("line.separator");
    private static final String[] PLOT_AND_NBO_FILES = PT.split("31;32;33;34;35;36;37;38;39;40;41;42;46;nbo", ";");
    static final String[] MODEL_OPEN_OPTIONS = new String[]{"<Select File Type>", "[.47]   NBO Archive", "[.gau]  Gaussian Input", "[.log]  Gaussian Output", "[.gms]  GAMESS Input", "[.adf]  ADF Input", "[.jag]  Jaguar Input", "[.mm2]  MM2-Input", "[.mnd]  Dewar Type Input", "[.mp]   Molpro Input", "[.nw]   NWChem Input", "[.orc]  Orca Input", "[.pqs]  PQS Input", "[.qc]   Q-Chem Input", "[.cfi]  NBO Cartesian", "[.vfi]  NBO Valence", "[.xyz]  XYZ", "[.mol]  MOL"};
    static final String[] MODEL_SAVE_OPTIONS = new String[]{"<Select File Type>", "Gaussian Input             [.gau]", "Gaussian Input (Cartesian) [.gau]", "Gaussian Input (z-Matrix)  [.gau]", "GAMESS Input               [.gms]", "ADF Input                  [.adf]", "Jaguar Input               [.jag]", "MM2-Input                  [.mm2]", "Dewar Type Input           [.mnd]", "Molpro Input               [.mp]", "NWChem Input               [.nw]", "Orca Input                 [.orc]", "PQS Input                  [.pqs]", "Q-Chem Input               [.qc]", "NBO Cartesian              [.cfi]", "NBO Valence                [.vfi]", "XYZ                        [.xyz]", "MOL                        [.mol]"};
    private static final String GAUSSIAN_EXTENSIONS = ";gau;g09;com;";
    static final String MODEL_SAVE_FILE_EXTENSIONS = ";adf;cfi;gms;jag;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;gau;g09;com;";
    static final String MODEL_OPEN_FILE_EXTENSIONS = ";adf;cfi;gms;jag;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;gau;g09;com;log;47;";
    static final String JMOL_EXTENSIONS = ";xyz;mol;";
    protected static final int MODE_MODEL_OPEN = 1;
    protected static final int MODE_RUN = 2;
    protected static final int MODE_VIEW = 3;
    protected static final int MODE_SEARCH = 4;
    protected static final int MODE_MODEL_SAVE = 5;
    protected File file47;
    protected JTextField tfDir;
    protected JTextField tfName;
    protected JTextField tfExt;
    JButton btnBrowse;
    protected String fullFilePath;
    protected String jobStem;
    private String useExt;
    private NBODialog dialog;
    private boolean canReRun;
    private NBOFileAcceptor fileAcceptor;
    private int dialogMode;
    protected String saveFilter;

    NBOFileHandler(String jobName, int mode, NBODialog dialog, NBOFileAcceptor acceptor) {
        this.dialogMode = mode;
        this.useExt = mode == 5 ? "" : "47";
        this.dialog = dialog;
        this.fileAcceptor = acceptor;
        this.canReRun = true;
        this.fullFilePath = dialog.getWorkingPath();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(350, 40));
        this.setPreferredSize(new Dimension(350, 40));
        this.setMinimumSize(new Dimension(350, 40));
        GridBagConstraints c = new GridBagConstraints();
        boolean showExtensionField = mode == 5 || mode == 1;
        boolean canEditTextFields = false;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.tfDir = new JTextField();
        this.tfDir.setPreferredSize(new Dimension(110, 20));
        this.tfDir.setEditable(canEditTextFields);
        this.tfDir.setText(this.fullFilePath);
        this.add((Component)this.tfDir, c);
        c.gridx = 1;
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(120, 20));
        this.tfName.setEditable(canEditTextFields);
        this.add((Component)this.tfName, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)new JLabel("         folder"), c);
        c.gridx = 1;
        this.add((Component)new JLabel("          name"), c);
        c.gridx = 2;
        c.gridy = 0;
        this.tfExt = new JTextField();
        this.tfExt.setPreferredSize(new Dimension(40, 20));
        this.tfExt.setEditable(canEditTextFields);
        this.tfExt.setText(this.useExt);
        if (showExtensionField) {
            this.add((Component)this.tfExt, c);
            c.gridy = 1;
            this.add((Component)new JLabel("  ext"), c);
        }
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 2;
        this.btnBrowse = new JButton(mode == 5 ? "Save" : "Browse");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBOFileHandler.this.doFileBrowsePressed();
            }
        });
        this.add((Component)this.btnBrowse, c);
        this.setJobStemAndTextFieldName(jobName);
        this.setTextFields(this.fullFilePath, jobName, this.useExt);
    }

    protected boolean doFileBrowsePressed() {
        int i;
        if (this.dialog.nboService.getWorkingMode() == 2 && (i = JOptionPane.showConfirmDialog(this.dialog, "Warning, changing jobs while running GenNBO can effect output files.\nContinue anyway?")) == 1) {
            return false;
        }
        final NBOFileChooser myChooser = new NBOFileChooser();
        String folder = this.tfDir.getText().trim();
        String name = this.tfName.getText();
        String ext = this.tfExt.getText();
        if (folder.length() > 0) {
            this.fullFilePath = NBOUtil.getWindowsFullNameFor(folder, name.length() == 0 ? " " : name + (this.useExt.equals("47") ? ".47" : ""), null);
        }
        switch (this.dialogMode) {
            case 1: {
                if (ext.length() == 0) {
                    ext = "*";
                }
                String path = NBOUtil.getWindowsFullNameFor(folder, name, ext);
                NBOFileHandler.setFilterForDialog(myChooser, 1, ext);
                if (path.endsWith("/")) {
                    path = path + "*.*";
                }
                if (!path.equals("")) {
                    myChooser.setSelectedFile(new File(path));
                }
                if (myChooser.showDialog(this, GT._("Select")) != 0) break;
                File newFile = myChooser.getSelectedFile();
                if (newFile.toString().indexOf(".") < 0) {
                    this.dialog.logError("File not found");
                    return false;
                }
                this.fullFilePath = newFile.getParent();
                this.jobStem = NBOUtil.getJobStem(newFile);
                ext = NBOUtil.getExt(newFile);
                if (!PT.isOneOf(ext, MODEL_OPEN_FILE_EXTENSIONS)) {
                    this.dialog.logError("Invalid file extension");
                    break;
                }
                this.setTextFields(this.fullFilePath, this.jobStem, ext);
                this.dialog.saveWorkingPath(this.fullFilePath);
                this.fileAcceptor.acceptFile(1, this.fullFilePath, this.jobStem, ext, null);
                return true;
            }
            case 5: {
                boolean isAll;
                myChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("fileFilterChanged")) {
                            NBOFileHandler.this.saveFilter = myChooser.getFileFilter().getDescription();
                        }
                    }
                });
                ext = ext.equals("") ? "cfi" : ext;
                this.useExt = ext;
                NBOFileHandler.setFilterForDialog(myChooser, 5, this.fileAcceptor.getDefaultFilterOption());
                String savePath = NBOUtil.getWindowsFolderFor(folder, this.fullFilePath);
                savePath = name.equals("") && this.jobStem != null ? this.tfDir.getText() + "/" + (this.jobStem.equals("") ? "new.cfi" : this.jobStem + (ext.contains(";") ? "" : "." + ext)) : this.tfDir.getText() + "/" + name + "." + ext;
                myChooser.setSelectedFile(new File(savePath));
                if (myChooser.showSaveDialog(this) != 0) break;
                File newFile = myChooser.getSelectedFile();
                this.fullFilePath = newFile.getParent();
                this.jobStem = NBOUtil.getJobStem(newFile);
                ext = NBOUtil.getExt(newFile);
                boolean bl = isAll = this.saveFilter.indexOf("(") < 0;
                ext = isAll ? ext : (this.saveFilter.indexOf(",") < 0 ? this.saveFilter.substring(this.saveFilter.indexOf("(*") + 3, this.saveFilter.length() - 1) : (PT.isOneOf(ext, GAUSSIAN_EXTENSIONS) ? ext : "gau"));
                newFile = new File(this.fullFilePath, this.jobStem + "." + ext);
                if (!PT.isOneOf(ext, MODEL_SAVE_FILE_EXTENSIONS)) {
                    this.dialog.logError("Invalid file extension");
                    break;
                }
                if (newFile.exists() && JOptionPane.showConfirmDialog(null, "File " + newFile + " already exists, do you want to overwrite contents?", "Warning", 0) != 0) {
                    return false;
                }
                this.dialog.inputFileHandler.setTextFields(this.fullFilePath, this.jobStem, ext);
                this.dialog.saveWorkingPath(this.fullFilePath);
                this.fileAcceptor.acceptFile(5, this.fullFilePath, NBOUtil.getJobStem(newFile), ext, isAll ? null : this.saveFilter.substring(0, this.saveFilter.indexOf("(*")));
                return true;
            }
            default: {
                myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt));
                myChooser.setSelectedFile(new File(this.fullFilePath));
                if (myChooser.showDialog(this, GT._("Select")) != 0) break;
                return this.loadSelectedFile(myChooser.getSelectedFile());
            }
        }
        return false;
    }

    private static void setFilterForDialog(JFileChooser chooser, int mode, String defaultExt) {
        int i;
        FileNameExtensionFilter defaultFilter = null;
        if (defaultExt != null && PT.isOneOf(defaultExt, GAUSSIAN_EXTENSIONS)) {
            defaultExt = "gau";
        }
        boolean isOpen = mode == 1;
        String[] options = isOpen ? MODEL_OPEN_OPTIONS : MODEL_SAVE_OPTIONS;
        String allFiles = isOpen ? MODEL_OPEN_FILE_EXTENSIONS : MODEL_SAVE_FILE_EXTENSIONS;
        String[] allExt = allFiles.substring(1, allFiles.length() - 1).split(";");
        FileNameExtensionFilter[] filters = new FileNameExtensionFilter[options.length - 1];
        for (i = 1; i < options.length; ++i) {
            String[] stringArray;
            String option = options[i];
            int pt = option.indexOf("[");
            int pt2 = option.indexOf("]");
            String label = pt == 0 ? option.substring(pt2 + 1).trim() : option.substring(0, pt).trim();
            String ext = option.substring(pt + 1, pt2).trim().substring(1);
            if (ext.equals("gau")) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "gau";
                stringArray2[1] = "g09";
                stringArray = stringArray2;
                stringArray2[2] = "com";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = ext;
            }
            String[] a = stringArray;
            String ext2 = ext.equals("gau") ? " (*.gau, *.g09, *.com)" : " (*." + ext + ")";
            filters[i - 1] = new FileNameExtensionFilter(label + ext2, a);
            if (defaultFilter != null || !ext.equals(defaultExt) && label.indexOf(defaultExt) < 0) continue;
            defaultFilter = filters[i - 1];
        }
        for (i = 0; i < filters.length; ++i) {
            chooser.addChoosableFileFilter(filters[i]);
        }
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("All NBOPro-" + (isOpen ? "Readable" : "Writable") + " Types", allExt));
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(true);
        if (defaultFilter != null) {
            chooser.setFileFilter(defaultFilter);
        }
    }

    protected boolean loadSelectedFile(File selectedFile) {
        this.dialog.nboService.restartIfNecessary();
        this.file47 = selectedFile;
        if (this.dialog.dialogMode == 1) {
            return true;
        }
        if (!this.useExt.equals("47")) {
            this.setJobStemAndTextFieldName(NBOUtil.getJobStem(this.file47));
            this.dialog.modelPanel.loadModelFromNBO(this.fullFilePath, this.jobStem, this.useExt);
            this.tfExt.setText(this.useExt);
            return true;
        }
        this.canReRun = true;
        this.setFile47(this.file47);
        this.dialog.runPanel.doLogJobName(this.jobStem);
        this.fullFilePath = this.file47.getParent();
        this.dialog.saveWorkingPath(this.fullFilePath);
        return true;
    }

    private void setJobStemAndTextFieldName(String name) {
        this.jobStem = name;
        this.tfName.setText(this.jobStem);
    }

    protected void setFile47(File file47) {
        this.dialog.logValue("Input file=" + file47);
        this.deletePlotAndNBOFiles(false);
        this.file47 = file47;
        if (file47.getName().indexOf(".") > 0) {
            this.jobStem = NBOUtil.getJobStem(file47);
        }
        if (this.dialog.modelOrigin == 4) {
            this.deletePlotAndNBOFiles(true);
        }
        this.setTextFields(file47.getParent(), this.jobStem, this.useExt);
        if (!NBOUtil.getExt(file47).equals("47")) {
            return;
        }
        if (NBOUtil.fixPath(file47.getParent().toString()).equals(this.dialog.nboService.getServerPath(null))) {
            JOptionPane.showMessageDialog(this, "Select a directory that does not contain the NBOServe executable,\nor select a new location for your NBOServe executable");
            return;
        }
        this.fullFilePath = file47.getParent();
        boolean canLoad = true;
        boolean isOK = true;
        String msg = "";
        if (this.dialog.dialogMode != 1 && this.dialog.dialogMode != 2) {
            for (String nn : PLOT_AND_NBO_FILES) {
                File f3 = this.newNBOFile(nn);
                if (f3.exists() && (!nn.equals("36") || f3.length() != 0L)) continue;
                msg = "file " + f3 + " is missing or zero length";
                isOK = false;
                break;
            }
        }
        if (!isOK) {
            if (this.dialog.dialogMode != 2) {
                if (this.canReRun) {
                    this.canReRun = false;
                    this.dialog.runPanel.doRunGenNBOJob("PLOT");
                } else {
                    this.dialog.alertError("Error occurred during run: " + msg);
                }
                return;
            }
            canLoad = false;
        }
        if (canLoad) {
            this.dialog.loadNewFile(new File(this.fullFilePath + "/" + this.jobStem + ".47"));
        } else if (this.dialog.dialogMode == 2) {
            this.dialog.modelPanel.loadModelFromNBO(this.fullFilePath, this.jobStem, this.useExt);
            this.setJobStemAndTextFieldName(this.jobStem);
            this.tfExt.setText("47");
        }
    }

    private NBOFileData47 read47File(boolean doAll) {
        NBOFileData47 fileData = new NBOFileData47();
        String allKeywords = "";
        SB data = new SB();
        if (!NBOUtil.read47FileBuffered(this.file47, data, doAll)) {
            return fileData;
        }
        String s = PT.trim(data.toString(), "\t\r\n ");
        String[] tokens = PT.split(s, "$END");
        if (tokens.length == 0) {
            return fileData;
        }
        SB preParams = new SB();
        SB postParams = new SB();
        SB params = preParams;
        int n = tokens.length;
        for (int i = 0; i < n; ++i) {
            s = PT.trim(tokens[i], "\t\r\n ");
            if (params == preParams && s.indexOf("$NBO") >= 0) {
                String[] prePost = PT.split(s, "$NBO");
                if (prePost[0].length() > 0) {
                    params.append(s).append(sep);
                }
                allKeywords = PT.trim(prePost[1], "\t\r\n ");
                params = postParams;
                if (doAll) continue;
                break;
            }
            params.append(s).append(sep).append("$END").append(sep);
        }
        this.dialog.logInfo("$NBO: " + allKeywords, 4);
        return fileData.set(PT.rep(preParams.toString(), "FORMAT=PRECISE", ""), allKeywords, postParams.toString());
    }

    protected void deletePlotAndNBOFiles(boolean andUserDir) {
        if (this.jobStem.length() == 0) {
            return;
        }
        for (String ext : PLOT_AND_NBO_FILES) {
            try {
                new File(this.dialog.nboService.getServerPath(this.jobStem + "." + ext)).delete();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (andUserDir) {
            for (String ext : PLOT_AND_NBO_FILES) {
                try {
                    NBOUtil.newNBOFile(this.file47, ext).delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.file47 = null;
        if (this.dialog.dialogMode == 3) {
            this.dialog.viewPanel.resetView();
        }
    }

    protected void setTextFields(String dir, String name, String ext) {
        if (dir != null) {
            this.tfDir.setText(dir);
        }
        if (name != null) {
            this.tfName.setText(name);
        }
        if (this.tfExt != null) {
            this.tfExt.setText(ext);
        }
        if (dir != null && name != null && ext != null) {
            this.dialog.modelPanel.modelSetSaveParametersFromInput(this, dir, name, ext);
            this.file47 = new File(dir + "\\" + name + "." + ext);
        }
    }

    protected String getFileData(String fileName) {
        return this.dialog.vwr.getAsciiFileOrNull(fileName);
    }

    boolean writeToFile(String fileName, String s) {
        String ret = s == null ? null : this.dialog.vwr.writeTextFile(fileName, s);
        return ret != null && ret.startsWith("OK");
    }

    void setBrowseEnabled(boolean b) {
        this.btnBrowse.setEnabled(b);
    }

    String getInputFileData(String nn) {
        return this.getFileData(this.newNBOFile(nn).toString());
    }

    File newNBOFile(String nn) {
        return NBOUtil.newNBOFile(this.file47, nn);
    }

    String fixJobName(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            name = this.jobStem;
        }
        int i = name.length();
        while (--i >= 0) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            name = name.substring(0, i) + "_" + name.substring(i + 1);
        }
        return name;
    }

    NBOFileData47 update47File(String jobName, String keywords, boolean isRun) {
        if (!this.useExt.equals("47")) {
            return null;
        }
        String fileName47 = this.file47.getAbsolutePath();
        NBOFileData47 fileData = this.read47File(true);
        String oldData = isRun ? this.getFileData(fileName47) : null;
        String newFileData = fileData.preParams + "$NBO\n " + "FILE=" + jobName + " " + keywords + "  $END" + sep + fileData.postKeywordData;
        if (this.writeToFile(fileName47, newFileData)) {
            if (oldData != null) {
                this.writeToFile(fileName47 + "$", oldData);
            }
            fileData.noFileKeywords = keywords;
            fileData.allKeywords = "FILE=" + jobName + " " + keywords;
            this.dialog.runPanel.doLogJobName(jobName);
            this.dialog.runPanel.doLogKeywords(keywords);
            return fileData;
        }
        this.dialog.logInfo("Could not create " + fileName47, 2);
        return null;
    }

    boolean checkSwitch47To(String jobName) {
        if (!jobName.equals(this.jobStem)) {
            int i = JOptionPane.showConfirmDialog(null, "Note: Plot files are being created with name \"" + jobName + "\", which does not match your file name \"" + this.jobStem + "\"\nTo continue, we must create a new .47 file \"" + jobName + ".47\" so that all files related to this job are under the same name. Continue?", "Warning", 0);
            if (i != 0) {
                return false;
            }
            String data = this.dialog.vwr.getAsciiFileOrNull(this.file47.getAbsolutePath());
            this.setJobStemAndTextFieldName(jobName);
            this.setTextFields(this.tfDir.getText(), jobName, "47");
            if (data != null) {
                this.writeToFile(this.file47.getAbsolutePath(), data);
            }
        }
        return true;
    }

    void removeAllTemporaryRunFiles() {
        File[] files;
        for (File f : files = new File(this.fullFilePath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File theFile) {
                if (theFile.isFile()) {
                    return theFile.getName().endsWith("$");
                }
                return false;
            }
        })) {
            this.deleteFile(f);
        }
    }

    void deleteFile(File f) {
        try {
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            System.out.println("Could not delete " + f);
        }
    }

    String get47KeywordsNoFile() {
        return this.read47File((boolean)false).noFileKeywords;
    }

    boolean checkNBOComplete(boolean saveErr) {
        boolean isOK;
        this.deleteFile(this.newNBOFile("err$"));
        String data = this.getInputFileData("nbo");
        boolean bl = isOK = data != null && data.contains("NBO analysis completed");
        if (!isOK) {
            this.deleteFile(this.newNBOFile("nbo"));
            if (saveErr && data != null) {
                this.writeToFile(this.newNBOFile("err$").getAbsolutePath(), data);
            }
            this.writeToFile(this.newNBOFile("47").getAbsolutePath(), this.getInputFileData("47$"));
            this.deletePlotFiles(this.fullFilePath);
        }
        this.deleteFile(this.newNBOFile("47$"));
        this.deleteServerFiles();
        return isOK;
    }

    private void deleteServerFiles() {
        this.deletePlotFiles(null);
    }

    void deletePlotFiles(String path) {
        File[] files;
        final boolean isServerPath = path == null;
        for (File f : files = new File(isServerPath ? this.dialog.nboService.getServerPath(null) : path).listFiles(new FileFilter(){

            @Override
            public boolean accept(File theFile) {
                if (theFile.isFile()) {
                    String name = theFile.getName();
                    return name.startsWith(NBOFileHandler.this.jobStem + ".3") || name.startsWith(NBOFileHandler.this.jobStem + ".4") && (isServerPath || name.indexOf(".47") < 0) || name.equals(NBOFileHandler.this.jobStem + ".nbo");
                }
                return false;
            }
        })) {
            this.deleteFile(f);
        }
    }

    static String getEss(String ext, String saveType) {
        return PT.isOneOf(ext = ext.toLowerCase(), GAUSSIAN_EXTENSIONS) ? (saveType != null && saveType.contains("Cartesian") ? "gc" : (saveType.contains("z-matrix") ? "gz" : "g")) : (ext.equals("cfi") || ext.equals("vfi") || ext.equals("log") ? ext.substring(0, 1) : (ext.equals("47") ? "a" : (ext.equals("mm2") ? "mm" : ext)));
    }

    private class NBOFileChooser
    extends JFileChooser {
        NBOFileChooser() {
        }
    }
}

