/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.comparison;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.range.comparison.CharComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.DoubleComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.FloatComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.IntComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.LongComparisonGenerator;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"getComparisonGeneratorForPrimitiveType", "Lorg/jetbrains/kotlin/codegen/range/comparison/ComparisonGenerator;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "getComparisonGeneratorForRangeContainsCall", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isPrimitiveIntOrCoercible", "", "backend"})
public final class ComparisonGeneratorKt {
    @NotNull
    public static final ComparisonGenerator getComparisonGeneratorForPrimitiveType(@NotNull Type type2) {
        ComparisonGenerator comparisonGenerator;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        if (Intrinsics.areEqual(type2, Type.CHAR_TYPE)) {
            comparisonGenerator = CharComparisonGenerator.INSTANCE;
        } else if (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(type2)) {
            comparisonGenerator = IntComparisonGenerator.INSTANCE;
        } else if (Intrinsics.areEqual(type2, Type.LONG_TYPE)) {
            comparisonGenerator = LongComparisonGenerator.INSTANCE;
        } else if (Intrinsics.areEqual(type2, Type.FLOAT_TYPE)) {
            comparisonGenerator = FloatComparisonGenerator.INSTANCE;
        } else if (Intrinsics.areEqual(type2, Type.DOUBLE_TYPE)) {
            comparisonGenerator = DoubleComparisonGenerator.INSTANCE;
        } else {
            throw (Throwable)new UnsupportedOperationException("Unexpected primitive type: " + type2);
        }
        return comparisonGenerator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final ComparisonGenerator getComparisonGeneratorForRangeContainsCall(@NotNull ExpressionCodegen codegen, @NotNull ResolvedCall<? extends CallableDescriptor> call2) {
        ComparisonGenerator comparisonGenerator;
        Type asmValueParameterType;
        Type asmElementType;
        block9: {
            block8: {
                Annotated annotated;
                Intrinsics.checkParameterIsNotNull(codegen, "codegen");
                Intrinsics.checkParameterIsNotNull(call2, "call");
                CallableDescriptor descriptor2 = call2.getResultingDescriptor();
                Annotated annotated2 = descriptor2.getExtensionReceiverParameter();
                if (annotated2 == null || (annotated2 = annotated2.getType()) == null) {
                    ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
                    annotated2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
                }
                if (annotated2 == null) return null;
                Annotated annotated3 = annotated = annotated2;
                Intrinsics.checkExpressionValueIsNotNull(annotated3, "receiverType");
                KotlinType kotlinType = RangeCodegenUtilKt.getRangeOrProgressionElementType((KotlinType)annotated3);
                if (kotlinType == null) return null;
                KotlinType elementType = kotlinType;
                List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.valueParameters");
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.singleOrNull(list2);
                Annotated annotated4 = valueParameterDescriptor;
                if (valueParameterDescriptor == null) return null;
                KotlinType kotlinType2 = annotated4.getType();
                annotated4 = kotlinType2;
                if (kotlinType2 == null) return null;
                Annotated annotated5 = annotated4;
                asmElementType = codegen.asmType(elementType);
                asmValueParameterType = codegen.asmType((KotlinType)annotated5);
                if (Intrinsics.areEqual(asmElementType, asmValueParameterType)) {
                    Type type2 = asmElementType;
                    Intrinsics.checkExpressionValueIsNotNull(type2, "asmElementType");
                    comparisonGenerator = ComparisonGeneratorKt.getComparisonGeneratorForPrimitiveType(type2);
                    return comparisonGenerator;
                }
                Type type3 = asmElementType;
                Intrinsics.checkExpressionValueIsNotNull(type3, "asmElementType");
                if (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(type3)) {
                    Type type4 = asmValueParameterType;
                    Intrinsics.checkExpressionValueIsNotNull(type4, "asmValueParameterType");
                    if (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(type4)) {
                        comparisonGenerator = IntComparisonGenerator.INSTANCE;
                        return comparisonGenerator;
                    }
                }
                if (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmElementType) && Intrinsics.areEqual(asmValueParameterType, Type.LONG_TYPE)) break block8;
                Type type5 = asmValueParameterType;
                Intrinsics.checkExpressionValueIsNotNull(type5, "asmValueParameterType");
                if (!ComparisonGeneratorKt.isPrimitiveIntOrCoercible(type5) || !Intrinsics.areEqual(asmElementType, Type.LONG_TYPE)) break block9;
            }
            comparisonGenerator = LongComparisonGenerator.INSTANCE;
            return comparisonGenerator;
        }
        if (!Intrinsics.areEqual(asmElementType, Type.FLOAT_TYPE) || !Intrinsics.areEqual(asmValueParameterType, Type.DOUBLE_TYPE)) {
            if (!Intrinsics.areEqual(asmElementType, Type.DOUBLE_TYPE)) return null;
            if (!Intrinsics.areEqual(asmValueParameterType, Type.FLOAT_TYPE)) return null;
        }
        comparisonGenerator = DoubleComparisonGenerator.INSTANCE;
        return comparisonGenerator;
    }

    private static final boolean isPrimitiveIntOrCoercible(@NotNull Type $receiver) {
        return Intrinsics.areEqual($receiver, Type.INT_TYPE) || Intrinsics.areEqual($receiver, Type.SHORT_TYPE) || Intrinsics.areEqual($receiver, Type.BYTE_TYPE);
    }
}

