/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.ClassPresenterPanel;
import org.netbeans.modules.profiler.heapwalk.InstancesController;
import org.netbeans.modules.profiler.heapwalk.LegendPanel;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;

public class InstancesControllerUI
extends JPanel {
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private AbstractButton presenter;
    private CardLayout contents;
    private InstancesController instancesController;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JSplitPane browsersSplit;
    private JSplitPane contentsSplit;
    private LegendPanel legendPanel;

    public InstancesControllerUI(InstancesController instancesController) {
        this.instancesController = instancesController;
        this.initComponents();
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    public void update() {
        if (this.contents != null) {
            if (this.instancesController.getSelectedClass() == null) {
                this.contents.show(this, NO_DATA);
            } else {
                this.contents.show(this, DATA);
            }
        }
    }

    private void initComponents() {
        JPanel jPanel = this.instancesController.getFieldsBrowserController().getPanel();
        JPanel jPanel2 = this.instancesController.getReferencesBrowserController().getPanel();
        JPanel jPanel3 = this.instancesController.getInstancesListController().getPanel();
        this.browsersSplit = new JExtendedSplitPane(0, (Component)jPanel, (Component)jPanel2);
        this.tweakSplitPaneUI(this.browsersSplit);
        this.browsersSplit.setResizeWeight(0.5);
        this.contentsSplit = new JExtendedSplitPane(1, (Component)jPanel3, (Component)this.browsersSplit);
        this.tweakSplitPaneUI(this.contentsSplit);
        this.contentsSplit.setDividerLocation(jPanel3.getPreferredSize().width);
        ClassPresenterPanel classPresenterPanel = this.instancesController.getClassPresenterPanel();
        classPresenterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, this.getBackground()), classPresenterPanel.getBorder()));
        this.legendPanel = new LegendPanel(true);
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.setOpaque(false);
        this.dataPanel.add((Component)classPresenterPanel, "North");
        this.dataPanel.add((Component)this.contentsSplit, "Center");
        this.dataPanel.add((Component)this.legendPanel, "South");
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hTMLTextArea = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                InstancesControllerUI.this.instancesController.getHeapFragmentWalker().switchToClassesView();
            }
        };
        hTMLTextArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String string = Icons.getResource((String)"LanguageIcons.Class");
        String string2 = Bundle.InstancesControllerUI_NoClassDefinedMsg("<a href='#'><img border='0' align='bottom' src='nbresloc:/" + string + "'></a>");
        hTMLTextArea.setText(string2);
        this.noDataPanel.add((Component)hTMLTextArea, "Center");
        this.contents = new CardLayout();
        this.setLayout(this.contents);
        this.add((Component)this.noDataPanel, NO_DATA);
        this.add((Component)this.dataPanel, DATA);
        LegendUpdater legendUpdater = new LegendUpdater();
        jPanel.addHierarchyListener(legendUpdater);
        jPanel2.addHierarchyListener(legendUpdater);
    }

    private void tweakSplitPaneUI(JSplitPane jSplitPane) {
        jSplitPane.setOpaque(false);
        jSplitPane.setBorder(null);
        jSplitPane.setDividerSize(3);
        if (!(jSplitPane.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)jSplitPane.getUI()).getDivider();
        if (basicSplitPaneDivider != null) {
            basicSplitPaneDivider.setBorder(null);
        }
    }

    private class LegendUpdater
    implements HierarchyListener {
        private LegendUpdater() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            JPanel jPanel = InstancesControllerUI.this.instancesController.getFieldsBrowserController().getPanel();
            JPanel jPanel2 = InstancesControllerUI.this.instancesController.getReferencesBrowserController().getPanel();
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                InstancesControllerUI.this.legendPanel.setGCRootVisible(jPanel2.isShowing());
                InstancesControllerUI.this.legendPanel.setVisible(jPanel.isShowing() || jPanel2.isShowing());
            }
        }
    }

    private static class Presenter
    extends JToggleButton {
        public Presenter() {
            this.setText(Bundle.InstancesControllerUI_ViewCaption());
            this.setToolTipText(Bundle.InstancesControllerUI_ViewDescr());
            this.setIcon(BrowserUtils.ICON_INSTANCE);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width += 4;
            return dimension;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

