/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.DiffCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.DiffFlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;

public class CPUResultsDiff
extends CPUResultsSnapshot {
    private final CPUResultsSnapshot snapshot1;
    private final CPUResultsSnapshot snapshot2;

    public CPUResultsDiff(CPUResultsSnapshot cPUResultsSnapshot, CPUResultsSnapshot cPUResultsSnapshot2) {
        this.snapshot1 = cPUResultsSnapshot;
        this.snapshot2 = cPUResultsSnapshot2;
        this.threadCCTContainers = cPUResultsSnapshot.threadCCTContainers;
    }

    @Override
    public boolean isCollectingTwoTimeStamps() {
        return this.snapshot1.collectingTwoTimeStamps && this.snapshot2.collectingTwoTimeStamps;
    }

    @Override
    public CPUCCTContainer getContainerForThread(int n, int n2) {
        return this.snapshot1.getContainerForThread(n, n2);
    }

    @Override
    public DiffFlatProfileContainer getFlatProfile(int n, int n2) {
        FlatProfileContainer flatProfileContainer = this.snapshot1.getFlatProfile(n, n2);
        FlatProfileContainer flatProfileContainer2 = this.snapshot2.getFlatProfile(n, n2);
        return DiffFlatProfileContainer.create(flatProfileContainer, flatProfileContainer2);
    }

    @Override
    public FlatProfileContainer getFlatProfile(Collection<Integer> collection, int n) {
        FlatProfileContainer flatProfileContainer = this.snapshot1.getFlatProfile(collection, n);
        FlatProfileContainer flatProfileContainer2 = this.snapshot2.getFlatProfile(this.threads2(collection), n);
        return DiffFlatProfileContainer.create(flatProfileContainer, flatProfileContainer2);
    }

    @Override
    public String[] getInstrMethodClasses(int n) {
        return this.snapshot1.getInstrMethodClasses(n);
    }

    @Override
    public String[] getInstrMethodNames() {
        return this.snapshot1.getInstrMethodNames();
    }

    @Override
    public String[] getInstrMethodSignatures() {
        return this.snapshot1.getInstrMethodSignatures();
    }

    @Override
    public String[] getMethodClassNameAndSig(int n, int n2) {
        return n < 0 ? this.snapshot2.getMethodClassNameAndSig(-n, n2) : this.snapshot1.getMethodClassNameAndSig(n, n2);
    }

    @Override
    public Map<Integer, ClientUtils.SourceCodeSelection> getMethodIDMap(int n) {
        int n2;
        HashMap<Integer, ClientUtils.SourceCodeSelection> hashMap = new HashMap<Integer, ClientUtils.SourceCodeSelection>();
        for (n2 = 0; n2 < this.snapshot1.instrMethodClassesViews[n].length; ++n2) {
            hashMap.put(n2, this.snapshot1.getSourceCodeSelection(n2, n));
        }
        for (n2 = 0; n2 < this.snapshot2.instrMethodClassesViews[n].length; ++n2) {
            hashMap.put(-n2, this.snapshot2.getSourceCodeSelection(n2, n));
        }
        return hashMap;
    }

    @Override
    public int getNInstrMethods() {
        return this.snapshot1.getNInstrMethods();
    }

    @Override
    public int getNThreads() {
        return this.snapshot1.getNThreads();
    }

    @Override
    public PrestimeCPUCCTNode getReverseCCT(int n, int n2, int n3) {
        PrestimeCPUCCTNode prestimeCPUCCTNode = this.snapshot1.getReverseCCT(n, n2, n3);
        PrestimeCPUCCTNode prestimeCPUCCTNode2 = this.snapshot2.getReverseCCT(n, n2, n3);
        return new DiffCPUCCTNode(prestimeCPUCCTNode, prestimeCPUCCTNode2);
    }

    @Override
    public PrestimeCPUCCTNode getRootNode(int n) {
        PrestimeCPUCCTNode prestimeCPUCCTNode = this.snapshot1.getRootNode(n);
        PrestimeCPUCCTNode prestimeCPUCCTNode2 = this.snapshot2.getRootNode(n);
        return new DiffCPUCCTNode(prestimeCPUCCTNode, prestimeCPUCCTNode2);
    }

    @Override
    public PrestimeCPUCCTNode getRootNode(int n, Collection<Integer> collection, boolean bl) {
        PrestimeCPUCCTNode prestimeCPUCCTNode = this.snapshot1.getRootNode(n, collection, bl);
        PrestimeCPUCCTNode prestimeCPUCCTNode2 = this.snapshot2.getRootNode(n, this.threads2(collection), bl);
        return new DiffCPUCCTNode(prestimeCPUCCTNode, prestimeCPUCCTNode2);
    }

    @Override
    public PrestimeCPUCCTNode getReverseRootNode(int n, Collection<Integer> collection, boolean bl) {
        PrestimeCPUCCTNode prestimeCPUCCTNode = this.snapshot1.getReverseRootNode(n, collection, bl);
        PrestimeCPUCCTNode prestimeCPUCCTNode2 = this.snapshot2.getReverseRootNode(n, this.threads2(collection), bl);
        return new DiffCPUCCTNode(prestimeCPUCCTNode, prestimeCPUCCTNode2);
    }

    private Collection<Integer> threads2(Collection<Integer> collection) {
        if (collection == null || collection.isEmpty()) {
            return collection;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Object object = collection.iterator();
        while (object.hasNext()) {
            int n = object.next();
            hashSet.add(this.getThreadNameForId(n));
        }
        object = new HashSet();
        for (int n : this.snapshot2.getThreadIds()) {
            if (!hashSet.contains(this.snapshot2.getThreadNameForId(n))) continue;
            object.add(n);
        }
        return object;
    }

    public long getBound(int n) {
        CCTNode[] cCTNodeArray;
        long l = Long.MIN_VALUE;
        PrestimeCPUCCTNode prestimeCPUCCTNode = this.getRootNode(n);
        for (CCTNode cCTNode : cCTNodeArray = prestimeCPUCCTNode.getChildren()) {
            l = Math.max(l, Math.abs(((PrestimeCPUCCTNode)cCTNode).getTotalTime0()));
        }
        return l;
    }

    @Override
    public void filterForward(String string, int n, PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked) {
    }

    @Override
    public void saveSortParams(int n, boolean bl, CCTNode cCTNode) {
    }

    @Override
    public int[] getThreadIds() {
        return this.snapshot1.getThreadIds();
    }

    @Override
    public String getThreadNameForId(int n) {
        return this.snapshot1.getThreadNameForId(n);
    }

    @Override
    public String[] getThreadNames() {
        return this.snapshot1.getThreadNames();
    }
}

