/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public final class VisibilityFilter
extends SearchFilterDefinition {
    private static final VisibilityFilter INSTANCE = new VisibilityFilter();

    private VisibilityFilter() {
    }

    @Override
    public boolean searchFile(FileObject fileObject) throws IllegalArgumentException {
        if (fileObject.isFolder()) {
            throw new IllegalArgumentException("file (not folder) expected");
        }
        return this.isPermittedByQuery(fileObject) && this.isPrimaryFile(fileObject);
    }

    private boolean isPermittedByQuery(FileObject fileObject) {
        return VisibilityQuery.getDefault().isVisible(fileObject);
    }

    private boolean isPrimaryFile(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject.getPrimaryFile().equals(fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            String string = "DataObject not found for file:" + fileObject;
            Logger logger = Logger.getLogger(VisibilityFilter.class.getName());
            logger.log(Level.INFO, string, dataObjectNotFoundException);
            return true;
        }
    }

    @Override
    public SearchFilterDefinition.FolderResult traverseFolder(FileObject fileObject) throws IllegalArgumentException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("folder expected");
        }
        return VisibilityQuery.getDefault().isVisible(fileObject) ? SearchFilterDefinition.FolderResult.TRAVERSE : SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
    }

    public static SearchFilterDefinition getInstance() {
        return INSTANCE;
    }
}

