import tsInterfaces = require("./typesystem-interfaces");
import ts = require("./typesystem");
export declare class ValidationResult {
    result: any;
    num: number;
}
export interface Promise {
    then(instance: any, reject?: any): any;
    resolve(arg: any): any;
}
export interface IContentProvider {
    contextPath(): string;
    normalizePath(url: string): string;
    content(reference: string): string;
    hasAsyncRequests(): boolean;
    resolvePath(context: string, relativePath: string): string;
    isAbsolutePath(uri: string): boolean;
    contentAsync(arg: any): Promise;
    promiseResolve(arg: any): Promise;
}
export interface IExtendedContentProvider extends IContentProvider {
    rootPath(): string;
    isWebPath(p: string): boolean;
    relativePath(from: string, to: string): string;
}
export declare class JSONSchemaObject {
    private schema;
    private provider;
    jsonSchema: any;
    private graph;
    constructor(schema: string, provider: IContentProvider);
    private EXAMPLE_ERROR_ENTRY;
    private SCHEMA_ERROR_ENTRY;
    fixRequired(obj: any): void;
    getType(): string;
    validateObject(object: any): any;
    getMissingReferences(references: any[], normalize?: boolean): any[];
    private getSchemaPath(schema, normalize?);
    private patchSchema(schema);
    private removeFragmentPartOfIDs(obj);
    private collectRefContainers(rootObject, refContainers);
    validate(content: any, alreadyAccepted?: any[]): void;
    /**
     * Checks for z-schema messages related to the inability to assign to a property of non-object variables.
     * @param message
     *
     * @returns null if related message is not detected, assigned value if it can be detected, and empty string
     * if related message is detected, but assigned value can not be found.
     */
    static checkIfNonObjectAssignmentFailure(message: string): string;
    validateSelf(alreadyAccepted?: any[]): void;
    private setupId(json, path);
    private acceptErrors(key, errors, exampleContent, throwImmediately?, isWarning?);
    contentAsync(_reference: any): Promise;
    private static SCHEMA_ERROR_CODES;
    private static EXAMPLE_ERROR_CODES;
    private updateGraph(json, schemaPath);
}
export interface ValidationError {
    code: string;
    params: string[];
    message: string;
    path: string;
}
export declare class XMLSchemaObject {
    private schema;
    private provider;
    private schemaString;
    private extraElementData;
    private namspacePrefix;
    references: any;
    constructor(schema: string, provider: IContentProvider);
    getType(): string;
    private contentToResult;
    validateObject(object: any): any;
    collectReferences(xmlString: string, context: string, references: any): string;
    getMissingReferences(): string[];
    private collectReferencesAsync(xmlString, context, references);
    loadSchemaReferencesAsync(): Promise;
    validate(xml: any): void;
    private handleReferenceElement(content);
    private acceptErrors(key, errors, throwImmediately?);
}
export interface Schema {
    getType(): string;
    validate(content: string): void;
    validateObject(object: any): void;
}
export declare function getJSONSchema(content: string, provider: IContentProvider): any;
export declare function getXMLSchema(content: string, provider: IContentProvider): any;
export declare function createSchema(content: string, provider: IContentProvider): Schema;
export declare function messageToValidationError(message: string, isExample?: boolean): ts.ValidationError;
export declare function getJSONRange(jsonStrig: string, jsonObj: any, jsonPath: string): tsInterfaces.RangeObject;
export declare function tryParseJSON(content: any, isExample: boolean): void;
