/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class TlsECCUtils {
    public static final Integer EXT_ec_point_formats = Integers.valueOf((int)11);

    public static void addSupportedPointFormatsExtension(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_ec_point_formats, TlsECCUtils.createSupportedPointFormatsExtension(sArray));
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_ec_point_formats);
        return byArray == null ? null : TlsECCUtils.readSupportedPointFormatsExtension(byArray);
    }

    public static byte[] createSupportedPointFormatsExtension(short[] sArray) throws IOException {
        if (sArray == null || !Arrays.contains((short[])sArray, (short)0)) {
            sArray = Arrays.append((short[])sArray, (short)0);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(sArray);
    }

    public static short[] readSupportedPointFormatsExtension(byte[] byArray) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(byArray);
        if (!Arrays.contains((short[])sArray, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return sArray;
    }

    public static boolean containsECCipherSuites(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (!TlsECCUtils.isECCipherSuite(nArray[i])) continue;
            return true;
        }
        return false;
    }

    public static int getMinimumCurveBits(int n) {
        return TlsECCUtils.isECCipherSuite(n) ? 1 : 0;
    }

    public static boolean isECCipherSuite(int n) {
        switch (TlsUtils.getKeyExchangeAlgorithm(n)) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static short getCompressionFormat(int n) throws IOException {
        if (NamedGroup.isPrimeCurve(n)) {
            return 1;
        }
        if (NamedGroup.isChar2Curve(n)) {
            return 2;
        }
        throw new TlsFatalAlert(47);
    }

    public static boolean isCompressionPreferred(short[] sArray, int n) throws IOException {
        return TlsECCUtils.isCompressionPreferred(sArray, TlsECCUtils.getCompressionFormat(n));
    }

    public static boolean isCompressionPreferred(short[] sArray, short s) {
        if (sArray == null || s == 0) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            short s2 = sArray[i];
            if (s2 == 0) {
                return false;
            }
            if (s2 != s) continue;
            return true;
        }
        return false;
    }

    public static void checkPointEncoding(short[] sArray, int n, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 1) {
            throw new TlsFatalAlert(47);
        }
        short s = TlsECCUtils.getActualFormat(n, byArray);
        TlsECCUtils.checkActualFormat(sArray, s);
    }

    public static void checkActualFormat(short[] sArray, short s) throws IOException {
        if (!(s == 0 || sArray != null && Arrays.contains((short[])sArray, (short)s))) {
            throw new TlsFatalAlert(47);
        }
    }

    public static short getActualFormat(int n, byte[] byArray) throws IOException {
        switch (byArray[0]) {
            case 2: 
            case 3: {
                return TlsECCUtils.getCompressionFormat(n);
            }
            case 4: {
                return 0;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsECConfig readECConfig(short[] sArray, InputStream inputStream) throws IOException {
        short s = TlsUtils.readUint8(inputStream);
        if (s != 3) {
            throw new TlsFatalAlert(40);
        }
        int n = TlsUtils.readUint16(inputStream);
        if (!NamedGroup.refersToASpecificCurve(n)) {
            throw new TlsFatalAlert(47);
        }
        boolean bl = TlsECCUtils.isCompressionPreferred(sArray, n);
        TlsECConfig tlsECConfig = new TlsECConfig();
        tlsECConfig.setNamedGroup(n);
        tlsECConfig.setPointCompression(bl);
        return tlsECConfig;
    }

    public static TlsECConfig receiveECConfig(TlsECConfigVerifier tlsECConfigVerifier, short[] sArray, InputStream inputStream) throws IOException {
        TlsECConfig tlsECConfig = TlsECCUtils.readECConfig(sArray, inputStream);
        if (!tlsECConfigVerifier.accept(tlsECConfig)) {
            throw new TlsFatalAlert(47);
        }
        return tlsECConfig;
    }

    public static void writeECConfig(TlsECConfig tlsECConfig, OutputStream outputStream) throws IOException {
        TlsECCUtils.writeNamedECParameters(tlsECConfig.getNamedGroup(), outputStream);
    }

    public static void writeNamedECParameters(int n, OutputStream outputStream) throws IOException {
        if (!NamedGroup.refersToASpecificCurve(n)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, outputStream);
        TlsUtils.checkUint16(n);
        TlsUtils.writeUint16(n, outputStream);
    }
}

