/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.CompassController;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class CompassPanel
extends JPanel
implements DialogView {
    private final CompassController controller;
    private JLabel xLabel;
    private JSpinner xSpinner;
    private JLabel yLabel;
    private JSpinner ySpinner;
    private JLabel diameterLabel;
    private JSpinner diameterSpinner;
    private JCheckBox visibleCheckBox;
    private JComponent northDirectionComponent;
    private JLabel longitudeLabel;
    private JSpinner longitudeSpinner;
    private JLabel latitudeLabel;
    private JSpinner latitudeSpinner;
    private JLabel timeZoneLabel;
    private JComboBox timeZoneComboBox;
    private JLabel northDirectionLabel;
    private JSpinner northDirectionSpinner;
    private String dialogTitle;

    public CompassPanel(UserPreferences userPreferences, CompassController compassController) {
        super(new GridBagLayout());
        this.controller = compassController;
        this.createComponents(userPreferences, compassController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences);
    }

    private void createComponents(UserPreferences userPreferences, final CompassController compassController) {
        Object object;
        String string = userPreferences.getLengthUnit().getName();
        this.xLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, CompassPanel.class, "xLabel.text", string));
        float f = userPreferences.getLengthUnit().getMaximumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.xSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.setLength(Float.valueOf(compassController.getX()));
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        compassController.addPropertyChangeListener(CompassController.Property.X, propertyChangeListener);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                compassController.removePropertyChangeListener(CompassController.Property.X, propertyChangeListener);
                compassController.setX(nullableSpinnerLengthModel.getLength().floatValue());
                compassController.addPropertyChangeListener(CompassController.Property.X, propertyChangeListener);
            }
        });
        this.yLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, CompassPanel.class, "yLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.ySpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.setLength(Float.valueOf(compassController.getY()));
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        compassController.addPropertyChangeListener(CompassController.Property.Y, propertyChangeListener2);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                compassController.removePropertyChangeListener(CompassController.Property.Y, propertyChangeListener2);
                compassController.setY(nullableSpinnerLengthModel2.getLength().floatValue());
                compassController.addPropertyChangeListener(CompassController.Property.Y, propertyChangeListener2);
            }
        });
        this.diameterLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, CompassPanel.class, "diameterLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, userPreferences.getLengthUnit().getMinimumLength(), userPreferences.getLengthUnit().getMaximumLength() / 10.0f);
        this.diameterSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        nullableSpinnerLengthModel3.setLength(Float.valueOf(compassController.getDiameter()));
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        compassController.addPropertyChangeListener(CompassController.Property.DIAMETER, propertyChangeListener3);
        nullableSpinnerLengthModel3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                compassController.removePropertyChangeListener(CompassController.Property.DIAMETER, propertyChangeListener3);
                compassController.setDiameter(nullableSpinnerLengthModel3.getLength().floatValue());
                compassController.addPropertyChangeListener(CompassController.Property.DIAMETER, propertyChangeListener3);
            }
        });
        this.visibleCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, CompassPanel.class, "visibleCheckBox.text", new Object[0]));
        this.visibleCheckBox.setSelected(compassController.isVisible());
        final PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CompassPanel.this.visibleCheckBox.setSelected((Boolean)propertyChangeEvent.getNewValue());
            }
        };
        compassController.addPropertyChangeListener(CompassController.Property.VISIBLE, propertyChangeListener4);
        this.visibleCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                compassController.removePropertyChangeListener(CompassController.Property.VISIBLE, propertyChangeListener4);
                compassController.setVisible(CompassPanel.this.visibleCheckBox.isSelected());
                compassController.addPropertyChangeListener(CompassController.Property.VISIBLE, propertyChangeListener4);
            }
        });
        this.latitudeLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, CompassPanel.class, "latitudeLabel.text", new Object[0]));
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(new Float(0.0f), new Float(-90.0f), new Float(90.0f), new Float(5.0f));
        this.latitudeSpinner = new AutoCommitSpinner(spinnerNumberModel);
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.latitudeSpinner.getEditor()).getTextField();
        NumberFormatter numberFormatter = (NumberFormatter)((DefaultFormatterFactory)jFormattedTextField.getFormatterFactory()).getDefaultFormatter();
        numberFormatter.setFormat(new DecimalFormat("N ##0.000;S ##0.000"));
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        SwingTools.addAutoSelectionOnFocusGain(jFormattedTextField);
        spinnerNumberModel.setValue(Float.valueOf(compassController.getLatitudeInDegrees()));
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel.setValue((Float)propertyChangeEvent.getNewValue());
            }
        };
        compassController.addPropertyChangeListener(CompassController.Property.LATITUDE_IN_DEGREES, propertyChangeListener5);
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                compassController.removePropertyChangeListener(CompassController.Property.LATITUDE_IN_DEGREES, propertyChangeListener5);
                compassController.setLatitudeInDegrees(((Number)spinnerNumberModel.getValue()).floatValue());
                compassController.addPropertyChangeListener(CompassController.Property.LATITUDE_IN_DEGREES, propertyChangeListener5);
            }
        });
        this.longitudeLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, CompassPanel.class, "longitudeLabel.text", new Object[0]));
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(new Float(0.0f), new Float(-180.0f), new Float(180.0f), new Float(5.0f));
        this.longitudeSpinner = new AutoCommitSpinner(spinnerNumberModel2);
        jFormattedTextField = ((JSpinner.DefaultEditor)this.longitudeSpinner.getEditor()).getTextField();
        numberFormatter = (NumberFormatter)((DefaultFormatterFactory)jFormattedTextField.getFormatterFactory()).getDefaultFormatter();
        numberFormatter.setFormat(new DecimalFormat("E ##0.000;W ##0.000"));
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        SwingTools.addAutoSelectionOnFocusGain(jFormattedTextField);
        spinnerNumberModel2.setValue(Float.valueOf(compassController.getLongitudeInDegrees()));
        final PropertyChangeListener propertyChangeListener6 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel2.setValue((Float)propertyChangeEvent.getNewValue());
            }
        };
        compassController.addPropertyChangeListener(CompassController.Property.LONGITUDE_IN_DEGREES, propertyChangeListener6);
        spinnerNumberModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                compassController.removePropertyChangeListener(CompassController.Property.LONGITUDE_IN_DEGREES, propertyChangeListener6);
                compassController.setLongitudeInDegrees(((Number)spinnerNumberModel2.getValue()).floatValue());
                compassController.addPropertyChangeListener(CompassController.Property.LONGITUDE_IN_DEGREES, propertyChangeListener6);
            }
        });
        this.timeZoneLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, CompassPanel.class, "timeZoneLabel.text", new Object[0]));
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(TimeZone.getAvailableIDs()));
        arrayList.remove("GMT");
        arrayList.remove("GMT0");
        arrayList.remove("Etc/GMT0");
        arrayList.remove("Etc/GMT-0");
        arrayList.remove("Etc/GMT+0");
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            if (!((String)object).startsWith("Etc/GMT")) continue;
            arrayList.set(i, TimeZone.getTimeZone((String)object).getDisplayName(Locale.ENGLISH));
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        this.timeZoneComboBox = new JComboBox<Object>(objectArray);
        this.timeZoneComboBox.setSelectedItem(compassController.getTimeZone());
        object = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CompassPanel.this.timeZoneComboBox.setSelectedItem(propertyChangeEvent.getNewValue());
            }
        };
        compassController.addPropertyChangeListener(CompassController.Property.TIME_ZONE, (PropertyChangeListener)object);
        this.timeZoneComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = (String)object;
                if (string.startsWith("GMT")) {
                    if (!OperatingSystem.isMacOSX()) {
                        this.setToolTipText(string);
                    }
                } else {
                    String string2 = TimeZone.getTimeZone(string).getDisplayName();
                    if (OperatingSystem.isMacOSX()) {
                        object = string + " - " + string2;
                    } else {
                        this.setToolTipText(string + " - " + string2);
                    }
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.timeZoneComboBox.addItemListener(new ItemListener((PropertyChangeListener)object){
            final /* synthetic */ PropertyChangeListener val$timeZoneChangeListener;
            {
                this.val$timeZoneChangeListener = propertyChangeListener;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                compassController.removePropertyChangeListener(CompassController.Property.TIME_ZONE, this.val$timeZoneChangeListener);
                compassController.setTimeZone((String)CompassPanel.this.timeZoneComboBox.getSelectedItem());
                compassController.addPropertyChangeListener(CompassController.Property.TIME_ZONE, this.val$timeZoneChangeListener);
            }
        });
        this.timeZoneComboBox.setPrototypeDisplayValue("GMT");
        this.northDirectionLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, CompassPanel.class, "northDirectionLabel.text", new Object[0]));
        final AutoCommitSpinner.SpinnerModuloNumberModel spinnerModuloNumberModel = new AutoCommitSpinner.SpinnerModuloNumberModel(0, 0, 360, 5);
        this.northDirectionSpinner = new AutoCommitSpinner(spinnerModuloNumberModel);
        spinnerModuloNumberModel.setValue(new Integer(Math.round(compassController.getNorthDirectionInDegrees())));
        this.northDirectionComponent = new JComponent(){

            public Dimension getPreferredSize() {
                return new Dimension(35, 35);
            }

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.translate(this.getWidth() / 2, this.getHeight() / 2);
                graphics2D.scale(this.getWidth() / 2, this.getWidth() / 2);
                graphics2D.rotate(Math.toRadians(compassController.getNorthDirectionInDegrees()));
                graphics2D.setStroke(new BasicStroke(0.5f / (float)this.getWidth()));
                graphics2D.draw(new Ellipse2D.Float(-0.7f, -0.7f, 1.4f, 1.4f));
                graphics2D.draw(new Line2D.Float(-0.85f, 0.0f, -0.7f, 0.0f));
                graphics2D.draw(new Line2D.Float(0.85f, 0.0f, 0.7f, 0.0f));
                graphics2D.draw(new Line2D.Float(0.0f, -0.8f, 0.0f, -0.7f));
                graphics2D.draw(new Line2D.Float(0.0f, 0.85f, 0.0f, 0.7f));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(-0.1f, -0.8f);
                generalPath.lineTo(-0.1f, -1.0f);
                generalPath.lineTo(0.1f, -0.8f);
                generalPath.lineTo(0.1f, -1.0f);
                graphics2D.setStroke(new BasicStroke(1.5f / (float)this.getWidth()));
                graphics2D.draw(generalPath);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.moveTo(0.0f, -0.75f);
                generalPath2.lineTo(0.2f, 0.7f);
                generalPath2.lineTo(0.0f, 0.5f);
                generalPath2.lineTo(-0.2f, 0.7f);
                generalPath2.closePath();
                generalPath2.moveTo(-0.02f, 0.0f);
                generalPath2.lineTo(0.02f, 0.0f);
                graphics2D.setStroke(new BasicStroke(4 / this.getWidth()));
                graphics2D.draw(generalPath2);
            }
        };
        this.northDirectionComponent.setOpaque(false);
        final PropertyChangeListener propertyChangeListener7 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerModuloNumberModel.setValue(((Number)propertyChangeEvent.getNewValue()).intValue());
                CompassPanel.this.northDirectionComponent.repaint();
            }
        };
        compassController.addPropertyChangeListener(CompassController.Property.NORTH_DIRECTION_IN_DEGREES, propertyChangeListener7);
        spinnerModuloNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                compassController.removePropertyChangeListener(CompassController.Property.NORTH_DIRECTION_IN_DEGREES, propertyChangeListener7);
                compassController.setNorthDirectionInDegrees(((Number)spinnerModuloNumberModel.getValue()).floatValue());
                CompassPanel.this.northDirectionComponent.repaint();
                compassController.addPropertyChangeListener(CompassController.Property.NORTH_DIRECTION_IN_DEGREES, propertyChangeListener7);
            }
        });
        this.dialogTitle = userPreferences.getLocalizedString(CompassPanel.class, "compass.title", new Object[0]);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.xLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(CompassPanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
            this.xLabel.setLabelFor(this.xSpinner);
            this.yLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(CompassPanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
            this.yLabel.setLabelFor(this.ySpinner);
            this.diameterLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(CompassPanel.class, "diameterLabel.mnemonic", new Object[0])).getKeyCode());
            this.diameterLabel.setLabelFor(this.diameterSpinner);
            this.visibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(CompassPanel.class, "visibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.latitudeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(CompassPanel.class, "latitudeLabel.mnemonic", new Object[0])).getKeyCode());
            this.latitudeLabel.setLabelFor(this.latitudeSpinner);
            this.longitudeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(CompassPanel.class, "longitudeLabel.mnemonic", new Object[0])).getKeyCode());
            this.longitudeLabel.setLabelFor(this.longitudeSpinner);
            this.timeZoneLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(CompassPanel.class, "timeZoneLabel.mnemonic", new Object[0])).getKeyCode());
            this.timeZoneLabel.setLabelFor(this.timeZoneComboBox);
            this.northDirectionLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(CompassPanel.class, "northDirectionLabel.mnemonic", new Object[0])).getKeyCode());
            this.northDirectionLabel.setLabelFor(this.northDirectionSpinner);
        }
    }

    private void layoutComponents(UserPreferences userPreferences) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(CompassPanel.class, "compassRosePanel.title", new Object[0]));
        Insets insets = new Insets(0, 0, 5, 5);
        Insets insets2 = new Insets(0, 0, 5, 10);
        Insets insets3 = new Insets(0, 0, 5, 0);
        int n2 = OperatingSystem.isMacOSXLeopardOrSuperior() ? 0 : 5;
        jPanel.add((Component)this.xLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel.add((Component)this.xSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 5, 20), -10, 0));
        jPanel.add((Component)this.visibleCheckBox, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        jPanel.add((Component)this.yLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.ySpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 20), -10, 0));
        jPanel.add((Component)this.diameterLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.diameterSpinner, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, n2, 0), 0, 0));
        JPanel jPanel2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(CompassPanel.class, "geographicLocationPanel.title", new Object[0]));
        jPanel2.add((Component)this.latitudeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.latitudeSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, 20, 0));
        jPanel2.add((Component)this.northDirectionLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.northDirectionSpinner, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 5, 5), 0, 0));
        jPanel2.add((Component)this.northDirectionComponent, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel2.add((Component)this.longitudeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel2.add((Component)this.longitudeSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 20, 0));
        jPanel2.add((Component)this.timeZoneLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel2.add((Component)this.timeZoneComboBox, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.timeZoneComboBox.setPreferredSize(new Dimension(this.latitudeSpinner.getPreferredSize().width + 60, this.timeZoneComboBox.getPreferredSize().height));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void displayView(View view) {
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.northDirectionSpinner.getEditor()).getTextField();
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, jFormattedTextField) == 0 && this.controller != null) {
            this.controller.modifyCompass();
        }
    }
}

