/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class AggregateExec
extends UnaryExec
implements Unexecutable {
    private final List<? extends Expression> groupings;
    private final List<? extends NamedExpression> aggregates;

    public AggregateExec(Location location, PhysicalPlan child, List<? extends Expression> groupings, List<? extends NamedExpression> aggregates) {
        super(location, child);
        this.groupings = groupings;
        this.aggregates = aggregates;
    }

    @Override
    protected NodeInfo<AggregateExec> info() {
        return NodeInfo.create(this, AggregateExec::new, this.child(), this.groupings, this.aggregates);
    }

    @Override
    protected AggregateExec replaceChild(PhysicalPlan newChild) {
        return new AggregateExec(this.location(), newChild, this.groupings, this.aggregates);
    }

    public List<? extends Expression> groupings() {
        return this.groupings;
    }

    public List<? extends NamedExpression> aggregates() {
        return this.aggregates;
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.aggregates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groupings, this.aggregates, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggregateExec other = (AggregateExec)obj;
        return Objects.equals(this.groupings, other.groupings) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals(this.child(), other.child());
    }
}

