/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import com.inet.jortho.SpellChecker;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class EditNodeTextField
extends EditNodeBase {
    final int EDIT = 1;
    final int CANCEL = 2;
    int cursorWidth = 1;
    int xOffset = 0;
    int yOffset = -1;
    int widthAddition = 0 + this.cursorWidth + 2;
    int heightAddition = 2;
    final int MINIMAL_LEAF_WIDTH = 150;
    final int MINIMAL_WIDTH = 50;
    final int MINIMAL_HEIGHT = 20;
    private KeyEvent firstEvent;
    protected JTextField textfield;
    protected JComponent mParent;
    private final JComponent mFocusListener;
    protected static Logger logger = null;
    private Tools.IntHolder mEventSource;
    private UndoManager mUndoManager;

    public EditNodeTextField(NodeView node, String text, KeyEvent firstEvent, ModeController controller, EditNodeBase.EditControl editControl) {
        this(node, text, firstEvent, controller, editControl, node.getMap(), node);
    }

    public EditNodeTextField(NodeView node, String text, KeyEvent firstEvent, ModeController controller, EditNodeBase.EditControl editControl, JComponent pParent, JComponent pFocusListener) {
        super(node, text, controller, editControl);
        this.firstEvent = firstEvent;
        this.mParent = pParent;
        this.mFocusListener = pFocusListener;
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
    }

    public void show() {
        int ySize;
        this.textfield = this.getText().length() < 8 ? new JTextField(this.getText(), 8) : new JTextField(this.getText());
        NodeView nodeView = this.getNode();
        MindMapNode model = nodeView.getModel();
        int xSize = nodeView.getMainView().getTextWidth() + this.widthAddition;
        this.xOffset += nodeView.getMainView().getTextX();
        int xExtraWidth = 0;
        if (150 > xSize && (model.isFolded() || !model.hasChildren())) {
            xExtraWidth = 150 - xSize;
            xSize = 150;
            if (nodeView.isLeft()) {
                xExtraWidth = -xExtraWidth;
                this.textfield.setHorizontalAlignment(4);
            }
        } else if (50 > xSize) {
            xExtraWidth = 50 - xSize;
            xSize = 50;
            if (nodeView.isLeft()) {
                xExtraWidth = -xExtraWidth;
                this.textfield.setHorizontalAlignment(4);
            }
        }
        if ((ySize = nodeView.getMainView().getHeight() + this.heightAddition) < 20) {
            ySize = 20;
        }
        this.textfield.setSize(xSize, ySize);
        Font font = nodeView.getTextFont();
        MapView mapView = nodeView.getMap();
        float zoom = mapView.getZoom();
        if (zoom != 1.0f) {
            font = font.deriveFont((float)font.getSize() * zoom * 1.0f);
        }
        this.textfield.setFont(font);
        Color nodeTextColor = nodeView.getTextColor();
        this.textfield.setForeground(nodeTextColor);
        Color nodeTextBackground = nodeView.getTextBackground();
        this.textfield.setBackground(nodeTextBackground);
        this.textfield.setCaretColor(nodeTextColor);
        this.mEventSource = new Tools.IntHolder();
        this.mEventSource.setValue(1);
        final TextFieldListener textFieldListener = new TextFieldListener();
        this.textFieldListener = textFieldListener;
        this.textfield.addKeyListener(textFieldListener);
        this.textfield.addMouseListener(textFieldListener);
        this.mUndoManager = new UndoManager();
        this.textfield.getDocument().addUndoableEditListener(this.mUndoManager);
        this.textfield.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (EditNodeTextField.this.mUndoManager.canUndo()) {
                        EditNodeTextField.this.mUndoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.textfield.getInputMap().put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Undo");
        this.textfield.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (EditNodeTextField.this.mUndoManager.canRedo()) {
                        EditNodeTextField.this.mUndoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.textfield.getInputMap().put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Redo");
        this.getView().scrollNodeToVisible(nodeView, xExtraWidth);
        Point mPoint = null;
        if (mPoint == null) {
            mPoint = new Point();
            Tools.convertPointToAncestor((Component)nodeView.getMainView(), mPoint, mapView);
            if (xExtraWidth < 0) {
                mPoint.x += xExtraWidth;
            }
            mPoint.x += this.xOffset;
            mPoint.y += this.yOffset;
        }
        this.setTextfieldLoaction(mPoint);
        this.addTextfield();
        this.textfield.repaint();
        this.redispatchKeyEvents(this.textfield, this.firstEvent);
        if (checkSpelling) {
            SpellChecker.register((JTextComponent)this.textfield, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditNodeTextField.this.textfield.requestFocus();
                EditNodeTextField.this.textfield.addFocusListener(textFieldListener);
                EditNodeTextField.this.mFocusListener.addComponentListener(textFieldListener);
            }
        });
    }

    protected void addTextfield() {
        this.mParent.add((Component)this.textfield, 0);
    }

    protected void setTextfieldLoaction(Point mPoint) {
        this.textfield.setLocation(mPoint);
    }

    private void hideMe() {
        JComponent parent = (JComponent)this.textfield.getParent();
        Rectangle bounds = this.textfield.getBounds();
        this.textfield.removeFocusListener(this.textFieldListener);
        this.textfield.removeKeyListener((KeyListener)((Object)this.textFieldListener));
        this.textfield.removeMouseListener((MouseListener)((Object)this.textFieldListener));
        this.mFocusListener.removeComponentListener((ComponentListener)((Object)this.textFieldListener));
        parent.remove(this.textfield);
        parent.revalidate();
        parent.repaint(bounds);
        this.textFieldListener = null;
    }

    class TextFieldListener
    implements KeyListener,
    FocusListener,
    MouseListener,
    ComponentListener {
        private boolean checkSpelling = Resources.getInstance().getBoolProperty("check_spelling");

        TextFieldListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!EditNodeTextField.this.textfield.isVisible() || EditNodeTextField.this.mEventSource.getValue() == 2) {
                if (this.checkSpelling) {
                    EditNodeTextField.this.mEventSource.setValue(1);
                }
                return;
            }
            if (e == null) {
                EditNodeTextField.this.hideMe();
                EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
                EditNodeTextField.this.mEventSource.setValue(2);
            } else {
                EditNodeTextField.this.hideMe();
                EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isAltDown() || e.isControlDown() || e.isMetaDown() || EditNodeTextField.this.mEventSource.getValue() == 2) {
                return;
            }
            boolean commit = true;
            switch (e.getKeyCode()) {
                case 27: {
                    commit = false;
                }
                case 10: {
                    e.consume();
                    EditNodeTextField.this.mEventSource.setValue(2);
                    EditNodeTextField.this.hideMe();
                    if (commit) {
                        EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
                    } else {
                        EditNodeTextField.this.getEditControl().cancel();
                    }
                    e.consume();
                    break;
                }
                case 32: {
                    e.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.conditionallyShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.conditionallyShowPopup(e);
        }

        private void conditionallyShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                EditNodeBase.EditPopupMenu popupMenu = new EditNodeBase.EditPopupMenu(EditNodeTextField.this.textfield);
                if (this.checkSpelling) {
                    popupMenu.add(SpellChecker.createCheckerMenu());
                    popupMenu.add(SpellChecker.createLanguagesMenu());
                    EditNodeTextField.this.mEventSource.setValue(2);
                }
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
                e.consume();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.focusLost(null);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.focusLost(null);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.focusLost(null);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.focusLost(null);
        }
    }
}

