/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.browser;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.TrackInfo;

public abstract class UrlGenerator {
    private static final NumberFormat FIVE_DP = NumberFormat.getNumberInstance(Locale.UK);

    static {
        if (FIVE_DP instanceof DecimalFormat) {
            ((DecimalFormat)FIVE_DP).applyPattern("0.00000");
        }
    }

    public static String generateUrl(WebService webService, TrackInfo trackInfo) {
        switch (webService) {
            case MAP_SOURCE_GOOGLE: {
                return UrlGenerator.generateGoogleUrl(trackInfo);
            }
            case MAP_SOURCE_MAPQUEST: {
                return UrlGenerator.generateMapquestUrl(trackInfo);
            }
            case MAP_SOURCE_YAHOO: {
                return UrlGenerator.generateYahooUrl(trackInfo);
            }
            case MAP_SOURCE_BING: {
                return UrlGenerator.generateBingUrl(trackInfo);
            }
            case MAP_SOURCE_PEAKFINDER: 
            case MAP_SOURCE_GEOHACK: {
                return UrlGenerator.generateUrlForPoint(webService, trackInfo);
            }
        }
        return UrlGenerator.generateOpenStreetMapUrl(trackInfo);
    }

    private static String generateGoogleUrl(TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        double d = UrlGenerator.getMedianValue(trackInfo.getTrack().getLatRange());
        double d2 = UrlGenerator.getMedianValue(trackInfo.getTrack().getLonRange());
        double d3 = UrlGenerator.getSpan(trackInfo.getTrack().getLatRange());
        double d4 = UrlGenerator.getSpan(trackInfo.getTrack().getLonRange());
        String string = "http://" + I18nManager.getText("url.googlemaps") + "/?ll=" + FIVE_DP.format(d) + "," + FIVE_DP.format(d2) + "&spn=" + FIVE_DP.format(d3) + "," + FIVE_DP.format(d4);
        DataPoint dataPoint = trackInfo.getCurrentPoint();
        if (dataPoint != null) {
            string = String.valueOf(string) + "&q=" + FIVE_DP.format(dataPoint.getLatitude().getDouble()) + "," + FIVE_DP.format(dataPoint.getLongitude().getDouble());
            if (dataPoint.getWaypointName() != null) {
                string = String.valueOf(string) + "(" + dataPoint.getWaypointName() + ")";
            }
        }
        return string;
    }

    private static String generateMapquestUrl(TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        double d = UrlGenerator.getMedianValue(trackInfo.getTrack().getLatRange());
        double d2 = UrlGenerator.getMedianValue(trackInfo.getTrack().getLonRange());
        String string = "http://atlas.mapquest.com/maps/map.adp?latlongtype=decimal&latitude=" + FIVE_DP.format(d) + "&longitude=" + FIVE_DP.format(d2);
        return string;
    }

    private static String generateYahooUrl(TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        double d = UrlGenerator.getMedianValue(trackInfo.getTrack().getLatRange());
        double d2 = UrlGenerator.getMedianValue(trackInfo.getTrack().getLonRange());
        String string = "http://maps.yahoo.com/#lat=" + FIVE_DP.format(d) + "&lon=" + FIVE_DP.format(d2) + "&zoom=13";
        return string;
    }

    private static String generateBingUrl(TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        double d = UrlGenerator.getMedianValue(trackInfo.getTrack().getLatRange());
        double d2 = UrlGenerator.getMedianValue(trackInfo.getTrack().getLonRange());
        String string = FIVE_DP.format(d);
        String string2 = FIVE_DP.format(d2);
        String string3 = "http://bing.com/maps/default.aspx?cp=" + string + "~" + string2 + "&where1=" + string + "%2C%20" + string2;
        return string3;
    }

    private static String generateOpenStreetMapUrl(TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        DoubleRange doubleRange = trackInfo.getTrack().getLatRange();
        DoubleRange doubleRange2 = trackInfo.getTrack().getLonRange();
        String string = "http://openstreetmap.org/?minlat=" + FIVE_DP.format(doubleRange.getMinimum()) + "&maxlat=" + FIVE_DP.format(doubleRange.getMaximum()) + "&minlon=" + FIVE_DP.format(doubleRange2.getMinimum()) + "&maxlon=" + FIVE_DP.format(doubleRange2.getMaximum());
        DataPoint dataPoint = trackInfo.getCurrentPoint();
        if (dataPoint != null) {
            string = String.valueOf(string) + "&mlat=" + FIVE_DP.format(dataPoint.getLatitude().getDouble()) + "&mlon=" + FIVE_DP.format(dataPoint.getLongitude().getDouble());
        }
        return string;
    }

    private static String generateUrlForPoint(WebService webService, TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        DataPoint dataPoint = trackInfo.getCurrentPoint();
        if (dataPoint == null) {
            return null;
        }
        switch (webService) {
            case MAP_SOURCE_PEAKFINDER: {
                return UrlGenerator.generatePeakfinderUrl(dataPoint);
            }
            case MAP_SOURCE_GEOHACK: {
                return UrlGenerator.generateGeohackUrl(dataPoint);
            }
        }
        return null;
    }

    private static String generatePeakfinderUrl(DataPoint dataPoint) {
        return "http://peakfinder.org/?lat=" + FIVE_DP.format(dataPoint.getLatitude().getDouble()) + "&lng=" + FIVE_DP.format(dataPoint.getLongitude().getDouble());
    }

    private static String generateGeohackUrl(DataPoint dataPoint) {
        return "https://tools.wmflabs.org/geohack/geohack.php?params=" + FIVE_DP.format(dataPoint.getLatitude().getDouble()) + "_N_" + FIVE_DP.format(dataPoint.getLongitude().getDouble()) + "_E";
    }

    private static double getMedianValue(DoubleRange doubleRange) {
        return (doubleRange.getMaximum() + doubleRange.getMinimum()) / 2.0;
    }

    private static double getSpan(DoubleRange doubleRange) {
        return doubleRange.getMaximum() - doubleRange.getMinimum();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebService {
        MAP_SOURCE_GOOGLE,
        MAP_SOURCE_OSM,
        MAP_SOURCE_MAPQUEST,
        MAP_SOURCE_YAHOO,
        MAP_SOURCE_BING,
        MAP_SOURCE_PEAKFINDER,
        MAP_SOURCE_GEOHACK;

    }
}

