/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.io.ArpaLmReaderCallback;
import edu.berkeley.nlp.lm.io.IOUtils;
import edu.berkeley.nlp.lm.util.Logger;
import edu.berkeley.nlp.lm.util.StrUtils;
import edu.berkeley.nlp.lm.values.ProbBackoffPair;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;

public class KneserNeyFileWritingLmReaderCallback<W>
implements ArpaLmReaderCallback<ProbBackoffPair> {
    private PrintWriter out;
    private WordIndexer<W> wordIndexer;

    public KneserNeyFileWritingLmReaderCallback(File outputFile, WordIndexer<W> wordIndexer) {
        this(IOUtils.openOutHard(outputFile), wordIndexer);
    }

    public KneserNeyFileWritingLmReaderCallback(PrintWriter out, WordIndexer<W> wordIndexer) {
        this.wordIndexer = wordIndexer;
        this.out = out;
    }

    @Override
    public void handleNgramOrderFinished(int order) {
        this.out.println("");
    }

    @Override
    public void handleNgramOrderStarted(int order) {
        this.out.println("\\" + order + "-grams:");
    }

    @Override
    public void call(int[] ngram, int startPos, int endPos, ProbBackoffPair value, String words) {
        boolean endsWithEndSym;
        String line = StrUtils.join(WordIndexer.StaticMethods.toList(this.wordIndexer, ngram, startPos, endPos));
        boolean bl = endsWithEndSym = ngram[ngram.length - 1] == this.wordIndexer.getIndexPossiblyUnk(this.wordIndexer.getEndSymbol());
        if (endsWithEndSym || value.backoff == 0.0f) {
            this.out.printf("%f\t%s\n", Float.valueOf(value.prob), line);
        } else {
            this.out.printf("%f\t%s\t%f\n", Float.valueOf(value.prob), line, Float.valueOf(value.backoff));
        }
    }

    @Override
    public void cleanup() {
        this.out.println("\\end\\");
        this.out.close();
    }

    @Override
    public void initWithLengths(List<Long> numNGrams) {
        Logger.startTrack("Writing ARPA", new Object[0]);
        this.out.println();
        this.out.println("\\data\\");
        for (int ngramOrder = 0; ngramOrder < numNGrams.size(); ++ngramOrder) {
            long numNgrams = numNGrams.get(ngramOrder);
            this.out.println("ngram " + (ngramOrder + 1) + "=" + numNgrams);
        }
        this.out.println();
    }
}

