/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;
import writer2latex.xhtml.XhtmlStyleMapItem;

public class HeadingStyleConverter
extends StyleConverterHelper {
    private List<Set<String>> otherLevelStyles;

    public HeadingStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = config.getXHeadingStyleMap();
        this.bConvertStyles = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 2;
        this.bConvertHard = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 1;
        this.otherLevelStyles = new ArrayList<Set<String>>();
        for (int i = 0; i <= 6; ++i) {
            this.otherLevelStyles.add(new HashSet());
        }
    }

    @Override
    public String getStyleDeclarations(String sIndent) {
        if (this.bConvertStyles) {
            StringBuilder buf = new StringBuilder();
            for (int i = 1; i <= 6; ++i) {
                if (this.ofr.getHeadingStyle(i) != null) {
                    CSVList props = new CSVList(";");
                    this.getParSc().applyProperties(this.ofr.getHeadingStyle(i), props, true);
                    props.addValue("clear", "left");
                    buf.append(sIndent).append("h").append(i).append(" {").append(props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
                }
                for (String sDisplayName : this.otherLevelStyles.get(i)) {
                    StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyleByDisplayName(sDisplayName);
                    CSVList props = new CSVList(";");
                    this.getParSc().applyProperties(style, props, true);
                    props.addValue("clear", "left");
                    buf.append(sIndent).append("h").append(i).append(".").append(this.styleNames.getExportName(sDisplayName)).append(" {").append(props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
                }
            }
            return buf.toString();
        }
        return "";
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getParStyles();
    }

    public void applyStyle(int nLevel, String sStyleName, StyleInfo info) {
        StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyle(sStyleName);
        if (style != null) {
            if (this.config.multilingual()) {
                HeadingStyleConverter.applyLang(style, info);
            }
            HeadingStyleConverter.applyDirection(style, info);
            if (style.isAutomatic()) {
                this.applyStyle(nLevel, style.getParentName(), info);
                if (this.bConvertHard) {
                    this.getParSc().applyProperties(style, info.props, false);
                }
            } else {
                String sDisplayName = style.getDisplayName();
                if (this.styleMap.contains(sDisplayName)) {
                    XhtmlStyleMapItem map = this.styleMap.get(sDisplayName);
                    info.sTagName = map.sBlockElement;
                    if (!"(none)".equals(map.sBlockCss)) {
                        info.sClass = map.sBlockCss;
                    }
                } else if (style != this.ofr.getHeadingStyle(nLevel)) {
                    info.sClass = this.styleNames.getExportName(sDisplayName);
                    if (1 <= nLevel && nLevel <= 6) {
                        this.otherLevelStyles.get(nLevel).add(sDisplayName);
                    }
                }
            }
        }
    }

    public void applyInnerStyle(int nLevel, String sStyleName, StyleInfo info) {
        StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyle(sStyleName);
        if (style != null) {
            if (style.isAutomatic()) {
                this.applyInnerStyle(nLevel, style.getParentName(), info);
            } else {
                String sDisplayName = style.getDisplayName();
                if (this.styleMap.contains(sDisplayName)) {
                    XhtmlStyleMapItem map = this.styleMap.get(sDisplayName);
                    info.sTagName = map.sElement;
                    if (!"(none)".equals(map.sCss)) {
                        info.sClass = map.sCss;
                    }
                }
            }
        }
    }
}

