<?php

foreach (Array(
    'vendor/phpunit/phpunit/PHPUnitPHPUnit/Autoload.php',
    'PHPUnit/Autoload.php',
    'src/lightncandy.php'
) as $inc) {
    if (file_exists($inc)) {
       include_once($inc);
       break;
    }
}

genTestForClass('LightnCandy');
genTestForClass('LCRun3');

function genTestForClass($classname) {
    ob_start();

    echo <<<VAR
<?php
/**
 * Generated by build/gen_test
 */
require_once('src/lightncandy.php');

class {$classname}Test extends PHPUnit_Framework_TestCase
{

VAR
    ;

    $class = new ReflectionClass($classname);
    foreach ($class->getMethods() as $method) {
        if (preg_match_all('/@expect (.+) when input (.+)( after (.+))?/', $method->getDocComment(), $matched)) {
            echo <<<VAR
    /**
     * @covers {$classname}::{$method->name}
     */
    public function testOn_{$method->name}() {
        \$method = new ReflectionMethod('$classname', '{$method->name}');

VAR
            ;
            if ($method->isPrivate() || $method->isProtected()) {
                echo "        \$method->setAccessible(true);\n";
            }
            foreach ($matched[1] as $idx => $expect) {
                if ($matched[3][$idx]) {
                    echo "      {$matched[3][$idx]}\n";
                }
                echo "        \$this->assertEquals($expect, \$method->invokeArgs(null,array(\n            {$matched[2][$idx]}\n)        ));\n";
            }
            echo "    }\n";
        }
    }
    echo "}\n?>";

    $fn = "tests/{$classname}Test.php";
    if (!file_put_contents($fn, ob_get_clean())) {
        die("Can not generate tests into file $fn !!\n");
    }
}
?>
