/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ivy.plugins.matcher.AbstractPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;

public final class RegexpPatternMatcher
extends AbstractPatternMatcher {
    public static final RegexpPatternMatcher INSTANCE = new RegexpPatternMatcher();

    public RegexpPatternMatcher() {
        super("regexp");
    }

    @Override
    protected Matcher newMatcher(String string) {
        return new RegexpMatcher(string);
    }

    private static class RegexpMatcher
    implements Matcher {
        private Pattern pattern;
        private String expression;
        private Boolean exact;

        public RegexpMatcher(String string) throws PatternSyntaxException {
            if (string == null) {
                throw new NullPointerException();
            }
            this.expression = string;
            this.pattern = Pattern.compile(string);
        }

        @Override
        public boolean matches(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return this.pattern.matcher(string).matches();
        }

        @Override
        public boolean isExact() {
            if (this.exact == null) {
                this.exact = this.calculateExact();
            }
            return this.exact;
        }

        private Boolean calculateExact() {
            Boolean bl = Boolean.TRUE;
            char[] cArray = this.expression.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || '-' == c || '_' == c) continue;
                bl = Boolean.FALSE;
                break;
            }
            return bl;
        }
    }
}

