/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.ExtProcess;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.PasswdDialog;
import com.tigervnc.vncviewer.VncViewer;
import java.io.File;
import java.util.ArrayList;

public class Tunnel {
    private static final String DEFAULT_TUNNEL_TEMPLATE = "-f -L %L:localhost:%R %H sleep 20";
    private static final String DEFAULT_VIA_TEMPLATE = "-f -L %L:%H:%R %G sleep 20";
    static LogWriter vlog = new LogWriter("Tunnel");

    public static void createTunnel(CConn cConn, int n) throws com.tigervnc.rfb.Exception {
        String string;
        int n2 = cConn.getServerPort();
        String string2 = cConn.getServerName();
        String string3 = "localhost";
        if (!Parameters.via.getValue().isEmpty()) {
            string2 = Tunnel.getSshHost();
            string3 = cConn.getServerName();
        }
        if ((string = Parameters.extSSHArgs.getValue()) == null || string.isEmpty()) {
            string = Parameters.tunnel.getValue() && Parameters.via.getValue().isEmpty() ? System.getProperty("VNC_TUNNEL_CMD") : System.getProperty("VNC_VIA_CMD");
        }
        if (Parameters.extSSH.getValue() || string != null && string.length() > 0) {
            Tunnel.createTunnelExt(string2, string3, n2, n, string);
        } else {
            Tunnel.createTunnelJSch(string2, string3, n2, n);
        }
    }

    public static String getSshHost() {
        String string = Parameters.via.getValue();
        if (string.isEmpty()) {
            return Parameters.vncServerName.getValue();
        }
        int n = string.indexOf(":");
        if (n < 0) {
            n = string.length();
        }
        string = string.substring(string.indexOf("@") + 1, n);
        return string;
    }

    public static String getSshUser() {
        String string = (String)System.getProperties().get("user.name");
        String string2 = Parameters.via.getValue();
        if (!string2.isEmpty() && string2.indexOf("@") > 0) {
            string = string2.substring(0, string2.indexOf("@"));
        }
        return string;
    }

    public static int getSshPort() {
        String string = "22";
        String string2 = Parameters.via.getValue();
        if (!string2.isEmpty() && string2.indexOf(":") > 0) {
            string = string2.substring(string2.indexOf(":") + 1, string2.length());
        }
        return Integer.parseInt(string);
    }

    public static String getSshKeyFile() {
        String[] stringArray;
        if (!Parameters.sshKeyFile.getValue().isEmpty()) {
            return Parameters.sshKeyFile.getValue();
        }
        for (String string : stringArray = new String[]{"id_dsa", "id_rsa"}) {
            File file = new File(FileUtils.getHomeDir() + ".ssh/" + string);
            if (!file.exists() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return "";
    }

    public static String getSshKey() {
        if (!Parameters.sshKey.getValue().isEmpty()) {
            return Parameters.sshKeyFile.getValue().replaceAll("\\\\n", "\n");
        }
        return "";
    }

    private static void createTunnelJSch(String string, String string2, int n, int n2) throws com.tigervnc.rfb.Exception {
        JSch.setLogger(new MyJSchLogger());
        JSch jSch = new JSch();
        try {
            Object object;
            Object object22;
            Object object3;
            File file = new File(FileUtils.getHomeDir() + ".ssh/known_hosts");
            if (file.exists() && file.canRead()) {
                jSch.setKnownHosts(file.getAbsolutePath());
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (!Tunnel.getSshKey().isEmpty()) {
                object3 = null;
                if (!Parameters.sshKeyPass.getValue().isEmpty()) {
                    object3 = Parameters.sshKeyPass.getValue().getBytes();
                }
                jSch.addIdentity("TigerVNC", Tunnel.getSshKey().getBytes(), null, (byte[])object3);
            } else if (!Tunnel.getSshKeyFile().isEmpty()) {
                object3 = new File(Tunnel.getSshKeyFile());
                if (!((File)object3).exists() || !((File)object3).canRead()) {
                    throw new com.tigervnc.rfb.Exception("Cannot access SSH key file " + Tunnel.getSshKeyFile());
                }
                arrayList.add(object3);
            }
            for (Object object22 : arrayList) {
                if (!((File)object22).exists() || !((File)object22).canRead()) continue;
                if (!Parameters.sshKeyPass.getValue().isEmpty()) {
                    jSch.addIdentity(((File)object22).getAbsolutePath(), Parameters.sshKeyPass.getValue());
                    continue;
                }
                jSch.addIdentity(((File)object22).getAbsolutePath());
            }
            object3 = Tunnel.getSshUser();
            object22 = new String("SSH Authentication");
            PasswdDialog passwdDialog = new PasswdDialog((String)object22, object3 != null, false);
            passwdDialog.userEntry.setText((String)(object3 != null ? object3 : ""));
            File file2 = new File(Parameters.sshConfig.getValue());
            if (file2.exists() && file2.canRead()) {
                object = OpenSSHConfig.parse(file2.getAbsolutePath());
                jSch.setConfigRepository((ConfigRepository)object);
            }
            object = jSch.getSession((String)object3, string, Tunnel.getSshPort());
            ((Session)object).setUserInfo(passwdDialog);
            if (((Session)object).getConfig("StrictHostKeyChecking") == null) {
                ((Session)object).setConfig("StrictHostKeyChecking", "ask");
            }
            ((Session)object).connect();
            ((Session)object).setPortForwardingL(n2, string2, n);
        }
        catch (Exception exception) {
            throw new com.tigervnc.rfb.Exception(exception.getMessage());
        }
    }

    private static void createTunnelExt(String string, String string2, int n, int n2, String string3) throws com.tigervnc.rfb.Exception {
        if (string3 == null || string3.length() < 1) {
            string3 = Parameters.tunnel.getValue() && Parameters.via.getValue().isEmpty() ? DEFAULT_TUNNEL_TEMPLATE : DEFAULT_VIA_TEMPLATE;
        }
        String string4 = Tunnel.fillCmdPattern(string3, string, string2, n, n2);
        try {
            Thread thread = new Thread(new ExtProcess(string4, vlog, true));
            thread.start();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            throw new com.tigervnc.rfb.Exception(exception.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String fillCmdPattern(String var0, String var1_1, String var2_2, int var3_3, int var4_4) {
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = Parameters.extSSHClient.getValue() + " ";
        var0.replaceAll("^\\s+", "");
        var11_11 = Tunnel.getSshUser();
        var12_12 = Tunnel.getSshPort();
        var1_1 = var11_11 + "@" + var1_1;
        block7: for (var13_13 = 0; var13_13 < var0.length(); ++var13_13) {
            if (var0.charAt(var13_13) != '%') ** GOTO lbl-1000
            switch (var0.charAt(++var13_13)) {
                case 'H': {
                    var10_10 = var10_10 + var2_2;
                    var5_5 = true;
                    continue block7;
                }
                case 'G': {
                    var10_10 = var10_10 + var1_1;
                    var6_6 = true;
                    continue block7;
                }
                case 'R': {
                    var10_10 = var10_10 + var3_3;
                    var7_7 = true;
                    continue block7;
                }
                case 'L': {
                    var10_10 = var10_10 + var4_4;
                    var8_8 = true;
                    continue block7;
                }
                case 'P': {
                    var10_10 = var10_10 + var12_12;
                    var9_9 = true;
                    continue block7;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var10_10 = var10_10 + var0.charAt(var13_13);
                }
            }
        }
        if (var0.length() > 1024) {
            throw new com.tigervnc.rfb.Exception("Tunneling command is too long.");
        }
        if (!(var5_5 && var7_7 && var8_8)) {
            throw new com.tigervnc.rfb.Exception("%H, %R or %L absent in tunneling command template.");
        }
        if (!Parameters.tunnel.getValue() && !var6_6) {
            throw new com.tigervnc.rfb.Exception("%G pattern absent in tunneling command template.");
        }
        Tunnel.vlog.info("SSH command line: " + var10_10, new Object[0]);
        if (VncViewer.os.startsWith("windows")) {
            var10_10.replaceAll("\\\\", "\\\\\\\\");
        }
        return var10_10;
    }

    private static class MyJSchLogger
    implements Logger {
        private MyJSchLogger() {
        }

        @Override
        public boolean isEnabled(int n) {
            return true;
        }

        @Override
        public void log(int n, String string) {
            switch (n) {
                case 1: {
                    vlog.info(string, new Object[0]);
                    break;
                }
                case 3: {
                    vlog.error(string, new Object[0]);
                    break;
                }
                default: {
                    vlog.debug(string, new Object[0]);
                }
            }
        }
    }
}

