/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import java.util.Date;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Status;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.NodeKind;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.StatusKind;

public class Status
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String url;
    private String path;
    private int nodeKind;
    private long revision;
    private long lastChangedRevision;
    private long lastChangedDate;
    private String lastCommitAuthor;
    private int textStatus;
    private int propStatus;
    private boolean locked;
    private boolean copied;
    private boolean switched;
    private boolean fileExternal;
    private boolean treeConflicted;
    private ConflictDescriptor conflictDescriptor;
    private int repositoryTextStatus;
    private int repositoryPropStatus;
    private String conflictNew;
    private String conflictOld;
    private String conflictWorking;
    private String urlCopiedFrom;
    private long revisionCopiedFrom;
    private String lockToken;
    private String lockOwner;
    private String lockComment;
    private long lockCreationDate;
    private Lock reposLock;
    private long reposLastCmtRevision = -1L;
    private long reposLastCmtDate = 0L;
    private int reposKind = 0;
    private String reposLastCmtAuthor;
    private String changelist;

    public Status(String string, String string2, int n, long l, long l2, long l3, String string3, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, ConflictDescriptor conflictDescriptor, String string4, String string5, String string6, String string7, long l4, boolean bl4, boolean bl5, String string8, String string9, String string10, long l5, Lock lock, long l6, long l7, int n6, String string11, String string12) {
        this.path = string;
        this.url = string2;
        this.nodeKind = n;
        this.revision = l;
        this.lastChangedRevision = l2;
        this.lastChangedDate = l3;
        this.lastCommitAuthor = string3;
        this.textStatus = n2;
        this.propStatus = n3;
        this.locked = bl;
        this.copied = bl2;
        this.treeConflicted = bl3;
        this.conflictDescriptor = conflictDescriptor;
        this.repositoryTextStatus = n4;
        this.repositoryPropStatus = n5;
        this.conflictOld = string4;
        this.conflictNew = string5;
        this.conflictWorking = string6;
        this.urlCopiedFrom = string7;
        this.revisionCopiedFrom = l4;
        this.switched = bl4;
        this.fileExternal = bl5;
        this.lockToken = string8;
        this.lockOwner = string9;
        this.lockComment = string10;
        this.lockCreationDate = l5;
        this.reposLock = lock;
        this.reposLastCmtRevision = l6;
        this.reposLastCmtDate = l7;
        this.reposKind = n6;
        this.reposLastCmtAuthor = string11;
        this.changelist = string12;
    }

    public Status(String string) {
        this(string, null, NodeKind.fromApache(null), -1L, -1L, 0L, null, Status.fromAStatusKind(null), Status.fromAStatusKind(null), Status.fromAStatusKind(null), Status.fromAStatusKind(null), false, false, false, null, null, null, null, null, -1L, false, false, null, null, null, 0L, null, -1L, 0L, NodeKind.fromApache(null), null, null);
    }

    private void populateFromInfo(SVNClient sVNClient, String string) throws ClientException {
        class MyInfoCallback
        implements InfoCallback {
            Info info;

            MyInfoCallback() {
            }

            @Override
            public void singleInfo(Info info) {
                this.info = info;
            }

            public Info getInfo() {
                return this.info;
            }
        }
        MyInfoCallback myInfoCallback = new MyInfoCallback();
        sVNClient.info2(string, null, null, Depth.empty, null, myInfoCallback);
        Info info = myInfoCallback.getInfo();
        if (info == null) {
            return;
        }
        if (info.getConflicts() != null) {
            for (org.apache.subversion.javahl.ConflictDescriptor conflictDescriptor : info.getConflicts()) {
                switch (conflictDescriptor.getKind()) {
                    case tree: {
                        this.treeConflicted = true;
                        this.conflictDescriptor = new ConflictDescriptor(conflictDescriptor);
                        break;
                    }
                    case text: {
                        this.conflictOld = conflictDescriptor.getBasePath();
                        this.conflictWorking = conflictDescriptor.getMergedPath();
                        this.conflictNew = conflictDescriptor.getMyPath();
                        break;
                    }
                }
            }
        }
        this.urlCopiedFrom = info.getCopyFromUrl();
        this.revisionCopiedFrom = info.getCopyFromRev();
    }

    void populateLocalLock(org.apache.subversion.javahl.types.Lock lock) {
        if (lock == null) {
            return;
        }
        this.lockToken = lock.getToken();
        this.lockOwner = lock.getOwner();
        this.lockComment = lock.getComment();
        this.lockCreationDate = lock.getCreationDate().getTime() * 1000L;
    }

    public Status(SVNClient sVNClient, org.apache.subversion.javahl.types.Status status) {
        this(status.getPath(), status.getUrl(), NodeKind.fromApache(status.getNodeKind()), status.getRevisionNumber(), status.getLastChangedRevisionNumber(), status.getLastChangedDateMicros(), status.getLastCommitAuthor(), Status.fromAStatusKind(status.getTextStatus()), Status.fromAStatusKind(status.getPropStatus()), Status.fromAStatusKind(status.getRepositoryTextStatus()), Status.fromAStatusKind(status.getRepositoryPropStatus()), status.isLocked(), status.isCopied(), false, null, null, null, null, null, -1L, status.isSwitched(), status.isFileExternal(), null, null, null, 0L, status.getReposLock() == null ? null : new Lock(status.getReposLock()), status.getReposLastCmtRevisionNumber(), status.getReposLastCmtDateMicros(), NodeKind.fromApache(status.getReposKind()), status.getReposLastCmtAuthor(), status.getChangelist());
        try {
            this.populateFromInfo(sVNClient, status.getPath());
            if (status.getLocalLock() != null) {
                this.populateLocalLock(status.getLocalLock());
            }
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    public String getPath() {
        return this.path;
    }

    public Revision.Number getRevision() {
        return Revision.createNumber(this.revision);
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public Date getLastChangedDate() {
        return Status.microsecondsToDate(this.lastChangedDate);
    }

    public long getLastChangedDateMicros() {
        return this.lastChangedDate;
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public int getTextStatus() {
        return this.textStatus;
    }

    public String getTextStatusDescription() {
        return Kind.getDescription(this.textStatus);
    }

    public int getPropStatus() {
        return this.propStatus;
    }

    public String getPropStatusDescription() {
        return Kind.getDescription(this.propStatus);
    }

    public int getRepositoryTextStatus() {
        return this.repositoryTextStatus;
    }

    public int getRepositoryPropStatus() {
        return this.repositoryPropStatus;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public String getConflictNew() {
        return this.conflictNew;
    }

    public String getConflictOld() {
        return this.conflictOld;
    }

    public String getConflictWorking() {
        return this.conflictWorking;
    }

    public String getUrl() {
        return this.url;
    }

    public Revision.Number getLastChangedRevision() {
        return Revision.createNumber(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public String getUrlCopiedFrom() {
        return this.urlCopiedFrom;
    }

    public Revision.Number getRevisionCopiedFrom() {
        return Revision.createNumber(this.revisionCopiedFrom);
    }

    public long getRevisionCopiedFromNumber() {
        return this.revisionCopiedFrom;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public boolean isFileExternal() {
        return this.fileExternal;
    }

    public boolean isManaged() {
        int n = this.getTextStatus();
        return n != 5 && n != 0 && n != 11;
    }

    public boolean hasRemote() {
        return this.isManaged() && this.getTextStatus() != 3;
    }

    public boolean isAdded() {
        return this.getTextStatus() == 3;
    }

    public boolean isDeleted() {
        return this.getTextStatus() == 4;
    }

    public boolean isMerged() {
        return this.getTextStatus() == 8;
    }

    public boolean isIgnored() {
        return this.getTextStatus() == 11;
    }

    public boolean isModified() {
        return this.getTextStatus() == 2;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public Date getLockCreationDate() {
        return Status.microsecondsToDate(this.lockCreationDate);
    }

    public long getLockCreationDateMicros() {
        return this.lockCreationDate;
    }

    public Lock getReposLock() {
        return this.reposLock;
    }

    public Revision.Number getReposLastCmtRevision() {
        return Revision.createNumber(this.reposLastCmtRevision);
    }

    public long getReposLastCmtRevisionNumber() {
        return this.reposLastCmtRevision;
    }

    public Date getReposLastCmtDate() {
        return Status.microsecondsToDate(this.reposLastCmtDate);
    }

    public long getReposLastCmtDateMicros() {
        return this.reposLastCmtDate;
    }

    public int getReposKind() {
        return this.reposKind;
    }

    public String getReposLastCmtAuthor() {
        return this.reposLastCmtAuthor;
    }

    public String getChangelist() {
        return this.changelist;
    }

    public boolean hasTreeConflict() {
        return this.treeConflicted;
    }

    public ConflictDescriptor getConflictDescriptor() {
        return this.conflictDescriptor;
    }

    private static Date microsecondsToDate(long l) {
        return l == 0L ? null : new Date(l / 1000L);
    }

    private static int fromAStatusKind(Status.Kind kind) {
        if (kind == null) {
            return 0;
        }
        switch (kind) {
            default: {
                return 0;
            }
            case normal: {
                return 1;
            }
            case modified: {
                return 2;
            }
            case added: {
                return 3;
            }
            case deleted: {
                return 4;
            }
            case unversioned: {
                return 5;
            }
            case missing: {
                return 6;
            }
            case replaced: {
                return 7;
            }
            case merged: {
                return 8;
            }
            case conflicted: {
                return 9;
            }
            case obstructed: {
                return 10;
            }
            case ignored: {
                return 11;
            }
            case incomplete: {
                return 12;
            }
            case external: 
        }
        return 13;
    }

    public static final class Kind
    implements StatusKind {
        public static final String getDescription(int n) {
            switch (n) {
                case 0: {
                    return "non-svn";
                }
                case 1: {
                    return "normal";
                }
                case 3: {
                    return "added";
                }
                case 6: {
                    return "missing";
                }
                case 4: {
                    return "deleted";
                }
                case 7: {
                    return "replaced";
                }
                case 2: {
                    return "modified";
                }
                case 8: {
                    return "merged";
                }
                case 9: {
                    return "conflicted";
                }
                case 11: {
                    return "ignored";
                }
                case 12: {
                    return "incomplete";
                }
                case 13: {
                    return "external";
                }
            }
            return "unversioned";
        }
    }
}

