/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.ClassIndexedSet;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.MessageRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseContext
implements Iterable<BaseContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseContext.class);
    @Nullable
    private BaseContext parent;
    @Nonnull
    @NonnullElements
    private ClassIndexedSet<BaseContext> subcontexts = new ClassIndexedSet();
    private boolean autoCreateSubcontexts;

    public BaseContext() {
        this.setAutoCreateSubcontexts(false);
    }

    @Nullable
    public BaseContext getParent() {
        return this.parent;
    }

    protected void setParent(@Nullable BaseContext newParent) {
        this.parent = newParent;
    }

    @Nullable
    public <T extends BaseContext> T getSubcontext(@Nonnull Class<T> clazz) {
        return this.getSubcontext(clazz, this.isAutoCreateSubcontexts());
    }

    @Nullable
    public <T extends BaseContext> T getSubcontext(@Nonnull Class<T> clazz, boolean autocreate) {
        Constraint.isNotNull(clazz, (String)"Class type cannot be null");
        this.log.trace("Request for subcontext of type: {}", (Object)clazz.getName());
        BaseContext subcontext = (BaseContext)this.subcontexts.get(clazz);
        if (subcontext != null) {
            this.log.trace("Subcontext found of type: {}", (Object)clazz.getName());
            return (T)subcontext;
        }
        if (autocreate) {
            this.log.trace("Subcontext not found of type, autocreating: {}", (Object)clazz.getName());
            subcontext = this.createSubcontext(clazz);
            this.addSubcontext(subcontext);
            return (T)subcontext;
        }
        this.log.trace("Subcontext not found of type: {}", (Object)clazz.getName());
        return null;
    }

    @Nullable
    public BaseContext getSubcontext(@Nonnull @NotEmpty String className) throws ClassNotFoundException {
        return this.getSubcontext(className, this.isAutoCreateSubcontexts());
    }

    @Nullable
    public BaseContext getSubcontext(@Nonnull @NotEmpty String className, boolean autocreate) throws ClassNotFoundException {
        return this.getSubcontext(Class.forName(className).asSubclass(BaseContext.class), autocreate);
    }

    @Nonnull
    public BaseContext addSubcontext(@Nonnull BaseContext subContext) {
        return this.addSubcontext(subContext, false);
    }

    @Nonnull
    public BaseContext addSubcontext(@Nonnull BaseContext subcontext, boolean replace) {
        Constraint.isNotNull((Object)subcontext, (String)"Subcontext cannot be null");
        BaseContext existing = (BaseContext)this.subcontexts.get(subcontext.getClass());
        if (existing == subcontext) {
            this.log.trace("Subcontext to add is already a child of the current context, skipping");
            return subcontext;
        }
        this.log.trace("Attempting to store a subcontext with type '{}' with replace option '{}'", new Object[]{subcontext.getClass().getName(), new Boolean(replace).toString()});
        this.subcontexts.add((Object)subcontext, replace);
        BaseContext oldParent = subcontext.getParent();
        if (oldParent != null && oldParent != this) {
            this.log.trace("New subcontext with type '{}' is currently a subcontext of parent with type '{}', removing it", new Object[]{subcontext.getClass().getName(), oldParent.getClass().getName()});
            subcontext.getParent().removeSubcontext(subcontext);
        }
        this.log.trace("New subcontext with type '{}' set to have parent with type '{}'", new Object[]{subcontext.getClass().getName(), this.getClass().getName()});
        subcontext.setParent(this);
        if (existing != null) {
            this.log.trace("Old subcontext with type '{}' will have parent cleared", (Object)existing.getClass().getName());
            existing.setParent(null);
        }
        return subcontext;
    }

    public void removeSubcontext(@Nonnull BaseContext subcontext) {
        Constraint.isNotNull((Object)subcontext, (String)"Subcontext cannot be null");
        this.log.trace("Removing subcontext with type '{}' from parent with type '{}'", new Object[]{subcontext.getClass().getName(), this.getClass().getName()});
        subcontext.setParent(null);
        this.subcontexts.remove((Object)subcontext);
    }

    public <T extends BaseContext> void removeSubcontext(@Nonnull Class<T> clazz) {
        T subcontext = this.getSubcontext(clazz, false);
        if (subcontext != null) {
            this.removeSubcontext((BaseContext)subcontext);
        }
    }

    public <T extends BaseContext> boolean containsSubcontext(@Nonnull Class<T> clazz) {
        Constraint.isNotNull(clazz, (String)"Class type cannot be null");
        return this.subcontexts.contains(clazz);
    }

    public void clearSubcontexts() {
        this.log.trace("Clearing all subcontexts from context with type '{}'", (Object)this.getClass().getName());
        for (BaseContext subcontext : this.subcontexts) {
            subcontext.setParent(null);
        }
        this.subcontexts.clear();
    }

    public boolean isAutoCreateSubcontexts() {
        return this.autoCreateSubcontexts;
    }

    public void setAutoCreateSubcontexts(boolean autoCreate) {
        this.autoCreateSubcontexts = autoCreate;
    }

    @Override
    @Nonnull
    public Iterator<BaseContext> iterator() {
        return new ContextSetNoRemoveIteratorDecorator(this.subcontexts.iterator());
    }

    @Nonnull
    protected <T extends BaseContext> T createSubcontext(@Nonnull Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return (T)((BaseContext)constructor.newInstance(new Object[0]));
        }
        catch (SecurityException e) {
            this.log.error("Security error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (NoSuchMethodException e) {
            this.log.error("No such method error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Illegal argument error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (InstantiationException e) {
            this.log.error("Instantiation error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (IllegalAccessException e) {
            this.log.error("Illegal access error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (InvocationTargetException e) {
            this.log.error("Invocation target error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
    }

    protected class ContextSetNoRemoveIteratorDecorator
    implements Iterator<BaseContext> {
        private Iterator<BaseContext> wrappedIterator;

        protected ContextSetNoRemoveIteratorDecorator(Iterator<BaseContext> iterator) {
            this.wrappedIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public BaseContext next() {
            return this.wrappedIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal of subcontexts via the iterator is unsupported");
        }
    }
}

