/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public class ReflectionUtils {
    public static <E> Class<E> detectSuperTypeForRuleLike(Class<?> c) {
        Class<?> clazz;
        Type type = clazz.getGenericSuperclass();
        for (clazz = c; clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (type instanceof ParameterizedType) {
                Object[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
                if (typeArguments.length != 2 && typeArguments.length != 1) {
                    throw new SqlIllegalArgumentException("Unexpected number of type arguments {} for {}", Arrays.toString(typeArguments), c);
                }
                return (Class)typeArguments[0];
            }
            type = clazz.getGenericSuperclass();
        }
        throw new SqlIllegalArgumentException("Unexpected class structure for class {}", c);
    }

    public static String ruleLikeNaming(Class<?> c) {
        String className = c.getName();
        int parentPackage = className.lastIndexOf(".");
        if (parentPackage > 0) {
            int grandParentPackage = className.substring(0, parentPackage).lastIndexOf(".");
            return grandParentPackage > 0 ? className.substring(grandParentPackage + 1) : className.substring(parentPackage);
        }
        return className;
    }
}

