/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.search.ESToParentBlockJoinQuery;

public final class NestedHelper {
    private final MapperService mapperService;

    public NestedHelper(MapperService mapperService) {
        this.mapperService = mapperService;
    }

    public boolean mightMatchNestedDocs(Query query) {
        if (query instanceof ConstantScoreQuery) {
            return this.mightMatchNestedDocs(((ConstantScoreQuery)query).getQuery());
        }
        if (query instanceof BoostQuery) {
            return this.mightMatchNestedDocs(((BoostQuery)query).getQuery());
        }
        if (query instanceof MatchAllDocsQuery) {
            return true;
        }
        if (query instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query instanceof TermQuery) {
            return this.mightMatchNestedDocs(((TermQuery)query).getTerm().field());
        }
        if (query instanceof PointRangeQuery) {
            return this.mightMatchNestedDocs(((PointRangeQuery)query).getField());
        }
        if (query instanceof IndexOrDocValuesQuery) {
            return this.mightMatchNestedDocs(((IndexOrDocValuesQuery)query).getIndexQuery());
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            boolean hasRequiredClauses = bq.clauses().stream().anyMatch(BooleanClause::isRequired);
            if (hasRequiredClauses) {
                return bq.clauses().stream().filter(BooleanClause::isRequired).map(BooleanClause::getQuery).allMatch(this::mightMatchNestedDocs);
            }
            return bq.clauses().stream().filter(c -> c.getOccur() == BooleanClause.Occur.SHOULD).map(BooleanClause::getQuery).anyMatch(this::mightMatchNestedDocs);
        }
        if (query instanceof ESToParentBlockJoinQuery) {
            return ((ESToParentBlockJoinQuery)query).getPath() != null;
        }
        return true;
    }

    boolean mightMatchNestedDocs(String field) {
        if (field.startsWith("_")) {
            return true;
        }
        if (this.mapperService.fullName(field) == null) {
            return false;
        }
        String parent = NestedHelper.parentObject(field);
        while (parent != null) {
            ObjectMapper mapper = this.mapperService.getObjectMapper(parent);
            if (mapper != null && mapper.nested().isNested()) {
                return true;
            }
            parent = NestedHelper.parentObject(parent);
        }
        return false;
    }

    public boolean mightMatchNonNestedDocs(Query query, String nestedPath) {
        if (query instanceof ConstantScoreQuery) {
            return this.mightMatchNonNestedDocs(((ConstantScoreQuery)query).getQuery(), nestedPath);
        }
        if (query instanceof BoostQuery) {
            return this.mightMatchNonNestedDocs(((BoostQuery)query).getQuery(), nestedPath);
        }
        if (query instanceof MatchAllDocsQuery) {
            return true;
        }
        if (query instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query instanceof TermQuery) {
            return this.mightMatchNonNestedDocs(((TermQuery)query).getTerm().field(), nestedPath);
        }
        if (query instanceof PointRangeQuery) {
            return this.mightMatchNonNestedDocs(((PointRangeQuery)query).getField(), nestedPath);
        }
        if (query instanceof IndexOrDocValuesQuery) {
            return this.mightMatchNonNestedDocs(((IndexOrDocValuesQuery)query).getIndexQuery(), nestedPath);
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            boolean hasRequiredClauses = bq.clauses().stream().anyMatch(BooleanClause::isRequired);
            if (hasRequiredClauses) {
                return bq.clauses().stream().filter(BooleanClause::isRequired).map(BooleanClause::getQuery).allMatch(q -> this.mightMatchNonNestedDocs((Query)q, nestedPath));
            }
            return bq.clauses().stream().filter(c -> c.getOccur() == BooleanClause.Occur.SHOULD).map(BooleanClause::getQuery).anyMatch(q -> this.mightMatchNonNestedDocs((Query)q, nestedPath));
        }
        return true;
    }

    boolean mightMatchNonNestedDocs(String field, String nestedPath) {
        if (field.startsWith("_")) {
            return true;
        }
        if (this.mapperService.fullName(field) == null) {
            return false;
        }
        String parent = NestedHelper.parentObject(field);
        while (parent != null) {
            ObjectMapper mapper = this.mapperService.getObjectMapper(parent);
            if (mapper != null && mapper.nested().isNested()) {
                if (mapper.fullPath().equals(nestedPath)) {
                    return mapper.nested().isIncludeInParent() || mapper.nested().isIncludeInRoot();
                }
                return true;
            }
            parent = NestedHelper.parentObject(parent);
        }
        return true;
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }
}

