/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPExtendedOperationException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StartTLSPostConnectProcessor
implements PostConnectProcessor {
    private final SSLContext sslContext;
    private final SSLSocketFactory sslSocketFactory;

    public StartTLSPostConnectProcessor(SSLContext sslContext) {
        Validator.ensureNotNull(sslContext);
        this.sslContext = sslContext;
        this.sslSocketFactory = null;
    }

    public StartTLSPostConnectProcessor(SSLSocketFactory sslSocketFactory) {
        Validator.ensureNotNull(sslSocketFactory);
        this.sslSocketFactory = sslSocketFactory;
        this.sslContext = null;
    }

    public void processPreAuthenticatedConnection(LDAPConnection connection) throws LDAPException {
        StartTLSExtendedRequest startTLSRequest = this.sslContext == null ? new StartTLSExtendedRequest(this.sslSocketFactory) : new StartTLSExtendedRequest(this.sslContext);
        LDAPConnectionOptions opts = connection.getConnectionOptions();
        startTLSRequest.setResponseTimeoutMillis(opts.getConnectTimeoutMillis());
        ExtendedResult r = connection.processExtendedOperation(startTLSRequest);
        if (!r.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPExtendedOperationException(r);
        }
    }

    public void processPostAuthenticatedConnection(LDAPConnection connection) throws LDAPException {
    }
}

