/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.elasticsearch.search.aggregations.bucket.composite.TermsSortedDocsProducer;

class BinaryValuesSource
extends SingleDimensionValuesSource<BytesRef> {
    private final LongConsumer breakerConsumer;
    private final CheckedFunction<LeafReaderContext, SortedBinaryDocValues, IOException> docValuesFunc;
    private ObjectArray<BytesRef> values;
    private ObjectArray<BytesRefBuilder> valueBuilders;
    private BytesRef currentValue;

    BinaryValuesSource(BigArrays bigArrays, LongConsumer breakerConsumer, MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedBinaryDocValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, Object missing, int size, int reverseMul) {
        super(bigArrays, format, fieldType, missingBucket, missing, size, reverseMul);
        this.breakerConsumer = breakerConsumer;
        this.docValuesFunc = docValuesFunc;
        this.values = bigArrays.newObjectArray(Math.min(size, 100));
        this.valueBuilders = bigArrays.newObjectArray(Math.min(size, 100));
    }

    @Override
    void copyCurrent(int slot) {
        int byteSize;
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        this.valueBuilders = this.bigArrays.grow(this.valueBuilders, (long)(slot + 1));
        BytesRefBuilder builder = this.valueBuilders.get(slot);
        int n = byteSize = builder == null ? 0 : builder.bytes().length;
        if (builder == null) {
            builder = new BytesRefBuilder();
            this.valueBuilders.set(slot, builder);
        }
        if (this.missingBucket && this.currentValue == null) {
            this.values.set(slot, null);
        } else {
            assert (this.currentValue != null);
            builder.copyBytes(this.currentValue);
            this.breakerConsumer.accept(builder.bytes().length - byteSize);
            this.values.set(slot, builder.get());
        }
    }

    @Override
    int compare(int from, int to) {
        if (this.missingBucket) {
            if (this.values.get(from) == null) {
                return this.values.get(to) == null ? 0 : -1 * this.reverseMul;
            }
            if (this.values.get(to) == null) {
                return this.reverseMul;
            }
        }
        return this.compareValues(this.values.get(from), this.values.get(to));
    }

    @Override
    int compareCurrent(int slot) {
        if (this.missingBucket) {
            if (this.currentValue == null) {
                return this.values.get(slot) == null ? 0 : -1 * this.reverseMul;
            }
            if (this.values.get(slot) == null) {
                return this.reverseMul;
            }
        }
        return this.compareValues(this.currentValue, this.values.get(slot));
    }

    @Override
    int compareCurrentWithAfter() {
        if (this.missingBucket) {
            if (this.currentValue == null) {
                return this.afterValue == null ? 0 : -1 * this.reverseMul;
            }
            if (this.afterValue == null) {
                return this.reverseMul;
            }
        }
        return this.compareValues(this.currentValue, (BytesRef)this.afterValue);
    }

    int compareValues(BytesRef v1, BytesRef v2) {
        return v1.compareTo(v2) * this.reverseMul;
    }

    @Override
    void setAfter(Comparable<?> value) {
        if (this.missingBucket && value == null) {
            this.afterValue = null;
        } else if (value.getClass() == String.class) {
            this.afterValue = this.format.parseBytesRef(value.toString());
        } else {
            throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
        }
    }

    @Override
    BytesRef toComparable(int slot) {
        return this.values.get(slot);
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedBinaryDocValues dvs = this.docValuesFunc.apply(context);
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        BinaryValuesSource.this.currentValue = dvs.nextValue();
                        next.collect(doc, bucket);
                    }
                } else if (BinaryValuesSource.this.missingBucket) {
                    BinaryValuesSource.this.currentValue = null;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable<?> value, LeafReaderContext context, final LeafBucketCollector next) {
        if (value.getClass() != BytesRef.class) {
            throw new IllegalArgumentException("Expected BytesRef, got " + value.getClass());
        }
        this.currentValue = (BytesRef)value;
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !(this.fieldType instanceof StringFieldType) || query != null && query.getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        return new TermsSortedDocsProducer(this.fieldType.name());
    }

    @Override
    public void close() {
        Releasables.close(this.values, this.valueBuilders);
    }
}

