/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.graph.action;

import com.carrotsearch.hppc.ObjectIntHashMap;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.graph.action.Vertex;

public class Connection {
    Vertex from;
    Vertex to;
    double weight;
    long docCount;

    public Connection(Vertex from, Vertex to, double weight, long docCount) {
        this.from = from;
        this.to = to;
        this.weight = weight;
        this.docCount = docCount;
    }

    void readFrom(StreamInput in, Map<Vertex.VertexId, Vertex> vertices) throws IOException {
        this.from = vertices.get(new Vertex.VertexId(in.readString(), in.readString()));
        this.to = vertices.get(new Vertex.VertexId(in.readString(), in.readString()));
        this.weight = in.readDouble();
        this.docCount = in.readVLong();
    }

    Connection() {
    }

    void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.from.getField());
        out.writeString(this.from.getTerm());
        out.writeString(this.to.getField());
        out.writeString(this.to.getTerm());
        out.writeDouble(this.weight);
        out.writeVLong(this.docCount);
    }

    public ConnectionId getId() {
        return new ConnectionId(this.from.getId(), this.to.getId());
    }

    public Vertex getFrom() {
        return this.from;
    }

    public Vertex getTo() {
        return this.to;
    }

    public double getWeight() {
        return this.weight;
    }

    public long getDocCount() {
        return this.docCount;
    }

    void toXContent(XContentBuilder builder, ToXContent.Params params, ObjectIntHashMap<Vertex> vertexNumbers) throws IOException {
        builder.field("source", vertexNumbers.get((Object)this.from));
        builder.field("target", vertexNumbers.get((Object)this.to));
        builder.field("weight", this.weight);
        builder.field("doc_count", this.docCount);
    }

    public static class ConnectionId {
        private final Vertex.VertexId source;
        private final Vertex.VertexId target;

        public ConnectionId(Vertex.VertexId source, Vertex.VertexId target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionId vertexId = (ConnectionId)o;
            if (this.source != null ? !this.source.equals(vertexId.source) : vertexId.source != null) {
                return false;
            }
            return !(this.target != null ? !this.target.equals(vertexId.target) : vertexId.target != null);
        }

        public int hashCode() {
            int result = this.source != null ? this.source.hashCode() : 0;
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }

        public Vertex.VertexId getSource() {
            return this.source;
        }

        public Vertex.VertexId getTarget() {
            return this.target;
        }

        public String toString() {
            return this.getSource() + "->" + this.getTarget();
        }
    }
}

