/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.scheduler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Cron
implements ToXContentFragment {
    protected static final TimeZone UTC = DateTimeZone.UTC.toTimeZone();
    protected static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-dd'T'HH:mm:ss");
    private static final int SECOND = 0;
    private static final int MINUTE = 1;
    private static final int HOUR = 2;
    private static final int DAY_OF_MONTH = 3;
    private static final int MONTH = 4;
    private static final int DAY_OF_WEEK = 5;
    private static final int YEAR = 6;
    private static final int ALL_SPEC_INT = 99;
    private static final int NO_SPEC_INT = 98;
    private static final Integer ALL_SPEC = 99;
    private static final Integer NO_SPEC = 98;
    private static final Map<String, Integer> monthMap = new HashMap<String, Integer>(20);
    private static final Map<String, Integer> dayMap = new HashMap<String, Integer>(60);
    private final String expression;
    private transient TreeSet<Integer> seconds;
    private transient TreeSet<Integer> minutes;
    private transient TreeSet<Integer> hours;
    private transient TreeSet<Integer> daysOfMonth;
    private transient TreeSet<Integer> months;
    private transient TreeSet<Integer> daysOfWeek;
    private transient TreeSet<Integer> years;
    private transient boolean lastdayOfWeek = false;
    private transient int nthdayOfWeek = 0;
    private transient boolean lastdayOfMonth = false;
    private transient boolean nearestWeekday = false;
    private transient int lastdayOffset = 0;
    private transient boolean expressionParsed = false;
    public static final int MAX_YEAR;

    public Cron(String expression) {
        assert (expression != null) : "cron expression cannot be null";
        this.expression = expression.toUpperCase(Locale.ROOT);
        try {
            this.buildExpression(this.expression);
        }
        catch (Exception e) {
            throw Exceptions.illegalArgument("invalid cron expression [{}]", e, expression);
        }
    }

    public Cron(Cron cron) {
        this(cron.expression);
    }

    public long getNextValidTimeAfter(long time) {
        GregorianCalendar cl = new GregorianCalendar(UTC, Locale.ROOT);
        long afterTime = time + 1000L;
        cl.setTimeInMillis(afterTime);
        cl.set(14, 0);
        boolean gotOne = false;
        while (!gotOne) {
            boolean dayOfWSpec;
            if (cl.get(1) > 2999) {
                return -1L;
            }
            SortedSet<Integer> st = null;
            int t = 0;
            int sec = cl.get(13);
            int min = cl.get(12);
            st = this.seconds.tailSet(sec);
            if (st != null && st.size() != 0) {
                sec = st.first();
            } else {
                sec = this.seconds.first();
                cl.set(12, ++min);
            }
            cl.set(13, sec);
            min = cl.get(12);
            int hr = cl.get(11);
            t = -1;
            st = this.minutes.tailSet(min);
            if (st != null && st.size() != 0) {
                t = min;
                min = st.first();
            } else {
                min = this.minutes.first();
                ++hr;
            }
            if (min != t) {
                cl.set(13, 0);
                cl.set(12, min);
                Cron.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(12, min);
            hr = cl.get(11);
            int day = cl.get(5);
            t = -1;
            st = this.hours.tailSet(hr);
            if (st != null && st.size() != 0) {
                t = hr;
                hr = st.first();
            } else {
                hr = this.hours.first();
                ++day;
            }
            if (hr != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(5, day);
                Cron.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(11, hr);
            day = cl.get(5);
            int mon = cl.get(2) + 1;
            t = -1;
            int tmon = mon;
            boolean dayOfMSpec = !this.daysOfMonth.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
            if (dayOfMSpec && !dayOfWSpec) {
                int dow;
                int ldom;
                st = this.daysOfMonth.tailSet(day);
                if (this.lastdayOfMonth) {
                    if (!this.nearestWeekday) {
                        t = day;
                        day = this.getLastDayOfMonth(mon, cl.get(1));
                        if (t > (day -= this.lastdayOffset)) {
                            if (++mon > 12) {
                                mon = 1;
                                tmon = 3333;
                                ((Calendar)cl).add(1, 1);
                            }
                            day = 1;
                        }
                    } else {
                        t = day;
                        day = this.getLastDayOfMonth(mon, cl.get(1));
                        Calendar tcal = Calendar.getInstance(UTC, Locale.ROOT);
                        tcal.set(13, 0);
                        tcal.set(12, 0);
                        tcal.set(11, 0);
                        tcal.set(5, day -= this.lastdayOffset);
                        tcal.set(2, mon - 1);
                        tcal.set(1, cl.get(1));
                        ldom = this.getLastDayOfMonth(mon, cl.get(1));
                        dow = tcal.get(7);
                        if (dow == 7 && day == 1) {
                            day += 2;
                        } else if (dow == 7) {
                            --day;
                        } else if (dow == 1 && day == ldom) {
                            day -= 2;
                        } else if (dow == 1) {
                            ++day;
                        }
                        tcal.set(13, sec);
                        tcal.set(12, min);
                        tcal.set(11, hr);
                        tcal.set(5, day);
                        tcal.set(2, mon - 1);
                        long nTime = tcal.getTimeInMillis();
                        if (nTime < afterTime) {
                            day = 1;
                            ++mon;
                        }
                    }
                } else if (this.nearestWeekday) {
                    t = day;
                    day = this.daysOfMonth.first();
                    Calendar tcal = Calendar.getInstance(UTC, Locale.ROOT);
                    tcal.set(13, 0);
                    tcal.set(12, 0);
                    tcal.set(11, 0);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    tcal.set(1, cl.get(1));
                    ldom = this.getLastDayOfMonth(mon, cl.get(1));
                    dow = tcal.get(7);
                    if (dow == 7 && day == 1) {
                        day += 2;
                    } else if (dow == 7) {
                        --day;
                    } else if (dow == 1 && day == ldom) {
                        day -= 2;
                    } else if (dow == 1) {
                        ++day;
                    }
                    tcal.set(13, sec);
                    tcal.set(12, min);
                    tcal.set(11, hr);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    long nTime = tcal.getTimeInMillis();
                    if (nTime < afterTime) {
                        day = this.daysOfMonth.first();
                        ++mon;
                    }
                } else if (st != null && st.size() != 0) {
                    int lastDay;
                    t = day;
                    day = st.first();
                    if (day > (lastDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        day = this.daysOfMonth.first();
                        ++mon;
                    }
                } else {
                    day = this.daysOfMonth.first();
                    ++mon;
                }
                if (day != t || mon != tmon) {
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    cl.set(5, day);
                    cl.set(2, mon - 1);
                    continue;
                }
            } else if (dayOfWSpec && !dayOfMSpec) {
                int daysToAdd;
                int cDow;
                if (this.lastdayOfWeek) {
                    int lDay;
                    int dow = this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    }
                    if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    while (day + daysToAdd + 7 <= lDay) {
                        daysToAdd += 7;
                    }
                    day += daysToAdd;
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else if (this.nthdayOfWeek != 0) {
                    int dow = this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    } else if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    boolean dayShifted = false;
                    if (daysToAdd > 0) {
                        dayShifted = true;
                    }
                    int weekOfMonth = (day += daysToAdd) / 7;
                    if (day % 7 > 0) {
                        ++weekOfMonth;
                    }
                    if ((daysToAdd = (this.nthdayOfWeek - weekOfMonth) * 7) < 0 || (day += daysToAdd) > this.getLastDayOfMonth(mon, cl.get(1))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0 || dayShifted) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else {
                    int lDay;
                    int cDow2 = cl.get(7);
                    int dow = this.daysOfWeek.first();
                    st = this.daysOfWeek.tailSet(cDow2);
                    if (st != null && st.size() > 0) {
                        dow = st.first();
                    }
                    daysToAdd = 0;
                    if (cDow2 < dow) {
                        daysToAdd = dow - cDow2;
                    }
                    if (cDow2 > dow) {
                        daysToAdd = dow + (7 - cDow2);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day + daysToAdd);
                        cl.set(2, mon - 1);
                        continue;
                    }
                }
            } else {
                return -1L;
            }
            cl.set(5, day);
            mon = cl.get(2) + 1;
            int year = cl.get(1);
            t = -1;
            if (year > MAX_YEAR) {
                return -1L;
            }
            st = this.months.tailSet(mon);
            if (st != null && st.size() != 0) {
                t = mon;
                mon = st.first();
            } else {
                mon = this.months.first();
                ++year;
            }
            if (mon != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, mon - 1);
                cl.set(1, year);
                continue;
            }
            cl.set(2, mon - 1);
            year = cl.get(1);
            t = -1;
            st = this.years.tailSet(year);
            if (st == null || st.size() == 0) {
                return -1L;
            }
            t = year;
            year = st.first();
            if (year != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, 0);
                cl.set(1, year);
                continue;
            }
            cl.set(1, year);
            gotOne = true;
        }
        return cl.getTimeInMillis();
    }

    public String expression() {
        return this.expression;
    }

    public String getExpressionSummary() {
        StringBuilder buf = new StringBuilder();
        buf.append("seconds: ");
        buf.append(Cron.expressionSetSummary(this.seconds));
        buf.append("\n");
        buf.append("minutes: ");
        buf.append(Cron.expressionSetSummary(this.minutes));
        buf.append("\n");
        buf.append("hours: ");
        buf.append(Cron.expressionSetSummary(this.hours));
        buf.append("\n");
        buf.append("daysOfMonth: ");
        buf.append(Cron.expressionSetSummary(this.daysOfMonth));
        buf.append("\n");
        buf.append("months: ");
        buf.append(Cron.expressionSetSummary(this.months));
        buf.append("\n");
        buf.append("daysOfWeek: ");
        buf.append(Cron.expressionSetSummary(this.daysOfWeek));
        buf.append("\n");
        buf.append("lastdayOfWeek: ");
        buf.append(this.lastdayOfWeek);
        buf.append("\n");
        buf.append("nearestWeekday: ");
        buf.append(this.nearestWeekday);
        buf.append("\n");
        buf.append("NthDayOfWeek: ");
        buf.append(this.nthdayOfWeek);
        buf.append("\n");
        buf.append("lastdayOfMonth: ");
        buf.append(this.lastdayOfMonth);
        buf.append("\n");
        buf.append("years: ");
        buf.append(Cron.expressionSetSummary(this.years));
        buf.append("\n");
        return buf.toString();
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cron other = (Cron)obj;
        return Objects.equals(this.expression, other.expression);
    }

    public String toString() {
        return this.expression;
    }

    public static boolean isValid(String expression) {
        try {
            Cron.validate(expression);
        }
        catch (IllegalArgumentException pe) {
            return false;
        }
        return true;
    }

    public static void validate(String expression) throws IllegalArgumentException {
        new Cron(expression);
    }

    private void buildExpression(String expression) {
        this.expressionParsed = true;
        try {
            boolean dayOfWSpec;
            int exprOn;
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            StringTokenizer exprsTok = new StringTokenizer(expression, " \t", false);
            for (exprOn = 0; exprsTok.hasMoreTokens() && exprOn <= 6; ++exprOn) {
                String expr = exprsTok.nextToken().trim();
                if (exprOn == 3 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw Exceptions.illegalArgument("support for specifying 'L' and 'LW' with other days of the month is not implemented", new Object[0]);
                }
                if (exprOn == 5 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw Exceptions.illegalArgument("support for specifying 'L' with other days of the week is not implemented", new Object[0]);
                }
                if (exprOn == 5 && expr.indexOf(35) != -1 && expr.indexOf(35, expr.indexOf(35) + 1) != -1) {
                    throw Exceptions.illegalArgument("support for specifying multiple \"nth\" days is not implemented.", new Object[0]);
                }
                StringTokenizer vTok = new StringTokenizer(expr, ",");
                while (vTok.hasMoreTokens()) {
                    String v = vTok.nextToken();
                    this.storeExpressionVals(0, v, exprOn);
                }
            }
            if (exprOn <= 5) {
                throw Exceptions.illegalArgument("unexpected end of expression at pos [{}].", expression.length());
            }
            if (exprOn <= 6) {
                this.storeExpressionVals(0, "*", 6);
            }
            TreeSet<Integer> dow = this.getSet(5);
            TreeSet<Integer> dom = this.getSet(3);
            boolean dayOfMSpec = !dom.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !dow.contains(NO_SPEC);
            if (!(dayOfMSpec && !dayOfWSpec || dayOfWSpec && !dayOfMSpec)) {
                throw Exceptions.illegalArgument("support for specifying both a day-of-week AND a day-of-month parameter is not implemented.", new Object[0]);
            }
        }
        catch (Exception e) {
            throw Exceptions.illegalArgument("illegal cron expression format [{}]", e.toString());
        }
    }

    private int storeExpressionVals(int pos, String s, int type) throws ElasticsearchParseException {
        int val;
        int incr = 0;
        int i = Cron.skipWhiteSpace(pos, s);
        if (i >= s.length()) {
            return i;
        }
        char c = s.charAt(i);
        if (!(c < 'A' || c > 'Z' || s.equals("L") || s.equals("LW") || s.matches("^L-[0-9]*[W]?"))) {
            int eval;
            int sval;
            block47: {
                String sub = s.substring(i, i + 3);
                sval = -1;
                eval = -1;
                if (type == 4) {
                    sval = this.getMonthNumber(sub) + 1;
                    if (sval <= 0) {
                        throw Exceptions.illegalArgument("invalid Month value [{}] at pos [{}]", sub, i);
                    }
                    if (s.length() > i + 3 && (c = s.charAt(i + 3)) == '-' && (eval = this.getMonthNumber(sub = s.substring(i += 4, i + 3)) + 1) <= 0) {
                        throw Exceptions.illegalArgument("invalid Month value [{}] at pos [{}]", sub, i);
                    }
                } else if (type == 5) {
                    sval = this.getDayOfWeekNumber(sub);
                    if (sval < 0) {
                        throw Exceptions.illegalArgument("invalid Day-of-Week value [{}] at pos [{}]", sub, i);
                    }
                    if (s.length() > i + 3) {
                        c = s.charAt(i + 3);
                        if (c == '-') {
                            if ((eval = this.getDayOfWeekNumber(sub = s.substring(i += 4, i + 3))) < 0) {
                                throw Exceptions.illegalArgument("invalid Day-of-Week value [{}] at pos [{}]", sub, i);
                            }
                        } else {
                            if (c == '#') {
                                try {
                                    this.nthdayOfWeek = Integer.parseInt(s.substring(i += 4));
                                    if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                                        throw new Exception();
                                    }
                                    break block47;
                                }
                                catch (Exception e) {
                                    throw Exceptions.illegalArgument("a numeric value between 1 and 5 must follow the '#' option at pos [{}]", i);
                                }
                            }
                            if (c == 'L') {
                                this.lastdayOfWeek = true;
                                ++i;
                            }
                        }
                    }
                } else {
                    throw Exceptions.illegalArgument("illegal characters [{}] at pos [{}] '", sub, i);
                }
            }
            if (eval != -1) {
                incr = 1;
            }
            this.addToSet(sval, eval, incr, type);
            return i + 3;
        }
        if (c == '?') {
            int val2;
            if (++i + 1 < s.length() && s.charAt(i) != ' ' && s.charAt(i + 1) != '\t') {
                throw Exceptions.illegalArgument("illegal character [{}] after '?' at pos [{}]", Character.valueOf(s.charAt(i)), i);
            }
            if (type != 5 && type != 3) {
                throw Exceptions.illegalArgument("'?' can only be specified for Day-of-Month or Day-of-Week. at pos [{}]", i);
            }
            if (type == 5 && !this.lastdayOfMonth && (val2 = this.daysOfMonth.last().intValue()) == 98) {
                throw Exceptions.illegalArgument("'?' can only be specified for Day-of-Month -OR- Day-of-Week. at pos [{}]", i);
            }
            this.addToSet(98, -1, 0, type);
            return i;
        }
        if (c == '*' || c == '/') {
            if (c == '*' && i + 1 >= s.length()) {
                this.addToSet(99, -1, incr, type);
                return i + 1;
            }
            if (c == '/' && (i + 1 >= s.length() || s.charAt(i + 1) == ' ' || s.charAt(i + 1) == '\t')) {
                throw Exceptions.illegalArgument("'/' must be followed by an integer. at pos [{}]", i);
            }
            if (c == '*') {
                ++i;
            }
            if ((c = s.charAt(i)) == '/') {
                if (++i >= s.length()) {
                    throw Exceptions.illegalArgument("Unexpected end of string. at pos [{}]", i);
                }
                incr = this.getNumericValue(s, i);
                ++i;
                if (incr > 10) {
                    ++i;
                }
                if (incr > 59 && (type == 0 || type == 1)) {
                    throw Exceptions.illegalArgument("increment [{}] > 60 at pos [{}]", incr, i);
                }
                if (incr > 23 && type == 2) {
                    throw Exceptions.illegalArgument("increment [{}] > 24 at pos [{}]", incr, i);
                }
                if (incr > 31 && type == 3) {
                    throw Exceptions.illegalArgument("increment [{}] > 31 at pos [{}] ", incr, i);
                }
                if (incr > 7 && type == 5) {
                    throw Exceptions.illegalArgument("increment [{}] > 7 at pos [{}] ", incr, i);
                }
                if (incr > 12 && type == 4) {
                    throw Exceptions.illegalArgument("increment [{}] > 12 at pos [{}]", incr, i);
                }
            } else {
                incr = 1;
            }
            this.addToSet(99, -1, incr, type);
            return i;
        }
        if (c == 'L') {
            ++i;
            if (type == 3) {
                this.lastdayOfMonth = true;
            }
            if (type == 5) {
                this.addToSet(7, 7, 0, type);
            }
            if (type == 3 && s.length() > i) {
                c = s.charAt(i);
                if (c == '-') {
                    ValueSet vs = this.getValue(0, s, i + 1);
                    this.lastdayOffset = vs.value;
                    if (this.lastdayOffset > 30) {
                        throw Exceptions.illegalArgument("offset from last day must be <= 30 at pos [{}]", i + 1);
                    }
                    i = vs.pos;
                }
                if (s.length() > i && (c = s.charAt(i)) == 'W') {
                    this.nearestWeekday = true;
                    ++i;
                }
            }
            return i;
        }
        if (c >= '0' && c <= '9') {
            val = Integer.parseInt(String.valueOf(c));
            if (++i < s.length()) {
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(val, s, i);
                    val = vs.value;
                    i = vs.pos;
                }
                i = this.checkNext(i, s, val, type);
                return i;
            }
        } else {
            throw Exceptions.illegalArgument("Unexpected character [{}] at pos [{}] ", Character.valueOf(c), i);
        }
        this.addToSet(val, -1, -1, type);
        return i;
    }

    private int checkNext(int pos, String s, int val, int type) throws ElasticsearchParseException {
        int end = -1;
        int i = pos;
        if (i >= s.length()) {
            this.addToSet(val, end, -1, type);
            return i;
        }
        char c = s.charAt(pos);
        if (c == 'L') {
            if (type == 5) {
                if (val < 1 || val > 7) {
                    throw Exceptions.illegalArgument("Day-of-Week values must be between 1 and 7", new Object[0]);
                }
            } else {
                throw Exceptions.illegalArgument("'L' option is not valid here. at pos [{}]", i);
            }
            this.lastdayOfWeek = true;
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == 'W') {
            if (type != 3) {
                throw Exceptions.illegalArgument("'W' option is not valid here. at pos [{}]", i);
            }
            this.nearestWeekday = true;
            if (val > 31) {
                throw Exceptions.illegalArgument("the 'W' option does not make sense with values larger than 31 (max number of days in a month) at pos [{}]", i);
            }
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == '#') {
            if (type != 5) {
                throw Exceptions.illegalArgument("'#' option is not valid here. at pos [{}]", i);
            }
            ++i;
            try {
                this.nthdayOfWeek = Integer.parseInt(s.substring(i));
                if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > 5) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw Exceptions.illegalArgument("a numeric value between 1 and 5 must follow the '#' option at pos [{}]", i);
            }
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == '-') {
            int v;
            c = s.charAt(++i);
            end = v = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, 1, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = this.getValue(v, s, i);
                end = vs.value;
                i = vs.pos;
            }
            if (i < s.length() && (c = s.charAt(i)) == '/') {
                c = s.charAt(++i);
                int v2 = Integer.parseInt(String.valueOf(c));
                if (++i >= s.length()) {
                    this.addToSet(val, end, v2, type);
                    return i;
                }
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(v2, s, i);
                    int v3 = vs.value;
                    this.addToSet(val, end, v3, type);
                    i = vs.pos;
                    return i;
                }
                this.addToSet(val, end, v2, type);
                return i;
            }
            this.addToSet(val, end, 1, type);
            return i;
        }
        if (c == '/') {
            c = s.charAt(++i);
            int v2 = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, v2, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = this.getValue(v2, s, i);
                int v3 = vs.value;
                this.addToSet(val, end, v3, type);
                i = vs.pos;
                return i;
            }
            throw Exceptions.illegalArgument("Unexpected character [{}] after '/' at pos [{}]", Character.valueOf(c), i);
        }
        this.addToSet(val, end, 0, type);
        return ++i;
    }

    private static String expressionSetSummary(Set<Integer> set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = set.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    private static String expressionSetSummary(ArrayList<Integer> list) {
        if (list.contains(NO_SPEC)) {
            return "?";
        }
        if (list.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = list.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    private static int skipWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t')) {
            ++i;
        }
        return i;
    }

    private static int findNextWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) != ' ' || s.charAt(i) != '\t')) {
            ++i;
        }
        return i;
    }

    private void addToSet(int val, int end, int incr, int type) throws ElasticsearchParseException {
        TreeSet<Integer> set = this.getSet(type);
        if (type == 0 || type == 1) {
            if ((val < 0 || val > 59 || end > 59) && val != 99) {
                throw Exceptions.illegalArgument("Minute and Second values must be between 0 and 59", new Object[0]);
            }
        } else if (type == 2) {
            if ((val < 0 || val > 23 || end > 23) && val != 99) {
                throw Exceptions.illegalArgument("Hour values must be between 0 and 23", new Object[0]);
            }
        } else if (type == 3) {
            if ((val < 1 || val > 31 || end > 31) && val != 99 && val != 98) {
                throw Exceptions.illegalArgument("Day of month values must be between 1 and 31", new Object[0]);
            }
        } else if (type == 4) {
            if ((val < 1 || val > 12 || end > 12) && val != 99) {
                throw Exceptions.illegalArgument("Month values must be between 1 and 12", new Object[0]);
            }
        } else if (type == 5 && (val == 0 || val > 7 || end > 7) && val != 99 && val != 98) {
            throw Exceptions.illegalArgument("Day-of-Week values must be between 1 and 7", new Object[0]);
        }
        if ((incr == 0 || incr == -1) && val != 99) {
            if (val != -1) {
                set.add(val);
            } else {
                set.add(NO_SPEC);
            }
            return;
        }
        int startAt = val;
        int stopAt = end;
        if (val == 99 && incr <= 0) {
            incr = 1;
            set.add(ALL_SPEC);
        }
        if (type == 0 || type == 1) {
            if (stopAt == -1) {
                stopAt = 59;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 2) {
            if (stopAt == -1) {
                stopAt = 23;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 3) {
            if (stopAt == -1) {
                stopAt = 31;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 4) {
            if (stopAt == -1) {
                stopAt = 12;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 5) {
            if (stopAt == -1) {
                stopAt = 7;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 6) {
            if (stopAt == -1) {
                stopAt = MAX_YEAR;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1970;
            }
        }
        int max = -1;
        if (stopAt < startAt) {
            switch (type) {
                case 0: {
                    max = 60;
                    break;
                }
                case 1: {
                    max = 60;
                    break;
                }
                case 2: {
                    max = 24;
                    break;
                }
                case 4: {
                    max = 12;
                    break;
                }
                case 5: {
                    max = 7;
                    break;
                }
                case 3: {
                    max = 31;
                    break;
                }
                case 6: {
                    throw new IllegalArgumentException("Start year must be less than stop year");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type encountered");
                }
            }
            stopAt += max;
        }
        for (int i = startAt; i <= stopAt; i += incr) {
            if (max == -1) {
                set.add(i);
                continue;
            }
            int i2 = i % max;
            if (i2 == 0 && (type == 4 || type == 5 || type == 3)) {
                i2 = max;
            }
            set.add(i2);
        }
    }

    private TreeSet<Integer> getSet(int type) {
        switch (type) {
            case 0: {
                return this.seconds;
            }
            case 1: {
                return this.minutes;
            }
            case 2: {
                return this.hours;
            }
            case 3: {
                return this.daysOfMonth;
            }
            case 4: {
                return this.months;
            }
            case 5: {
                return this.daysOfWeek;
            }
            case 6: {
                return this.years;
            }
        }
        return null;
    }

    private ValueSet getValue(int v, String s, int i) {
        char c = s.charAt(i);
        StringBuilder s1 = new StringBuilder(String.valueOf(v));
        while (c >= '0' && c <= '9') {
            s1.append(c);
            if (++i >= s.length()) break;
            c = s.charAt(i);
        }
        ValueSet val = new ValueSet();
        val.pos = i < s.length() ? i : i + 1;
        val.value = Integer.parseInt(s1.toString());
        return val;
    }

    private int getNumericValue(String s, int i) {
        int endOfVal = Cron.findNextWhiteSpace(i, s);
        String val = s.substring(i, endOfVal);
        return Integer.parseInt(val);
    }

    private int getMonthNumber(String s) {
        Integer integer = monthMap.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    private int getDayOfWeekNumber(String s) {
        Integer integer = dayMap.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    private static void setCalendarHour(Calendar cal, int hour) {
        cal.set(11, hour);
        if (cal.get(11) != hour && hour != 24) {
            cal.set(11, hour + 1);
        }
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private int getLastDayOfMonth(int monthNum, int year) {
        switch (monthNum) {
            case 1: {
                return 31;
            }
            case 2: {
                return Cron.isLeapYear(year) ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + monthNum);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    static {
        monthMap.put("JAN", 0);
        monthMap.put("FEB", 1);
        monthMap.put("MAR", 2);
        monthMap.put("APR", 3);
        monthMap.put("MAY", 4);
        monthMap.put("JUN", 5);
        monthMap.put("JUL", 6);
        monthMap.put("AUG", 7);
        monthMap.put("SEP", 8);
        monthMap.put("OCT", 9);
        monthMap.put("NOV", 10);
        monthMap.put("DEC", 11);
        dayMap.put("SUN", 1);
        dayMap.put("MON", 2);
        dayMap.put("TUE", 3);
        dayMap.put("WED", 4);
        dayMap.put("THU", 5);
        dayMap.put("FRI", 6);
        dayMap.put("SAT", 7);
        MAX_YEAR = Calendar.getInstance(UTC, Locale.ROOT).get(1) + 100;
    }

    private static class ValueSet {
        int value;
        int pos;

        private ValueSet() {
        }
    }
}

