/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.ssl.CertificateTrustRestrictions;
import org.elasticsearch.xpack.core.ssl.DerParser;

public final class RestrictedTrustManager
extends X509ExtendedTrustManager {
    private static final String CN_OID = "2.5.4.3";
    private static final int SAN_CODE_OTHERNAME = 0;
    private final Logger logger;
    private final X509ExtendedTrustManager delegate;
    private final CertificateTrustRestrictions trustRestrictions;

    public RestrictedTrustManager(Settings settings, X509ExtendedTrustManager delegate, CertificateTrustRestrictions restrictions) {
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
        this.delegate = delegate;
        this.trustRestrictions = restrictions;
        this.logger.debug("Configured with trust restrictions: [{}]", (Object)restrictions);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
        this.verifyTrust(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, socket);
        this.verifyTrust(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, engine);
        this.verifyTrust(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, engine);
        this.verifyTrust(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        this.verifyTrust(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
        this.verifyTrust(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    private void verifyTrust(X509Certificate[] chain) throws CertificateException {
        if (chain.length == 0) {
            throw new CertificateException("No certificate presented");
        }
        X509Certificate certificate = chain[0];
        Set<String> names = this.readCommonNames(certificate);
        if (!this.verifyCertificateNames(names)) {
            this.logger.info("Rejecting certificate [{}] [{}] with common-names [{}]", (Object)certificate.getSubjectDN(), (Object)certificate.getSerialNumber().toString(16), names);
            throw new CertificateException("Certificate for " + certificate.getSubjectDN() + " with common-names " + names + " does not match the trusted names " + this.trustRestrictions.getTrustedNames());
        }
        this.logger.debug(() -> new ParameterizedMessage("Trusting certificate [{}] [{}] with common-names [{}]", new Object[]{certificate.getSubjectDN(), certificate.getSerialNumber().toString(16), names}));
    }

    private boolean verifyCertificateNames(Set<String> names) {
        for (Predicate<String> trust : this.trustRestrictions.getTrustedNames()) {
            Optional<String> match = names.stream().filter(trust).findFirst();
            if (!match.isPresent()) continue;
            this.logger.debug("Name [{}] matches trusted pattern [{}]", (Object)match.get(), trust);
            return true;
        }
        return false;
    }

    private Set<String> readCommonNames(X509Certificate certificate) throws CertificateParsingException {
        return this.getSubjectAlternativeNames(certificate).stream().filter(pair -> (Integer)pair.get(0) == 0).map(pair -> pair.get(1)).map(value -> this.decodeDerValue((byte[])value, certificate)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private String decodeDerValue(byte[] value, X509Certificate certificate) {
        try {
            DerParser parser = new DerParser(value);
            DerParser.Asn1Object seq = parser.readAsn1Object();
            parser = seq.getParser();
            String id = parser.readAsn1Object().getOid();
            if (CN_OID.equals(id)) {
                DerParser.Asn1Object cnObject = parser.readAsn1Object();
                DerParser.Asn1Object innerObject = (parser = cnObject.getParser()).readAsn1Object();
                if (innerObject.isConstructed()) {
                    innerObject = innerObject.getParser().readAsn1Object();
                }
                this.logger.trace("Read innermost ASN.1 Object with type code [{}]", (Object)innerObject.getType());
                String cn = innerObject.getString();
                this.logger.trace("Read cn [{}] from ASN1Sequence [{}]", (Object)cn, (Object)seq);
                return cn;
            }
            this.logger.debug("Certificate [{}] has 'otherName' [{}] with unsupported object-id [{}]", (Object)certificate.getSubjectDN(), (Object)seq, (Object)id);
            return null;
        }
        catch (IOException e) {
            this.logger.warn("Failed to read 'otherName' from certificate [{}]", (Object)certificate.getSubjectDN());
            return null;
        }
    }

    private Collection<List<?>> getSubjectAlternativeNames(X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> sans = certificate.getSubjectAlternativeNames();
        this.logger.trace("Certificate [{}] has subject alternative names [{}]", (Object)certificate.getSubjectDN(), sans);
        return sans == null ? Collections.emptyList() : sans;
    }
}

