/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.index;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;
import org.joda.time.DateTimeZone;

public class IndexAction
implements Action {
    public static final String TYPE = "index";
    @Nullable
    final String docType;
    @Nullable
    final String index;
    @Nullable
    final String docId;
    @Nullable
    final String executionTimeField;
    @Nullable
    final TimeValue timeout;
    @Nullable
    final DateTimeZone dynamicNameTimeZone;
    @Nullable
    final WriteRequest.RefreshPolicy refreshPolicy;

    public IndexAction(@Nullable String index, @Nullable String docType, @Nullable String docId, @Nullable String executionTimeField, @Nullable TimeValue timeout, @Nullable DateTimeZone dynamicNameTimeZone, @Nullable WriteRequest.RefreshPolicy refreshPolicy) {
        this.index = index;
        this.docType = docType;
        this.docId = docId;
        this.executionTimeField = executionTimeField;
        this.timeout = timeout;
        this.dynamicNameTimeZone = dynamicNameTimeZone;
        this.refreshPolicy = refreshPolicy;
    }

    public String type() {
        return TYPE;
    }

    public String getIndex() {
        return this.index;
    }

    public String getDocType() {
        return this.docType;
    }

    public String getDocId() {
        return this.docId;
    }

    public String getExecutionTimeField() {
        return this.executionTimeField;
    }

    public DateTimeZone getDynamicNameTimeZone() {
        return this.dynamicNameTimeZone;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexAction that = (IndexAction)o;
        return Objects.equals(this.index, that.index) && Objects.equals(this.docType, that.docType) && Objects.equals(this.docId, that.docId) && Objects.equals(this.executionTimeField, that.executionTimeField) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.dynamicNameTimeZone, that.dynamicNameTimeZone) && Objects.equals(this.refreshPolicy, that.refreshPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.docType, this.docId, this.executionTimeField, this.timeout, this.dynamicNameTimeZone, this.refreshPolicy);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.index != null) {
            builder.field(Field.INDEX.getPreferredName(), this.index);
        }
        if (this.docType != null) {
            builder.field(Field.DOC_TYPE.getPreferredName(), this.docType);
        }
        if (this.docId != null) {
            builder.field(Field.DOC_ID.getPreferredName(), this.docId);
        }
        if (this.executionTimeField != null) {
            builder.field(Field.EXECUTION_TIME_FIELD.getPreferredName(), this.executionTimeField);
        }
        if (this.timeout != null) {
            builder.humanReadableField(Field.TIMEOUT.getPreferredName(), Field.TIMEOUT_HUMAN.getPreferredName(), (Object)this.timeout);
        }
        if (this.dynamicNameTimeZone != null) {
            builder.field(Field.DYNAMIC_NAME_TIMEZONE.getPreferredName(), this.dynamicNameTimeZone.toString());
        }
        if (this.refreshPolicy != null) {
            builder.field(Field.REFRESH.getPreferredName(), this.refreshPolicy.getValue());
        }
        return builder.endObject();
    }

    public static IndexAction parse(String watchId, String actionId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String index = null;
        String docType = null;
        String docId = null;
        String executionTimeField = null;
        TimeValue timeout = null;
        DateTimeZone dynamicNameTimeZone = null;
        WriteRequest.RefreshPolicy refreshPolicy = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    index = parser.text();
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]. failed to parse index name value for field [{}]", (Throwable)pe, new Object[]{TYPE, watchId, actionId, currentFieldName});
                }
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (Field.TIMEOUT.match(currentFieldName, parser.getDeprecationHandler())) {
                    timeout = TimeValue.timeValueMillis((long)parser.longValue());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]. unexpected number field [{}]", new Object[]{TYPE, watchId, actionId, currentFieldName});
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (Field.DOC_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    docType = parser.text();
                    continue;
                }
                if (Field.DOC_ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    docId = parser.text();
                    continue;
                }
                if (Field.EXECUTION_TIME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    executionTimeField = parser.text();
                    continue;
                }
                if (Field.TIMEOUT_HUMAN.match(currentFieldName, parser.getDeprecationHandler())) {
                    timeout = WatcherDateTimeUtils.parseTimeValue((XContentParser)parser, (String)Field.TIMEOUT_HUMAN.toString());
                    continue;
                }
                if (Field.DYNAMIC_NAME_TIMEZONE.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        dynamicNameTimeZone = DateTimeZone.forID((String)parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse [{}] action for watch [{}]. failed to parse [{}]. must be a string value (e.g. 'UTC' or '+01:00').", new Object[]{TYPE, watchId, currentFieldName});
                }
                if (Field.REFRESH.match(currentFieldName, parser.getDeprecationHandler())) {
                    refreshPolicy = WriteRequest.RefreshPolicy.parse((String)parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]. unexpected string field [{}]", new Object[]{TYPE, watchId, actionId, currentFieldName});
            }
            throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]. unexpected token [{}]", new Object[]{TYPE, watchId, actionId, token});
        }
        return new IndexAction(index, docType, docId, executionTimeField, timeout, dynamicNameTimeZone, refreshPolicy);
    }

    public static Builder builder(String index, String docType) {
        return new Builder(index, docType);
    }

    static interface Field {
        public static final ParseField INDEX = new ParseField("index", new String[0]);
        public static final ParseField DOC_TYPE = new ParseField("doc_type", new String[0]);
        public static final ParseField DOC_ID = new ParseField("doc_id", new String[0]);
        public static final ParseField EXECUTION_TIME_FIELD = new ParseField("execution_time_field", new String[0]);
        public static final ParseField SOURCE = new ParseField("source", new String[0]);
        public static final ParseField RESPONSE = new ParseField("response", new String[0]);
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout_in_millis", new String[0]);
        public static final ParseField TIMEOUT_HUMAN = new ParseField("timeout", new String[0]);
        public static final ParseField DYNAMIC_NAME_TIMEZONE = new ParseField("dynamic_name_timezone", new String[0]);
        public static final ParseField REFRESH = new ParseField("refresh", new String[0]);
    }

    public static class Builder
    implements Action.Builder<IndexAction> {
        final String index;
        final String docType;
        String docId;
        String executionTimeField;
        TimeValue timeout;
        DateTimeZone dynamicNameTimeZone;
        WriteRequest.RefreshPolicy refreshPolicy;

        private Builder(String index, String docType) {
            this.index = index;
            this.docType = docType;
        }

        public Builder setDocId(String docId) {
            this.docId = docId;
            return this;
        }

        public Builder setExecutionTimeField(String executionTimeField) {
            this.executionTimeField = executionTimeField;
            return this;
        }

        public Builder setTimeout(TimeValue writeTimeout) {
            this.timeout = writeTimeout;
            return this;
        }

        public Builder setDynamicNameTimeZone(DateTimeZone dynamicNameTimeZone) {
            this.dynamicNameTimeZone = dynamicNameTimeZone;
            return this;
        }

        public Builder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
            return this;
        }

        public IndexAction build() {
            return new IndexAction(this.index, this.docType, this.docId, this.executionTimeField, this.timeout, this.dynamicNameTimeZone, this.refreshPolicy);
        }
    }

    static class Simulated
    extends Action.Result {
        private final String index;
        private final String docType;
        @Nullable
        private final String docId;
        @Nullable
        private final WriteRequest.RefreshPolicy refreshPolicy;
        private final XContentSource source;

        protected Simulated(String index, String docType, @Nullable String docId, @Nullable WriteRequest.RefreshPolicy refreshPolicy, XContentSource source) {
            super(IndexAction.TYPE, Action.Result.Status.SIMULATED);
            this.index = index;
            this.docType = docType;
            this.docId = docId;
            this.source = source;
            this.refreshPolicy = refreshPolicy;
        }

        public String index() {
            return this.index;
        }

        public String docType() {
            return this.docType;
        }

        public String docId() {
            return this.docId;
        }

        public XContentSource source() {
            return this.source;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.type).startObject(Field.REQUEST.getPreferredName()).field(Field.INDEX.getPreferredName(), this.index).field(Field.DOC_TYPE.getPreferredName(), this.docType);
            if (this.docId != null) {
                builder.field(Field.DOC_ID.getPreferredName(), this.docId);
            }
            if (this.refreshPolicy != null) {
                builder.field(Field.REFRESH.getPreferredName(), this.refreshPolicy.getValue());
            }
            return builder.field(Field.SOURCE.getPreferredName(), (ToXContent)this.source, params).endObject().endObject();
        }
    }

    public static class Result
    extends Action.Result {
        private final XContentSource response;

        public Result(Action.Result.Status status, XContentSource response) {
            super(IndexAction.TYPE, status);
            this.response = response;
        }

        public XContentSource response() {
            return this.response;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject(this.type).field(Field.RESPONSE.getPreferredName(), (ToXContent)this.response, params).endObject();
        }
    }
}

