/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http.auth;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.common.http.auth.ApplicableHttpAuth;
import org.elasticsearch.xpack.watcher.common.http.auth.HttpAuth;
import org.elasticsearch.xpack.watcher.common.http.auth.HttpAuthFactory;

public class HttpAuthRegistry {
    private final Map<String, HttpAuthFactory> factories;

    public HttpAuthRegistry(Map<String, HttpAuthFactory> factories) {
        this.factories = factories;
    }

    public HttpAuth parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        HttpAuth auth = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT || type == null) continue;
            HttpAuthFactory factory = this.factories.get(type);
            if (factory == null) {
                throw new ElasticsearchParseException("unknown http auth type [{}]", new Object[]{type});
            }
            auth = (HttpAuth)factory.parse(parser);
        }
        return auth;
    }

    public <A extends HttpAuth, AA extends ApplicableHttpAuth<A>> AA createApplicable(A auth) {
        HttpAuthFactory factory = this.factories.get(auth.type());
        if (factory == null) {
            throw Exceptions.illegalArgument((String)"unknown http auth type [{}]", (Object[])new Object[]{auth.type()});
        }
        return (AA)factory.createApplicable(auth);
    }
}

