/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Config;
import esmska.data.CountryPrefix;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Icons;
import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.event.AbstractListDataListener;
import esmska.data.event.ActionEventSupport;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedEventSupport;
import esmska.data.event.ValuedListener;
import esmska.gui.Actions;
import esmska.gui.InfoLabel;
import esmska.gui.ListPopupMouseListener;
import esmska.gui.ThemeManager;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import esmska.utils.RuntimeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.openide.awt.Mnemonics;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.highlight.SubstanceHighlightPainter;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.api.skin.SkinChangeListener;

public class QueuePanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(QueuePanel.class.getName());
    private static final String RES = "/esmska/resources/";
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Queue queue = Queue.getInstance();
    private static final Config config = Config.getInstance();
    private static final Gateways gateways = Gateways.getInstance();
    private Action deleteSMSAction = new DeleteSMSAction();
    private Action editSMSAction = new EditSMSAction();
    private Action smsUpAction = new SMSUpAction();
    private Action smsDownAction = new SMSDownAction();
    private QueueListModel queueListModel = new QueueListModel();
    private QueuePopupMenu popup = new QueuePopupMenu();
    private QueueMouseListener mouseListener;
    private Timer timer = new Timer(500, new DelayListener());
    private ValuedEventSupport<Events, SMS> valuedSupport = new ValuedEventSupport(this);
    private ActionEventSupport actionSupport = new ActionEventSupport(this);
    private JButton deleteButton;
    private JButton editButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane2;
    private JToggleButton pauseButton;
    private InfoLabel pausedLabel;
    private JList queueList;
    private JButton smsDownButton;
    private JButton smsUpButton;

    public void addValuedListener(ValuedListener<Events, SMS> valuedListener) {
        this.valuedSupport.addValuedListener(valuedListener);
    }

    public void removeValuedListener(ValuedListener<Events, SMS> valuedListener) {
        this.valuedSupport.removeValuedListener(valuedListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    public QueuePanel() {
        this.initComponents();
        this.mouseListener = new QueueMouseListener(this.queueList, this.popup);
        this.queueList.addMouseListener(this.mouseListener);
        this.queueListModel.addListDataListener(new AbstractListDataListener(){

            @Override
            public void onUpdate(ListDataEvent e) {
                QueuePanel.this.queueListValueChanged(null);
            }
        });
        this.showAdvancedControls(config.isShowAdvancedControls());
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("showAdvancedControls".equals(evt.getPropertyName())) {
                    QueuePanel.this.showAdvancedControls((Boolean)evt.getNewValue());
                }
            }
        });
        queue.addValuedListener(new ValuedListener<Queue.Events, SMS>(){

            @Override
            public void eventOccured(ValuedEvent<Queue.Events, SMS> e) {
                switch (e.getEvent()) {
                    case QUEUE_PAUSED: {
                        QueuePanel.this.pausedLabel.setVisible(true);
                        break;
                    }
                    case QUEUE_RESUMED: {
                        QueuePanel.this.pausedLabel.setVisible(false);
                    }
                }
                if (MiscUtils.needsResize(QueuePanel.this, MiscUtils.Direction.HEIGHT)) {
                    QueuePanel.this.actionSupport.fireActionPerformed(0, null);
                }
                QueuePanel.this.revalidate();
            }
        });
        gateways.addValuedListener(new ValuedListener<Gateways.Events, Gateway>(){

            @Override
            public void eventOccured(ValuedEvent<Gateways.Events, Gateway> e) {
                switch (e.getEvent()) {
                    case ADDED_GATEWAY: 
                    case ADDED_GATEWAYS: 
                    case CLEARED_GATEWAYS: 
                    case REMOVED_GATEWAY: 
                    case REMOVED_GATEWAYS: {
                        QueuePanel.this.queueList.repaint();
                    }
                }
            }
        });
    }

    private void showAdvancedControls(boolean show) {
        this.smsUpButton.setVisible(show);
        this.smsDownButton.setVisible(show);
        this.popup.showAdvancedControls(show);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.queueList = new JList();
        this.pausedLabel = new InfoLabel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.jPanel4 = new JPanel();
        this.pauseButton = new JToggleButton();
        this.jPanel5 = new JPanel();
        this.smsUpButton = new JButton();
        this.smsDownButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder(l10n.getString("QueuePanel.border.title")));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                QueuePanel.this.formFocusGained(evt);
            }
        });
        this.jPanel1.setBorder(null);
        this.queueList.setModel(this.queueListModel);
        this.queueList.setCellRenderer(new SMSQueueListRenderer(this.queueList));
        this.queueList.setVisibleRowCount(1);
        this.queueList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                QueuePanel.this.queueListValueChanged(evt);
            }
        });
        this.queueList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                QueuePanel.this.queueListKeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.queueList);
        Mnemonics.setLocalizedText(this.pausedLabel, l10n.getString("QueuePanel.pausedLabel.text"));
        this.pausedLabel.setVisible(queue.isPaused());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 195, Short.MAX_VALUE).addComponent(this.pausedLabel, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 25, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pausedLabel, -2, -1, -2)));
        this.jPanel2.setBorder(null);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setBorder(null);
        this.editButton.setAction(this.editSMSAction);
        this.editButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.editButton.setText("");
        this.deleteButton.setAction(this.deleteSMSAction);
        this.deleteButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.deleteButton.setText("");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.editButton, -1, 28, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton, -1, -1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editButton).addComponent(this.deleteButton));
        this.jPanel2.add((Component)this.jPanel3, "First");
        this.jPanel4.setBorder(null);
        this.pauseButton.setAction(Actions.getQueuePauseAction(false));
        this.pauseButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pauseButton, -1, 62, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pauseButton));
        this.jPanel2.add((Component)this.jPanel4, "Last");
        this.smsUpButton.setAction(this.smsUpAction);
        this.smsUpButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.smsUpButton.setText("");
        this.smsDownButton.setAction(this.smsDownAction);
        this.smsDownButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.smsDownButton.setText("");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.smsUpButton).addComponent(this.smsDownButton));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.smsUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.smsDownButton)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, 55, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, 55, Short.MAX_VALUE)).addContainerGap()));
    }

    private void queueListValueChanged(ListSelectionEvent evt) {
        if (evt != null && evt.getValueIsAdjusting()) {
            return;
        }
        if (this.queueList.getMaxSelectionIndex() >= this.queueListModel.getSize()) {
            return;
        }
        int size = this.queueList.getSelectedIndices().length;
        SMS sms = (SMS)this.queueList.getSelectedValue();
        Object[] smses = this.queueList.getSelectedValues();
        this.editSMSAction.setEnabled(size == 1 && sms.getStatus() != SMS.Status.SENDING);
        this.deleteSMSAction.setEnabled(size > 0);
        for (Object s : smses) {
            if (((SMS)s).getStatus() != SMS.Status.SENDING) continue;
            this.deleteSMSAction.setEnabled(false);
        }
        if (sms != null && size == 1) {
            List<SMS> list = queue.getAll(sms.getGateway());
            int index = list.indexOf(sms);
            this.smsUpAction.setEnabled(index != 0);
            this.smsDownAction.setEnabled(index < list.size() - 1);
        } else {
            this.smsUpAction.setEnabled(false);
            this.smsDownAction.setEnabled(false);
        }
    }

    private void formFocusGained(FocusEvent evt) {
        this.pauseButton.requestFocusInWindow();
    }

    private void queueListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deleteButton.doClick(0);
            return;
        }
    }

    private class QueueMouseListener
    extends ListPopupMouseListener {
        public QueueMouseListener(JList list, JPopupMenu popup) {
            super(list, popup);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                QueuePanel.this.editButton.doClick();
            }
        }
    }

    private class QueuePopupMenu
    extends JPopupMenu {
        private ArrayList<JMenuItem> advancedItems = new ArrayList();

        public QueuePopupMenu() {
            JMenuItem menuItem = null;
            menuItem = new JMenuItem(QueuePanel.this.editSMSAction);
            this.add(menuItem);
            menuItem = new JMenuItem(QueuePanel.this.deleteSMSAction);
            this.add(menuItem);
            menuItem = new JMenuItem(QueuePanel.this.smsUpAction);
            this.add(menuItem);
            this.advancedItems.add(menuItem);
            menuItem = new JMenuItem(QueuePanel.this.smsDownAction);
            this.add(menuItem);
            this.advancedItems.add(menuItem);
            this.addSeparator();
            menuItem = new JMenuItem(Actions.getQueuePauseAction(true));
            this.add(menuItem);
        }

        public void showAdvancedControls(boolean show) {
            for (JMenuItem item : this.advancedItems) {
                item.setVisible(show);
            }
        }
    }

    private class DelayListener
    implements ActionListener {
        private DelayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean timerNeeded = false;
            for (int i = 0; i < QueuePanel.this.queueListModel.getSize(); ++i) {
                SMS sms = QueuePanel.this.queueListModel.getElementAt(i);
                long delay = queue.getSMSDelay(sms);
                if (delay <= 0L) continue;
                timerNeeded = true;
                QueuePanel.this.queueListModel.fireContentsChanged(i, i);
            }
            if (!timerNeeded) {
                QueuePanel.this.timer.stop();
            }
        }
    }

    private class SMSQueueListRenderer
    extends SubstanceDefaultListCellRenderer {
        private final ListCellRenderer lafRenderer = new JList().getCellRenderer();
        private final JLabel delayLabel = new JLabel("", 11);
        private final ImageIcon sendIcon = Icons.get("send-16.png");
        private final URL messageIconURI = this.getClass().getResource("/esmska/resources/message-32.png");
        private final boolean isSubstance = ThemeManager.isSubstanceCurrentLaF();
        private boolean selected = false;
        private final JList jlist;
        private SubstanceColorScheme scheme;
        private SubstanceColorScheme borderScheme;
        private SubstanceHighlightPainter highlPainter;
        private SubstanceBorderPainter borderPainter;
        private final JPanel panel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (SMSQueueListRenderer.this.isSubstance && SMSQueueListRenderer.this.selected) {
                    SMSQueueListRenderer.this.highlPainter.paintHighlight((Graphics2D)g, this, this.getWidth(), this.getHeight(), SMSQueueListRenderer.this.scheme);
                    Rectangle contour = new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    SMSQueueListRenderer.this.borderPainter.paintBorder((Graphics2D)g, this, this.getWidth(), this.getHeight(), contour, contour, SMSQueueListRenderer.this.borderScheme);
                }
            }
        };

        public SMSQueueListRenderer(JList list) {
            this.jlist = list;
            this.panel.add((Component)this.delayLabel, "After");
            this.updateSubstanceSkinValues();
            SubstanceLookAndFeel.registerSkinChangeListener(new SkinChangeListener(){

                @Override
                public void skinChanged() {
                    SMSQueueListRenderer.this.updateSubstanceSkinValues();
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.lafRenderer.getListCellRendererComponent(list, value, index, isSelected, false);
            this.selected = isSelected;
            JLabel label = (JLabel)c;
            SMS sms = (SMS)value;
            label.setText(StringUtils.defaultIfEmpty(sms.getName(), CountryPrefix.stripCountryPrefix(sms.getNumber(), true)));
            if (sms.isProblematic() && !isSelected) {
                label.setBackground(Color.RED);
            }
            this.delayLabel.setForeground(label.getForeground());
            this.delayLabel.setBackground(label.getBackground());
            this.panel.setBackground(label.getBackground());
            Gateway gateway = gateways.get(sms.getGateway());
            label.setIcon(gateway != null ? gateway.getIcon() : Icons.GATEWAY_BLANK);
            String text = WordUtils.wrap(sms.getText(), 50, null, true);
            text = MiscUtils.escapeHtml(text);
            text = text.replaceAll("\n", "<br>");
            String tooltip = "<html><table><tr><td><img src=\"" + this.messageIconURI + "\"></td><td valign=top><b>" + label.getText() + "</b><br>" + (StringUtils.isEmpty(sms.getName()) ? "" : CountryPrefix.stripCountryPrefix(sms.getNumber(), true) + ", ") + sms.getGateway() + "<br><br>" + text + "</td></tr></table></html>";
            this.panel.setToolTipText(tooltip);
            if (queue.getAllWithStatus(SMS.Status.SENDING).contains(sms)) {
                this.delayLabel.setIcon(this.sendIcon);
                this.delayLabel.setText(null);
            } else {
                this.delayLabel.setIcon(null);
                long delay = queue.getSMSDelay(sms);
                this.delayLabel.setText(Gateways.convertDelayToHumanString(delay, true));
            }
            this.panel.add((Component)label, "Center");
            return this.panel;
        }

        private void updateSubstanceSkinValues() {
            if (!this.isSubstance) {
                return;
            }
            this.scheme = SubstanceLookAndFeel.getCurrentSkin(this.jlist).getColorScheme(this.jlist, ColorSchemeAssociationKind.HIGHLIGHT, ComponentState.SELECTED);
            this.borderScheme = SubstanceLookAndFeel.getCurrentSkin(this.jlist).getColorScheme(this.jlist, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, ComponentState.SELECTED);
            this.highlPainter = SubstanceLookAndFeel.getCurrentSkin(this.jlist).getHighlightPainter();
            this.borderPainter = (SubstanceBorderPainter)ObjectUtils.defaultIfNull(SubstanceLookAndFeel.getCurrentSkin(this.jlist).getHighlightBorderPainter(), SubstanceLookAndFeel.getCurrentSkin(this.jlist).getBorderPainter());
        }
    }

    private class QueueListModel
    extends AbstractListModel {
        private int oldSize = this.getSize();

        public QueueListModel() {
            queue.addValuedListener(new ValuedListener<Queue.Events, SMS>(){

                @Override
                public void eventOccured(ValuedEvent<Queue.Events, SMS> e) {
                    switch (e.getEvent()) {
                        case SMS_ADDED: 
                        case SENDING_SMS: 
                        case SMS_SENDING_FAILED: 
                        case SMS_POSITION_CHANGED: {
                            QueueListModel.this.fireContentsChanged(QueueListModel.this, 0, QueueListModel.this.getSize());
                            break;
                        }
                        case SMS_REMOVED: 
                        case QUEUE_CLEARED: {
                            QueueListModel.this.fireIntervalRemoved(QueueListModel.this, 0, QueueListModel.this.oldSize);
                        }
                    }
                    QueueListModel.this.oldSize = QueueListModel.this.getSize();
                    QueuePanel.this.timer.start();
                }
            });
        }

        @Override
        public SMS getElementAt(int index) {
            return queue.getAll().get(index);
        }

        @Override
        public int getSize() {
            return queue.size();
        }

        public int indexOf(SMS element) {
            return queue.getAll().indexOf(element);
        }

        public void fireContentsChanged(int index0, int index1) {
            super.fireContentsChanged(this, index0, index1);
        }
    }

    private class SMSDownAction
    extends AbstractAction {
        public SMSDownAction() {
            super(l10n.getString("Move_down"), Icons.get("down-16.png"));
            this.putValue("ShortDescription", l10n.getString("QueuePanel.Move_sms_down_in_the_queue"));
            this.putValue("SwingLargeIconKey", Icons.get("down-22.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SMS sms = (SMS)QueuePanel.this.queueList.getSelectedValue();
            if (sms == null) {
                return;
            }
            queue.movePosition(sms, 1);
            int index = QueuePanel.this.queueListModel.indexOf(sms);
            QueuePanel.this.queueList.setSelectedIndex(index);
            QueuePanel.this.queueList.ensureIndexIsVisible(index);
        }
    }

    private class SMSUpAction
    extends AbstractAction {
        public SMSUpAction() {
            super(l10n.getString("Move_up"), Icons.get("up-16.png"));
            this.putValue("ShortDescription", l10n.getString("QueuePanel.Move_sms_up_in_the_queue"));
            this.putValue("SwingLargeIconKey", Icons.get("up-22.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SMS sms = (SMS)QueuePanel.this.queueList.getSelectedValue();
            if (sms == null) {
                return;
            }
            queue.movePosition(sms, -1);
            int index = QueuePanel.this.queueListModel.indexOf(sms);
            QueuePanel.this.queueList.setSelectedIndex(index);
            QueuePanel.this.queueList.ensureIndexIsVisible(index);
        }
    }

    private class EditSMSAction
    extends AbstractAction {
        public EditSMSAction() {
            super(l10n.getString("Edit_message"), Icons.get("edit-16.png"));
            this.putValue("ShortDescription", l10n.getString("Edit_selected_message"));
            this.putValue("SwingLargeIconKey", Icons.get("edit-22.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SMS sms = (SMS)QueuePanel.this.queueList.getSelectedValue();
            if (sms == null) {
                return;
            }
            logger.fine("SMS requested for editing: " + sms);
            QueuePanel.this.valuedSupport.fireEventOccured(Events.SMS_EDIT_REQUESTED, sms);
        }
    }

    private class DeleteSMSAction
    extends AbstractAction {
        private final String deleteOption;
        private final String cancelOption;
        private final Object[] options;
        private final String message;

        public DeleteSMSAction() {
            super(l10n.getString("Delete_messages"), Icons.get("delete-16.png"));
            this.deleteOption = l10n.getString("Delete");
            this.cancelOption = l10n.getString("Cancel");
            this.options = RuntimeUtils.sortDialogOptions(this.cancelOption, this.deleteOption);
            this.message = l10n.getString("QueuePanel.confirmDelete");
            this.putValue("ShortDescription", l10n.getString("Delete_selected_messages"));
            this.putValue("SwingLargeIconKey", Icons.get("delete-22.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] toRemove = QueuePanel.this.queueList.getSelectedValues();
            JOptionPane pane = new JOptionPane(this.message, 2, -1, null, this.options, this.deleteOption);
            JDialog dialog = pane.createDialog(Context.mainFrame, null);
            dialog.setResizable(true);
            RuntimeUtils.setDocumentModalDialog(dialog);
            dialog.pack();
            dialog.setVisible(true);
            if (this.deleteOption.equals(pane.getValue())) {
                for (Object o : toRemove) {
                    SMS sms = (SMS)o;
                    queue.remove(sms.getId());
                }
            }
            if (QueuePanel.this.queueListModel.getSize() > 0) {
                QueuePanel.this.queueList.requestFocusInWindow();
            } else {
                QueuePanel.this.pauseButton.requestFocusInWindow();
            }
        }
    }

    public static enum Events {
        SMS_EDIT_REQUESTED;

    }
}

